/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AutoScrollFromSourceHandler {
    protected final Project myProject;
    protected final Alarm myAlarm;
    private final Disposable myParentDisposable;
    private final JComponent myComponent;

    public AutoScrollFromSourceHandler(@NotNull Project project, @NotNull JComponent view, @NotNull Disposable parentDisposable) {
        if (project == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(0);
        }
        if (view == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myComponent = view;
        this.myAlarm = new Alarm(parentDisposable);
        this.myParentDisposable = parentDisposable;
    }

    @NlsActions.ActionText
    protected String getActionName() {
        return UIBundle.message("autoscroll.from.source.action.name", new Object[0]);
    }

    @NlsActions.ActionDescription
    protected String getActionDescription() {
        return UIBundle.message("autoscroll.from.source.action.description", new Object[0]);
    }

    protected abstract boolean isAutoScrollEnabled();

    protected abstract void setAutoScrollEnabled(boolean var1);

    protected abstract void selectElementFromEditor(@NotNull FileEditor var1);

    protected ModalityState getModalityState() {
        return ModalityState.current();
    }

    protected long getAlarmDelay() {
        return Registry.intValue((String)"ide.autoscroll.from.source.delay", (int)100);
    }

    public void install() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this.myParentDisposable);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AutoScrollFromSourceHandler.this.selectInAlarm(event.getNewEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/AutoScrollFromSourceHandler$1", "selectionChanged"));
            }
        });
        this.updateCurrentSelection();
    }

    protected void selectInAlarm(FileEditor editor) {
        if (!ClientId.isCurrentlyUnderLocalId()) {
            return;
        }
        if (editor != null && this.myComponent.isShowing() && this.isAutoScrollEnabled()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.selectElementFromEditor(editor), this.getAlarmDelay(), this.getModalityState());
        }
    }

    private void updateCurrentSelection() {
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
        if (selectedEditor != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.selectInAlarm(selectedEditor), ModalityState.nonModal(), this.myProject.getDisposed());
        }
    }

    public ToggleAction createToggleAction() {
        return new AutoScrollFromSourceAction(this.getActionName(), this.getActionDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/AutoScrollFromSourceHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AutoScrollFromSourceAction
    extends ToggleAction
    implements DumbAware {
        AutoScrollFromSourceAction(@NlsActions.ActionDescription String actionName, String actionDescription) {
            super(actionName, actionDescription, AllIcons.General.AutoscrollFromSource);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                AutoScrollFromSourceAction.$$$reportNull$$$0(0);
            }
            return AutoScrollFromSourceHandler.this.isAutoScrollEnabled();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                AutoScrollFromSourceAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                AutoScrollFromSourceAction.$$$reportNull$$$0(2);
            }
            AutoScrollFromSourceHandler.this.setAutoScrollEnabled(flag);
            AutoScrollFromSourceHandler.this.updateCurrentSelection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/AutoScrollFromSourceHandler$AutoScrollFromSourceAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/AutoScrollFromSourceHandler$AutoScrollFromSourceAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

