/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.UIBundle;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002'(B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001f\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\rJ\u0012\u0010\u001a\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0014J;\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0000\u0010\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001d0\u001f2\u0010\u0010 \u001a\f\u0012\u0006\b\u0000\u0012\u0002H\u001d\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0014J\u0012\u0010&\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0014R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/ui/CheckboxTreeBase;", "Lcom/intellij/ui/treeStructure/Tree;", "cellRenderer", "Lcom/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase;", "root", "Lcom/intellij/ui/CheckedTreeNode;", "checkPolicy", "Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;", "<init>", "(Lcom/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase;Lcom/intellij/ui/CheckedTreeNode;Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;)V", "(Lcom/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase;Lcom/intellij/ui/CheckedTreeNode;)V", "myEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ui/CheckboxTreeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myHelper", "Lcom/intellij/ui/CheckboxTreeHelper;", "myCheckPolicy", "setNodeState", "", "node", "checked", "", "addCheckboxTreeListener", "listener", "onDoubleClick", "getCheckedNodes", "", "T", "nodeType", "Ljava/lang/Class;", "filter", "Lcom/intellij/ui/treeStructure/Tree$NodeFilter;", "(Ljava/lang/Class;Lcom/intellij/ui/treeStructure/Tree$NodeFilter;)[Ljava/lang/Object;", "getToggleClickCount", "", "onNodeStateChanged", "nodeStateWillChange", "CheckboxTreeCellRendererBase", "CheckPolicy", "intellij.platform.ide"})
public class CheckboxTreeBase
extends Tree {
    @NotNull
    private final EventDispatcher<CheckboxTreeListener> myEventDispatcher;
    @NotNull
    private final CheckboxTreeHelper myHelper;
    @NotNull
    private final CheckPolicy myCheckPolicy;

    public CheckboxTreeBase(@NotNull CheckboxTreeCellRendererBase cellRenderer, @Nullable CheckedTreeNode root, @NotNull CheckPolicy checkPolicy) {
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        Intrinsics.checkNotNullParameter((Object)checkPolicy, (String)"checkPolicy");
        EventDispatcher eventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.myEventDispatcher = eventDispatcher;
        this.myHelper = new CheckboxTreeHelper(checkPolicy, this.myEventDispatcher);
        this.myCheckPolicy = checkPolicy;
        if (root != null) {
            this.setModel(new DefaultTreeModel((TreeNode)root));
            this.setSelectionRow(0);
        }
        this.myEventDispatcher.addListener((EventListener)new CheckboxTreeListener(){

            public void mouseDoubleClicked(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.onDoubleClick(node);
            }

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.onNodeStateChanged(node);
            }

            public void beforeNodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.nodeStateWillChange(node);
            }
        });
        this.myHelper.initTree(this, this, cellRenderer);
    }

    public /* synthetic */ CheckboxTreeBase(CheckboxTreeCellRendererBase checkboxTreeCellRendererBase, CheckedTreeNode checkedTreeNode, CheckPolicy checkPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            checkboxTreeCellRendererBase = new CheckboxTreeCellRendererBase(false, false, 3, null);
        }
        if ((n & 2) != 0) {
            checkedTreeNode = null;
        }
        this(checkboxTreeCellRendererBase, checkedTreeNode, checkPolicy);
    }

    @Deprecated(message="provide `checkPolicy` explicitly, as the default one is defective")
    @JvmOverloads
    public CheckboxTreeBase(@NotNull CheckboxTreeCellRendererBase cellRenderer, @Nullable CheckedTreeNode root) {
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        this(cellRenderer, root, CheckboxTreeHelper.DEFAULT_POLICY);
    }

    public /* synthetic */ CheckboxTreeBase(CheckboxTreeCellRendererBase checkboxTreeCellRendererBase, CheckedTreeNode checkedTreeNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            checkboxTreeCellRendererBase = new CheckboxTreeCellRendererBase(false, false, 3, null);
        }
        if ((n & 2) != 0) {
            checkedTreeNode = null;
        }
        this(checkboxTreeCellRendererBase, checkedTreeNode);
    }

    public void setNodeState(@NotNull CheckedTreeNode node, boolean checked) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.myHelper.setNodeState(this, node, checked);
    }

    public final void addCheckboxTreeListener(@NotNull CheckboxTreeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    protected void onDoubleClick(@Nullable CheckedTreeNode node) {
    }

    @NotNull
    public <T> T[] getCheckedNodes(@NotNull Class<? extends T> nodeType, @Nullable Tree.NodeFilter<? super T> filter) {
        Intrinsics.checkNotNullParameter(nodeType, (String)"nodeType");
        TreeModel treeModel = this.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
        return CheckboxTreeHelper.Companion.getCheckedNodes(nodeType, filter, treeModel);
    }

    @Override
    public int getToggleClickCount() {
        return -1;
    }

    protected void onNodeStateChanged(@Nullable CheckedTreeNode node) {
    }

    protected void nodeStateWillChange(@Nullable CheckedTreeNode node) {
    }

    @Deprecated(message="provide `checkPolicy` explicitly, as the default one is defective")
    @JvmOverloads
    public CheckboxTreeBase(@NotNull CheckboxTreeCellRendererBase cellRenderer) {
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        this(cellRenderer, null, 2, null);
    }

    @Deprecated(message="provide `checkPolicy` explicitly, as the default one is defective")
    @JvmOverloads
    public CheckboxTreeBase() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;", "", "checkChildrenWithCheckedParent", "", "uncheckChildrenWithUncheckedParent", "checkParentWithCheckedChild", "uncheckParentWithUncheckedChild", "checkByRowClick", "<init>", "(ZZZZZ)V", "getCheckChildrenWithCheckedParent", "()Z", "getUncheckChildrenWithUncheckedParent", "getCheckParentWithCheckedChild", "getUncheckParentWithUncheckedChild", "getCheckByRowClick", "Companion", "intellij.platform.ide"})
    public static class CheckPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean checkChildrenWithCheckedParent;
        private final boolean uncheckChildrenWithUncheckedParent;
        private final boolean checkParentWithCheckedChild;
        private final boolean uncheckParentWithUncheckedChild;
        private final boolean checkByRowClick;
        @JvmField
        @NotNull
        public static final CheckPolicy PROPAGATE_EVERYTHING_POLICY = new CheckPolicy(true, true, true, true, false, 16, null);

        @JvmOverloads
        public CheckPolicy(boolean checkChildrenWithCheckedParent, boolean uncheckChildrenWithUncheckedParent, boolean checkParentWithCheckedChild, boolean uncheckParentWithUncheckedChild, boolean checkByRowClick) {
            this.checkChildrenWithCheckedParent = checkChildrenWithCheckedParent;
            this.uncheckChildrenWithUncheckedParent = uncheckChildrenWithUncheckedParent;
            this.checkParentWithCheckedChild = checkParentWithCheckedChild;
            this.uncheckParentWithUncheckedChild = uncheckParentWithUncheckedChild;
            this.checkByRowClick = checkByRowClick;
        }

        public /* synthetic */ CheckPolicy(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl5 = false;
            }
            this(bl, bl2, bl3, bl4, bl5);
        }

        public final boolean getCheckChildrenWithCheckedParent() {
            return this.checkChildrenWithCheckedParent;
        }

        public final boolean getUncheckChildrenWithUncheckedParent() {
            return this.uncheckChildrenWithUncheckedParent;
        }

        public final boolean getCheckParentWithCheckedChild() {
            return this.checkParentWithCheckedChild;
        }

        public final boolean getUncheckParentWithUncheckedChild() {
            return this.uncheckParentWithUncheckedChild;
        }

        public final boolean getCheckByRowClick() {
            return this.checkByRowClick;
        }

        @JvmOverloads
        public CheckPolicy(boolean checkChildrenWithCheckedParent, boolean uncheckChildrenWithUncheckedParent, boolean checkParentWithCheckedChild, boolean uncheckParentWithUncheckedChild) {
            this(checkChildrenWithCheckedParent, uncheckChildrenWithUncheckedParent, checkParentWithCheckedChild, uncheckParentWithUncheckedChild, false, 16, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy$Companion;", "", "<init>", "()V", "PROPAGATE_EVERYTHING_POLICY", "Lcom/intellij/ui/CheckboxTreeBase$CheckPolicy;", "intellij.platform.ide"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010\u001b\u001a\u0004\u0018\u00010)H\u0002J\b\u0010*\u001a\u00020+H\u0016J@\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase;", "Ljavax/swing/JPanel;", "Ljavax/swing/tree/TreeCellRenderer;", "opaque", "", "myUsePartialStatusForParentNodes", "<init>", "(ZZ)V", "textRenderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "getTextRenderer", "()Lcom/intellij/ui/ColoredTreeCellRenderer;", "myCheckbox", "Lcom/intellij/util/ui/ThreeStateCheckBox;", "getMyCheckbox$annotations", "()V", "checkbox", "Ljavax/swing/JCheckBox;", "getCheckbox$annotations", "getCheckbox", "()Ljavax/swing/JCheckBox;", "threeStateCheckBox", "getThreeStateCheckBox", "()Lcom/intellij/util/ui/ThreeStateCheckBox;", "myIgnoreInheritance", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "getNodeStatus", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "node", "Lcom/intellij/ui/CheckedTreeNode;", "Lcom/intellij/ui/CheckboxTreeBase;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "customizeRenderer", "", "intellij.platform.ide"})
    public static class CheckboxTreeCellRendererBase
    extends JPanel
    implements TreeCellRenderer {
        private final boolean myUsePartialStatusForParentNodes;
        @NotNull
        private final ColoredTreeCellRenderer textRenderer;
        @JvmField
        @NotNull
        public final ThreeStateCheckBox myCheckbox;
        @NotNull
        private final JCheckBox checkbox;
        @NotNull
        private final ThreeStateCheckBox threeStateCheckBox;
        @JvmField
        protected boolean myIgnoreInheritance;

        @JvmOverloads
        public CheckboxTreeCellRendererBase(boolean opaque, boolean myUsePartialStatusForParentNodes) {
            super(new BorderLayout());
            this.myUsePartialStatusForParentNodes = myUsePartialStatusForParentNodes;
            this.textRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                }
            };
            this.myCheckbox = new ThreeStateCheckBox();
            this.checkbox = (JCheckBox)this.myCheckbox;
            this.threeStateCheckBox = this.myCheckbox;
            this.checkbox.setSelected(false);
            this.myCheckbox.setThirdStateEnabled(false);
            this.getTextRenderer().setOpaque(opaque);
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.getTextRenderer(), "Center");
        }

        public /* synthetic */ CheckboxTreeCellRendererBase(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            this(bl, bl2);
        }

        @NotNull
        public ColoredTreeCellRenderer getTextRenderer() {
            return this.textRenderer;
        }

        @Deprecated(message="use `threeStateCheckBox` instead", replaceWith=@ReplaceWith(expression="threeStateCheckBox", imports={}))
        public static /* synthetic */ void getMyCheckbox$annotations() {
        }

        @NotNull
        public final JCheckBox getCheckbox() {
            return this.checkbox;
        }

        @Deprecated(message="use `threeStateCheckBox` instead", replaceWith=@ReplaceWith(expression="threeStateCheckBox", imports={}))
        public static /* synthetic */ void getCheckbox$annotations() {
        }

        @NotNull
        public final ThreeStateCheckBox getThreeStateCheckBox() {
            return this.threeStateCheckBox;
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.invalidate();
            if (value2 instanceof CheckedTreeNode) {
                ThreeStateCheckBox.State state = this.getNodeStatus((CheckedTreeNode)value2, tree instanceof CheckboxTreeBase ? (CheckboxTreeBase)tree : null);
                this.checkbox.setVisible(true);
                this.checkbox.setEnabled(((CheckedTreeNode)value2).isEnabled());
                this.checkbox.setSelected(state != ThreeStateCheckBox.State.NOT_SELECTED);
                this.threeStateCheckBox.setState(state);
                this.checkbox.setOpaque(false);
                this.checkbox.setBackground(null);
                this.setBackground(null);
                if (UIUtil.isUnderWin10LookAndFeel()) {
                    Object hoverValue = this.getClientProperty("JCheckBox.rollOver.rectangle");
                    this.checkbox.getModel().setRollover(hoverValue == value2);
                    Object pressedValue = this.getClientProperty("JCheckBox.pressed.rectangle");
                    this.checkbox.getModel().setPressed(pressedValue == value2);
                }
            } else {
                this.checkbox.setVisible(false);
            }
            this.getTextRenderer().getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.customizeRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.revalidate();
            return this;
        }

        private final ThreeStateCheckBox.State getNodeStatus(CheckedTreeNode node, CheckboxTreeBase tree) {
            ThreeStateCheckBox.State ownState;
            ThreeStateCheckBox.State state = ownState = node.isChecked() ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
            if (this.myIgnoreInheritance || node.getChildCount() == 0 || !this.myUsePartialStatusForParentNodes) {
                return ownState;
            }
            ThreeStateCheckBox.State result2 = null;
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                ThreeStateCheckBox.State childStatus;
                TreeNode child = node.getChildAt(i);
                ThreeStateCheckBox.State state2 = childStatus = child instanceof CheckedTreeNode ? this.getNodeStatus((CheckedTreeNode)child, tree) : ownState;
                if (childStatus == ThreeStateCheckBox.State.DONT_CARE) {
                    return ThreeStateCheckBox.State.DONT_CARE;
                }
                if (result2 == null) {
                    result2 = childStatus;
                    continue;
                }
                if (result2 == childStatus) continue;
                return ThreeStateCheckBox.State.DONT_CARE;
            }
            if (result2 != null && result2 != ownState) {
                if (tree != null && tree.myCheckPolicy == CheckboxTreeHelper.DEFAULT_POLICY) {
                    return result2;
                }
                return ThreeStateCheckBox.State.DONT_CARE;
            }
            ThreeStateCheckBox.State state3 = result2;
            if (state3 == null) {
                state3 = ownState;
            }
            return state3;
        }

        @Override
        @NotNull
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                AccessibleContext accessibleContext = super.getAccessibleContext();
                this.accessibleContext = (AccessibleContext)new AccessibleContextDelegateWithContextMenu(this, accessibleContext){
                    final /* synthetic */ CheckboxTreeCellRendererBase this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    protected Container getDelegateParent() {
                        return this.this$0.getParent();
                    }

                    protected void doShowContextMenu() {
                        ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, null, null, true);
                    }

                    public String getAccessibleName() {
                        return AccessibleContextUtil.combineAccessibleStrings((String)this.this$0.getTextRenderer().getAccessibleContext().getAccessibleName(), (String)UIBundle.message(this.this$0.getCheckbox().isSelected() ? "checkbox.tree.accessible.name.checked" : "checkbox.tree.accessible.name.not.checked", new Object[0]));
                    }
                };
            }
            AccessibleContext accessibleContext = this.accessibleContext;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
            return accessibleContext;
        }

        public void customizeRenderer(@NotNull JTree tree, @NotNull Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        }

        @JvmOverloads
        public CheckboxTreeCellRendererBase(boolean opaque) {
            this(opaque, false, 2, null);
        }

        @JvmOverloads
        public CheckboxTreeCellRendererBase() {
            this(false, false, 3, null);
        }
    }
}

