/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.TooltipTitle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBLabel;
import java.awt.Dimension;
import java.net.URL;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextHelpLabel
extends JBLabel {
    private final HelpTooltip tooltip;

    public ContextHelpLabel(@Nls String label2, @NlsContexts.Tooltip String description) {
        super(label2);
        this.tooltip = new HelpTooltip().setDescription(description);
        this.initTooltip();
    }

    private ContextHelpLabel(@NotNull HelpTooltip tooltip) {
        if (tooltip == null) {
            ContextHelpLabel.$$$reportNull$$$0(0);
        }
        super(AllIcons.General.ContextHelp);
        this.tooltip = tooltip;
    }

    private void initTooltip() {
        this.tooltip.setNeverHideOnTimeout(true).setLocation(HelpTooltip.Alignment.HELP_BUTTON);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tooltip.installOn(this);
    }

    @Override
    public void removeNotify() {
        HelpTooltip.dispose(this);
        super.removeNotify();
    }

    @NotNull
    public static ContextHelpLabel create(@NlsContexts.Tooltip @NotNull String description) {
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(1);
        }
        ContextHelpLabel label2 = new ContextHelpLabel(new HelpTooltip().setDescription(description));
        label2.initTooltip();
        ContextHelpLabel contextHelpLabel = label2;
        if (contextHelpLabel == null) {
            ContextHelpLabel.$$$reportNull$$$0(2);
        }
        return contextHelpLabel;
    }

    @NotNull
    public static ContextHelpLabel create(@TooltipTitle @NotNull String title, @NlsContexts.Tooltip @NotNull String description) {
        if (title == null) {
            ContextHelpLabel.$$$reportNull$$$0(3);
        }
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(4);
        }
        ContextHelpLabel label2 = new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title));
        label2.initTooltip();
        ContextHelpLabel contextHelpLabel = label2;
        if (contextHelpLabel == null) {
            ContextHelpLabel.$$$reportNull$$$0(5);
        }
        return contextHelpLabel;
    }

    @NotNull
    public static ContextHelpLabel createWithLink(@TooltipTitle @Nullable String title, @NlsContexts.Tooltip @NotNull String description, @NlsContexts.LinkLabel @NotNull String linkText, @NotNull Runnable linkAction) {
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(6);
        }
        if (linkText == null) {
            ContextHelpLabel.$$$reportNull$$$0(7);
        }
        if (linkAction == null) {
            ContextHelpLabel.$$$reportNull$$$0(8);
        }
        return ContextHelpLabel.createWithLink(title, description, linkText, false, linkAction);
    }

    @NotNull
    public static ContextHelpLabel createWithLink(@TooltipTitle @Nullable String title, @NlsContexts.Tooltip @NotNull String description, @NlsContexts.LinkLabel @NotNull String linkText, boolean linkIsExternal, @NotNull Runnable linkAction) {
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(9);
        }
        if (linkText == null) {
            ContextHelpLabel.$$$reportNull$$$0(10);
        }
        if (linkAction == null) {
            ContextHelpLabel.$$$reportNull$$$0(11);
        }
        ContextHelpLabel label2 = new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title).setLink(linkText, linkAction, linkIsExternal));
        label2.initTooltip();
        ContextHelpLabel contextHelpLabel = label2;
        if (contextHelpLabel == null) {
            ContextHelpLabel.$$$reportNull$$$0(12);
        }
        return contextHelpLabel;
    }

    @NotNull
    public static ContextHelpLabel createWithBrowserLink(@TooltipTitle @Nullable String title, @NlsContexts.Tooltip @NotNull String description, @NlsContexts.LinkLabel @NotNull String linkText, @NotNull URL url) {
        if (description == null) {
            ContextHelpLabel.$$$reportNull$$$0(13);
        }
        if (linkText == null) {
            ContextHelpLabel.$$$reportNull$$$0(14);
        }
        if (url == null) {
            ContextHelpLabel.$$$reportNull$$$0(15);
        }
        ContextHelpLabel label2 = new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title).setBrowserLink(linkText, url));
        label2.initTooltip();
        ContextHelpLabel contextHelpLabel = label2;
        if (contextHelpLabel == null) {
            ContextHelpLabel.$$$reportNull$$$0(16);
        }
        return contextHelpLabel;
    }

    @NotNull
    public static ContextHelpLabel createFromTooltip(HelpTooltip helpTooltip) {
        return new ContextHelpLabel(helpTooltip);
    }

    @Override
    public void setPreferredSize(Dimension size) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ContextHelpLabel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkAction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ContextHelpLabel";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithLink";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithBrowserLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createWithLink";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createWithBrowserLink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 12, 16 -> new IllegalStateException(string);
        };
    }
}

