/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FilterComponent
extends JPanel {
    private final SearchTextField myFilter;
    private final SingleEdtTaskScheduler updateAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
    private final boolean myOnTheFly;

    public FilterComponent(@NonNls String propertyName, int historySize) {
        this(propertyName, historySize, true);
    }

    public FilterComponent(@NonNls String propertyName, int historySize, boolean onTheFlyUpdate) {
        super(new BorderLayout());
        this.myOnTheFly = onTheFlyUpdate;
        this.myFilter = new SearchTextField(propertyName){

            @Override
            protected Runnable createItemChosenCallback(JList list) {
                Runnable callback = super.createItemChosenCallback(list);
                return () -> {
                    callback.run();
                    FilterComponent.this.filter();
                };
            }

            @Override
            protected Component getPopupLocationComponent() {
                return FilterComponent.this.getPopupLocationComponent();
            }
        };
        this.myFilter.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    FilterComponent.this.userTriggeredFilter();
                } else if (e.getKeyCode() == 27) {
                    FilterComponent.this.onEscape(e);
                }
            }
        });
        this.myFilter.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }
        });
        this.myFilter.setHistorySize(historySize);
        AccessibleContextUtil.setName((Component)this.myFilter.getTextEditor(), (String)UIBundle.message("filter.component.accessible.name", new Object[0]));
        this.add((Component)this.myFilter, "Center");
    }

    protected JComponent getPopupLocationComponent() {
        return this.myFilter;
    }

    public JTextField getTextEditor() {
        return this.myFilter.getTextEditor();
    }

    private void onChange() {
        if (this.myOnTheFly) {
            this.updateAlarm.cancelAndRequest(100L, ModalityState.stateForComponent((Component)this.myFilter), () -> this.onlineFilter());
        }
    }

    public void setHistorySize(int historySize) {
        this.myFilter.setHistorySize(historySize);
    }

    public void reset() {
        this.myFilter.reset();
    }

    protected void onEscape(@NotNull KeyEvent e) {
        if (e == null) {
            FilterComponent.$$$reportNull$$$0(0);
        }
    }

    public String getFilter() {
        return this.myFilter.getText();
    }

    public void setSelectedItem(String filter) {
        this.myFilter.setSelectedItem(filter);
    }

    public void setFilter(String filter) {
        this.myFilter.setText(filter);
    }

    public void selectText() {
        this.myFilter.selectText();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myFilter.requestFocusInWindow();
    }

    public abstract void filter();

    protected void onlineFilter() {
        this.filter();
    }

    public void userTriggeredFilter() {
        this.myFilter.addCurrentTextToHistory();
        this.filter();
    }

    public void dispose() {
        this.updateAlarm.dispose();
    }

    protected void setHistory(List<String> strings) {
        this.myFilter.setHistory(strings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/FilterComponent", "onEscape"));
    }
}

