/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

public final class GuiUtils {
    private static final Insets paddingInsideDialog = JBUI.insets((int)5);
    private static final CharFilter NOT_MNEMONIC_CHAR_FILTER = ch -> ch != '&' && ch != '\u001b';

    public static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    public static JPanel constructFieldWithBrowseButton(TextFieldWithHistory aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    private static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener, int delta) {
        JPanel result2 = new JPanel(new GridBagLayout());
        result2.add((Component)aComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        FixedSizeButton browseButton = new FixedSizeButton(aComponent.getPreferredSize().height - delta);
        ComponentWithBrowseButton.MyDoClickAction.addTo(browseButton, aComponent);
        result2.add((Component)browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        browseButton.addActionListener(aActionListener);
        return result2;
    }

    public static Component createVerticalStrut() {
        return Box.createRigidArea(new Dimension(0, GuiUtils.paddingInsideDialog.top));
    }

    public static String getTextWithoutMnemonicEscaping(String text) {
        return StringUtil.strip((String)text, (CharFilter)NOT_MNEMONIC_CHAR_FILTER);
    }

    public static char getDisplayedMnemonic(String text) {
        int i = GuiUtils.getDisplayedMnemonicIndex(text);
        return i == -1 ? (char)'\uffff' : text.charAt(i + 1);
    }

    public static int getDisplayedMnemonicIndex(String text) {
        return text.indexOf("&");
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root) {
        GuiUtils.replaceJSplitPaneWithIDEASplitter(root, false);
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root, boolean useOnePixelDivider) {
        Container parent = root.getParent();
        if (root instanceof JSplitPane) {
            JSplitPane pane = (JSplitPane)root;
            if (parent.getComponents().length != 1 && !(parent instanceof Splitter)) {
                return;
            }
            Component component1 = pane.getTopComponent();
            Component component2 = pane.getBottomComponent();
            int orientation = pane.getOrientation();
            boolean vertical = orientation == 0;
            JBSplitter splitter = useOnePixelDivider ? new OnePixelSplitter(vertical) : new JBSplitter(vertical);
            splitter.setFirstComponent((JComponent)component1);
            splitter.setSecondComponent((JComponent)component2);
            splitter.setShowDividerControls(pane.isOneTouchExpandable());
            splitter.setHonorComponentsMinimumSize(true);
            if (pane.getDividerLocation() > 0) {
                SwingUtilities.invokeLater(() -> {
                    double proportion = pane.getOrientation() == 0 ? (double)pane.getDividerLocation() / (double)(parent.getHeight() - pane.getDividerSize()) : (double)pane.getDividerLocation() / (double)(parent.getWidth() - pane.getDividerSize());
                    if (proportion > 0.0 && proportion < 1.0) {
                        splitter.setProportion((float)proportion);
                    }
                });
            }
            if (parent instanceof Splitter) {
                Splitter psplitter = (Splitter)parent;
                if (psplitter.getFirstComponent() == root) {
                    psplitter.setFirstComponent((JComponent)((Object)splitter));
                } else {
                    psplitter.setSecondComponent((JComponent)((Object)splitter));
                }
            } else {
                parent.remove(0);
                parent.setLayout(new BorderLayout());
                parent.add((Component)((Object)splitter), "Center");
            }
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component1, useOnePixelDivider);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component2, useOnePixelDivider);
        } else {
            Component[] components;
            for (Component component : components = root.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component, useOnePixelDivider);
            }
        }
    }

    public static void iterateChildren(Component container, Consumer<? super Component> consumer, JComponent ... excludeComponents) {
        if (excludeComponents != null && ArrayUtilRt.find((Object[])excludeComponents, (Object)container) != -1) {
            return;
        }
        consumer.accept(container);
        if (container instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)container).getComponents()) {
                GuiUtils.iterateChildren(child, consumer, excludeComponents);
            }
        }
    }

    public static void enableChildren(boolean enabled, Component ... components) {
        for (Component component : components) {
            GuiUtils.enableChildren(component, enabled, new JComponent[0]);
        }
    }

    public static void showComponents(boolean visible, Component ... components) {
        for (Component component : components) {
            component.setVisible(visible);
        }
    }

    public static void enableChildren(Component container, boolean enabled, JComponent ... excludeComponents) {
        GuiUtils.iterateChildren(container, t -> GuiUtils.enableComponent(t, enabled), excludeComponents);
    }

    private static void enableComponent(Component component, boolean enabled) {
        if (component.isEnabled() == enabled) {
            return;
        }
        component.setEnabled(enabled);
        if (component instanceof JPanel) {
            Border border = ((JPanel)component).getBorder();
            if (border instanceof TitledBorder) {
                Color color = enabled ? component.getForeground() : NamedColorUtil.getInactiveTextColor();
                ((TitledBorder)border).setTitleColor(color);
            }
        } else if (component instanceof JLabel) {
            JLabel label2 = (JLabel)component;
            Color color = NamedColorUtil.getInactiveTextColor();
            @NonNls String changeColorString = "<font color=#" + GuiUtils.colorToHex(color) + ">";
            @NonNls Object text = label2.getText();
            if (text != null && ((String)text).startsWith("<html>")) {
                if (StringUtil.startsWithConcatenation((String)text, (String[])new String[]{"<html>", changeColorString}) && enabled) {
                    text = "<html>" + ((String)text).substring(("<html>" + changeColorString).length());
                } else if (!StringUtil.startsWithConcatenation((String)text, (String[])new String[]{"<html>", changeColorString}) && !enabled) {
                    text = "<html>" + changeColorString + ((String)text).substring("<html>".length());
                }
                label2.setText((String)text);
            }
        } else if (component instanceof JTable) {
            TableColumnModel columnModel = ((JTable)component).getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableCellRenderer cellRenderer = columnModel.getColumn(0).getCellRenderer();
                if (!(cellRenderer instanceof Component)) continue;
                GuiUtils.enableComponent((Component)((Object)cellRenderer), enabled);
            }
        }
    }

    public static String colorToHex(Color color) {
        return UIUtil.colorToHex((Color)color);
    }

    @Deprecated(forRemoval=true)
    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        Application app;
        if (runnable == null) {
            GuiUtils.$$$reportNull$$$0(0);
        }
        if (modalityState == null) {
            GuiUtils.$$$reportNull$$$0(1);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, modalityState);
        }
    }

    public static JTextField createUndoableTextField() {
        return new JBTextField();
    }

    @NotNull
    public static Dimension getSizeByChars(int charCount, @NotNull JComponent comp) {
        if (comp == null) {
            GuiUtils.$$$reportNull$$$0(2);
        }
        Dimension size = comp.getPreferredSize();
        FontMetrics fontMetrics = comp.getFontMetrics(comp.getFont());
        size.width = fontMetrics.charWidth('a') * charCount;
        Dimension dimension = size;
        if (dimension == null) {
            GuiUtils.$$$reportNull$$$0(3);
        }
        return dimension;
    }

    public static void installVisibilityReferent(final JComponent owner2, JComponent referent) {
        referent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                this.toggleVisibility(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.toggleVisibility(e);
            }

            private void toggleVisibility(ComponentEvent e) {
                Component component = e.getComponent();
                if (component != null) {
                    owner2.setVisible(component.isVisible());
                }
            }
        });
    }

    public static void removePotentiallyLeakingReferences(@NotNull Container container) {
        if (container == null) {
            GuiUtils.$$$reportNull$$$0(4);
        }
        assert (SwingUtilities.isEventDispatchThread());
        AWTAccessor.getComponentAccessor().setParent(container, null);
        container.removeAll();
        for (ComponentListener componentListener : container.getComponentListeners()) {
            container.removeComponentListener(componentListener);
        }
        for (EventListener eventListener : container.getFocusListeners()) {
            container.removeFocusListener((FocusListener)eventListener);
        }
        for (EventListener eventListener : container.getHierarchyListeners()) {
            container.removeHierarchyListener((HierarchyListener)eventListener);
        }
        for (EventListener eventListener : container.getHierarchyBoundsListeners()) {
            container.removeHierarchyBoundsListener((HierarchyBoundsListener)eventListener);
        }
        for (EventListener eventListener : container.getKeyListeners()) {
            container.removeKeyListener((KeyListener)eventListener);
        }
        for (EventListener eventListener : container.getMouseListeners()) {
            container.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : container.getMouseMotionListeners()) {
            container.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : container.getMouseWheelListeners()) {
            container.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : container.getInputMethodListeners()) {
            container.removeInputMethodListener((InputMethodListener)eventListener);
        }
        for (EventListener eventListener : container.getPropertyChangeListeners()) {
            container.removePropertyChangeListener((PropertyChangeListener)eventListener);
        }
        for (EventListener eventListener : container.getContainerListeners()) {
            container.removeContainerListener((ContainerListener)eventListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/GuiUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/GuiUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeByChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSizeByChars";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removePotentiallyLeakingReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

