/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.execution.ui.FragmentWrapper;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawCommandLineEditor
extends JPanel
implements TextAccessor,
FragmentWrapper {
    private final ExpandableTextField myEditor;
    private String myDialogCaption = "";

    public RawCommandLineEditor() {
        this((Function<? super String, ? extends List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<? super List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public RawCommandLineEditor(Function<? super String, ? extends List<String>> lineParser, Function<? super List<String>, String> lineJoiner) {
        super(new BorderLayout());
        this.myEditor = new ExpandableTextField(lineParser, lineJoiner);
        this.setFocusable(false);
        this.add((Component)this.myEditor, "Center");
        this.setDescriptor(null);
        this.putClientProperty((Object)DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        this.putClientProperty((Object)DslComponentProperty.INTERACTIVE_COMPONENT, this.myEditor);
        this.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, UnscaledGapsKt.toUnscaledGaps(this.myEditor.getInsets()));
    }

    public void setDescriptor(FileChooserDescriptor descriptor2) {
        this.setDescriptor(descriptor2, true);
    }

    public void setDescriptor(FileChooserDescriptor descriptor2, boolean insertSystemDependentPaths) {
        InsertPathAction.addTo(this.myEditor, descriptor2, insertSystemDependentPaths);
    }

    @Deprecated(forRemoval=true)
    public String getDialogCaption() {
        return this.myDialogCaption;
    }

    @Deprecated
    public void setDialogCaption(String dialogCaption) {
        this.myDialogCaption = dialogCaption != null ? dialogCaption : "";
    }

    public void setText(@Nullable String text) {
        this.myEditor.setText(text);
    }

    public String getText() {
        return StringUtil.notNullize((String)this.myEditor.getText());
    }

    public JTextField getTextField() {
        return this.myEditor;
    }

    public ExpandableTextField getEditorField() {
        return this.myEditor;
    }

    public Document getDocument() {
        return this.myEditor.getDocument();
    }

    public void attachLabel(JLabel label2) {
        label2.setLabelFor(this.myEditor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myEditor.setEnabled(enabled);
    }

    @NotNull
    public RawCommandLineEditor withMonospaced(boolean monospaced) {
        this.myEditor.setMonospaced(monospaced);
        RawCommandLineEditor rawCommandLineEditor = this;
        if (rawCommandLineEditor == null) {
            RawCommandLineEditor.$$$reportNull$$$0(0);
        }
        return rawCommandLineEditor;
    }

    @Override
    public JComponent getComponentToRegister() {
        return this.getEditorField();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/RawCommandLineEditor", "withMonospaced"));
    }
}

