/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.MarkupText;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.HtmlToSimpleColoredComponentConverter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SuitableFontProvider;
import com.intellij.ui.icons.IconWithToolTip;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class SimpleColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final Logger LOG = Logger.getInstance(SimpleColoredComponent.class);
    public static final int FRAGMENT_ICON = -2;
    private static final Cache<WidthKey, Float> widthCache = Caffeine.newBuilder().maximumSize(128L).build();
    private final List<ColoredFragment> myFragments;
    private ColoredFragment myCurrentFragment;
    private Font myLayoutFont;
    private FontRenderContext myLayoutFRC;
    private Icon myIcon;
    private Insets myIpad;
    protected int myIconTextGap;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private Border border;
    private int myMainTextLastIndex = -1;
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private boolean myIconOnTheRight;
    private boolean myTransparentIconBackground;
    private boolean myDynamicSearchMatchHighlighting;

    public SimpleColoredComponent() {
        this.myFragments = new ArrayList<ColoredFragment>(3);
        this.myIpad = JBInsets.create((int)1, (int)2);
        this.myIconTextGap = JBUIScale.scale((int)2);
        this.border = JBUI.Borders.empty((int)1);
        this.setOpaque(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAATextInfoForSwingComponent());
        Object value2 = UIManager.getDefaults().get(RenderingHints.KEY_FRACTIONALMETRICS);
        if (value2 == null) {
            value2 = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        }
        this.putClientProperty(RenderingHints.KEY_FRACTIONALMETRICS, value2);
    }

    @NotNull
    public ColoredIterator iterator() {
        return new MyIterator();
    }

    @NotNull
    public ColoredIterator iterator(int fromIndex) {
        MyIterator iterator = new MyIterator();
        iterator.myIndex = fromIndex - 1;
        MyIterator myIterator = iterator;
        if (myIterator == null) {
            SimpleColoredComponent.$$$reportNull$$$0(0);
        }
        return myIterator;
    }

    public boolean isIconOnTheRight() {
        return this.myIconOnTheRight;
    }

    public void setIconOnTheRight(boolean iconOnTheRight) {
        this.myIconOnTheRight = iconOnTheRight;
    }

    @NotNull
    public final SimpleColoredComponent append(@NotNull @Nls String fragment) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(1);
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        SimpleColoredComponent simpleColoredComponent = this;
        if (simpleColoredComponent == null) {
            SimpleColoredComponent.$$$reportNull$$$0(2);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public final SimpleColoredComponent appendWithClipping(@NotNull @Nls String fragment, @Nullable FragmentTextClipper clipper) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(3);
        }
        return this.appendWithClipping(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES, clipper);
    }

    @NotNull
    public final SimpleColoredComponent appendWithClipping(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, @Nullable FragmentTextClipper clipper) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(5);
        }
        this._append(fragment, attributes, clipper, this.myMainTextLastIndex < 0);
        this.revalidateAndRepaint();
        SimpleColoredComponent simpleColoredComponent = this;
        if (simpleColoredComponent == null) {
            SimpleColoredComponent.$$$reportNull$$$0(6);
        }
        return simpleColoredComponent;
    }

    public final void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(7);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(8);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public final void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, int padding, @JdkConstants.HorizontalAlignment int align) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(9);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(10);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
        this.appendTextPadding(padding, align);
    }

    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(12);
        }
        this._append(fragment, attributes, null, isMainText);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, @Nullable FragmentTextClipper clipper, boolean isMainText) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(13);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(14);
        }
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            this.myCurrentFragment = new ColoredFragment(fragment, attributes, this, clipper);
            this.myFragments.add(this.myCurrentFragment);
            if (isMainText) {
                this.myMainTextLastIndex = this.myFragments.size() - 1;
            }
        }
    }

    protected void revalidateAndRepaint() {
        this.firePropertyChange("state", null, this);
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(15);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(16);
        }
        this._append(fragment, attributes, tag);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _append(@Nls String fragment, SimpleTextAttributes attributes, Object tag) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            this.append(fragment, attributes);
            if (tag != null) {
                this.myCurrentFragment.tag = tag;
            }
        }
    }

    public void appendTextPadding(int padding) {
        this.appendTextPadding(padding, 2);
    }

    public void appendHTML(@Nls String html, SimpleTextAttributes baseAttributes) {
        new HtmlToSimpleColoredComponentConverter().appendHtml(this, html, baseAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendTextPadding(int padding, @JdkConstants.HorizontalAlignment int align) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (this.myCurrentFragment != null) {
                this.myCurrentFragment.padding = padding;
                this.myCurrentFragment.alignment = align;
            }
        }
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    @ApiStatus.Experimental
    public static SimpleColoredComponent fromMarkupText(@NotNull MarkupText text) {
        if (text == null) {
            SimpleColoredComponent.$$$reportNull$$$0(17);
        }
        SimpleColoredComponent component = new SimpleColoredComponent();
        for (MarkupText.Fragment fragment : text.fragments()) {
            component.append(fragment.text(), SimpleTextAttributes.fromMarkupTextKind((MarkupText.Kind)fragment.kind()));
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clear() {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            this.myIcon = null;
            this.myPaintFocusBorder = false;
            this.myFragments.clear();
            this.myCurrentFragment = null;
            this.myMainTextLastIndex = -1;
        }
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    public final void setIcon(@Nullable Icon icon) {
        if (!Objects.equals(icon, this.myIcon)) {
            this.myIcon = icon;
            this.revalidateAndRepaint();
        }
    }

    @NotNull
    public Insets getIpad() {
        Insets insets = this.myIpad;
        if (insets == null) {
            SimpleColoredComponent.$$$reportNull$$$0(18);
        }
        return insets;
    }

    public void setIpad(@NotNull Insets ipad) {
        if (ipad == null) {
            SimpleColoredComponent.$$$reportNull$$$0(19);
        }
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    public Border getMyBorder() {
        return this.border;
    }

    public void setMyBorder(@Nullable Border border) {
        this.border = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        if (this.myPaintFocusBorder == paintFocusBorder) {
            return;
        }
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        if (this.myFocusBorderAroundIcon == focusBorderAroundIcon) {
            return;
        }
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        if (this.myIconOpaque == iconOpaque) {
            return;
        }
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            Dimension dimension = super.getMinimumSize();
            if (dimension == null) {
                SimpleColoredComponent.$$$reportNull$$$0(20);
            }
            return dimension;
        }
        return this.computePreferredSize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getFragmentTag(int index) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (0 <= index && index < this.myFragments.size()) {
                return this.myFragments.get((int)index).tag;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFragmentCount() {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            return this.myFragments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Dimension computePreferredSize(boolean mainTextOnly) {
        List<ColoredFragment> list = this.myFragments;
        // MONITORENTER : list
        float width = this.myIpad.left;
        if (this.myIcon != null) {
            width += (float)(this.myIcon.getIconWidth() + this.myIconTextGap);
        }
        JBInsets borderInsets = this.border != null ? this.border.getBorderInsets(this) : JBInsets.emptyInsets();
        width += (float)borderInsets.left;
        Font font = this.getBaseFont();
        width += this.computeTextWidth(font, mainTextOnly);
        width += (float)(this.myIpad.right + borderInsets.right);
        Insets insets = this.getInsets();
        if (insets != null) {
            width += (float)(insets.left + insets.right);
        }
        int height = this.computePreferredHeight();
        Dimension dimension = new Dimension((int)Math.ceil(width), height);
        // MONITOREXIT : list
        if (dimension != null) return dimension;
        SimpleColoredComponent.$$$reportNull$$$0(21);
        return dimension;
    }

    @ApiStatus.Internal
    public final synchronized int computePreferredHeight() {
        int height = this.myIpad.top + this.myIpad.bottom;
        Font font = this.getBaseFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = Math.max(this.getMinHeight(), metrics.getHeight());
        JBInsets borderInsets = this.border != null ? this.border.getBorderInsets(this) : JBInsets.emptyInsets();
        height += this.myIcon == null ? textHeight : Math.max(this.myIcon.getIconHeight(), textHeight += borderInsets.top + borderInsets.bottom);
        Insets insets = this.getInsets();
        if (insets != null) {
            height += insets.top + insets.bottom;
        }
        return height;
    }

    protected int getMinHeight() {
        return JBUIScale.scale((int)16);
    }

    @ApiStatus.Internal
    protected Rectangle computePaintArea() {
        Rectangle area = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.getInsets());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.myIpad);
        return area;
    }

    private float computeTextWidth(@NotNull Font font, boolean mainTextOnly) {
        if (font == null) {
            SimpleColoredComponent.$$$reportNull$$$0(22);
        }
        float result2 = 0.0f;
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myFragments.size(); ++i) {
            ColoredFragment fragment = this.myFragments.get(i);
            SimpleTextAttributes attributes = fragment.attributes;
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = SimpleColoredComponent.deriveFont(font, attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            result2 += this.computeStringWidth(fragment, i, font);
            int fixedWidth = fragment.padding;
            if (fixedWidth > 0 && result2 < (float)fixedWidth) {
                result2 = fixedWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        return result2;
    }

    @NotNull
    protected Font getBaseFont() {
        Font font = this.getFont();
        if (font == null) {
            font = StartupUiUtil.getLabelFont();
        }
        Font font2 = font;
        if (font2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(23);
        }
        return font2;
    }

    private FontRenderContext getFontRenderContext(Font font) {
        FontRenderContext frc = this.getFontMetrics(font).getFontRenderContext();
        Font baseFont = this.getBaseFont();
        if (!baseFont.equals(this.myLayoutFont) || !frc.equals(this.myLayoutFRC)) {
            this.myFragments.forEach(ColoredFragment::invalidateLayout);
            this.myLayoutFont = new ImmutableFont(baseFont);
            this.myLayoutFRC = frc;
        }
        return frc;
    }

    private void doDrawString(Graphics2D g, @NotNull ColoredFragment fragment, int fragmentIndex, float x, float y) {
        String text;
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmpty((String)(text = fragment.text))) {
            return;
        }
        Font font = g.getFont();
        FontRenderContext frc = this.getFontRenderContext(font);
        fragment.getAndCacheRenderer(font, frc).draw(g, fragmentIndex, x, y);
    }

    private float computeStringWidth(@NotNull ColoredFragment fragment, int index, Font font) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(25);
        }
        if (StringUtil.isEmpty((String)fragment.text)) {
            return 0.0f;
        }
        if (this.myFragments.get(index) != fragment) {
            return 0.0f;
        }
        ColoredFragment nextFragment = index < this.myFragments.size() - 1 ? this.myFragments.get(index + 1) : null;
        FontRenderContext frc = this.getFontRenderContext(font);
        if (!SystemInfo.isMacOSCatalina || !fragment.attributes.isSearchMatch() || nextFragment == null || fragment.attributes.getFontStyle() != nextFragment.attributes.getFontStyle()) {
            return SimpleColoredComponent.getFragmentWidth(fragment, font, frc);
        }
        float first = SimpleColoredComponent.getFragmentWidth(fragment, font, frc);
        float second = SimpleColoredComponent.getFragmentWidth(nextFragment, font, frc);
        float compound = SimpleColoredComponent.getFragmentWidth(new ColoredFragment(fragment.text + nextFragment.text, fragment.attributes, this, null), font, frc);
        return (first + 2.0f * (compound - second)) / 3.0f;
    }

    private static float getFragmentWidth(@NotNull ColoredFragment fragment, Font font, FontRenderContext frc) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(26);
        }
        WidthKey key = new WidthKey(fragment.text, new ImmutableFont(font), frc, fragment.attributes.getStyle(), font.getSize());
        return ((Float)widthCache.get((Object)key, it -> Float.valueOf(fragment.getAndCacheRenderer(it.font, it.frc).getWidth()))).floatValue();
    }

    @NotNull
    private static TextLayout createTextLayout(String text, Font basefont, FontRenderContext fontRenderContext) {
        AttributedString string = new AttributedString(text);
        int length = text.length();
        Font currentFont = basefont;
        int currentIndex = 0;
        int pos = 0;
        while (pos < length) {
            Font font = basefont;
            int codePoint = text.codePointAt(pos);
            if (!font.canDisplay(codePoint)) {
                SuitableFontProvider provider;
                Iterator iterator = SuitableFontProvider.EP_NAME.getExtensionsIfPointIsRegistered().iterator();
                while (iterator.hasNext() && (font = (provider = (SuitableFontProvider)iterator.next()).getFontAbleToDisplay(codePoint, basefont.getSize(), basefont.getStyle(), basefont.getFamily())) == null) {
                }
            }
            if (!Comparing.equal((Object)currentFont, (Object)font)) {
                if (pos > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, pos);
                }
                currentFont = font;
                currentIndex = pos;
            }
            pos = text.offsetByCodePoints(pos, 1);
        }
        if (currentIndex < length) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, length);
        }
        return new TextLayout(string.getIterator(), fontRenderContext);
    }

    private static boolean needFontFallback(Font font, String text) {
        return font.canDisplayUpTo(text) != -1 && text.indexOf(65535) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findFragmentAt(int x) {
        float curX = this.myIpad.left;
        if (this.border != null) {
            curX += (float)this.border.getBorderInsets((Component)this).left;
        }
        curX += (float)this.getInsets().left;
        if (this.myIcon != null && !this.myIconOnTheRight) {
            int iconRight = this.myIcon.getIconWidth() + this.myIconTextGap;
            if (x < iconRight) {
                return -2;
            }
            curX += (float)iconRight;
        }
        Font font = this.getBaseFont();
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            curX += (float)this.computeTextAlignShift();
            for (int i = 0; i < this.myFragments.size(); ++i) {
                ColoredFragment fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = fragment.attributes;
                boolean isSmaller = attributes.isSmaller();
                if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                    font = SimpleColoredComponent.deriveFont(font, attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
                }
                wasSmaller = isSmaller;
                float curWidth = this.computeStringWidth(fragment, i, font);
                if ((float)x >= curX && (float)x < curX + curWidth) {
                    return i;
                }
                curX += curWidth;
                int fragmentPadding = fragment.padding;
                if (fragmentPadding <= 0 || !(curX < (float)fragmentPadding)) continue;
                curX = fragmentPadding;
            }
        }
        if (this.myIcon != null && this.myIconOnTheRight && (float)x >= (curX += (float)(this.myIconTextGap + this.myIpad.left)) && (float)x < curX + (float)this.myIcon.getIconWidth()) {
            return -2;
        }
        return -1;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        int index = this.findFragmentAt(x);
        return index < 0 ? null : this.getFragmentTag(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected JLabel formatToLabel(@NotNull JLabel label2) {
        if (label2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(27);
        }
        label2.setIcon(this.myIcon);
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (!this.myFragments.isEmpty()) {
                @Nls StringBuilder sb = new StringBuilder();
                sb.append("<html><body style=\"white-space:nowrap\">");
                for (ColoredFragment fragment : this.myFragments) {
                    String text = fragment.text;
                    SimpleTextAttributes attributes = fragment.attributes;
                    Object tag = fragment.tag;
                    if (tag instanceof BrowserLauncherTag) {
                        SimpleColoredComponent.formatLink(sb, text, attributes, ((BrowserLauncherTag)tag).myUrl);
                        continue;
                    }
                    SimpleColoredComponent.formatText(sb, text, attributes);
                }
                sb.append("</body></html>");
                label2.setText(sb.toString());
            }
        }
        JLabel jLabel = label2;
        if (jLabel == null) {
            SimpleColoredComponent.$$$reportNull$$$0(28);
        }
        return jLabel;
    }

    static void formatText(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (builder == null) {
            SimpleColoredComponent.$$$reportNull$$$0(29);
        }
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(30);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(31);
        }
        if (!fragment.isEmpty()) {
            builder.append("<span");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (builder == null) {
            SimpleColoredComponent.$$$reportNull$$$0(32);
        }
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(33);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(34);
        }
        if (url == null) {
            SimpleColoredComponent.$$$reportNull$$$0(35);
        }
        if (!fragment.isEmpty()) {
            builder.append("<a href=\"").append(StringUtil.replace((String)url, (String)"\"", (String)"%22")).append("\"");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    private static String convertFragment(@NotNull String fragment) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(36);
        }
        return StringUtil.escapeXmlEntities((String)fragment).replaceAll("\\\\n", "<br>");
    }

    private static void formatStyle(StringBuilder builder, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder.length();
        if (fgColor != null) {
            builder.append("color:").append(ColorUtil.toHtmlColor((Color)fgColor)).append(';');
        }
        if (bgColor != null) {
            builder.append("background-color:").append(ColorUtil.toHtmlColor((Color)bgColor)).append(';');
        }
        if ((style & 1) != 0) {
            builder.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder.append("text-decoration:line-through;");
        }
        if (builder.length() > pos) {
            builder.insert(pos, " style=\"");
            builder.append('\"');
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this.doPaint((Graphics2D)g);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPaint(Graphics2D g) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            int offset = 0;
            Icon icon = this.myIcon;
            if (icon != null && !this.myIconOnTheRight) {
                this.doPaintIcon(g, icon, 0);
                offset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
            }
            this.doPaintTextBackground(g, offset);
            offset = this.doPaintText(g, offset, this.myFocusBorderAroundIcon || icon == null) + this.myIconTextGap;
            if (icon != null && this.myIconOnTheRight) {
                this.doPaintIcon(g, icon, offset);
            }
        }
    }

    private void doPaintTextBackground(Graphics2D g, int offset) {
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(37);
        }
        if (icon == null) {
            SimpleColoredComponent.$$$reportNull$$$0(38);
        }
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon, offset + this.myIpad.left);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPaintText(Graphics2D g, int textStart, boolean focusAroundIcon) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (textStart == 0) {
                textStart = this.myIpad.left;
            }
            float offset = textStart;
            if (this.border != null) {
                offset += (float)this.border.getBorderInsets((Component)this).left;
            }
            offset += (float)this.getInsets().left;
            int height = this.getHeight();
            this.applyAdditionalHints(g);
            Font baseFont = this.getBaseFont();
            g.setFont(baseFont);
            offset += (float)this.computeTextAlignShift();
            int baseSize = baseFont.getSize();
            FontMetrics baseMetrics = g.getFontMetrics();
            Rectangle area = this.computePaintArea();
            int textBaseline = area.y + SimpleColoredComponent.getTextBaseLine(baseMetrics, area.height);
            boolean wasSmaller = false;
            final class Frag {
                private final int index;
                private final float start;
                private final float end;
                private final float baseLine;
                private final Font font;
                private final Frag next;

                private Frag(SimpleColoredComponent this$0, int index, float start2, float end, @NotNull float baseLine, Font font, Frag next) {
                    if (font == null) {
                        Frag.$$$reportNull$$$0(0);
                    }
                    this.index = index;
                    this.start = start2;
                    this.end = end;
                    this.baseLine = baseLine;
                    this.font = font;
                    this.next = next;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/ui/SimpleColoredComponent$1Frag", "<init>"));
                }
            }
            Frag secondPassFrag = null;
            for (int i = 0; i < this.myFragments.size(); ++i) {
                float endOffset;
                boolean enabled;
                Color color;
                Color bgColor;
                ColoredFragment fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = fragment.attributes;
                Font font = g.getFont();
                boolean isSmaller = attributes.isSmaller();
                if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                    font = SimpleColoredComponent.deriveFont(font, attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
                }
                wasSmaller = isSmaller;
                g.setFont(font);
                FontMetrics metrics = g.getFontMetrics(font);
                float fragmentWidth = this.computeStringWidth(fragment, i, font);
                int fragmentPadding = fragment.padding;
                boolean secondPass = attributes.isSearchMatch() || attributes.isClickable();
                Color color2 = bgColor = secondPass ? null : attributes.getBgColor();
                if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                    this.doPaintFragmentBackground(g, i, bgColor, (int)offset, 0, (int)fragmentWidth, height);
                }
                Color color3 = color = (enabled = this.isEnabled()) ? this.getActiveTextColor(attributes.getFgColor()) : NamedColorUtil.getInactiveTextColor();
                if (enabled && attributes.useFaded()) {
                    color = ColorUtil.faded((Color)color);
                }
                g.setColor(color);
                int fragmentAlignment = fragment.alignment;
                if (fragmentPadding > 0 && (float)fragmentPadding > fragmentWidth) {
                    endOffset = fragmentPadding;
                    if (fragmentAlignment == 4 || fragmentAlignment == 11) {
                        offset = (float)fragmentPadding - fragmentWidth;
                    }
                } else {
                    endOffset = offset + fragmentWidth;
                }
                if ((double)offset < area.getMaxX()) {
                    if (!secondPass) {
                        if (this.shouldDrawDimmed()) {
                            color = ColorUtil.dimmer((Color)color);
                        }
                        g.setColor(color);
                        this.doDrawString(g, fragment, i, offset, textBaseline);
                        g.setStroke(g.getStroke());
                        this.drawTextAttributes(g, attributes, (int)offset, textBaseline, (int)fragmentWidth, metrics, font);
                    }
                    if (secondPass) {
                        secondPassFrag = new Frag(this, i, offset, offset + fragmentWidth, textBaseline, font, secondPassFrag);
                    }
                }
                offset = endOffset;
            }
            if (this.myPaintFocusBorder && this.border != null) {
                int width = this.getWidth();
                if (focusAroundIcon) {
                    this.border.paintBorder(this, g, 0, 0, width, height);
                } else {
                    this.border.paintBorder(this, g, textStart, 0, width - textStart, height);
                }
            }
            Frag frag = secondPassFrag;
            while (frag != null) {
                block27: {
                    Object fgColor;
                    SimpleTextAttributes attributes;
                    String text;
                    float baseline;
                    float x2;
                    float x1;
                    block26: {
                        block25: {
                            x1 = frag.start;
                            x2 = frag.end;
                            baseline = frag.baseLine;
                            ColoredFragment fragment = this.myFragments.get(frag.index);
                            text = fragment.text;
                            attributes = fragment.attributes;
                            if (!attributes.isSearchMatch()) break block25;
                            fgColor = new JBColor((Color)Gray._50, (Color)Gray._0);
                            UIUtil.drawSearchMatch((Graphics2D)g, (float)x1, (float)x2, (int)height);
                            break block26;
                        }
                        if (!attributes.isClickable()) break block27;
                        boolean selected2 = UIUtil.getTreeSelectionBackground((boolean)true) == this.getBackground();
                        fgColor = (Color)ObjectUtils.notNull((Object)attributes.getFgColor(), (Object)UIUtil.getLabelForeground());
                        SimpleColoredComponent.drawClickableFrag(g, x1, x2, height, selected2, attributes.isHovered(), attributes.isNoBorder());
                    }
                    g.setFont(frag.font);
                    g.setColor((Color)fgColor);
                    if (!this.drawWithClipping(frag.index, g, frag.font, frag.start, frag.end, baseline)) {
                        g.drawString(text, x1, baseline);
                    }
                    int fragmentWidth = (int)(x2 - x1);
                    this.drawTextAttributes(g, attributes, (int)x1, (int)baseline, fragmentWidth, g.getFontMetrics(), g.getFont());
                }
                frag = frag.next;
            }
            return (int)offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawWithClipping(int index, Graphics2D g, Font font, float x1, float x2, float baseline) {
        boolean okToMerge;
        if (!SystemInfo.isMacOSCatalina || !this.myDynamicSearchMatchHighlighting) {
            return false;
        }
        ColoredFragment fragment = this.myFragments.get(index);
        if (!fragment.attributes.isSearchMatch()) {
            return false;
        }
        ColoredFragment prevFragment = index > 0 ? this.myFragments.get(index - 1) : null;
        ColoredFragment nextFragment = index < this.myFragments.size() - 1 ? this.myFragments.get(index + 1) : null;
        boolean bl = okToMerge = prevFragment != null || nextFragment != null;
        if (okToMerge && prevFragment != null) {
            boolean bl2 = okToMerge = (prevFragment.attributes.getStyle() | 0x40) == fragment.attributes.getStyle();
        }
        if (okToMerge && nextFragment != null) {
            boolean bl3 = okToMerge = (nextFragment.attributes.getStyle() | 0x40) == fragment.attributes.getStyle();
        }
        if (okToMerge) {
            String mergedText = (prevFragment != null ? prevFragment.text : "") + fragment.text + (nextFragment != null ? nextFragment.text : "");
            Graphics2D clippedGraphics = (Graphics2D)g.create();
            try {
                clippedGraphics.clip(new Rectangle2D.Float(x1, 0.0f, x2 - x1, this.getHeight()));
                if (prevFragment != null) {
                    x1 -= this.computeStringWidth(prevFragment, index - 1, font);
                }
                clippedGraphics.drawString(mergedText, x1, baseline);
            }
            finally {
                clippedGraphics.dispose();
            }
            return true;
        }
        return false;
    }

    protected Color getActiveTextColor(Color attributesColor) {
        return attributesColor != null ? attributesColor : this.getForeground();
    }

    protected void doPaintFragmentBackground(@NotNull Graphics2D g, int index, @NotNull Color bgColor, int x, int y, int width, int height) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(39);
        }
        if (bgColor == null) {
            SimpleColoredComponent.$$$reportNull$$$0(40);
        }
        g.setColor(bgColor);
        g.fillRect(x, y, width, height);
    }

    private static void drawClickableFrag(Graphics2D g, float x1, float x2, int height, boolean selected2, boolean hovered, boolean noBorder) {
        if (noBorder) {
            return;
        }
        GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)g);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x1 + 1.0f, 2.0f, x2 - x1 - 2.0f, height - 4, 6.0f, 6.0f);
        g.setColor(JBUI.CurrentTheme.ActionButton.hoverBackground());
        if (hovered && !selected2) {
            g.fill(shape);
        } else {
            g.draw(shape);
        }
        c.restore();
    }

    private void drawTextAttributes(@NotNull Graphics2D g, @NotNull SimpleTextAttributes attributes, int offset, int textBaseline, int fragmentWidth, @NotNull FontMetrics metrics, Font font) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(41);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(42);
        }
        if (metrics == null) {
            SimpleColoredComponent.$$$reportNull$$$0(43);
        }
        if (attributes.isStrikeout()) {
            EffectPainter.STRIKE_THROUGH.paint(g, offset, textBaseline, fragmentWidth, SimpleColoredComponent.getCharHeight(g), font);
        }
        if (attributes.isWaved()) {
            if (attributes.getWaveColor() != null) {
                g.setColor(attributes.getWaveColor());
            }
            EffectPainter.WAVE_UNDERSCORE.paint(g, offset, textBaseline + 1, fragmentWidth, Math.max(2, metrics.getDescent()), font);
        }
        if (attributes.isUnderline()) {
            if (attributes.useEffectColor() && attributes.getWaveColor() != null) {
                g.setColor(attributes.getWaveColor());
            }
            EffectPainter.LINE_UNDERSCORE.paint(g, offset, textBaseline, fragmentWidth, metrics.getDescent(), font);
        }
        if (attributes.isBoldDottedLine()) {
            int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
            Color lineColor = attributes.getWaveColor();
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)offset, (int)(offset + fragmentWidth), (int)dottedAt, (Color)attributes.getBgColor(), (Color)lineColor, (boolean)this.isOpaque());
        }
        if (attributes.isBoldUnderline()) {
            if (attributes.useEffectColor() && attributes.getWaveColor() != null) {
                g.setColor(attributes.getWaveColor());
            }
            EffectPainter.BOLD_LINE_UNDERSCORE.paint(g, offset, textBaseline, fragmentWidth, metrics.getDescent(), font);
        }
    }

    private static int getCharHeight(Graphics g) {
        return g.getFontMetrics().charWidth('a');
    }

    private int computeTextAlignShift() {
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(44);
        }
        if (icon == null) {
            SimpleColoredComponent.$$$reportNull$$$0(45);
        }
        Rectangle area = this.computePaintArea();
        int x = offset;
        int y = area.y + (area.height - icon.getIconHeight()) / 2;
        IconUtil.paintSelectionAwareIcon((Icon)icon, (JComponent)this, (Graphics)g, (int)x, (int)y, (boolean)this.isSelection());
    }

    private boolean isSelection() {
        Color bg = this.getBackground();
        return bg != null && Comparing.equal((Object)UIUtil.getTreeSelectionBackground((boolean)true), (Object)bg) || Comparing.equal((Object)UIUtil.getListSelectionBackground((boolean)true), (Object)bg);
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(46);
        }
        UISettings.setupAntialiasing((Graphics)g);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.getClientProperty(RenderingHints.KEY_FRACTIONALMETRICS));
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        return SimpleColoredComponent.getTextBaseLine(this.getFontMetrics(this.getBaseFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public void setDynamicSearchMatchHighlighting(boolean dynamicSearchMatchHighlighting) {
        this.myDynamicSearchMatchHighlighting = dynamicSearchMatchHighlighting;
    }

    public static int getTextBaseLine(@NotNull FontMetrics metrics, int height) {
        if (metrics == null) {
            SimpleColoredComponent.$$$reportNull$$$0(47);
        }
        return (height - metrics.getHeight() + 1) / 2 + metrics.getAscent() + (SystemInfo.isJetBrainsJvm ? metrics.getLeading() : 0);
    }

    @NotNull
    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            SimpleColoredComponent.$$$reportNull$$$0(48);
        }
        return string;
    }

    protected void setBorderInsets(Insets insets) {
        this.border = new JBEmptyBorder(insets);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    @NlsSafe
    public CharSequence getCharSequence(boolean mainOnly) {
        List<ColoredFragment> list = this.myFragments;
        // MONITORENTER : list
        int count = this.myFragments.size();
        if (count == 0) {
            // MONITOREXIT : list
            return "";
        }
        if (mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size()) {
            count = this.myMainTextLastIndex + 1;
        }
        StringBuilder sb = new StringBuilder(this.myFragments.get((int)0).text);
        int i = 1;
        while (true) {
            if (i >= count) {
                String string = sb.toString();
                // MONITOREXIT : list
                if (string != null) return string;
                SimpleColoredComponent.$$$reportNull$$$0(50);
                return string;
            }
            sb.append(this.myFragments.get((int)i).text);
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.getCharSequence(false).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable, boolean autoInvalidate) {
        if (runnable == null) {
            SimpleColoredComponent.$$$reportNull$$$0(51);
        }
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @ApiStatus.Experimental
    @Nls
    @Nullable
    protected String getIconToolTipText() {
        String string;
        Icon icon = this.myIcon;
        if (icon instanceof IconWithToolTip) {
            IconWithToolTip i = (IconWithToolTip)icon;
            string = i.getToolTip(false);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String iconToolTip;
        if (this.myIcon != null && this.findFragmentAt(event.getX()) == -2 && (iconToolTip = this.getIconToolTipText()) != null) {
            return StringUtil.capitalize((String)iconToolTip);
        }
        return super.getToolTipText(event);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSimpleColoredComponent();
        }
        return this.accessibleContext;
    }

    private static Font deriveFont(Font originalFont, int style, float size) {
        Font derivedFont = originalFont.deriveFont(style, size);
        if ("Dialog".equals(derivedFont.getFamily()) && !"Dialog".equals(originalFont.getFamily())) {
            return originalFont.deriveFont(size);
        }
        return derivedFont;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 22, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 51 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SimpleColoredComponent";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 31: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipad";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgColor";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SimpleColoredComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendWithClipping";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpad";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "computePreferredSize";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFont";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "formatToLabel";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "logSwingPath";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendWithClipping";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "_append";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fromMarkupText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setIpad";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "computeTextWidth";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doDrawString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeStringWidth";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentWidth";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatToLabel";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "formatLink";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "convertFragment";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doPaintIcon";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "doPaintFragmentBackground";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "drawTextAttributes";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalHints";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTextBaseLine";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 22, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 51 -> new IllegalArgumentException(string);
        };
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public String getFragment() {
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            // MONITORENTER : list
            String string = SimpleColoredComponent.this.myFragments.get((int)this.myIndex).text;
            // MONITOREXIT : list
            if (string != null) return string;
            MyIterator.$$$reportNull$$$0(0);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            // MONITORENTER : list
            SimpleTextAttributes simpleTextAttributes = SimpleColoredComponent.this.myFragments.get((int)this.myIndex).attributes;
            // MONITOREXIT : list
            if (simpleTextAttributes != null) return simpleTextAttributes;
            MyIterator.$$$reportNull$$$0(1);
            return simpleTextAttributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object getTag() {
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                return SimpleColoredComponent.this.myFragments.get((int)this.myIndex).tag;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int split(int offset, @NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                MyIterator.$$$reportNull$$$0(2);
            }
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                    throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
                }
                ColoredFragment oldFragment = SimpleColoredComponent.this.myFragments.get(this.myIndex);
                if (offset == this.myEndOffset - this.myOffset) {
                    oldFragment.attributes = attributes;
                } else if (offset > 0) {
                    String text = this.getFragment();
                    ColoredFragment newFragment = new ColoredFragment(text.substring(offset), oldFragment.attributes, oldFragment.myComponent, oldFragment.myClipper);
                    oldFragment.setText(text.substring(0, offset));
                    oldFragment.attributes = attributes;
                    newFragment.tag = oldFragment;
                    SimpleColoredComponent.this.myFragments.add(this.myIndex + 1, newFragment);
                    ++this.myIndex;
                }
                this.myOffset += offset;
                return this.myOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                return this.myIndex + 1 < SimpleColoredComponent.this.myFragments.size();
            }
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text = this.getFragment();
            this.myEndOffset += text.length();
            return text;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFragment(@NotNull String text) {
            if (text == null) {
                MyIterator.$$$reportNull$$$0(3);
            }
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                SimpleColoredComponent.this.myFragments.get(this.myIndex).setText(text);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTag(@Nullable Object tag) {
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                SimpleColoredComponent.this.myFragments.get((int)this.myIndex).tag = tag;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTextAttributes(@NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                MyIterator.$$$reportNull$$$0(4);
            }
            List<ColoredFragment> list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                SimpleColoredComponent.this.myFragments.get((int)this.myIndex).attributes = attributes;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$MyIterator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$MyIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFragment";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTextAttributes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static interface FragmentTextClipper {
        @NotNull
        public String clipText(@NotNull SimpleColoredComponent var1, @NotNull Graphics2D var2, int var3, @NotNull String var4, int var5);
    }

    private static class ColoredFragment {
        @Nls
        @NotNull
        private volatile String text;
        @NotNull
        volatile SimpleTextAttributes attributes;
        @Nullable
        volatile Object tag;
        @Nullable
        private volatile TextRenderer renderer;
        volatile int padding;
        volatile int alignment;
        @NotNull
        private final SimpleColoredComponent myComponent;
        @Nullable
        private final FragmentTextClipper myClipper;

        ColoredFragment(@Nls @NotNull String text, @NotNull SimpleTextAttributes attributes, @NotNull SimpleColoredComponent component, @Nullable FragmentTextClipper clipper) {
            if (text == null) {
                ColoredFragment.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                ColoredFragment.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ColoredFragment.$$$reportNull$$$0(2);
            }
            this.text = text;
            this.attributes = attributes;
            this.myComponent = component;
            this.myClipper = clipper;
        }

        private void setText(@Nls @NotNull String text) {
            if (text == null) {
                ColoredFragment.$$$reportNull$$$0(3);
            }
            if (!this.text.equals(text)) {
                this.text = text;
                this.invalidateLayout();
            }
        }

        void invalidateLayout() {
            this.renderer = null;
        }

        @NotNull
        private TextRenderer getAndCacheRenderer(Font font, FontRenderContext frc) {
            TextRenderer renderer = this.renderer;
            if (renderer == null) {
                String text = this.text;
                renderer = SimpleColoredComponent.needFontFallback(font, text) && !AppMode.isRemoteDevHost() ? new LayoutTextRenderer(SimpleColoredComponent.createTextLayout(text, font, frc)) : (this.myClipper != null ? new ClippedTextRenderer(this.myComponent, text, this.myClipper, (float)font.getStringBounds(text, frc).getWidth()) : new SimpleTextRenderer(text, (float)font.getStringBounds(text, frc).getWidth()));
                this.renderer = renderer;
            }
            TextRenderer textRenderer2 = renderer;
            if (textRenderer2 == null) {
                ColoredFragment.$$$reportNull$$$0(4);
            }
            return textRenderer2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$ColoredFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$ColoredFragment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAndCacheRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ImmutableFont
    extends Font {
        private ImmutableFont(Font font) {
            super(font);
        }
    }

    private static interface TextRenderer {
        public float getWidth();

        public void draw(Graphics2D var1, int var2, float var3, float var4);
    }

    private record WidthKey(@NotNull String text, Font font, FontRenderContext frc, int style, int size) {
        @NotNull
        private final String text;

        private WidthKey(@NotNull String text, Font font, FontRenderContext frc, int style, int size) {
            if (text == null) {
                WidthKey.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                WidthKey.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$WidthKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$WidthKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(@NotNull String url) {
            if (url == null) {
                BrowserLauncherTag.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse(this.myUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ui/SimpleColoredComponent$BrowserLauncherTag", "<init>"));
        }
    }

    protected class AccessibleSimpleColoredComponent
    extends JComponent.AccessibleJComponent {
        protected AccessibleSimpleColoredComponent() {
            super(SimpleColoredComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return AccessibleContextUtil.combineAccessibleStrings((String)SimpleColoredComponent.this.getCharSequence(false).toString(), (String)", ", (String)SimpleColoredComponent.this.getIconToolTipText());
        }

        @Nullable
        @Nls
        protected String getAccessibleNameWithoutIconTooltip() {
            return SimpleColoredComponent.this.getCharSequence(false).toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }

    private static final class SimpleTextRenderer
    implements TextRenderer {
        private final String myText;
        private final float myWidth;

        private SimpleTextRenderer(String text, float width) {
            this.myText = text;
            this.myWidth = width;
        }

        @Override
        public float getWidth() {
            return this.myWidth;
        }

        @Override
        public void draw(Graphics2D g2, int fragmentIndex, float x, float y) {
            g2.drawString(this.myText, x, y);
        }
    }

    private static final class ClippedTextRenderer
    implements TextRenderer {
        @NotNull
        private final String myText;
        @NotNull
        private final SimpleColoredComponent myComponent;
        @NotNull
        private final FragmentTextClipper myFragmentTextClipper;
        private final float myWidth;

        private ClippedTextRenderer(@NotNull SimpleColoredComponent component, @NotNull String text, @NotNull FragmentTextClipper fragmentTextClipper, float width) {
            if (component == null) {
                ClippedTextRenderer.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ClippedTextRenderer.$$$reportNull$$$0(1);
            }
            if (fragmentTextClipper == null) {
                ClippedTextRenderer.$$$reportNull$$$0(2);
            }
            this.myText = text;
            this.myWidth = width;
            this.myComponent = component;
            this.myFragmentTextClipper = fragmentTextClipper;
        }

        @Override
        public float getWidth() {
            return this.myWidth;
        }

        @Override
        public void draw(Graphics2D g2, int fragmentIndex, float x, float y) {
            String clippedText = this.myFragmentTextClipper.clipText(this.myComponent, g2, fragmentIndex, this.myText, this.myComponent.getWidth() - (int)x);
            g2.drawString(clippedText, x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragmentTextClipper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/SimpleColoredComponent$ClippedTextRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LayoutTextRenderer
    implements TextRenderer {
        private final TextLayout myLayout;

        private LayoutTextRenderer(TextLayout layout) {
            this.myLayout = layout;
        }

        @Override
        public float getWidth() {
            return this.myLayout.getAdvance();
        }

        @Override
        public void draw(Graphics2D g2, int fragmentIndex, float x, float y) {
            this.myLayout.draw(g2, x, y);
        }
    }

    public static final class DefaultFragmentTextClipper
    implements FragmentTextClipper {
        public static final FragmentTextClipper INSTANCE = new DefaultFragmentTextClipper();

        @Override
        @NotNull
        public String clipText(@NotNull SimpleColoredComponent component, @NotNull Graphics2D g, int fragmentIndex, @NotNull String text, int availTextWidth) {
            if (component == null) {
                DefaultFragmentTextClipper.$$$reportNull$$$0(0);
            }
            if (g == null) {
                DefaultFragmentTextClipper.$$$reportNull$$$0(1);
            }
            if (text == null) {
                DefaultFragmentTextClipper.$$$reportNull$$$0(2);
            }
            String string = SwingUtilities2.clipStringIfNecessary(component, component.getFontMetrics(g.getFont()), text, availTextWidth);
            if (string == null) {
                DefaultFragmentTextClipper.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$DefaultFragmentTextClipper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$DefaultFragmentTextClipper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clipText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "clipText";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        @Nls
        @NotNull
        public String getFragment();

        @NotNull
        public SimpleTextAttributes getTextAttributes();

        @Nullable
        public Object getTag();

        public int split(int var1, @NotNull SimpleTextAttributes var2);

        public void setFragment(@Nls @NotNull String var1);

        public void setTag(@Nullable Object var1);

        public void setTextAttributes(@NotNull SimpleTextAttributes var1);
    }
}

