/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.DefaultScrollBarAnimationBehavior;
import com.intellij.ui.components.DefaultScrollBarUIKt;
import com.intellij.ui.components.DefaultScrollbarUiInstalledState;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.ScrollBarAnimationBehavior;
import com.intellij.ui.components.ScrollBarPainter;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.components.ToggleableScrollBarAnimationBehaviorDecorator;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 K2\u00020\u0001:\u0002KLB'\b\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0003H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003J\u0016\u0010.\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003J\u0018\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0014J%\u00104\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b5J(\u00106\u001a\u00020\"2\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00109\u001a\u00020\u0013J\u0010\u0010:\u001a\u00020;2\u0006\u00109\u001a\u00020\u0013H\u0014J\u0010\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0002J\u0006\u0010>\u001a\u00020\"J&\u0010>\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003J\u0010\u0010A\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0010\u0010B\u001a\u00020\"2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010C\u001a\u00020\"2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00106\u001a\u00020\"2\u0006\u00100\u001a\u00020F2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010G\u001a\u00020\"2\u0006\u0010H\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010\r\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006M"}, d2={"Lcom/intellij/ui/components/DefaultScrollBarUI;", "Ljavax/swing/plaf/ScrollBarUI;", "thickness", "", "thicknessMax", "thicknessMin", "<init>", "(III)V", "listener", "Lcom/intellij/ui/components/DefaultScrollBarUI$Listener;", "scrollTimer", "Ljavax/swing/Timer;", "Lorg/jetbrains/annotations/NotNull;", "value", "Lcom/intellij/ui/components/DefaultScrollbarUiInstalledState;", "installedState", "getInstalledState$intellij_platform_ide", "()Lcom/intellij/ui/components/DefaultScrollbarUiInstalledState;", "isValueCached", "", "cachedValue", "oldValue", "createWrapAnimationBehaviour", "Lcom/intellij/ui/components/ScrollBarAnimationBehavior;", "state", "createWrapAnimationBehaviour$intellij_platform_ide", "createThumbPainter", "Lcom/intellij/ui/components/ScrollBarPainter$Thumb;", "createThumbPainter$intellij_platform_ide", "createBaseAnimationBehavior", "createBaseAnimationBehavior$intellij_platform_ide", "getEffectiveThickness", "getMinimalThickness", "toggle", "", "isOn", "isAbsolutePositioning", "event", "Ljava/awt/event/MouseEvent;", "isTrackClickable", "isMousePressedOnVisiblePart", "isTrackExpandable", "()Z", "isTrackContains", "x", "y", "isThumbContains", "paintTrack", "g", "Ljava/awt/Graphics2D;", "c", "Ljavax/swing/JComponent;", "paintThumb", "paintThumb$intellij_platform_ide", "paint", "p", "Lcom/intellij/ui/components/ScrollBarPainter;", "small", "getInsets", "Ljava/awt/Insets;", "getTrackOffset", "offset", "repaint", "width", "height", "scale", "installUI", "uninstallUI", "getPreferredSize", "Ljava/awt/Dimension;", "Ljava/awt/Graphics;", "updateThumbBounds", "animate", "getValue", "()I", "Companion", "Listener", "intellij.platform.ide"})
@ApiStatus.Internal
public class DefaultScrollBarUI
extends ScrollBarUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int thickness;
    private final int thicknessMax;
    private final int thicknessMin;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Timer scrollTimer;
    @Nullable
    private DefaultScrollbarUiInstalledState installedState;
    private boolean isValueCached;
    private int cachedValue;
    private int oldValue;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Component> LEADING;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Component> TRAILING;

    @JvmOverloads
    public DefaultScrollBarUI(int thickness, int thicknessMax, int thicknessMin) {
        this.thickness = thickness;
        this.thicknessMax = thicknessMax;
        this.thicknessMin = thicknessMin;
        this.listener = new Listener();
        Timer timer = TimerUtil.createNamedTimer((String)"ScrollBarThumbScrollTimer", (int)60, (ActionListener)this.listener);
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"createNamedTimer(...)");
        this.scrollTimer = timer;
    }

    public /* synthetic */ DefaultScrollBarUI(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            int n5 = n = (Boolean)ScrollSettings.isThumbSmallIfOpaque.invoke() != false ? 13 : 10;
        }
        if ((n4 & 2) != 0) {
            n2 = 14;
        }
        if ((n4 & 4) != 0) {
            n3 = 10;
        }
        this(n, n2, n3);
    }

    @Nullable
    public final DefaultScrollbarUiInstalledState getInstalledState$intellij_platform_ide() {
        return this.installedState;
    }

    @NotNull
    public ScrollBarAnimationBehavior createWrapAnimationBehaviour$intellij_platform_ide(@NotNull DefaultScrollbarUiInstalledState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ScrollBarAnimationBehavior scrollBarAnimationBehavior = this.createBaseAnimationBehavior$intellij_platform_ide(state);
        TwoWayAnimator twoWayAnimator = state.track.animator;
        Intrinsics.checkNotNullExpressionValue((Object)twoWayAnimator, (String)"animator");
        TwoWayAnimator twoWayAnimator2 = state.thumb.animator;
        Intrinsics.checkNotNullExpressionValue((Object)twoWayAnimator2, (String)"animator");
        return new ToggleableScrollBarAnimationBehaviorDecorator(scrollBarAnimationBehavior, twoWayAnimator, twoWayAnimator2);
    }

    @NotNull
    public ScrollBarPainter.Thumb createThumbPainter$intellij_platform_ide(@NotNull DefaultScrollbarUiInstalledState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ScrollBarPainter.Thumb(() -> DefaultScrollBarUI.createThumbPainter$lambda$0(state), false, state.coroutineScope);
    }

    @NotNull
    public ScrollBarAnimationBehavior createBaseAnimationBehavior$intellij_platform_ide(@NotNull DefaultScrollbarUiInstalledState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TwoWayAnimator twoWayAnimator = state.track.animator;
        Intrinsics.checkNotNullExpressionValue((Object)twoWayAnimator, (String)"animator");
        TwoWayAnimator twoWayAnimator2 = state.thumb.animator;
        Intrinsics.checkNotNullExpressionValue((Object)twoWayAnimator2, (String)"animator");
        return new DefaultScrollBarAnimationBehavior(twoWayAnimator, twoWayAnimator2);
    }

    private final int getEffectiveThickness() {
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        JScrollBar scrollBar = defaultScrollbarUiInstalledState != null ? defaultScrollbarUiInstalledState.scrollBar : null;
        return this.scale(scrollBar == null || Companion.isOpaque(scrollBar) ? this.thickness : this.thicknessMax);
    }

    private final int getMinimalThickness() {
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        JScrollBar scrollBar = defaultScrollbarUiInstalledState != null ? defaultScrollbarUiInstalledState.scrollBar : null;
        return this.scale(scrollBar == null || Companion.isOpaque(scrollBar) ? this.thickness : this.thicknessMin);
    }

    public final void toggle(boolean isOn) {
        block0: {
            Object object = this.installedState;
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).animationBehavior) == null) break block0;
            ((ScrollBarAnimationBehavior)object).onToggle(isOn);
        }
    }

    public boolean isAbsolutePositioning(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return SwingUtilities.isMiddleMouseButton(event);
    }

    public boolean isTrackClickable() {
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        if (defaultScrollbarUiInstalledState == null) {
            return false;
        }
        DefaultScrollbarUiInstalledState state = defaultScrollbarUiInstalledState;
        return Companion.isOpaque(state.scrollBar) || state.animationBehavior.getTrackFrame() > 0.0f;
    }

    private final boolean isMousePressedOnVisiblePart(MouseEvent event) {
        return event.getID() == 501 && this.isThumbContains(event.getX(), event.getY());
    }

    public boolean isTrackExpandable() {
        return false;
    }

    public final boolean isTrackContains(int x, int y) {
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        return defaultScrollbarUiInstalledState.track.bounds.contains(x, y);
    }

    public final boolean isThumbContains(int x, int y) {
        Object object = this.installedState;
        return object != null && (object = ((DefaultScrollbarUiInstalledState)object).thumb) != null && (object = ((ScrollBarPainter.Thumb)object).bounds) != null ? ((Rectangle)object).contains(x, y) : false;
    }

    protected void paintTrack(@NotNull Graphics2D g, @NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        this.paint(defaultScrollbarUiInstalledState.track, g, c, false);
    }

    public void paintThumb$intellij_platform_ide(@NotNull Graphics2D g, @NotNull JComponent c, @NotNull DefaultScrollbarUiInstalledState state) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        this.paint(defaultScrollbarUiInstalledState.thumb, g, c, (Boolean)ScrollSettings.isThumbSmallIfOpaque.invoke() != false && Companion.isOpaque(c));
    }

    public final void paint(@NotNull ScrollBarPainter p, @NotNull Graphics2D g, @Nullable JComponent c, boolean small) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int x = p.bounds.x;
        int y = p.bounds.y;
        int width = p.bounds.width;
        int height = p.bounds.height;
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
            offset = this.getTrackOffset(width - this.getMinimalThickness());
            if (offset > 0) {
                width -= offset;
                if (alignment == JBScrollPane.Alignment.RIGHT) {
                    x += offset;
                }
            }
        } else {
            offset = this.getTrackOffset(height - this.getMinimalThickness());
            if (offset > 0) {
                height -= offset;
                if (alignment == JBScrollPane.Alignment.BOTTOM) {
                    y += offset;
                }
            }
        }
        Insets insets = this.getInsets(small);
        p.paint(g, x += insets.left, y += insets.top, width -= insets.left + insets.right, height -= insets.top + insets.bottom, Float.valueOf(p.animator.value));
    }

    @NotNull
    protected Insets getInsets(boolean small) {
        Insets insets;
        if (small) {
            JBInsets jBInsets = JBUI.insets((int)1);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            insets = (Insets)jBInsets;
        } else {
            JBInsets jBInsets = JBUI.emptyInsets();
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
            insets = (Insets)jBInsets;
        }
        return insets;
    }

    private final int getTrackOffset(int offset) {
        if (!this.isTrackExpandable()) {
            return offset;
        }
        Object object = this.installedState;
        float value2 = object != null && (object = ((DefaultScrollbarUiInstalledState)object).animationBehavior) != null ? ((ScrollBarAnimationBehavior)object).getTrackFrame() : 0.0f;
        return value2 <= 0.0f ? offset : (value2 >= 1.0f ? 0 : (int)(0.5f + (float)offset * (1.0f - value2)));
    }

    public final void repaint() {
        block0: {
            Object object = this.installedState;
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) break block0;
            ((Component)object).repaint();
        }
    }

    public final void repaint(int x, int y, int width, int height) {
        block0: {
            Object object = this.installedState;
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) break block0;
            ((Component)object).repaint(x, y, width, height);
        }
    }

    private final int scale(int value2) {
        int scaledValue = JBUIScale.scale((int)value2);
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        return switch (WhenMappings.$EnumSwitchMapping$0[UIUtil.getComponentStyle((Component)defaultScrollbarUiInstalledState.scrollBar).ordinal()]) {
            case 1 -> (int)((double)scaledValue * 1.15);
            case 2 -> (int)((double)scaledValue * 0.857);
            case 3 -> (int)((double)scaledValue * 0.714);
            case 4 -> scaledValue;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        JScrollBar scrollBar = (JScrollBar)c;
        this.installedState = new DefaultScrollbarUiInstalledState(this, scrollBar);
        ScrollBarPainter.setBackground(c);
        scrollBar.setOpaque(false);
        scrollBar.setFocusable(false);
        scrollBar.addMouseListener(this.listener);
        scrollBar.addMouseMotionListener(this.listener);
        scrollBar.getModel().addChangeListener(this.listener);
        scrollBar.addPropertyChangeListener(this.listener);
        scrollBar.addFocusListener(this.listener);
        this.scrollTimer.setInitialDelay(300);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        if (defaultScrollbarUiInstalledState == null) {
            return;
        }
        DefaultScrollbarUiInstalledState state = defaultScrollbarUiInstalledState;
        CoroutineScopeKt.cancel$default((CoroutineScope)state.coroutineScope, null, (int)1, null);
        this.installedState = null;
        state.animationBehavior.onUninstall();
        this.scrollTimer.stop();
        JScrollBar scrollBar = state.scrollBar;
        scrollBar.removeFocusListener(this.listener);
        scrollBar.removePropertyChangeListener(this.listener);
        scrollBar.getModel().removeChangeListener(this.listener);
        scrollBar.removeMouseMotionListener(this.listener);
        scrollBar.removeMouseListener(this.listener);
        scrollBar.setForeground(null);
        scrollBar.setBackground(null);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        JScrollBar scrollBar = defaultScrollbarUiInstalledState.scrollBar;
        int thickness = this.getEffectiveThickness();
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        Dimension preferred = new Dimension(thickness, thickness);
        if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
            preferred.height += preferred.height;
            DefaultScrollBarUIKt.access$addPreferredHeight(preferred, (Component)ClientProperty.get((Component)scrollBar, LEADING));
            DefaultScrollBarUIKt.access$addPreferredHeight(preferred, (Component)ClientProperty.get((Component)scrollBar, TRAILING));
        } else {
            preferred.width += preferred.width;
            DefaultScrollBarUIKt.access$addPreferredWidth(preferred, (Component)ClientProperty.get((Component)scrollBar, LEADING));
            DefaultScrollBarUIKt.access$addPreferredWidth(preferred, (Component)ClientProperty.get((Component)scrollBar, TRAILING));
        }
        return preferred;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        boolean animate;
        Component trailing;
        Color background;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        if (alignment == null || !(g instanceof Graphics2D)) {
            return;
        }
        Color color = background = Companion.isOpaque(c) ? c.getBackground() : null;
        if (background != null) {
            g.setColor(background);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Rectangle bounds = new Rectangle(c.getWidth(), c.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)c.getInsets());
        Component leading = (Component)ClientProperty.get((Component)c, LEADING);
        if (leading != null) {
            if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                size = leading.getPreferredSize().height;
                leading.setBounds(bounds.x, bounds.y, bounds.width, size);
                bounds.height -= size;
                bounds.y += size;
            } else {
                size = leading.getPreferredSize().width;
                leading.setBounds(bounds.x, bounds.y, size, bounds.height);
                bounds.width -= size;
                bounds.x += size;
            }
        }
        if ((trailing = (Component)ClientProperty.get((Component)c, TRAILING)) != null) {
            if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                size = trailing.getPreferredSize().height;
                bounds.height -= size;
                trailing.setBounds(bounds.x, bounds.y + bounds.height, bounds.width, size);
            } else {
                size = trailing.getPreferredSize().width;
                bounds.width -= size;
                trailing.setBounds(bounds.x + bounds.width, bounds.y, size, bounds.height);
            }
        }
        if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
            offset = bounds.width - this.getEffectiveThickness();
            if (offset > 0) {
                bounds.width -= offset;
                if (alignment == JBScrollPane.Alignment.RIGHT) {
                    bounds.x += offset;
                }
            }
        } else {
            offset = bounds.height - this.getEffectiveThickness();
            if (offset > 0) {
                bounds.height -= offset;
                if (alignment == JBScrollPane.Alignment.BOTTOM) {
                    bounds.y += offset;
                }
            }
        }
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        DefaultScrollbarUiInstalledState state = defaultScrollbarUiInstalledState;
        ScrollBarPainter.Track track = state.track;
        boolean bl = animate = !Intrinsics.areEqual((Object)track.bounds, (Object)bounds);
        if (animate) {
            track.bounds.setBounds(bounds);
        }
        this.updateThumbBounds(animate);
        this.paintTrack((Graphics2D)g, c);
        RegionPainter trackPainter = (RegionPainter)ClientProperty.get((Component)c, JBScrollBar.TRACK);
        if (trackPainter != null && track.bounds.width > 0 && track.bounds.height > 0) {
            trackPainter.paint((Graphics2D)g, track.bounds.x, track.bounds.y, track.bounds.width, track.bounds.height, null);
        }
        if (state.thumb.bounds.width > 0 && state.thumb.bounds.height > 0) {
            this.paintThumb$intellij_platform_ide((Graphics2D)g, c, state);
        }
    }

    private final void updateThumbBounds(boolean animate) {
        boolean animate2 = animate;
        int value2 = 0;
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        DefaultScrollbarUiInstalledState state = defaultScrollbarUiInstalledState;
        JScrollBar scrollBar = state.scrollBar;
        int min = scrollBar.getMinimum();
        int max = scrollBar.getMaximum();
        int range = max - min;
        if (range <= 0) {
            state.thumb.bounds.setBounds(0, 0, 0, 0);
        } else if (1 == scrollBar.getOrientation()) {
            int extent = scrollBar.getVisibleAmount();
            ScrollBarPainter.Track track = state.track;
            int height = (int)Math.max((double)DefaultScrollBarUIKt.access$convert(track.bounds.height, extent, range), (double)(2 * this.getEffectiveThickness()));
            if (track.bounds.height <= height) {
                state.thumb.bounds.setBounds(0, 0, 0, 0);
            } else {
                value2 = this.getValue();
                int maxY = track.bounds.y + track.bounds.height - height;
                int y = value2 < max - extent ? DefaultScrollBarUIKt.access$convert(track.bounds.height - height, value2 - min, range - extent) : maxY;
                state.thumb.bounds.setBounds(track.bounds.x, DefaultScrollBarUIKt.access$adjust(y, track.bounds.y, maxY), track.bounds.width, height);
                animate2 |= this.oldValue != value2;
            }
        } else {
            ScrollBarPainter.Track track = state.track;
            int extent = scrollBar.getVisibleAmount();
            int width = (int)Math.max((double)DefaultScrollBarUIKt.access$convert(track.bounds.width, extent, range), (double)(2 * this.getEffectiveThickness()));
            if (track.bounds.width <= width) {
                state.thumb.bounds.setBounds(0, 0, 0, 0);
            } else {
                int x;
                value2 = this.getValue();
                int maxX = track.bounds.x + track.bounds.width - width;
                int n = x = value2 < max - extent ? DefaultScrollBarUIKt.access$convert(track.bounds.width - width, value2 - min, range - extent) : maxX;
                if (!scrollBar.getComponentOrientation().isLeftToRight()) {
                    x = track.bounds.x - x + maxX;
                }
                state.thumb.bounds.setBounds(DefaultScrollBarUIKt.access$adjust(x, track.bounds.x, maxX), track.bounds.y, width, track.bounds.height);
                animate2 |= this.oldValue != value2;
            }
        }
        this.oldValue = value2;
        if (animate2) {
            state.animationBehavior.onThumbMove();
        }
    }

    private final int getValue() {
        int n;
        if (this.isValueCached) {
            n = this.cachedValue;
        } else {
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.installedState;
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            n = defaultScrollbarUiInstalledState.scrollBar.getValue();
        }
        return n;
    }

    @JvmOverloads
    public DefaultScrollBarUI(int thickness, int thicknessMax) {
        this(thickness, thicknessMax, 0, 4, null);
    }

    @JvmOverloads
    public DefaultScrollBarUI(int thickness) {
        this(thickness, 0, 0, 6, null);
    }

    @JvmOverloads
    public DefaultScrollBarUI() {
        this(0, 0, 0, 7, null);
    }

    private static final Component createThumbPainter$lambda$0(DefaultScrollbarUiInstalledState $state) {
        return $state.scrollBar;
    }

    static {
        Key key = Key.create((String)"JB_SCROLL_BAR_LEADING_COMPONENT");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LEADING = key;
        Key key2 = Key.create((String)"JB_SCROLL_BAR_TRAILING_COMPONENT");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        TRAILING = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ui/components/DefaultScrollBarUI$Companion;", "", "<init>", "()V", "LEADING", "Lcom/intellij/openapi/util/Key;", "Ljava/awt/Component;", "TRAILING", "isOpaque", "", "c", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isOpaque(@NotNull Component c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            if (c.isOpaque()) {
                return true;
            }
            Container parent = c.getParent();
            return parent instanceof JScrollPane && ((JScrollPane)parent).getLayout() instanceof ScrollPaneLayout.UIResource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020(H\u0016J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010*\u001a\u00020\u0012J\u0006\u0010+\u001a\u00020\rJ\u0006\u0010,\u001a\u00020\rJ\u0006\u0010-\u001a\u00020\rJ\u0006\u0010.\u001a\u00020\rJ\u0006\u0010/\u001a\u00020\rJ\u0006\u00100\u001a\u00020\rJ\u000e\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/ui/components/DefaultScrollBarUI$Listener;", "Ljava/awt/event/MouseAdapter;", "Ljava/awt/event/ActionListener;", "Ljava/awt/event/FocusListener;", "Ljavax/swing/event/ChangeListener;", "Ljava/beans/PropertyChangeListener;", "<init>", "(Lcom/intellij/ui/components/DefaultScrollBarUI;)V", "myOffset", "", "myMouseX", "myMouseY", "isReversed", "", "isDragging", "isOverTrack", "isOverThumb", "updateMouse", "", "x", "y", "updateMouseExit", "passMouseEventThroughInvisibleScrollbar", "event", "Ljava/awt/event/MouseEvent;", "mouseClicked", "e", "mousePressed", "mouseReleased", "mouseDragged", "mouseMoved", "mouseExited", "actionPerformed", "Ljava/awt/event/ActionEvent;", "focusGained", "Ljava/awt/event/FocusEvent;", "focusLost", "stateChanged", "Ljavax/swing/event/ChangeEvent;", "propertyChange", "Ljava/beans/PropertyChangeEvent;", "setValueFrom", "startScrollTimerIfNecessary", "isMouseBeforeThumb", "isMouseAfterThumb", "isMouseOnTop", "isMouseOnLeft", "isMouseOnRight", "isMouseOnBottom", "scroll", "reversed", "intellij.platform.ide"})
    @SourceDebugExtension(value={"SMAP\nDefaultScrollBarUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultScrollBarUI.kt\ncom/intellij/ui/components/DefaultScrollBarUI$Listener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,790:1\n1#2:791\n*E\n"})
    private final class Listener
    extends MouseAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener,
    PropertyChangeListener {
        private int myOffset;
        private int myMouseX;
        private int myMouseY;
        private boolean isReversed;
        private boolean isDragging;
        private boolean isOverTrack;
        private boolean isOverThumb;

        /*
         * WARNING - void declaration
         */
        public final void updateMouse(int x, int y) {
            if (DefaultScrollBarUI.this.isTrackContains(x, y)) {
                boolean hover;
                boolean bl;
                Object object;
                boolean bl2;
                Object object2 = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
                if (object2 == null || (object2 = ((DefaultScrollbarUiInstalledState)object2).animationBehavior) == null) {
                    return;
                }
                Object animationBehavior = object2;
                if (!this.isOverTrack) {
                    boolean bl3;
                    bl2 = bl3 = true;
                    object = animationBehavior;
                    bl = false;
                    this.isOverTrack = true;
                    ((ScrollBarAnimationBehavior)object).onTrackHover(bl3);
                }
                if (this.isOverThumb != (hover = DefaultScrollBarUI.this.isThumbContains(x, y))) {
                    void it;
                    bl = bl2 = hover;
                    object = animationBehavior;
                    boolean bl4 = false;
                    this.isOverThumb = it;
                    ((ScrollBarAnimationBehavior)object).onThumbHover(bl2);
                }
            } else {
                this.updateMouseExit();
            }
        }

        public final void updateMouseExit() {
            Object object;
            boolean bl;
            Object object2 = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (object2 == null || (object2 = ((DefaultScrollbarUiInstalledState)object2).animationBehavior) == null) {
                return;
            }
            Object animationBehavior = object2;
            if (this.isOverThumb) {
                boolean bl2 = bl = false;
                object = animationBehavior;
                boolean bl3 = false;
                this.isOverThumb = false;
                ((ScrollBarAnimationBehavior)object).onThumbHover(bl);
            }
            if (this.isOverTrack) {
                boolean it = bl = false;
                object = animationBehavior;
                boolean bl4 = false;
                this.isOverTrack = false;
                ((ScrollBarAnimationBehavior)object).onTrackHover(bl);
            }
        }

        public final boolean passMouseEventThroughInvisibleScrollbar(@NotNull MouseEvent event) {
            Component view;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (DefaultScrollBarUI.this.isTrackClickable() || DefaultScrollBarUI.this.isMousePressedOnVisiblePart(event)) {
                return false;
            }
            Object object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Container parent = object != null && (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) != null ? ((Component)object).getParent() : null;
            JComponent jComponent = parent instanceof JScrollPane ? (JScrollPane)parent : null;
            Component component = jComponent != null && (jComponent = ((JScrollPane)jComponent).getViewport()) != null ? ((JViewport)jComponent).getView() : (view = null);
            if (view != null) {
                Point point = event.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, view);
                MouseEventAdapter.redispatch((MouseEvent)event, (Component)SwingUtilities.getDeepestComponentAt(view, point.x, point.y));
            }
            return true;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
                return;
            }
            Object scrollBar = object;
            if (((Component)scrollBar).isEnabled()) {
                this.passMouseEventThroughInvisibleScrollbar(e);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            boolean vertical;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
                return;
            }
            Object scrollBar = object;
            if (!((Component)scrollBar).isEnabled() || this.passMouseEventThroughInvisibleScrollbar(event) || SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            DefaultScrollBarUI.this.isValueCached = true;
            DefaultScrollBarUI.this.cachedValue = ((JScrollBar)scrollBar).getValue();
            ((JScrollBar)scrollBar).setValueIsAdjusting(true);
            this.myMouseX = event.getX();
            this.myMouseY = event.getY();
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            ScrollBarPainter.Thumb thumb = defaultScrollbarUiInstalledState.thumb;
            boolean bl = vertical = 1 == ((JScrollBar)scrollBar).getOrientation();
            if (DefaultScrollBarUI.this.isThumbContains(this.myMouseX, this.myMouseY)) {
                this.myOffset = vertical ? this.myMouseY - thumb.bounds.y : this.myMouseX - thumb.bounds.x;
                this.isDragging = true;
            } else if (DefaultScrollBarUI.this.isTrackContains(this.myMouseX, this.myMouseY)) {
                if (DefaultScrollBarUI.this.isAbsolutePositioning(event)) {
                    this.myOffset = (vertical ? thumb.bounds.height : thumb.bounds.width) / 2;
                    this.isDragging = true;
                    this.setValueFrom(event);
                } else {
                    DefaultScrollBarUI.this.scrollTimer.stop();
                    this.isDragging = false;
                    if (1 == ((JScrollBar)scrollBar).getOrientation()) {
                        int y = thumb.bounds.isEmpty() ? ((JComponent)scrollBar).getHeight() / 2 : thumb.bounds.y;
                        this.isReversed = this.myMouseY < y;
                    } else {
                        int x = thumb.bounds.isEmpty() ? ((JComponent)scrollBar).getWidth() / 2 : thumb.bounds.x;
                        boolean bl2 = this.isReversed = this.myMouseX < x;
                        if (!((Component)scrollBar).getComponentOrientation().isLeftToRight()) {
                            this.isReversed = !this.isReversed;
                        }
                    }
                    this.scroll(this.isReversed);
                    this.startScrollTimerIfNecessary();
                }
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
            if ((object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide()) == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
                return;
            }
            Object scrollBar = object;
            if (!((Component)scrollBar).isEnabled()) {
                return;
            }
            ((JScrollBar)scrollBar).setValueIsAdjusting(false);
            if (this.passMouseEventThroughInvisibleScrollbar(event)) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.isDragging = false;
            this.myOffset = 0;
            DefaultScrollBarUI.this.scrollTimer.stop();
            DefaultScrollBarUI.this.isValueCached = true;
            DefaultScrollBarUI.this.cachedValue = ((JScrollBar)scrollBar).getValue();
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
                return;
            }
            Object scrollBar = object;
            if (!((Component)scrollBar).isEnabled()) {
                return;
            }
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            if (defaultScrollbarUiInstalledState.thumb.bounds.isEmpty() || SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (this.isDragging) {
                this.setValueFrom(event);
            } else {
                this.myMouseX = event.getX();
                this.myMouseY = event.getY();
                this.updateMouse(this.myMouseX, this.myMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
                return;
            }
            Object scrollBar = object;
            if (!((Component)scrollBar).isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
                return;
            }
            Object scrollBar = object;
            if (!((Component)scrollBar).isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouseExit();
            }
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            JScrollBar scrollBar;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            JScrollBar jScrollBar = scrollBar = defaultScrollbarUiInstalledState != null ? defaultScrollbarUiInstalledState.scrollBar : null;
            if (scrollBar == null) {
                DefaultScrollBarUI.this.scrollTimer.stop();
            } else {
                this.scroll(this.isReversed);
                DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState2 = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
                Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState2);
                if (!defaultScrollbarUiInstalledState2.thumb.bounds.isEmpty()) {
                    boolean bl = this.isReversed ? !this.isMouseBeforeThumb() : !this.isMouseAfterThumb();
                    if (bl) {
                        DefaultScrollBarUI.this.scrollTimer.stop();
                    }
                }
                int value2 = scrollBar.getValue();
                boolean bl = this.isReversed ? value2 <= scrollBar.getMinimum() : value2 >= scrollBar.getMaximum() - scrollBar.getVisibleAmount();
                if (bl) {
                    DefaultScrollBarUI.this.scrollTimer.stop();
                }
            }
        }

        @Override
        public void focusGained(@NotNull FocusEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void focusLost(@NotNull FocusEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DefaultScrollBarUI.this.updateThumbBounds(false);
            DefaultScrollBarUI.this.isValueCached = false;
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent event) {
            DefaultScrollbarUiInstalledState state;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            String string = event.getPropertyName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropertyName(...)");
            String name = string;
            if (Intrinsics.areEqual((Object)"model", (Object)name)) {
                Object object = event.getOldValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.BoundedRangeModel");
                BoundedRangeModel oldModel = (BoundedRangeModel)object;
                Object object2 = event.getNewValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.BoundedRangeModel");
                BoundedRangeModel newModel = (BoundedRangeModel)object2;
                oldModel.removeChangeListener(this);
                newModel.addChangeListener(this);
            }
            if (Intrinsics.areEqual((Object)"model", (Object)name) || Intrinsics.areEqual((Object)"orientation", (Object)name) || Intrinsics.areEqual((Object)"componentOrientation", (Object)name)) {
                DefaultScrollBarUI.this.repaint();
            }
            if ((Intrinsics.areEqual((Object)"opaque", (Object)name) || Intrinsics.areEqual((Object)"visible", (Object)name)) && (state = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide()) != null) {
                state.animationBehavior.onReset();
                state.track.bounds.setBounds(0, 0, 0, 0);
                state.thumb.bounds.setBounds(0, 0, 0, 0);
            }
        }

        public final void setValueFrom(@NotNull MouseEvent event) {
            boolean isDefaultOrientation;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int x = event.getX();
            int y = event.getY();
            int thumbMin = 0;
            int thumbMax = 0;
            int thumbPos = 0;
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            if (defaultScrollbarUiInstalledState == null) {
                return;
            }
            DefaultScrollbarUiInstalledState state = defaultScrollbarUiInstalledState;
            ScrollBarPainter.Track track = state.track;
            ScrollBarPainter.Thumb thumb = state.thumb;
            JScrollBar scrollBar = state.scrollBar;
            if (1 == scrollBar.getOrientation()) {
                thumbMin = track.bounds.y;
                thumbMax = track.bounds.y + track.bounds.height - thumb.bounds.height;
                thumbPos = MathUtil.clamp((int)(y - this.myOffset), (int)thumbMin, (int)thumbMax);
                if (thumb.bounds.y != thumbPos) {
                    int minY = Math.min(thumb.bounds.y, thumbPos);
                    int maxY = Math.max(thumb.bounds.y, thumbPos) + thumb.bounds.height;
                    thumb.bounds.y = thumbPos;
                    state.animationBehavior.onThumbMove();
                    DefaultScrollBarUI.this.repaint(thumb.bounds.x, minY, thumb.bounds.width, maxY - minY);
                }
            } else {
                thumbMin = track.bounds.x;
                thumbMax = track.bounds.x + track.bounds.width - thumb.bounds.width;
                thumbPos = MathUtil.clamp((int)(x - this.myOffset), (int)thumbMin, (int)thumbMax);
                if (thumb.bounds.x != thumbPos) {
                    int minX = Math.min(thumb.bounds.x, thumbPos);
                    int maxX = Math.max(thumb.bounds.x, thumbPos) + thumb.bounds.width;
                    thumb.bounds.x = thumbPos;
                    state.animationBehavior.onThumbMove();
                    DefaultScrollBarUI.this.repaint(minX, thumb.bounds.y, maxX - minX, thumb.bounds.height);
                }
            }
            int valueMin = scrollBar.getMinimum();
            int valueMax = scrollBar.getMaximum() - scrollBar.getVisibleAmount();
            boolean bl = isDefaultOrientation = 1 == scrollBar.getOrientation() || scrollBar.getComponentOrientation().isLeftToRight();
            if (thumbPos == thumbMax) {
                scrollBar.setValue(isDefaultOrientation ? valueMax : valueMin);
            } else {
                int valueRange = valueMax - valueMin;
                int thumbRange = thumbMax - thumbMin;
                int thumbValue = isDefaultOrientation ? thumbPos - thumbMin : thumbMax - thumbPos;
                DefaultScrollBarUI.this.isValueCached = true;
                DefaultScrollBarUI.this.cachedValue = valueMin + DefaultScrollBarUIKt.access$convert(valueRange, thumbValue, thumbRange);
                scrollBar.setValue(DefaultScrollBarUI.this.cachedValue);
            }
            if (!this.isDragging) {
                this.updateMouse(x, y);
            }
        }

        public final void startScrollTimerIfNecessary() {
            if (!DefaultScrollBarUI.this.scrollTimer.isRunning() && (this.isReversed ? this.isMouseBeforeThumb() : this.isMouseAfterThumb())) {
                DefaultScrollBarUI.this.scrollTimer.start();
            }
        }

        public final boolean isMouseBeforeThumb() {
            boolean bl;
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            if (1 == defaultScrollbarUiInstalledState.scrollBar.getOrientation()) {
                bl = this.isMouseOnTop();
            } else {
                DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState2 = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
                Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState2);
                bl = defaultScrollbarUiInstalledState2.scrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnLeft() : this.isMouseOnRight();
            }
            return bl;
        }

        public final boolean isMouseAfterThumb() {
            boolean bl;
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            if (1 == defaultScrollbarUiInstalledState.scrollBar.getOrientation()) {
                bl = this.isMouseOnBottom();
            } else {
                DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState2 = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
                Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState2);
                bl = defaultScrollbarUiInstalledState2.scrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnRight() : this.isMouseOnLeft();
            }
            return bl;
        }

        public final boolean isMouseOnTop() {
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            return this.myMouseY < defaultScrollbarUiInstalledState.thumb.bounds.y;
        }

        public final boolean isMouseOnLeft() {
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            return this.myMouseX < defaultScrollbarUiInstalledState.thumb.bounds.x;
        }

        public final boolean isMouseOnRight() {
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            ScrollBarPainter.Thumb thumb = defaultScrollbarUiInstalledState.thumb;
            return this.myMouseX > thumb.bounds.x + thumb.bounds.width;
        }

        public final boolean isMouseOnBottom() {
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            ScrollBarPainter.Thumb thumb = defaultScrollbarUiInstalledState.thumb;
            return this.myMouseY > thumb.bounds.y + thumb.bounds.height;
        }

        public final void scroll(boolean reversed) {
            DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = DefaultScrollBarUI.this.getInstalledState$intellij_platform_ide();
            Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
            JScrollBar scrollBar = defaultScrollbarUiInstalledState.scrollBar;
            int delta = scrollBar.getBlockIncrement(reversed ? -1 : 1);
            if (reversed) {
                delta = -delta;
            }
            int oldValue = scrollBar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollBar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollBar.getMinimum();
            }
            if (oldValue != newValue) {
                scrollBar.setValue(newValue);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UIUtil.ComponentStyle.values().length];
            try {
                nArray[UIUtil.ComponentStyle.LARGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UIUtil.ComponentStyle.SMALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UIUtil.ComponentStyle.MINI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UIUtil.ComponentStyle.REGULAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

