/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.tabs.impl.IslandsPainterProvider;
import com.intellij.util.ui.RegionPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ScrollBarPainter
implements RegionPainter<Float> {
    final Rectangle bounds;
    final TwoWayAnimator animator;
    public static final ColorKey BACKGROUND = ScrollBarPainter.key(-657931, -12631484, "ScrollBar.background");
    public static final ColorKey TRACK_OPAQUE_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.trackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.trackColor");
    public static final ColorKey TRACK_OPAQUE_HOVERED_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.hoverTrackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.hoverTrackColor");
    public static final ColorKey TRACK_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.Transparent.trackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Transparent.trackColor");
    public static final ColorKey TRACK_HOVERED_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(444629120, 444629120, "ScrollBar.Mac.Transparent.hoverTrackColor") : ScrollBarPainter.key(444629120, 444629120, "ScrollBar.Transparent.hoverTrackColor");
    public static final ColorKey THUMB_OPAQUE_FOREGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0x33000000, 1495672358, "ScrollBar.Mac.thumbBorderColor") : ScrollBarPainter.key(0x33595959, 1194866744, "ScrollBar.thumbBorderColor");
    public static final ColorKey THUMB_OPAQUE_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0x33000000, 1501593728, "ScrollBar.Mac.thumbColor") : ScrollBarPainter.key(0x33737373, 1202103974, "ScrollBar.thumbColor");
    public static final ColorKey THUMB_OPAQUE_HOVERED_FOREGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1943656922, "ScrollBar.Mac.hoverThumbBorderColor") : ScrollBarPainter.key(1197037913, 1496856632, "ScrollBar.hoverThumbBorderColor");
    public static final ColorKey THUMB_OPAQUE_HOVERED_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1937735552, "ScrollBar.Mac.hoverThumbColor") : ScrollBarPainter.key(0x47737373, 1504093862, "ScrollBar.hoverThumbColor");
    public static final ColorKey THUMB_FOREGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0, 0x262626, "ScrollBar.Mac.Transparent.thumbBorderColor") : ScrollBarPainter.key(0x33595959, 1194866744, "ScrollBar.Transparent.thumbBorderColor");
    public static final ColorKey THUMB_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(0, 0x808080, "ScrollBar.Mac.Transparent.thumbColor") : ScrollBarPainter.key(0x33737373, 1202103974, "ScrollBar.Transparent.thumbColor");
    public static final ColorKey THUMB_HOVERED_FOREGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1943656922, "ScrollBar.Mac.Transparent.hoverThumbBorderColor") : ScrollBarPainter.key(1197037913, 1496856632, "ScrollBar.Transparent.hoverThumbBorderColor");
    public static final ColorKey THUMB_HOVERED_BACKGROUND = SystemInfoRt.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1937735552, "ScrollBar.Mac.Transparent.hoverThumbColor") : ScrollBarPainter.key(0x47737373, 1504093862, "ScrollBar.Transparent.hoverThumbColor");
    public static final ColorKey TABS_TRANSPARENT_THUMB_BACKGROUND = ScrollBarPainter.key(0xABABAB, 0x434344, "Scrollbar.Tabs.TransparentThumbColor");
    public static final ColorKey TABS_THUMB_BACKGROUND = ScrollBarPainter.key(-5526613, -12369084, "Scrollbar.Tabs.ThumbColor");
    public static final ColorKey TABS_THUMB_HOVERED_BACKGROUND = ScrollBarPainter.key(-8421505, -11316139, "Scrollbar.Tabs.HoveredThumbColor");
    private static final List<ColorKey> CONTRAST_ELEMENTS_KEYS = Arrays.asList(THUMB_OPAQUE_FOREGROUND, THUMB_OPAQUE_BACKGROUND, THUMB_OPAQUE_HOVERED_FOREGROUND, THUMB_OPAQUE_HOVERED_BACKGROUND, THUMB_FOREGROUND, THUMB_BACKGROUND, THUMB_HOVERED_FOREGROUND, THUMB_HOVERED_BACKGROUND);

    ScrollBarPainter(final @NotNull Supplier<? extends Component> supplier, @NotNull CoroutineScope coroutineScope) {
        if (supplier == null) {
            ScrollBarPainter.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            ScrollBarPainter.$$$reportNull$$$0(1);
        }
        this.bounds = new Rectangle();
        this.animator = new TwoWayAnimator(this, this.getClass().getName(), 11, 150, 125, 300, 125, coroutineScope){

            @Override
            public void onValueUpdate() {
                Component component = (Component)supplier.get();
                if (component != null) {
                    component.repaint();
                }
            }
        };
    }

    @NotNull
    private static ColorKey key(int light, int dark, @NotNull String name) {
        if (name == null) {
            ScrollBarPainter.$$$reportNull$$$0(2);
        }
        ColorKey colorKey = EditorColorsUtil.createColorKey((String)name, (Color)new JBColor(new Color(light, true), new Color(dark, true)));
        if (colorKey == null) {
            ScrollBarPainter.$$$reportNull$$$0(3);
        }
        return colorKey;
    }

    @NotNull
    private static Color getColor(@Nullable Component component, @NotNull ColorKey key) {
        boolean useContrastScrollbars;
        if (key == null) {
            ScrollBarPainter.$$$reportNull$$$0(4);
        }
        Color color = EditorColorsUtil.getColor((Component)component, (ColorKey)key);
        assert (color != null) : "default color is not specified for " + String.valueOf(key);
        boolean bl = useContrastScrollbars = LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && UISettings.getInstance().getUseContrastScrollbars();
        if (useContrastScrollbars) {
            color = ScrollBarPainter.updateTransparency(color, key);
        }
        Color color2 = color;
        if (color2 == null) {
            ScrollBarPainter.$$$reportNull$$$0(5);
        }
        return color2;
    }

    private static Color updateTransparency(Color color, ColorKey key) {
        if (!CONTRAST_ELEMENTS_KEYS.contains(key)) {
            return color;
        }
        int alpha = Registry.intValue((String)"contrast.scrollbars.alpha.level");
        if (alpha > 0) {
            alpha = Integer.min(alpha, 255);
        } else {
            IslandsPainterProvider provider = IslandsPainterProvider.getInstance();
            boolean isMac = SystemInfoRt.isMac || provider != null && provider.useMacScrollBar();
            int LIGHT_ALPHA = isMac ? 120 : 160;
            int DARK_ALPHA = isMac ? 255 : 180;
            alpha = JBColor.isBright() ? LIGHT_ALPHA : DARK_ALPHA;
        }
        return ColorUtil.toAlpha((Color)color, (int)alpha);
    }

    static Color getColor(@NotNull Supplier<? extends Component> supplier, @NotNull ColorKey key) {
        if (supplier == null) {
            ScrollBarPainter.$$$reportNull$$$0(6);
        }
        if (key == null) {
            ScrollBarPainter.$$$reportNull$$$0(7);
        }
        return JBColor.lazy(() -> ScrollBarPainter.getColor((Component)supplier.get(), key));
    }

    static Color getColor(@NotNull Supplier<? extends Component> supplier, @NotNull ColorKey transparent, @NotNull ColorKey opaque) {
        if (supplier == null) {
            ScrollBarPainter.$$$reportNull$$$0(8);
        }
        if (transparent == null) {
            ScrollBarPainter.$$$reportNull$$$0(9);
        }
        if (opaque == null) {
            ScrollBarPainter.$$$reportNull$$$0(10);
        }
        return JBColor.lazy(() -> {
            Component component;
            return ScrollBarPainter.getColor(component, (component = (Component)supplier.get()) != null && DefaultScrollBarUI.Companion.isOpaque(component) ? opaque : transparent);
        });
    }

    static void setBackground(@NotNull Component component) {
        if (component == null) {
            ScrollBarPainter.$$$reportNull$$$0(11);
        }
        component.setBackground((Color)JBColor.lazy(() -> ScrollBarPainter.getColor(component, BACKGROUND)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/ScrollBarPainter";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transparent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opaque";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/ScrollBarPainter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "key";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "key";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class ThinScrollBarThumb
    extends Thumb {
        ThinScrollBarThumb(@NotNull Supplier<? extends Component> supplier, boolean opaque, @NotNull CoroutineScope coroutineScope) {
            if (supplier == null) {
                ThinScrollBarThumb.$$$reportNull$$$0(0);
            }
            if (coroutineScope == null) {
                ThinScrollBarThumb.$$$reportNull$$$0(1);
            }
            super(supplier, opaque, coroutineScope);
        }

        @Override
        protected int macMargin(boolean withBorder) {
            return 0;
        }

        @Override
        protected boolean ignoreBorder() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "supplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "coroutineScope";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/components/ScrollBarPainter$ThinScrollBarThumb";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class Thumb
    extends ScrollBarPainter {
        private final MixedColorProducer fillProducer;
        private final MixedColorProducer drawProducer;

        Thumb(@NotNull Supplier<? extends Component> supplier, boolean opaque, @NotNull CoroutineScope coroutineScope) {
            if (supplier == null) {
                Thumb.$$$reportNull$$$0(0);
            }
            if (coroutineScope == null) {
                Thumb.$$$reportNull$$$0(1);
            }
            super(supplier, coroutineScope);
            this.fillProducer = new MixedColorProducer(opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_BACKGROUND) : Thumb.getColor(supplier, THUMB_BACKGROUND, THUMB_OPAQUE_BACKGROUND), opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_HOVERED_BACKGROUND) : Thumb.getColor(supplier, THUMB_HOVERED_BACKGROUND, THUMB_OPAQUE_HOVERED_BACKGROUND));
            this.drawProducer = new MixedColorProducer(opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_FOREGROUND) : Thumb.getColor(supplier, THUMB_FOREGROUND, THUMB_OPAQUE_FOREGROUND), opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_HOVERED_FOREGROUND) : Thumb.getColor(supplier, THUMB_HOVERED_FOREGROUND, THUMB_OPAQUE_HOVERED_FOREGROUND));
        }

        public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Float value2) {
            if (g == null) {
                Thumb.$$$reportNull$$$0(2);
            }
            double mixer = value2 == null ? 0.0 : value2.doubleValue();
            MixedColorProducer fillProducer = this.getFillProducer();
            Color fill = fillProducer.produce(mixer);
            Color draw = this.drawProducer.produce(mixer);
            if (this.ignoreBorder() || fill.getRGB() == draw.getRGB()) {
                draw = null;
            }
            int arc = 0;
            IslandsPainterProvider provider = IslandsPainterProvider.getInstance();
            if (SystemInfoRt.isMac || provider != null && provider.useMacScrollBar()) {
                int margin = this.macMargin(draw != null);
                x += margin;
                y += margin;
                arc = Math.min(width -= margin + margin, height -= margin + margin);
            }
            RectanglePainter.paint((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (int)arc, (Paint)fill, (Paint)draw);
        }

        protected MixedColorProducer getFillProducer() {
            return this.fillProducer;
        }

        protected int macMargin(boolean withBorder) {
            return withBorder ? 1 : 2;
        }

        protected boolean ignoreBorder() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coroutineScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/components/ScrollBarPainter$Thumb";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Track
    extends ScrollBarPainter {
        private final MixedColorProducer fillProducer;

        public Track(@NotNull Supplier<? extends Component> supplier, @NotNull CoroutineScope coroutineScope) {
            if (supplier == null) {
                Track.$$$reportNull$$$0(0);
            }
            if (coroutineScope == null) {
                Track.$$$reportNull$$$0(1);
            }
            super(supplier, coroutineScope);
            this.fillProducer = new MixedColorProducer(Track.getColor(supplier, TRACK_BACKGROUND, TRACK_OPAQUE_BACKGROUND), Track.getColor(supplier, TRACK_HOVERED_BACKGROUND, TRACK_OPAQUE_HOVERED_BACKGROUND));
        }

        public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Float value2) {
            double mixer;
            Color fill;
            if (g == null) {
                Track.$$$reportNull$$$0(2);
            }
            if (0 >= (fill = this.fillProducer.produce(mixer = value2 == null ? 0.0 : value2.doubleValue())).getAlpha()) {
                return;
            }
            g.setPaint(fill);
            RectanglePainter.FILL.paint(g, x, y, width, height, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coroutineScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/components/ScrollBarPainter$Track";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

