/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsX;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.ui.dsl.gridLayout.impl.Cell;
import com.intellij.ui.dsl.gridLayout.impl.GridImplKt;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J1\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0015H\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010%\"\u0004\b(\u0010)\u00a8\u00065"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "", "cell", "Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "preferredSize", "Ljava/awt/Dimension;", "unscaledColumnGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;", "unscaledRowGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "<init>", "(Lcom/intellij/ui/dsl/gridLayout/impl/Cell;Ljava/awt/Dimension;Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;)V", "getCell", "()Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "getPreferredSize", "()Ljava/awt/Dimension;", "getUnscaledColumnGaps", "()Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;", "getUnscaledRowGaps", "()Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "baseline", "", "getBaseline", "()Ljava/lang/Integer;", "setBaseline", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "gapWidth", "getGapWidth", "()I", "gapHeight", "getGapHeight", "cellPaddedWidth", "getCellPaddedWidth", "scaledGaps", "Lcom/intellij/ui/dsl/gridLayout/Gaps;", "getScaledGaps", "()Lcom/intellij/ui/dsl/gridLayout/Gaps;", "scaledVisualPaddings", "getScaledVisualPaddings", "setScaledVisualPaddings", "(Lcom/intellij/ui/dsl/gridLayout/Gaps;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide"})
final class LayoutCellData {
    @NotNull
    private final Cell cell;
    @NotNull
    private final Dimension preferredSize;
    @NotNull
    private final UnscaledGapsX unscaledColumnGaps;
    @NotNull
    private final UnscaledGapsY unscaledRowGaps;
    @Nullable
    private Integer baseline;
    @NotNull
    private final Gaps scaledGaps;
    @NotNull
    private Gaps scaledVisualPaddings;

    public LayoutCellData(@NotNull Cell cell, @NotNull Dimension preferredSize, @NotNull UnscaledGapsX unscaledColumnGaps, @NotNull UnscaledGapsY unscaledRowGaps) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)unscaledColumnGaps, (String)"unscaledColumnGaps");
        Intrinsics.checkNotNullParameter((Object)unscaledRowGaps, (String)"unscaledRowGaps");
        this.cell = cell;
        this.preferredSize = preferredSize;
        this.unscaledColumnGaps = unscaledColumnGaps;
        this.unscaledRowGaps = unscaledRowGaps;
        this.scaledGaps = GridImplKt.access$scale(this.cell.getConstraints().getGaps());
        this.scaledVisualPaddings = GridImplKt.access$scale(this.cell.getConstraints().getVisualPaddings());
    }

    @NotNull
    public final Cell getCell() {
        return this.cell;
    }

    @NotNull
    public final Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @NotNull
    public final UnscaledGapsX getUnscaledColumnGaps() {
        return this.unscaledColumnGaps;
    }

    @NotNull
    public final UnscaledGapsY getUnscaledRowGaps() {
        return this.unscaledRowGaps;
    }

    @Nullable
    public final Integer getBaseline() {
        return this.baseline;
    }

    public final void setBaseline(@Nullable Integer n) {
        this.baseline = n;
    }

    public final int getGapWidth() {
        return this.scaledGaps.getWidth() + JBUIScale.scale((int)this.unscaledColumnGaps.getLeft()) + JBUIScale.scale((int)this.unscaledColumnGaps.getRight());
    }

    public final int getGapHeight() {
        return this.scaledGaps.getHeight() + JBUIScale.scale((int)this.unscaledRowGaps.getTop()) + JBUIScale.scale((int)this.unscaledRowGaps.getBottom());
    }

    public final int getCellPaddedWidth() {
        return this.preferredSize.width + this.getGapWidth() - this.scaledVisualPaddings.getWidth();
    }

    @NotNull
    public final Gaps getScaledGaps() {
        return this.scaledGaps;
    }

    @NotNull
    public final Gaps getScaledVisualPaddings() {
        return this.scaledVisualPaddings;
    }

    public final void setScaledVisualPaddings(@NotNull Gaps gaps) {
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"<set-?>");
        this.scaledVisualPaddings = gaps;
    }

    @NotNull
    public final Cell component1() {
        return this.cell;
    }

    @NotNull
    public final Dimension component2() {
        return this.preferredSize;
    }

    @NotNull
    public final UnscaledGapsX component3() {
        return this.unscaledColumnGaps;
    }

    @NotNull
    public final UnscaledGapsY component4() {
        return this.unscaledRowGaps;
    }

    @NotNull
    public final LayoutCellData copy(@NotNull Cell cell, @NotNull Dimension preferredSize, @NotNull UnscaledGapsX unscaledColumnGaps, @NotNull UnscaledGapsY unscaledRowGaps) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)unscaledColumnGaps, (String)"unscaledColumnGaps");
        Intrinsics.checkNotNullParameter((Object)unscaledRowGaps, (String)"unscaledRowGaps");
        return new LayoutCellData(cell, preferredSize, unscaledColumnGaps, unscaledRowGaps);
    }

    public static /* synthetic */ LayoutCellData copy$default(LayoutCellData layoutCellData, Cell cell, Dimension dimension, UnscaledGapsX unscaledGapsX, UnscaledGapsY unscaledGapsY, int n, Object object) {
        if ((n & 1) != 0) {
            cell = layoutCellData.cell;
        }
        if ((n & 2) != 0) {
            dimension = layoutCellData.preferredSize;
        }
        if ((n & 4) != 0) {
            unscaledGapsX = layoutCellData.unscaledColumnGaps;
        }
        if ((n & 8) != 0) {
            unscaledGapsY = layoutCellData.unscaledRowGaps;
        }
        return layoutCellData.copy(cell, dimension, unscaledGapsX, unscaledGapsY);
    }

    @NotNull
    public String toString() {
        return "LayoutCellData(cell=" + this.cell + ", preferredSize=" + this.preferredSize + ", unscaledColumnGaps=" + this.unscaledColumnGaps + ", unscaledRowGaps=" + this.unscaledRowGaps + ")";
    }

    public int hashCode() {
        int result2 = this.cell.hashCode();
        result2 = result2 * 31 + this.preferredSize.hashCode();
        result2 = result2 * 31 + this.unscaledColumnGaps.hashCode();
        result2 = result2 * 31 + this.unscaledRowGaps.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutCellData)) {
            return false;
        }
        LayoutCellData layoutCellData = (LayoutCellData)other;
        if (!Intrinsics.areEqual((Object)this.cell, (Object)layoutCellData.cell)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preferredSize, (Object)layoutCellData.preferredSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.unscaledColumnGaps, (Object)layoutCellData.unscaledColumnGaps)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.unscaledRowGaps, (Object)layoutCellData.unscaledRowGaps);
    }
}

