/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.TabLabel;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a(\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u001a\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"checkConstraints", "", "constraints", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MIN_WIDTH_TO_CROP_ICON", "", "paintGradientRect", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "fromColor", "Ljava/awt/Color;", "toColor", "mergeUiDecorations", "Lcom/intellij/ui/tabs/impl/TabLabel$MergedUiDecoration;", "customDec", "Lcom/intellij/ui/tabs/UiDecorator$UiDecoration;", "defaultDec", "mergeInsets", "Ljava/awt/Insets;", "custom", "def", "getValue", "currentValue", "newValue", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nTabLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabLabel.kt\ncom/intellij/ui/tabs/impl/TabLabelKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,858:1\n13#2:859\n*S KotlinDebug\n*F\n+ 1 TabLabel.kt\ncom/intellij/ui/tabs/impl/TabLabelKt\n*L\n826#1:859\n*E\n"})
public final class TabLabelKt {
    @NotNull
    private static final Logger LOG;
    private static final int MIN_WIDTH_TO_CROP_ICON = 39;

    private static final void checkConstraints(Object constraints) {
        if (Intrinsics.areEqual((Object)"North", (Object)constraints) || Intrinsics.areEqual((Object)"South", (Object)constraints)) {
            LOG.warn((Throwable)new IllegalArgumentException("constraints=" + constraints));
        }
    }

    private static final void paintGradientRect(Graphics2D g, Rectangle rect, Color fromColor, Color toColor) {
        g.setPaint(new GradientPaint(rect.x, rect.y, fromColor, rect.x + rect.width, rect.y, toColor));
        g.fill(rect);
    }

    @NotNull
    public static final TabLabel.MergedUiDecoration mergeUiDecorations(@NotNull UiDecorator.UiDecoration customDec, @NotNull UiDecorator.UiDecoration defaultDec) {
        int n;
        Intrinsics.checkNotNullParameter((Object)customDec, (String)"customDec");
        Intrinsics.checkNotNullParameter((Object)defaultDec, (String)"defaultDec");
        Insets insets = customDec.getLabelInsets();
        Insets insets2 = defaultDec.getLabelInsets();
        Intrinsics.checkNotNull((Object)insets2);
        Insets insets3 = TabLabelKt.mergeInsets(insets, insets2);
        Function<TabLabel.ActionsPosition, Insets> function = arg_0 -> TabLabelKt.mergeUiDecorations$lambda$0(defaultDec, customDec, arg_0);
        Integer n2 = customDec.getIconTextGap();
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = defaultDec.getIconTextGap();
            Intrinsics.checkNotNull((Object)n3);
            n = n3;
        }
        return new TabLabel.MergedUiDecoration(insets3, function, n);
    }

    private static final Insets mergeInsets(Insets custom, Insets def) {
        if (custom != null) {
            return new Insets(TabLabelKt.getValue(def.top, custom.top), TabLabelKt.getValue(def.left, custom.left), TabLabelKt.getValue(def.bottom, custom.bottom), TabLabelKt.getValue(def.right, custom.right));
        }
        return def;
    }

    private static final int getValue(int currentValue, int newValue) {
        return newValue == -1 ? currentValue : newValue;
    }

    private static final Insets mergeUiDecorations$lambda$0(UiDecorator.UiDecoration $defaultDec, UiDecorator.UiDecoration $customDec, TabLabel.ActionsPosition position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Function<TabLabel.ActionsPosition, Insets> function = $defaultDec.getContentInsetsSupplier();
        Intrinsics.checkNotNull(function);
        Insets insets = function.apply(position);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"apply(...)");
        Insets def = insets;
        if ($customDec.getContentInsetsSupplier() != null) {
            return TabLabelKt.mergeInsets($customDec.getContentInsetsSupplier().apply(position), def);
        }
        return def;
    }

    public static final /* synthetic */ void access$paintGradientRect(Graphics2D g, Rectangle rect, Color fromColor, Color toColor) {
        TabLabelKt.paintGradientRect(g, rect, fromColor, toColor);
    }

    public static final /* synthetic */ void access$checkConstraints(Object constraints) {
        TabLabelKt.checkConstraints(constraints);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TabLabel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

