/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.multiRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.multiRow.CompressibleTabsRow;
import com.intellij.ui.tabs.impl.multiRow.MultiRowLayout;
import com.intellij.ui.tabs.impl.multiRow.MultiRowPassInfo;
import com.intellij.ui.tabs.impl.multiRow.ScrollableTabsRow;
import com.intellij.ui.tabs.impl.multiRow.TabsRow;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/ScrollableMultiRowLayout;", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowLayout;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "showPinnedTabsSeparately", "", "isWithScrollBar", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;ZZ)V", "scrollOffset", "", "layoutTable", "Lcom/intellij/ui/tabs/impl/LayoutPassInfo;", "visibleInfos", "", "Lcom/intellij/ui/tabs/TabInfo;", "splitToRows", "Lcom/intellij/ui/tabs/impl/multiRow/TabsRow;", "data", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "splitToRows$intellij_platform_ide", "getScrollOffset", "scroll", "", "units", "isScrollable", "scrollToSelectedTab", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nScrollableMultiRowLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollableMultiRowLayout.kt\ncom/intellij/ui/tabs/impl/multiRow/ScrollableMultiRowLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class ScrollableMultiRowLayout
extends MultiRowLayout {
    private final boolean isWithScrollBar;
    private int scrollOffset;

    public ScrollableMultiRowLayout(@NotNull JBTabsImpl tabs, boolean showPinnedTabsSeparately, boolean isWithScrollBar) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        super(tabs, showPinnedTabsSeparately, null);
        this.isWithScrollBar = isWithScrollBar;
    }

    public /* synthetic */ ScrollableMultiRowLayout(JBTabsImpl jBTabsImpl, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(jBTabsImpl, bl, bl2);
    }

    @Override
    @NotNull
    public LayoutPassInfo layoutTable(@NotNull List<TabInfo> visibleInfos) {
        Intrinsics.checkNotNullParameter(visibleInfos, (String)"visibleInfos");
        if (!(this.getTabs().isMouseInsideTabsArea() || this.getTabs().isHideTabs() || this.getTabs().isScrollBarAdjusting$intellij_platform_ide() || this.getTabs().isRecentlyActive())) {
            this.scrollToSelectedTab();
        }
        return super.layoutTable(visibleInfos);
    }

    @Override
    @NotNull
    public List<TabsRow> splitToRows$intellij_platform_ide(@NotNull MultiRowPassInfo data) {
        List list;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List list2 = data.visibleInfos;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"visibleInfos");
        Pair<List<TabInfo>, List<TabInfo>> pair = this.splitToPinnedUnpinned(list2);
        List pinned = (List)pair.component1();
        List unpinned = (List)pair.component2();
        boolean withTitle = this.getTabs().getTitleWrapper().getPreferredSize().width > 0;
        boolean withEntryPoint = this.getTabs().getEntryPointPreferredSize().width > 0;
        if (!((Collection)pinned).isEmpty() && !((Collection)unpinned).isEmpty()) {
            Object[] objectArray = new TabsRow[]{new CompressibleTabsRow(pinned, withTitle, withEntryPoint), new ScrollableTabsRow(unpinned, false, false)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = !((Collection)pinned).isEmpty() ? CollectionsKt.listOf((Object)new CompressibleTabsRow(pinned, withTitle, withEntryPoint)) : CollectionsKt.listOf((Object)new ScrollableTabsRow(unpinned, withTitle, withEntryPoint));
        }
        return list;
    }

    @Override
    public int getScrollOffset() {
        return this.scrollOffset;
    }

    @Override
    public void scroll(int units) {
        this.scrollOffset += units;
    }

    @Override
    public boolean isScrollable() {
        return true;
    }

    @Override
    public boolean isWithScrollBar() {
        return this.isWithScrollBar;
    }

    private final void scrollToSelectedTab() {
        Object v1;
        MultiRowPassInfo data;
        block9: {
            MultiRowPassInfo multiRowPassInfo = this.getPrevLayoutPassInfo$intellij_platform_ide();
            if (multiRowPassInfo == null) {
                return;
            }
            data = multiRowPassInfo;
            Iterable iterable = data.getRows();
            for (Object object : iterable) {
                TabsRow it = (TabsRow)object;
                boolean bl = false;
                if (!(it instanceof ScrollableTabsRow)) continue;
                v1 = object;
                break block9;
            }
            v1 = null;
        }
        TabsRow tabsRow = v1;
        if (tabsRow == null) {
            return;
        }
        TabsRow scrollableRow = tabsRow;
        TabInfo tabInfo = this.getTabs().getSelectedInfo();
        if (tabInfo == null) {
            return;
        }
        TabInfo selectedInfo = tabInfo;
        int minX = 0;
        int maxX = data.getScrollExtent();
        int offset = -this.scrollOffset;
        for (TabInfo info : scrollableRow.getInfos()) {
            Integer n = data.getLengths().get(info);
            Intrinsics.checkNotNull((Object)n);
            int length = ((Number)n).intValue();
            if (Intrinsics.areEqual((Object)info, (Object)selectedInfo)) {
                if (offset <= 0) {
                    this.scroll(offset - minX);
                } else if (offset + length > maxX) {
                    this.scroll(offset + length - maxX);
                }
                return;
            }
            offset += length + this.getTabs().getTabHGap();
        }
    }
}

