/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.multiRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.multiRow.MultiRowPassInfo;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J-\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H \u00a2\u0006\u0002\b\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/TabsRow;", "", "infos", "", "Lcom/intellij/ui/tabs/TabInfo;", "withTitle", "", "withEntryPointToolbar", "<init>", "(Ljava/util/List;ZZ)V", "getInfos", "()Ljava/util/List;", "getWithTitle", "()Z", "getWithEntryPointToolbar", "layoutRow", "", "data", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "y", "", "layoutRow$intellij_platform_ide", "layoutTabs", "x", "maxLength", "layoutTabs$intellij_platform_ide", "layoutTitleAndEntryPoint", "Lkotlin/ranges/IntRange;", "toString", "", "intellij.platform.ide"})
public abstract class TabsRow {
    @NotNull
    private final List<TabInfo> infos;
    private final boolean withTitle;
    private final boolean withEntryPointToolbar;

    public TabsRow(@NotNull List<TabInfo> infos, boolean withTitle, boolean withEntryPointToolbar) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        this.infos = infos;
        this.withTitle = withTitle;
        this.withEntryPointToolbar = withEntryPointToolbar;
    }

    @NotNull
    public final List<TabInfo> getInfos() {
        return this.infos;
    }

    public final boolean getWithTitle() {
        return this.withTitle;
    }

    public final boolean getWithEntryPointToolbar() {
        return this.withEntryPointToolbar;
    }

    public final void layoutRow$intellij_platform_ide(@NotNull MultiRowPassInfo data, int y) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IntRange tabsRange = this.layoutTitleAndEntryPoint(data, y);
        this.layoutTabs$intellij_platform_ide(data, tabsRange.getFirst(), y, tabsRange.getLast() - tabsRange.getFirst());
    }

    public abstract void layoutTabs$intellij_platform_ide(@NotNull MultiRowPassInfo var1, int var2, int var3, int var4);

    private final IntRange layoutTitleAndEntryPoint(MultiRowPassInfo data, int y) {
        JBTabsImpl tabs = data.tabs;
        if (this.withTitle) {
            data.titleRect = new Rectangle(data.toFitRec.x, y, tabs.getTitleWrapper().getPreferredSize().width, data.getRowHeight());
        }
        if (this.withEntryPointToolbar) {
            int entryPointWidth = tabs.getEntryPointPreferredSize().width;
            data.entryPointRect = new Rectangle(data.toFitRec.x + data.toFitRec.width - entryPointWidth - tabs.getActionsInsets().right, y, entryPointWidth, data.getRowHeight());
        }
        int leftmostX = data.toFitRec.x + data.titleRect.width;
        int rightmostX = this.withEntryPointToolbar ? data.entryPointRect.x - tabs.getActionsInsets().left : data.toFitRec.x + data.toFitRec.width;
        return new IntRange(leftmostX, rightmostX);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.infos;
    }
}

