/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class WindowTabsLayout
extends SingleRowLayout {
    public WindowTabsLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data) {
        data.requiredLength = this.tabs.getWidth();
        data.toLayout.addAll(data.visibleInfos);
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label2, int length) {
        int tabCount = data.toLayout.size();
        if (tabCount > 0) {
            int fullWidth;
            Rectangle bounds = this.getStrategy().getLayoutRect(data, data.position, length);
            int tabsWidth = this.tabs.getWidth();
            bounds.width = tabsWidth / tabCount;
            if (this.tabs.getIndexOf(label2.getInfo()) == this.tabs.getTabCount() - 1 && (fullWidth = bounds.width * tabCount) < tabsWidth) {
                bounds.width += tabsWidth - fullWidth;
            }
            this.tabs.layout(label2, bounds);
            label2.setAlignmentToCenter(true);
            return true;
        }
        return super.applyTabLayout(data, label2, length);
    }

    @Override
    public int getDropIndexFor(@NotNull Point point) {
        Component component;
        if (point == null) {
            WindowTabsLayout.$$$reportNull$$$0(0);
        }
        if ((component = this.tabs.getComponentAt(point)) instanceof TabLabel) {
            TabLabel label2 = (TabLabel)component;
            if (this.lastSingRowLayout != null) {
                return this.lastSingRowLayout.visibleInfos.indexOf(label2.getInfo());
            }
        }
        return -1;
    }

    @Override
    public int getDropSideFor(@NotNull Point point) {
        if (point == null) {
            WindowTabsLayout.$$$reportNull$$$0(1);
        }
        return -1;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            WindowTabsLayout.$$$reportNull$$$0(2);
        }
        Rectangle bounds = tabLabel.getBounds();
        if (bounds.x + bounds.width + deltaX < 0 || bounds.x + bounds.width > tabLabel.getParent().getWidth()) {
            return true;
        }
        return Math.abs(deltaY) > tabLabel.getHeight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabLabel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/singleRow/WindowTabsLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropIndexFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropSideFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

