/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.animation.AnimationContext;
import com.intellij.util.animation.Easing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class Animation {
    @NotNull
    private final DoubleConsumer myConsumer;
    @NotNull
    private Easing myEasing;
    private int myDelay;
    private int myDuration;
    @Nullable
    private List<Listener> myListeners;

    public Animation(@NotNull DoubleConsumer consumer) {
        if (consumer == null) {
            Animation.$$$reportNull$$$0(0);
        }
        this.myEasing = Easing.EASE;
        this.myDelay = 0;
        this.myDuration = 500;
        this.myConsumer = consumer;
    }

    public Animation(DoubleConsumer ... consumers) {
        if (consumers == null) {
            Animation.$$$reportNull$$$0(1);
        }
        this.myEasing = Easing.EASE;
        this.myDelay = 0;
        this.myDuration = 500;
        this.myConsumer = value2 -> {
            for (DoubleConsumer consumer : consumers) {
                consumer.accept(value2);
            }
        };
    }

    public <T> Animation(@NotNull DoubleFunction<? extends T> function, @NotNull Consumer<? super T> consumer) {
        if (function == null) {
            Animation.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            Animation.$$$reportNull$$$0(3);
        }
        this.myEasing = Easing.EASE;
        this.myDelay = 0;
        this.myDuration = 500;
        this.myConsumer = value2 -> consumer.accept((Object)function.apply(value2));
    }

    public static <T> Animation withContext(@NotNull AnimationContext<T> context, @NotNull DoubleFunction<? extends T> function) {
        if (context == null) {
            Animation.$$$reportNull$$$0(4);
        }
        if (function == null) {
            Animation.$$$reportNull$$$0(5);
        }
        return new Animation(function, context);
    }

    public int getDelay() {
        return this.myDelay;
    }

    @NotNull
    public Animation setDelay(int delay) {
        this.myDelay = Math.max(delay, 0);
        Animation animation = this;
        if (animation == null) {
            Animation.$$$reportNull$$$0(6);
        }
        return animation;
    }

    public int getDuration() {
        return this.myDuration;
    }

    @NotNull
    public Animation setDuration(int duration) {
        this.myDuration = Math.max(duration, 0);
        Animation animation = this;
        if (animation == null) {
            Animation.$$$reportNull$$$0(7);
        }
        return animation;
    }

    public int getFinish() {
        return this.myDelay + this.myDuration;
    }

    void update(double timeline) {
        this.myConsumer.accept(this.myEasing.calc(timeline));
    }

    @NotNull
    public Easing getEasing() {
        Easing easing = this.myEasing;
        if (easing == null) {
            Animation.$$$reportNull$$$0(8);
        }
        return easing;
    }

    @NotNull
    public Animation setEasing(@NotNull Easing easing) {
        if (easing == null) {
            Animation.$$$reportNull$$$0(9);
        }
        this.myEasing = easing;
        Animation animation = this;
        if (animation == null) {
            Animation.$$$reportNull$$$0(10);
        }
        return animation;
    }

    @NotNull
    public Animation addListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            Animation.$$$reportNull$$$0(11);
        }
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<Listener>();
        }
        this.myListeners.add(listener2);
        Animation animation = this;
        if (animation == null) {
            Animation.$$$reportNull$$$0(12);
        }
        return animation;
    }

    @NotNull
    public Animation runWhenScheduled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(13);
        }
        return this.addListener(Phase.SCHEDULED, runnable);
    }

    @NotNull
    public Animation runWhenUpdated(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(14);
        }
        return this.addListener(Phase.UPDATED, runnable);
    }

    @NotNull
    public Animation runWhenExpired(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(15);
        }
        return this.addListener(Phase.EXPIRED, runnable);
    }

    @NotNull
    public Animation runWhenCancelled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(16);
        }
        return this.addListener(Phase.CANCELLED, runnable);
    }

    public Animation runWhenExpiredOrCancelled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(17);
        }
        return this.addListener(p -> {
            if (p == Phase.EXPIRED || p == Phase.CANCELLED) {
                runnable.run();
            }
        });
    }

    @NotNull
    private Animation addListener(@NotNull Phase phase, @NotNull Runnable runnable) {
        if (phase == null) {
            Animation.$$$reportNull$$$0(18);
        }
        if (runnable == null) {
            Animation.$$$reportNull$$$0(19);
        }
        Animation animation = this.addListener(p -> {
            if (p == phase) {
                runnable.run();
            }
        });
        if (animation == null) {
            Animation.$$$reportNull$$$0(20);
        }
        return animation;
    }

    public void fireEvent(@NotNull Phase phase) {
        if (phase == null) {
            Animation.$$$reportNull$$$0(21);
        }
        if (this.myListeners == null) {
            return;
        }
        Iterator<Listener> iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().update(phase);
            }
            catch (Throwable t) {
                iterator.remove();
                Logger.getInstance(Animation.class).error("Listener caused an error and was removed from listeners", t);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 10, 12, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/animation/Animation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "easing";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/animation/Animation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setDelay";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setDuration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEasing";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setEasing";
                break;
            }
            case 12: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEasing";
                break;
            }
            case 11: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runWhenScheduled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWhenUpdated";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runWhenExpired";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runWhenCancelled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runWhenExpiredOrCancelled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 10, 12, 20 -> new IllegalStateException(string);
        };
    }

    public static enum Phase {
        SCHEDULED,
        UPDATED,
        EXPIRED,
        CANCELLED;

    }

    @FunctionalInterface
    public static interface Listener {
        public void update(@NotNull Phase var1);
    }
}

