/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.MathUtil;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.JBAnimatorHelper;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class JBAnimator
implements Disposable {
    private int myPeriod;
    @NotNull
    private Type myType;
    private boolean myCyclic;
    private boolean myIgnorePowerSaveMode;
    @Nullable
    private String myName;
    @NotNull
    private final ScheduledExecutorService myService;
    @NotNull
    private final AtomicLong myRunning;
    @NotNull
    private final AtomicBoolean myDisposed;
    private static final Logger LOG = Logger.getInstance(JBAnimator.class);
    @Nullable
    private Statistic myStatistic;
    @NotNull
    private volatile Future<?> myCurrentAnimatorFuture;

    public JBAnimator() {
        this(Alarm.ThreadToUse.SWING_THREAD, null);
    }

    public JBAnimator(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JBAnimator.$$$reportNull$$$0(0);
        }
        this(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public JBAnimator(@NotNull Alarm.ThreadToUse threadToUse, @Nullable Disposable parentDisposable) {
        if (threadToUse == null) {
            JBAnimator.$$$reportNull$$$0(1);
        }
        this.myPeriod = 16;
        this.myType = Type.IN_TIME;
        this.myRunning = new AtomicLong();
        this.myDisposed = new AtomicBoolean();
        this.myCurrentAnimatorFuture = CompletableFuture.completedFuture(null);
        ScheduledExecutorService scheduledExecutorService = this.myService = threadToUse == Alarm.ThreadToUse.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService((String)"Animator Pool", (int)1);
        if (parentDisposable == null) {
            if (threadToUse != Alarm.ThreadToUse.SWING_THREAD) {
                Logger.getInstance(JBAnimator.class).error((Throwable)new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm"));
            }
        } else {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public long animate(Animation ... animations) {
        if (animations == null) {
            JBAnimator.$$$reportNull$$$0(2);
        }
        return this.animate(Arrays.asList(animations));
    }

    public long animate(final @NotNull @NotNull Collection<@NotNull Animation> animations) {
        if (animations == null) {
            JBAnimator.$$$reportNull$$$0(3);
        }
        if (this.myDisposed.get()) {
            LOG.warn("Animator is already disposed");
            return Long.MAX_VALUE;
        }
        int from = Integer.MAX_VALUE;
        int to = 0;
        for (Animation animation : animations) {
            from = Math.min(animation.getDelay(), from);
            to = Math.max(animation.getDelay() + animation.getDuration(), to);
        }
        final int delay = animations.isEmpty() ? 0 : from;
        final int duration = animations.isEmpty() ? 0 : to - from;
        final long taskId = this.myRunning.incrementAndGet();
        if (!this.myIgnorePowerSaveMode && PowerSaveMode.isEnabled() || Registry.is((String)"ui.no.bangs.and.whistles", (boolean)false) || RemoteDesktopService.isRemoteSession() || duration == 0) {
            this.myCurrentAnimatorFuture = this.myService.schedule(() -> {
                if (taskId < this.myRunning.get()) {
                    for (Animation animation : animations) {
                        animation.fireEvent(Animation.Phase.CANCELLED);
                    }
                    return;
                }
                for (Animation animation : animations) {
                    try {
                        animation.fireEvent(Animation.Phase.SCHEDULED);
                        animation.update(1.0);
                        animation.fireEvent(Animation.Phase.UPDATED);
                        animation.fireEvent(Animation.Phase.EXPIRED);
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                    }
                }
                this.myRunning.compareAndSet(taskId, taskId + 1L);
            }, (long)delay, TimeUnit.MILLISECONDS);
            return taskId;
        }
        final Statistic stat = new Statistic(this.myName, taskId);
        stat.start = System.nanoTime();
        if (this.myPeriod < 16) {
            JBAnimatorHelper.requestHighPrecisionTimer(this);
        }
        this.myCurrentAnimatorFuture = this.myService.schedule(new Runnable(){
            final Type type;
            final int period;
            final boolean cycle;
            @Nullable
            FrameCounter frameCounter;
            @NotNull
            LinkedHashSet<Animation> scheduledAnimations;
            private long nextScheduleTime;
            {
                this.type = JBAnimator.this.myType;
                this.period = JBAnimator.this.myPeriod;
                this.cycle = JBAnimator.this.myCyclic;
                this.scheduledAnimations = new LinkedHashSet();
                this.nextScheduleTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(delay);
            }

            private void prepareAnimations() {
                this.frameCounter = JBAnimator.create(this.type, this.period, duration);
                this.scheduledAnimations = new LinkedHashSet(animations);
                for (Animation animation : this.scheduledAnimations) {
                    animation.fireEvent(Animation.Phase.SCHEDULED);
                }
            }

            private void finalizeRunning() {
                JBAnimatorHelper.cancelHighPrecisionTimer(JBAnimator.this);
                stat.end = System.nanoTime();
                JBAnimator.this.myStatistic = stat;
            }

            @Override
            public void run() {
                boolean isProceed;
                stat.count.incrementAndGet();
                long wasLate = System.nanoTime() - this.nextScheduleTime;
                if (wasLate < 0L) {
                    LOG.warn("Negative animation late value");
                    wasLate = 0L;
                }
                if (taskId < JBAnimator.this.myRunning.get()) {
                    this.finalizeRunning();
                    for (Animation animation : this.scheduledAnimations) {
                        animation.fireEvent(Animation.Phase.CANCELLED);
                    }
                    return;
                }
                if (this.frameCounter == null) {
                    this.prepareAnimations();
                }
                long totalFrames = this.frameCounter.getTotalFrames();
                long currentFrame = Math.min(this.frameCounter.getNextFrame(this.cycle), totalFrames);
                long currentDelay = this.frameCounter.getDelay(currentFrame);
                double timeline = (double)currentFrame / (double)totalFrames;
                if (currentFrame >= totalFrames && this.cycle) {
                    this.frameCounter = null;
                }
                LinkedList<Animation> expired = new LinkedList<Animation>();
                for (Animation animation : this.scheduledAnimations) {
                    double start2 = (double)(animation.getDelay() - delay) / (double)duration;
                    double end = start2 + (double)animation.getDuration() / (double)duration;
                    if (start2 <= timeline) {
                        try {
                            double current = (timeline - start2) / (end - start2);
                            animation.update(MathUtil.clamp((double)current, (double)0.0, (double)1.0));
                            animation.fireEvent(Animation.Phase.UPDATED);
                        }
                        catch (Throwable t) {
                            LOG.error(t);
                        }
                    }
                    if (!(timeline > end)) continue;
                    expired.add(animation);
                }
                expired.forEach(this.scheduledAnimations::remove);
                boolean bl = isProceed = currentFrame < totalFrames || this.cycle;
                if (isProceed) {
                    long nextDelay = Math.max(TimeUnit.MILLISECONDS.toNanos(currentDelay) - wasLate, TimeUnit.MILLISECONDS.toNanos(1L));
                    this.nextScheduleTime = System.nanoTime() + nextDelay;
                    JBAnimator.this.myCurrentAnimatorFuture = JBAnimator.this.myService.schedule(this, nextDelay, TimeUnit.NANOSECONDS);
                } else {
                    JBAnimator.this.myRunning.compareAndSet(taskId, taskId + 1L);
                    this.finalizeRunning();
                }
                for (Animation animation : isProceed ? expired : this.scheduledAnimations) {
                    animation.fireEvent(Animation.Phase.EXPIRED);
                }
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
        return taskId;
    }

    public boolean isRunning(long taskId) {
        return this.myRunning.get() == taskId;
    }

    public void stop() {
        this.myRunning.incrementAndGet();
    }

    public int getPeriod() {
        return this.myPeriod;
    }

    @NotNull
    public JBAnimator setPeriod(int period) {
        this.myPeriod = Math.max(period, 1);
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(4);
        }
        return jBAnimator;
    }

    public boolean isCyclic() {
        return this.myCyclic;
    }

    @NotNull
    public JBAnimator setCyclic(boolean cyclic) {
        this.myCyclic = cyclic;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(5);
        }
        return jBAnimator;
    }

    @NotNull
    public JBAnimator ignorePowerSaveMode() {
        this.myIgnorePowerSaveMode = true;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(6);
        }
        return jBAnimator;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            JBAnimator.$$$reportNull$$$0(7);
        }
        return type;
    }

    @NotNull
    public JBAnimator setType(Type type) {
        this.myType = type;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(8);
        }
        return jBAnimator;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public JBAnimator setName(@Nullable String name) {
        this.myName = name;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(9);
        }
        return jBAnimator;
    }

    @ApiStatus.Internal
    @Nullable
    public Statistic getStatistic() {
        return this.myStatistic;
    }

    public void dispose() {
        this.stop();
        this.myCurrentAnimatorFuture.cancel(false);
        if (!this.myDisposed.getAndSet(true) && this.myService != EdtExecutorService.getScheduledExecutorInstance()) {
            this.myService.shutdownNow();
            JBAnimatorHelper.cancelHighPrecisionTimer(this);
        }
    }

    private static FrameCounter create(@NotNull Type type, final int period, final int duration) {
        if (type == null) {
            JBAnimator.$$$reportNull$$$0(10);
        }
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new FrameCounter(){
                final long frames;
                long frame;
                {
                    this.frames = duration / period + (duration % period == 0 ? 0 : 1);
                }

                @Override
                public long getNextFrame(boolean isCyclic) {
                    long f = this.frame++;
                    if (isCyclic) {
                        this.frame %= this.frames;
                    }
                    return f;
                }

                @Override
                public long getTotalFrames() {
                    return Math.max(this.frames, 1L);
                }

                @Override
                public long getDelay(long currentFrame) {
                    return period;
                }
            };
            case 1 -> new FrameCounter(){
                final long startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());

                @Override
                public long getNextFrame(boolean isCyclic) {
                    return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.startTime;
                }

                @Override
                public long getTotalFrames() {
                    return duration;
                }

                @Override
                public long getDelay(long currentFrame) {
                    return Math.min((long)duration - currentFrame, (long)period);
                }
            };
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/animation/JBAnimator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/animation/JBAnimator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setPeriod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setCyclic";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ignorePowerSaveMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "animate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        EACH_FRAME,
        IN_TIME;

    }

    @ApiStatus.Internal
    public static class Statistic {
        @Nullable
        private final String myName;
        private final AtomicLong count = new AtomicLong(0L);
        private long start;
        private long end;
        private final long taskId;

        public Statistic(@Nullable String name, long id) {
            this.myName = name;
            this.taskId = id;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getCount() {
            return this.count.get();
        }

        public long getDuration() {
            return TimeUnit.NANOSECONDS.toMillis(this.end - this.start);
        }

        public String toString() {
            return "Statistic{name=" + this.myName + ", taskId=" + this.taskId + ", duration=" + this.getDuration() + "ms, count=" + String.valueOf(this.count) + ", updates=" + this.count.get() * 1000L / this.getDuration() + "}";
        }
    }

    private static interface FrameCounter {
        public long getNextFrame(boolean var1);

        public long getTotalFrames();

        public long getDelay(long var1);
    }
}

