/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.util.SystemInfoRt;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class SystemProxySettings {
    public abstract void openProxySettings() throws IOException;

    public abstract boolean isProxySettingsOpenSupported();

    @NotNull
    public static SystemProxySettings getInstance() {
        SystemProxySettings systemProxySettings = Holder.instance;
        if (systemProxySettings == null) {
            SystemProxySettings.$$$reportNull$$$0(0);
        }
        return systemProxySettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/SystemProxySettings", "getInstance"));
    }

    private static class Holder {
        @NotNull
        private static final SystemProxySettings instance = SystemInfoRt.isMac ? new MacOSSettings() : (SystemInfoRt.isWindows ? new WindowsSettings() : new UnsupportedOSSettings());

        private Holder() {
        }
    }

    private static class UnsupportedOSSettings
    extends SystemProxySettings {
        private UnsupportedOSSettings() {
        }

        @Override
        public void openProxySettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isProxySettingsOpenSupported() {
            return false;
        }
    }

    private static class WindowsSettings
    extends SystemProxySettings {
        private WindowsSettings() {
        }

        @Override
        public void openProxySettings() throws IOException {
            Desktop.getDesktop().browse(URI.create("ms-settings:network-proxy"));
        }

        @Override
        public boolean isProxySettingsOpenSupported() {
            return SystemInfoRt.isWindows && Desktop.isDesktopSupported();
        }
    }

    private static class MacOSSettings
    extends SystemProxySettings {
        private MacOSSettings() {
        }

        @Override
        public void openProxySettings() throws IOException {
            Desktop.getDesktop().browse(URI.create("x-apple.systempreferences:com.apple.Network-Settings.extension?Proxies"));
        }

        @Override
        public boolean isProxySettingsOpenSupported() {
            return SystemInfoRt.isMac && Desktop.isDesktopSupported();
        }
    }
}

