/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.Animator;
import java.awt.GraphicsEnvironment;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\n\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\n"}, d2={"skipAnimation", "", "animatorCoroutineScopeWithError", "Lkotlinx/coroutines/CoroutineScope;", "name", "", "animatorCoroutineScope", "disposable", "Lcom/intellij/openapi/Disposable;", "getCallerClassName", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animator.kt\ncom/intellij/util/ui/AnimatorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,250:1\n13#2:251\n*S KotlinDebug\n*F\n+ 1 Animator.kt\ncom/intellij/util/ui/AnimatorKt\n*L\n212#1:251\n*E\n"})
public final class AnimatorKt {
    private static final boolean skipAnimation() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private static final CoroutineScope animatorCoroutineScopeWithError(String name) {
        String string = name;
        if (string == null) {
            string = AnimatorKt.getCallerClassName();
        }
        String realName = string;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Animator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Do not use repeatable animators without an explicit lifetime scope. An explicit Disposable would at least let us log memory leaks and runaway tasks.");
        CoroutineContext coroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault());
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)).plus(ClientId.Companion.coroutineContext()).plus((CoroutineContext)new CoroutineName("Dangerously utilized ui.Animator by " + realName)));
    }

    @NotNull
    public static final CoroutineScope animatorCoroutineScope(@Nullable String name, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (disposable instanceof Application) {
            throw new IllegalArgumentException("Please use a real disposable");
        }
        CoroutineScope scope = AnimatorKt.animatorCoroutineScope(name);
        Disposer.register((Disposable)disposable, () -> AnimatorKt.animatorCoroutineScope$lambda$0(scope));
        return scope;
    }

    @NotNull
    public static final CoroutineScope animatorCoroutineScope(@Nullable String name) {
        String string = name;
        if (string == null) {
            string = AnimatorKt.getCallerClassName();
        }
        String realName = string;
        CoroutineContext coroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault());
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)).plus(ClientId.Companion.coroutineContext()).plus((CoroutineContext)new CoroutineName("ui.Animator by " + realName)));
        return scope;
    }

    private static final String getCallerClassName() {
        for (int i = 5; i < 11; ++i) {
            Class callerClazz = ReflectionUtil.getCallerClass((int)i);
            if (Intrinsics.areEqual((Object)callerClazz, Animator.class)) continue;
            return callerClazz.getName();
        }
        return "Unknown Caller";
    }

    private static final void animatorCoroutineScope$lambda$0(CoroutineScope $scope) {
        CoroutineScopeKt.cancel$default((CoroutineScope)$scope, null, (int)1, null);
    }

    public static final /* synthetic */ CoroutineScope access$animatorCoroutineScopeWithError(String name) {
        return AnimatorKt.animatorCoroutineScopeWithError(name);
    }

    public static final /* synthetic */ boolean access$skipAnimation() {
        return AnimatorKt.skipAnimation();
    }
}

