/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public abstract class ComboBoxCellEditor
extends DefaultCellEditor {
    public ComboBoxCellEditor() {
        super(new ComboBox());
        this.setClickCountToStart(2);
    }

    protected abstract List<String> getComboBoxItems();

    protected boolean isComboboxEditable() {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.removeActionListener(this.delegate);
        boolean result2 = super.stopCellEditing();
        comboBox.addActionListener(this.delegate);
        return result2;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        String currentValue = (String)value2;
        JComboBox component = (JComboBox)super.getTableCellEditorComponent(table, value2, isSelected, row, column);
        component.removeActionListener(this.delegate);
        component.setBorder(null);
        component.removeAllItems();
        List<String> items = this.getComboBoxItems();
        int selected2 = -1;
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i);
            component.addItem(item);
            if (!Objects.equals(item, currentValue)) continue;
            selected2 = i;
        }
        if (selected2 == -1) {
            component.setEditable(true);
            component.setSelectedItem(currentValue);
            component.setEditable(false);
        } else {
            component.setSelectedIndex(selected2);
        }
        component.setEditable(this.isComboboxEditable());
        component.addActionListener(this.delegate);
        return component;
    }
}

