/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentStatisticsService;
import com.intellij.execution.ui.SettingsEditorFragmentType;
import com.intellij.execution.ui.TagButton;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsEditorFragment<Settings, C extends JComponent>
extends SettingsEditor<Settings> {
    private final String myId;
    @Nls
    private final String myName;
    @Nls
    private final String myGroup;
    protected C myComponent;
    private final BiConsumer<? super Settings, ? super C> onResetEditorFromSettings;
    private final BiConsumer<? super Settings, ? super C> onApplyEditorToSettings;
    private final List<Function<? super Settings, List<ValidationInfo>>> myValidation;
    @NotNull
    private final SettingsEditorFragmentType myType;
    private final int myPriority;
    private final Predicate<? super Settings> myInitialSelection;
    @Nullable
    @Nls
    private String myHint;
    @Nullable
    private JComponent myHintComponent;
    @Nullable
    @Nls
    private String myActionHint;
    @Nullable
    @Nls
    private String myActionDescription;
    @Nullable
    private String myConfigId;
    @Nullable
    private Function<? super C, ? extends JComponent> myEditorGetter;
    private boolean myRemovable;
    private boolean myCanBeHidden;
    private boolean isSelected;

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, int priority, @NotNull SettingsEditorFragmentType type, BiConsumer<? super Settings, ? super C> resetEditorFromSettings, BiConsumer<? super Settings, ? super C> applyEditorToSettings, Predicate<? super Settings> initialSelection) {
        if (type == null) {
            SettingsEditorFragment.$$$reportNull$$$0(0);
        }
        this.myValidation = new ArrayList<Function<? super Settings, List<ValidationInfo>>>();
        this.myRemovable = true;
        this.myCanBeHidden = false;
        this.myId = id;
        this.myName = name;
        this.myGroup = group;
        this.myComponent = component;
        this.onResetEditorFromSettings = resetEditorFromSettings;
        this.onApplyEditorToSettings = applyEditorToSettings;
        this.myPriority = priority;
        this.myType = type;
        this.myInitialSelection = initialSelection;
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, @NotNull SettingsEditorFragmentType type, BiConsumer<? super Settings, ? super C> resetEditorFromSettings, BiConsumer<? super Settings, ? super C> applyEditorToSettings, Predicate<? super Settings> initialSelection) {
        if (type == null) {
            SettingsEditorFragment.$$$reportNull$$$0(1);
        }
        this(id, name, group, (C)component, 0, type, resetEditorFromSettings, applyEditorToSettings, initialSelection);
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, int commandLinePosition, BiConsumer<? super Settings, ? super C> resetEditorFromSettings, BiConsumer<? super Settings, ? super C> applyEditorToSettings, Predicate<? super Settings> initialSelection) {
        this(id, name, group, (C)component, commandLinePosition, SettingsEditorFragment.getType(component, commandLinePosition), resetEditorFromSettings, applyEditorToSettings, initialSelection);
    }

    @NotNull
    private static SettingsEditorFragmentType getType(JComponent component, int commandLinePosition) {
        SettingsEditorFragmentType settingsEditorFragmentType = component instanceof TagButton ? SettingsEditorFragmentType.TAG : (commandLinePosition == -2 ? SettingsEditorFragmentType.BEFORE_RUN : (commandLinePosition == -1 ? SettingsEditorFragmentType.HEADER : (commandLinePosition == 0 ? SettingsEditorFragmentType.EDITOR : SettingsEditorFragmentType.COMMAND_LINE)));
        if (settingsEditorFragmentType == null) {
            SettingsEditorFragment.$$$reportNull$$$0(2);
        }
        return settingsEditorFragmentType;
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, BiConsumer<? super Settings, ? super C> resetEditorFromSettings, BiConsumer<? super Settings, ? super C> applyEditorToSettings, Predicate<? super Settings> initialSelection) {
        this(id, name, group, (C)component, 0, SettingsEditorFragmentType.EDITOR, resetEditorFromSettings, applyEditorToSettings, initialSelection);
    }

    public static <S> SettingsEditorFragment<S, ?> createWrapper(String id, @Nls String name, @Nls String group, @NotNull SettingsEditor<S> inner, Predicate<? super S> initialSelection) {
        if (inner == null) {
            SettingsEditorFragment.$$$reportNull$$$0(3);
        }
        JComponent component = inner.getComponent();
        SettingsEditorFragment<? super S, JComponent> fragment = new SettingsEditorFragment<S, JComponent>(id, name, group, component, (settings, c) -> inner.resetFrom(settings), (settings, c) -> {
            try {
                inner.applyTo(settings);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }, initialSelection);
        Disposer.register(fragment, inner);
        return fragment;
    }

    public static <Settings> SettingsEditorFragment<Settings, TagButton> createTag(String id, @Nls String name, @Nls String group, Predicate<? super Settings> getter, BiConsumer<? super Settings, ? super Boolean> setter) {
        Ref ref = new Ref();
        TagButton tagButton = new TagButton(name, e -> {
            ((SettingsEditorFragment)((Object)((Object)ref.get()))).setSelected(false);
            ((SettingsEditorFragment)((Object)((Object)ref.get()))).logChange(false, (AnActionEvent)e);
        });
        SettingsEditorFragment<? super Settings, TagButton> fragment = new SettingsEditorFragment<Settings, TagButton>(id, name, group, tagButton, SettingsEditorFragmentType.TAG, (settings, button2) -> button2.setVisible(getter.test((Object)settings)), (settings, button2) -> setter.accept((Object)settings, (Boolean)button2.isVisible()), getter);
        Disposer.register(fragment, (Disposable)tagButton);
        ref.set(fragment);
        return fragment;
    }

    public String getId() {
        return this.myId;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    @Nls
    public String getGroup() {
        return this.myGroup;
    }

    public C component() {
        return this.myComponent;
    }

    public JComponent[] getAllComponents() {
        return new JComponent[]{this.component()};
    }

    public boolean isTag() {
        return SettingsEditorFragmentType.TAG == this.myType;
    }

    public boolean isCommandLine() {
        return SettingsEditorFragmentType.COMMAND_LINE == this.myType;
    }

    public boolean isHeader() {
        return SettingsEditorFragmentType.HEADER == this.myType;
    }

    public boolean isBeforeRun() {
        return SettingsEditorFragmentType.BEFORE_RUN == this.myType;
    }

    public boolean isEditor() {
        return SettingsEditorFragmentType.EDITOR == this.myType;
    }

    public int getPriority() {
        return this.myPriority;
    }

    @Nullable
    public ActionGroup getCustomActionGroup() {
        return null;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isInitiallyVisible(Settings settings) {
        return this.myInitialSelection.test(settings);
    }

    public boolean isRemovable() {
        return this.myRemovable;
    }

    public void setRemovable(boolean removable) {
        this.myRemovable = removable;
    }

    public void setValidation(@Nullable Function<? super Settings, List<ValidationInfo>> validation) {
        this.myValidation.clear();
        if (validation != null) {
            this.myValidation.add(validation);
        }
    }

    @NotNull
    private SettingsEditorFragment<Settings, C> addValidation(@NotNull Function<? super Settings, ValidationInfo> validation) {
        if (validation == null) {
            SettingsEditorFragment.$$$reportNull$$$0(4);
        }
        this.myValidation.add(it -> Collections.singletonList((ValidationInfo)validation.apply((Object)it)));
        SettingsEditorFragment settingsEditorFragment = this;
        if (settingsEditorFragment == null) {
            SettingsEditorFragment.$$$reportNull$$$0(5);
        }
        return settingsEditorFragment;
    }

    @NotNull
    public SettingsEditorFragment<Settings, C> addValidation(@NotNull ThrowableConsumer<? super Settings, ? extends ConfigurationException> validation) {
        if (validation == null) {
            SettingsEditorFragment.$$$reportNull$$$0(6);
        }
        return this.addValidation((? super Settings settings) -> {
            try {
                validation.consume(settings);
                return new ValidationInfo("", this.getEditorComponent());
            }
            catch (ConfigurationException exception) {
                return new ValidationInfo(exception.getMessageHtml(), this.getEditorComponent());
            }
        });
    }

    protected void validate(Settings s) {
        if (this.myValidation.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List infos = ContainerUtil.flatMap(this.myValidation, it -> (List)ReadAction.nonBlocking(() -> (List)it.apply(s)).executeSynchronously());
            if (infos.isEmpty()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (Disposer.isDisposed((Disposable)this)) {
                    return;
                }
                for (ValidationInfo info : infos) {
                    ComponentValidator validator;
                    JComponent component = info.component;
                    if (component == null) continue;
                    Optional<ComponentValidator> optional = ComponentValidator.getInstance(component);
                    if (optional.isEmpty()) {
                        validator = new ComponentValidator((Disposable)this);
                        validator.installOn(component);
                    } else {
                        validator = optional.get();
                    }
                    validator.updateInfo(info.message.isEmpty() ? null : info);
                }
            });
        });
    }

    public boolean isCanBeHidden() {
        return this.myCanBeHidden;
    }

    public void setCanBeHidden(boolean canBeHidden) {
        this.myCanBeHidden = canBeHidden;
    }

    public void setSelected(boolean selected2) {
        this.isSelected = selected2;
        ((JComponent)this.myComponent).setVisible(selected2);
        if (this.myHintComponent != null) {
            this.myHintComponent.setVisible(selected2);
        }
        this.fireEditorStateChanged();
    }

    @ApiStatus.Internal
    @ApiStatus.OverrideOnly
    public boolean isAvailable() {
        return true;
    }

    public void toggle(boolean selected2, @Nullable AnActionEvent e) {
        boolean changed = this.isSelected() != selected2;
        this.setSelected(selected2);
        if (selected2) {
            JScrollPane scrollpane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, this.myComponent);
            if (scrollpane != null) {
                scrollpane.validate();
            }
            ((JComponent)this.myComponent).scrollRectToVisible(new Rectangle(new Point(0, 50), ((JComponent)this.myComponent).getPreferredSize()));
        }
        if (changed) {
            this.logChange(selected2, e);
        }
    }

    protected void logChange(boolean selected2, @Nullable AnActionEvent e) {
        if (selected2) {
            FragmentStatisticsService.getInstance().logOptionModified(this.getProject(), this.getId(), this.myConfigId, e);
        } else {
            FragmentStatisticsService.getInstance().logOptionRemoved(this.getProject(), this.getId(), this.myConfigId, e);
        }
    }

    private Project getProject() {
        return (Project)DataManager.getInstance().getDataContext(this.myComponent).getData(PlatformCoreDataKeys.PROJECT_CONTEXT);
    }

    public void setEditorGetter(@Nullable Function<? super C, ? extends JComponent> editorGetter) {
        this.myEditorGetter = editorGetter;
    }

    public JComponent getEditorComponent() {
        C component = this.component();
        if (this.myEditorGetter != null) {
            return this.myEditorGetter.apply(component);
        }
        return SettingsEditorFragment.getEditorComponent(component);
    }

    private static JComponent getEditorComponent(JComponent component) {
        if (component instanceof LabeledComponent) {
            component = ((LabeledComponent)component).getComponent();
        }
        if (component instanceof TagButton) {
            return ((TagButton)component).myButton;
        }
        if (component instanceof ComponentWithBrowseButton) {
            return ((ComponentWithBrowseButton)component).getChildComponent();
        }
        if (component instanceof RawCommandLineEditor) {
            return ((RawCommandLineEditor)component).getEditorField();
        }
        return component;
    }

    public int getMenuPosition() {
        return 0;
    }

    protected void resetEditorFrom(@NotNull Settings s) {
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(7);
        }
        this.onResetEditorFromSettings.accept(s, this.myComponent);
    }

    protected void applyEditorTo(@NotNull Settings s) {
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(8);
        }
        this.onApplyEditorToSettings.accept(s, this.myComponent);
    }

    @ApiStatus.Internal
    public static <S> void applyEditorTo(@NotNull SettingsEditorFragment<S, ?> fragment, @NotNull S s) {
        if (fragment == null) {
            SettingsEditorFragment.$$$reportNull$$$0(9);
        }
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(10);
        }
        fragment.applyEditorTo(s);
    }

    @NotNull
    protected JComponent createEditor() {
        ((JComponent)this.myComponent).setVisible(this.isSelected() && this.isAvailable());
        C c = this.myComponent;
        if (c == null) {
            SettingsEditorFragment.$$$reportNull$$$0(11);
        }
        return c;
    }

    public List<SettingsEditorFragment<Settings, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    @Nls
    public String getChildrenGroupName() {
        return null;
    }

    @Nullable
    @NlsActions.ActionDescription
    public String getActionHint() {
        return this.myActionHint;
    }

    public void setActionDescription(@Nullable @Nls String actionDescription) {
        this.myActionDescription = actionDescription;
    }

    @Nullable
    @Nls
    public String getActionDescription() {
        return this.myActionDescription;
    }

    public void setActionHint(@Nullable @Nls String hint) {
        this.myActionHint = hint == null ? null : StringUtil.removeHtmlTags((String)hint, (boolean)true);
    }

    @Nullable
    public String getHint(@Nullable JComponent component) {
        return this.myHint;
    }

    public void setHint(@Nullable @Nls String hint) {
        this.myHint = hint;
    }

    public void setConfigId(@Nullable String configId) {
        this.myConfigId = configId;
    }

    @Nullable
    public JComponent getHintComponent() {
        if (this.myHintComponent == null && this.myHint != null) {
            JLabel comment = ComponentPanelBuilder.createNonWrappingCommentComponent(this.myHint);
            comment.setFocusable(false);
            this.myHintComponent = LabeledComponent.create(comment, "", "West");
        }
        return this.myHintComponent;
    }

    public String toString() {
        return this.myId + " " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/SettingsEditorFragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validation";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/SettingsEditorFragment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addValidation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWrapper";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addValidation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 11 -> new IllegalStateException(string);
        };
    }
}

