/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import java.util.Locale;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public final class Prefs {
    public static void put(String key, String value2) {
        Prefs.getPreferences(key).put(Prefs.getNodeKey(key), value2);
    }

    public static String get(String key, String def) {
        return Prefs.getPreferences(key).get(Prefs.getNodeKey(key), def);
    }

    public static void putInt(String key, int value2) {
        Prefs.getPreferences(key).putInt(Prefs.getNodeKey(key), value2);
    }

    public static int getInt(String key, int def) {
        return Prefs.getPreferences(key).getInt(Prefs.getNodeKey(key), def);
    }

    public static void putLong(String key, long value2) {
        Prefs.getPreferences(key).putLong(Prefs.getNodeKey(key), value2);
    }

    public static long getLong(String key, long def) {
        return Prefs.getPreferences(key).getLong(Prefs.getNodeKey(key), def);
    }

    public static void putBoolean(String key, boolean value2) {
        Prefs.getPreferences(key).putBoolean(Prefs.getNodeKey(key), value2);
    }

    public static boolean getBoolean(String key, boolean def) {
        return Prefs.getPreferences(key).getBoolean(Prefs.getNodeKey(key), def);
    }

    public static void putFloat(String key, float value2) {
        Prefs.getPreferences(key).putFloat(Prefs.getNodeKey(key), value2);
    }

    public static float getFloat(String key, float def) {
        return Prefs.getPreferences(key).getFloat(Prefs.getNodeKey(key), def);
    }

    public static void putDouble(String key, double value2) {
        Prefs.getPreferences(key).putDouble(Prefs.getNodeKey(key), value2);
    }

    public static double getDouble(String key, double def) {
        return Prefs.getPreferences(key).getDouble(Prefs.getNodeKey(key), def);
    }

    public static void putByteArray(String key, byte[] value2) {
        Prefs.getPreferences(key).putByteArray(Prefs.getNodeKey(key), value2);
    }

    public static byte[] getByteArray(String key, byte[] def) {
        return Prefs.getPreferences(key).getByteArray(Prefs.getNodeKey(key), def);
    }

    public static void remove(String key) {
        Prefs.getPreferences(key).remove(Prefs.getNodeKey(key));
    }

    public static void flush(String key) throws BackingStoreException {
        Prefs.getPreferences(key).flush();
    }

    private static String getNodeKey(String key) {
        int dotIndex = key.lastIndexOf(46);
        return (dotIndex >= 0 ? key.substring(dotIndex + 1) : key).toLowerCase(Locale.ENGLISH);
    }

    private static Preferences getPreferences(String key) {
        Preferences prefs = Preferences.userRoot();
        int dotIndex = key.lastIndexOf(46);
        if (dotIndex > 0) {
            StringTokenizer tokenizer = new StringTokenizer(key.substring(0, dotIndex), ".", false);
            while (tokenizer.hasMoreElements()) {
                String str = tokenizer.nextToken();
                prefs = prefs.node(str == null ? null : str.toLowerCase(Locale.ENGLISH));
            }
        }
        return prefs;
    }
}

