/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtilKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u0001H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0007J\u0012\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007J\u0014\u0010\u0013\u001a\u00020\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0007J\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u0017R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/inspector/UiInspectorUtil;", "", "<init>", "()V", "ADDED_AT_STACKTRACE", "Lcom/intellij/openapi/util/Key;", "", "registerProvider", "", "component", "Ljavax/swing/JComponent;", "provider", "Lcom/intellij/internal/inspector/UiInspectorContextProvider;", "getProvider", "getComponentName", "", "Ljava/awt/Component;", "getClassName", "value", "getClassPresentation", "clazz0", "Ljava/lang/Class;", "shouldSaveStacktraces", "", "enableStacktraceSaving", "initStacktraceSaving", "isSaveStacktraces", "intellij.platform.ide"})
@ApiStatus.Internal
public final class UiInspectorUtil {
    @NotNull
    public static final UiInspectorUtil INSTANCE = new UiInspectorUtil();
    @JvmField
    @NotNull
    public static final Key<Throwable> ADDED_AT_STACKTRACE;
    private static boolean shouldSaveStacktraces;

    private UiInspectorUtil() {
    }

    @JvmStatic
    public static final void registerProvider(@NotNull JComponent component, @NotNull UiInspectorContextProvider provider) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ClientProperty.put((JComponent)component, (Key)UiInspectorUtilKt.access$getPROPERTY_KEY$p(), (Object)provider);
    }

    @JvmStatic
    @Nullable
    public static final UiInspectorContextProvider getProvider(@NotNull Object component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object = component;
        return object instanceof UiInspectorContextProvider ? (UiInspectorContextProvider)component : (object instanceof JComponent ? (UiInspectorContextProvider)ClientProperty.get((Component)((Component)component), (Key)UiInspectorUtilKt.access$getPROPERTY_KEY$p()) : null);
    }

    @JvmStatic
    @NotNull
    public static final String getComponentName(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object name = UiInspectorUtil.getClassName(component);
        String componentName = component.getName();
        if (StringUtil.isNotEmpty((String)componentName)) {
            name = (String)name + " \"" + componentName + "\"";
        }
        return name;
    }

    @JvmStatic
    @NotNull
    public static final String getClassName(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Class<?> clazz0 = value2.getClass();
        Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getClassPresentation(@Nullable Object value2) {
        if (value2 == null) {
            return "[null]";
        }
        return UiInspectorUtil.getClassPresentation(value2.getClass());
    }

    @JvmStatic
    @NotNull
    public static final String getClassPresentation(@NotNull Class<?> clazz0) {
        Intrinsics.checkNotNullParameter(clazz0, (String)"clazz0");
        Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        String simpleName = clazz.getSimpleName();
        return simpleName + " (" + clazz.getPackageName() + ")";
    }

    public final void enableStacktraceSaving() {
        shouldSaveStacktraces = true;
    }

    public final void initStacktraceSaving() {
        shouldSaveStacktraces = true;
    }

    public final boolean isSaveStacktraces() {
        return shouldSaveStacktraces || Registry.Companion.is("ui.inspector.save.stacktraces", false);
    }

    static {
        Key key = Key.create((String)"uiInspector.addedAt");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ADDED_AT_STACKTRACE = key;
    }
}

