/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class SettingsEditorWrapper<Src, Dst>
extends SettingsEditor<Src> {
    private final Function<? super Src, ? extends Dst> mySrcToDstConvertor;
    private final SettingsEditor<Dst> myWrapped;
    private final SettingsEditorListener<Dst> myListener;

    public SettingsEditorWrapper(SettingsEditor<Dst> wrapped, Function<? super Src, ? extends Dst> convertor) {
        this.mySrcToDstConvertor = convertor;
        this.myWrapped = wrapped;
        this.myListener = settingsEditor -> this.fireEditorStateChanged();
        this.myWrapped.addSettingsEditorListener(this.myListener);
    }

    public void resetEditorFrom(@NotNull Src src) {
        if (src == null) {
            SettingsEditorWrapper.$$$reportNull$$$0(0);
        }
        this.myWrapped.resetFrom(this.mySrcToDstConvertor.apply(src));
    }

    public void applyEditorTo(@NotNull Src src) throws ConfigurationException {
        if (src == null) {
            SettingsEditorWrapper.$$$reportNull$$$0(1);
        }
        this.myWrapped.applyTo(this.mySrcToDstConvertor.apply(src));
    }

    @NotNull
    public JComponent createEditor() {
        JComponent jComponent = SettingsEditorWrapper.createEditorComponent(this.myWrapped);
        if (jComponent == null) {
            SettingsEditorWrapper.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void disposeEditor() {
        this.myWrapped.removeSettingsEditorListener(this.myListener);
        Disposer.dispose(this.myWrapped);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/SettingsEditorWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/SettingsEditorWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

