/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\"\u001a\u00020\f2\b\b\u0001\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\fH\u0002J\"\u0010%\u001a\u00020&2\b\b\u0001\u0010#\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0002J\u0006\u00103\u001a\u00020&J\b\u00104\u001a\u00020&H\u0002J\b\u00105\u001a\u00020&H\u0016J6\u00106\u001a\u00020&2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u0003082\u0006\u00109\u001a\u0002022\b\b\u0002\u0010:\u001a\u00020\u00112\f\u0010;\u001a\b\u0012\u0004\u0012\u00020&08H\u0002J\b\u0010<\u001a\u00020&H\u0016J\u0016\u0010=\u001a\u00020&2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020&08H\u0002J\b\u0010>\u001a\u00020&H\u0002J\b\u0010?\u001a\u00020&H\u0002J\b\u0010@\u001a\u00020\u0006H\u0003J\b\u0010A\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001c\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010'\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u000e\u0010,\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/openapi/ui/PersistentThreeComponentSplitter;", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "vertical", "", "onePixelDivider", "proportionKey", "", "disposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "defaultFirstProportion", "", "defaultLastProportion", "<init>", "(ZZLjava/lang/String;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;FF)V", "maxRetryCount", "", "firstProportionKey", "lastProportionKey", "value", "firstProportion", "getFirstProportion", "()F", "setFirstProportion", "(F)V", "lastProportion", "getLastProportion", "setLastProportion", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "getPropertiesComponent", "()Lcom/intellij/ide/util/PropertiesComponent;", "getProportion", "key", "defaultProportion", "setProportion", "", "totalSize", "getTotalSize", "()I", "totalMinSize", "getTotalMinSize", "addNotifyCalled", "layoutIsRunning", "shouldLayout", "getShouldLayout", "()Z", "addNotifyTimestamp", "", "saveProportions", "restoreProportions", "addNotify", "invokeLaterWhen", "condition", "Lkotlin/Function0;", "timestamp", "count", "action", "doLayout", "doLayoutUnderGuard", "setFirstSize", "setLastSize", "dump", "checkSize", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nPersistentThreeComponentSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentThreeComponentSplitter.kt\ncom/intellij/openapi/ui/PersistentThreeComponentSplitter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n13#2:140\n*S KotlinDebug\n*F\n+ 1 PersistentThreeComponentSplitter.kt\ncom/intellij/openapi/ui/PersistentThreeComponentSplitter\n*L\n92#1:140\n*E\n"})
public final class PersistentThreeComponentSplitter
extends ThreeComponentsSplitter {
    @NotNull
    private final Disposable disposable;
    @Nullable
    private final Project project;
    private final float defaultFirstProportion;
    private final float defaultLastProportion;
    private int maxRetryCount;
    @NonNls
    @NotNull
    private final String firstProportionKey;
    @NonNls
    @NotNull
    private final String lastProportionKey;
    private boolean addNotifyCalled;
    private boolean layoutIsRunning;
    private long addNotifyTimestamp;

    public PersistentThreeComponentSplitter(boolean vertical, boolean onePixelDivider, @NotNull String proportionKey, @NotNull Disposable disposable, @Nullable Project project, float defaultFirstProportion, float defaultLastProportion) {
        Intrinsics.checkNotNullParameter((Object)proportionKey, (String)"proportionKey");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(vertical, onePixelDivider);
        this.disposable = disposable;
        this.project = project;
        this.defaultFirstProportion = defaultFirstProportion;
        this.defaultLastProportion = defaultLastProportion;
        this.maxRetryCount = 100;
        this.firstProportionKey = proportionKey + "_PTCS_FirstProportionKey";
        this.lastProportionKey = proportionKey + "_PTCS_LastProportionKey";
        Disposer.register((Disposable)this.disposable, () -> PersistentThreeComponentSplitter._init_$lambda$0(this));
    }

    public /* synthetic */ PersistentThreeComponentSplitter(boolean bl, boolean bl2, String string, Disposable disposable, Project project, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            f = 0.3f;
        }
        if ((n & 0x40) != 0) {
            f2 = 0.5f;
        }
        this(bl, bl2, string, disposable, project, f, f2);
    }

    private final float getFirstProportion() {
        return this.getProportion(this.firstProportionKey, this.defaultFirstProportion);
    }

    private final void setFirstProportion(float value2) {
        this.setProportion(this.firstProportionKey, value2, this.defaultFirstProportion);
    }

    private final float getLastProportion() {
        return this.getProportion(this.lastProportionKey, this.defaultLastProportion);
    }

    private final void setLastProportion(float value2) {
        this.setProportion(this.lastProportionKey, value2, this.defaultLastProportion);
    }

    private final PropertiesComponent getPropertiesComponent() {
        return this.project != null ? PropertiesComponent.getInstance((Project)this.project) : PropertiesComponent.getInstance();
    }

    private final float getProportion(@NonNls String key, float defaultProportion) {
        return this.getPropertiesComponent().getFloat(key, defaultProportion);
    }

    private final void setProportion(@NonNls String key, float value2, float defaultProportion) {
        if (value2 < 0.0f || value2 > 1.0f) {
            return;
        }
        this.getPropertiesComponent().setValue(key, value2, defaultProportion);
    }

    private final int getTotalSize() {
        return this.getOrientation() ? this.getHeight() : this.getWidth();
    }

    private final int getTotalMinSize() {
        return this.getOrientation() ? this.getMinimumSize().height : this.getMinimumSize().width;
    }

    private final boolean getShouldLayout() {
        return this.addNotifyCalled && !this.layoutIsRunning;
    }

    public final void saveProportions() {
        if (!this.checkSize()) {
            return;
        }
        this.setFirstProportion((float)this.getFirstSize() / ((float)this.getTotalSize() - 2.0f * (float)this.getDividerWidth()));
        this.setLastProportion((float)this.getLastSize() / ((float)this.getTotalSize() - 2.0f * (float)this.getDividerWidth()));
    }

    private final void restoreProportions() {
        this.setFirstSize();
        this.setLastSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        ++this.addNotifyTimestamp;
        PersistentThreeComponentSplitter.invokeLaterWhen$default(this, () -> PersistentThreeComponentSplitter.addNotify$lambda$0(this), this.addNotifyTimestamp, 0, () -> PersistentThreeComponentSplitter.addNotify$lambda$1(this), 4, null);
    }

    private final void invokeLaterWhen(Function0<Boolean> condition, long timestamp, int count, Function0<Unit> action) {
        if (this.addNotifyTimestamp != timestamp) {
            return;
        }
        SwingUtilities.invokeLater(() -> PersistentThreeComponentSplitter.invokeLaterWhen$lambda$0(this, condition, action, count, timestamp));
    }

    static /* synthetic */ void invokeLaterWhen$default(PersistentThreeComponentSplitter persistentThreeComponentSplitter, Function0 function0, long l, int n, Function0 function02, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        persistentThreeComponentSplitter.invokeLaterWhen((Function0<Boolean>)function0, l, n, (Function0<Unit>)function02);
    }

    @Override
    public void doLayout() {
        if (this.getShouldLayout()) {
            this.doLayoutUnderGuard((Function0<Unit>)((Function0)() -> PersistentThreeComponentSplitter.doLayout$lambda$0(this)));
        }
        super.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doLayoutUnderGuard(Function0<Unit> action) {
        this.layoutIsRunning = true;
        try {
            action.invoke();
        }
        finally {
            this.layoutIsRunning = false;
        }
    }

    private final void setFirstSize() {
        if (this.getTotalSize() <= this.getTotalMinSize()) {
            return;
        }
        this.setFirstSize(MathKt.roundToInt((float)(this.getFirstProportion() * (float)(this.getTotalSize() - 2 * this.getDividerWidth()))));
    }

    private final void setLastSize() {
        if (this.getTotalSize() <= this.getTotalMinSize()) {
            return;
        }
        this.setLastSize(MathKt.roundToInt((float)(this.getLastProportion() * (float)(this.getTotalSize() - 2 * this.getDividerWidth()))));
    }

    @NonNls
    private final String dump() {
        return "totalMinSize=" + this.getTotalMinSize() + ", totalSize=" + this.getTotalSize() + ", firstSize=(" + this.getFirstSize() + ", visible=" + this.firstVisible() + "), lastSize=(" + this.getLastSize() + ", visible=" + this.lastVisible() + ")";
    }

    private final boolean checkSize() {
        return !(this.getTotalMinSize() >= this.getTotalSize() || this.getFirstSize() <= 0 && this.firstVisible() || this.getLastSize() <= 0 && this.lastVisible());
    }

    private static final void _init_$lambda$0(PersistentThreeComponentSplitter this$0) {
        this$0.saveProportions();
    }

    private static final boolean addNotify$lambda$0(PersistentThreeComponentSplitter this$0) {
        return this$0.checkSize();
    }

    private static final Unit addNotify$lambda$1(PersistentThreeComponentSplitter this$0) {
        this$0.addNotifyCalled = false;
        this$0.restoreProportions();
        return Unit.INSTANCE;
    }

    private static final void invokeLaterWhen$lambda$0(PersistentThreeComponentSplitter this$0, Function0 $condition, Function0 $action, int $count, long $timestamp) {
        if (Disposer.isDisposed((Disposable)this$0.disposable)) {
            return;
        }
        if (((Boolean)$condition.invoke()).booleanValue()) {
            $action.invoke();
        } else if ($count > this$0.maxRetryCount) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PersistentThreeComponentSplitter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Could not restore proportions in " + this$0.maxRetryCount + " times. " + this$0.dump());
            $action.invoke();
        } else {
            this$0.invokeLaterWhen((Function0<Boolean>)$condition, $timestamp, $count + 1, (Function0<Unit>)$action);
        }
    }

    private static final Unit doLayout$lambda$0(PersistentThreeComponentSplitter this$0) {
        this$0.restoreProportions();
        return Unit.INSTANCE;
    }
}

