/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.ThreeComponentsSplitterKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.FocusUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0003RSTB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u001fJ\u000e\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0003J\b\u0010-\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020\u0003H\u0004J\b\u0010/\u001a\u00020\u0003H\u0002J\b\u00100\u001a\u00020\u0003H\u0004J\b\u00101\u001a\u00020\u001fH\u0002J\b\u00102\u001a\u00020\u0003H\u0002J\b\u00103\u001a\u00020\u0003H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020'H\u0016J\u0012\u0010<\u001a\u00020'2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010>\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u0003J\u000e\u0010G\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u0003J\u0012\u0010>\u001a\u00020\u001f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010H\u001a\u00020'2\u0006\u0010I\u001a\u00020\u000fJ\b\u0010N\u001a\u00020'H\u0016J\b\u0010O\u001a\u00020'H\u0016J\b\u0010P\u001a\u00020'H\u0002J\b\u0010Q\u001a\u00020'H\u0002R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R(\u0010\u001a\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u00107\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010=\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010#\"\u0004\b?\u0010%R&\u0010@\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010#\"\u0004\bB\u0010%R&\u0010C\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010#\"\u0004\bE\u0010%R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "Ljavax/swing/JPanel;", "vertical", "", "onePixelDividers", "<init>", "(ZZ)V", "isLookAndFeelUpdated", "verticalSplit", "isHonorMinimumSize", "firstDivider", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter$Divider;", "lastDivider", "dividerDispatcher", "Lcom/intellij/util/EventDispatcher;", "Ljava/awt/event/ComponentListener;", "component", "Ljavax/swing/JComponent;", "firstComponent", "getFirstComponent", "()Ljavax/swing/JComponent;", "setFirstComponent", "(Ljavax/swing/JComponent;)V", "innerComponent", "getInnerComponent", "setInnerComponent", "lastComponent", "getLastComponent", "setLastComponent", "showDividerControls", "dividerZone", "", "width", "dividerWidth", "getDividerWidth", "()I", "setDividerWidth", "(I)V", "updateUI", "", "setShowDividerControls", "setDividerMouseZoneSize", "size", "setHonorComponentsMinimumSize", "honorMinimumSize", "isVisible", "lastVisible", "innerVisible", "firstVisible", "visibleDividersCount", "firstDividerVisible", "lastDividerVisible", "getMinimumSize", "Ljava/awt/Dimension;", "doLayout", "orientation", "getOrientation", "()Z", "setOrientation", "(Z)V", "doAddComponent", "minSize", "getMinSize", "setMinSize", "firstSize", "getFirstSize", "setFirstSize", "lastSize", "getLastSize", "setLastSize", "first", "getMaxSize", "addDividerResizeListener", "listener", "glassPane", "Lcom/intellij/openapi/wm/IdeGlassPane;", "glassPaneDisposable", "Lcom/intellij/openapi/Disposable;", "addNotify", "removeNotify", "initGlassPane", "releaseGlassPane", "MyFocusTraversalPolicy", "Divider", "MyMouseAdapter", "intellij.platform.ide"})
public class ThreeComponentsSplitter
extends JPanel {
    private boolean isLookAndFeelUpdated;
    private boolean verticalSplit;
    private boolean isHonorMinimumSize;
    @NotNull
    private final Divider firstDivider;
    @NotNull
    private final Divider lastDivider;
    @Nullable
    private EventDispatcher<ComponentListener> dividerDispatcher;
    @Nullable
    private JComponent firstComponent;
    @Nullable
    private JComponent innerComponent;
    @Nullable
    private JComponent lastComponent;
    private boolean showDividerControls;
    private int dividerZone;
    private int dividerWidth;
    private int minSize;
    private int firstSize;
    private int lastSize;
    @Nullable
    private IdeGlassPane glassPane;
    @Nullable
    private Disposable glassPaneDisposable;

    @JvmOverloads
    public ThreeComponentsSplitter(boolean vertical, boolean onePixelDividers) {
        this.dividerWidth = onePixelDividers ? 1 : 7;
        this.verticalSplit = vertical;
        this.showDividerControls = false;
        this.firstDivider = new Divider(this, true, onePixelDividers);
        this.lastDivider = new Divider(this, false, onePixelDividers);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setOpaque(false);
        this.add(this.firstDivider);
        this.add(this.lastDivider);
    }

    public /* synthetic */ ThreeComponentsSplitter(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @Nullable
    public final JComponent getFirstComponent() {
        return this.firstComponent;
    }

    public final void setFirstComponent(@Nullable JComponent component) {
        if (this.firstComponent == component) {
            return;
        }
        if (this.firstComponent != null) {
            this.remove(this.firstComponent);
        }
        this.firstComponent = component;
        this.doAddComponent(component);
    }

    @Nullable
    public final JComponent getInnerComponent() {
        return this.innerComponent;
    }

    public final void setInnerComponent(@Nullable JComponent component) {
        if (this.innerComponent == component) {
            return;
        }
        if (this.innerComponent != null) {
            this.remove(this.innerComponent);
        }
        this.innerComponent = component;
        this.doAddComponent(component);
    }

    @Nullable
    public final JComponent getLastComponent() {
        return this.lastComponent;
    }

    public final void setLastComponent(@Nullable JComponent component) {
        if (this.lastComponent == component) {
            return;
        }
        if (this.lastComponent != null) {
            this.remove(this.lastComponent);
        }
        this.lastComponent = component;
        this.doAddComponent(component);
    }

    public final int getDividerWidth() {
        return this.dividerWidth;
    }

    public final void setDividerWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.dividerWidth != width) {
            this.dividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.firstDivider != null) {
            this.isLookAndFeelUpdated = true;
        }
    }

    public final void setShowDividerControls(boolean showDividerControls) {
        this.showDividerControls = showDividerControls;
        this.setOrientation(this.verticalSplit);
    }

    public final void setDividerMouseZoneSize(int size) {
        this.dividerZone = JBUIScale.scale((int)size);
    }

    public final void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.isHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.firstVisible() || this.innerVisible() || this.lastVisible());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean lastVisible() {
        if (NullableComponent.Check.isNull((Component)this.lastComponent)) return false;
        JComponent jComponent = this.lastComponent;
        Intrinsics.checkNotNull((Object)jComponent);
        if (!jComponent.isVisible()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean innerVisible() {
        if (NullableComponent.Check.isNull((Component)this.innerComponent)) return false;
        JComponent jComponent = this.innerComponent;
        Intrinsics.checkNotNull((Object)jComponent);
        if (!jComponent.isVisible()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean firstVisible() {
        if (NullableComponent.Check.isNull((Component)this.firstComponent)) return false;
        JComponent jComponent = this.firstComponent;
        Intrinsics.checkNotNull((Object)jComponent);
        if (!jComponent.isVisible()) return false;
        return true;
    }

    private final int visibleDividersCount() {
        int count = 0;
        if (this.firstDividerVisible()) {
            ++count;
        }
        if (this.lastDividerVisible()) {
            ++count;
        }
        return count;
    }

    private final boolean firstDividerVisible() {
        return this.firstVisible() && this.innerVisible() || this.firstVisible() && this.lastVisible() && !this.innerVisible();
    }

    private final boolean lastDividerVisible() {
        return this.innerVisible() && this.lastVisible();
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        if (this.isHonorMinimumSize) {
            Serializable innerSize;
            Serializable serializable;
            Serializable lastSize;
            Serializable serializable2;
            Serializable firstSize;
            int dividerWidth = this.dividerWidth;
            Serializable serializable3 = this.firstComponent;
            if (serializable3 == null || (serializable3 = serializable3.getMinimumSize()) == null) {
                JBDimension jBDimension = JBUI.emptySize();
                Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
                serializable3 = firstSize = (Dimension)jBDimension;
            }
            if ((serializable2 = this.lastComponent) == null || (serializable2 = serializable2.getMinimumSize()) == null) {
                JBDimension jBDimension = JBUI.emptySize();
                Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
                serializable2 = lastSize = (Dimension)jBDimension;
            }
            if ((serializable = this.innerComponent) == null || (serializable = serializable.getMinimumSize()) == null) {
                JBDimension jBDimension = JBUI.emptySize();
                Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
                serializable = innerSize = (Dimension)jBDimension;
            }
            if (this.getOrientation()) {
                int width = Math.max(((Dimension)firstSize).width, Math.max(((Dimension)lastSize).width, ((Dimension)innerSize).width));
                int height = this.visibleDividersCount() * dividerWidth;
                height += ((Dimension)firstSize).height;
                height += ((Dimension)lastSize).height;
                return new Dimension(width, height += ((Dimension)innerSize).height);
            }
            int height = Math.max(((Dimension)firstSize).height, Math.max(((Dimension)lastSize).height, ((Dimension)innerSize).height));
            int width = this.visibleDividersCount() * dividerWidth;
            width += ((Dimension)firstSize).width;
            width += ((Dimension)lastSize).width;
            return new Dimension(width += ((Dimension)innerSize).width, height);
        }
        Dimension dimension = super.getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
        return dimension;
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle firstRect = new Rectangle();
        Rectangle firstDividerRect = new Rectangle();
        Rectangle lastDividerRect = new Rectangle();
        Rectangle lastRect = new Rectangle();
        Rectangle innerRect = new Rectangle();
        int componentSize = this.getOrientation() ? height : width;
        int dividerWidth = this.dividerWidth;
        int dividersCount = this.visibleDividersCount();
        int firstComponentSize = 0;
        int lastComponentSize = 0;
        int innerComponentSize = 0;
        if (componentSize <= dividersCount * dividerWidth) {
            firstComponentSize = 0;
            lastComponentSize = 0;
            innerComponentSize = 0;
            dividerWidth = componentSize;
        } else {
            firstComponentSize = this.getFirstSize();
            int sizeLack = firstComponentSize + (lastComponentSize = this.getLastSize()) - (componentSize - dividersCount * dividerWidth - this.minSize);
            if (sizeLack > 0) {
                double firstSizeRatio = (double)firstComponentSize / (double)(firstComponentSize + lastComponentSize);
                if (firstComponentSize > 0) {
                    firstComponentSize -= (int)((double)sizeLack * firstSizeRatio);
                    firstComponentSize = Math.max(this.minSize, firstComponentSize);
                }
                if (lastComponentSize > 0) {
                    lastComponentSize -= (int)((double)sizeLack * (1.0 - firstSizeRatio));
                    lastComponentSize = Math.max(this.minSize, lastComponentSize);
                }
                innerComponentSize = this.getMinSize(this.innerComponent);
            } else {
                innerComponentSize = Math.max(this.getMinSize(this.innerComponent), componentSize - dividersCount * dividerWidth - this.getFirstSize() - this.getLastSize());
            }
            if (!this.innerVisible()) {
                lastComponentSize += innerComponentSize;
                innerComponentSize = 0;
                if (!this.lastVisible()) {
                    firstComponentSize = componentSize;
                }
            }
        }
        int space = firstComponentSize;
        if (this.getOrientation()) {
            firstRect.setBounds(0, 0, width, firstComponentSize);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            innerRect.setBounds(0, space, width, innerComponentSize);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            lastRect.setBounds(0, space, width, lastComponentSize);
        } else {
            firstRect.setBounds(0, 0, firstComponentSize, height);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            innerRect.setBounds(space, 0, innerComponentSize, height);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            lastRect.setBounds(space, 0, lastComponentSize, height);
        }
        this.firstDivider.setVisible(this.firstDividerVisible());
        this.firstDivider.setBounds(firstDividerRect);
        this.firstDivider.doLayout();
        this.lastDivider.setVisible(this.lastDividerVisible());
        this.lastDivider.setBounds(lastDividerRect);
        this.lastDivider.doLayout();
        ThreeComponentsSplitterKt.access$validateIfNeeded(this.firstComponent, firstRect);
        ThreeComponentsSplitterKt.access$validateIfNeeded(this.innerComponent, innerRect);
        ThreeComponentsSplitterKt.access$validateIfNeeded(this.lastComponent, lastRect);
    }

    public final boolean getOrientation() {
        return this.verticalSplit;
    }

    public final void setOrientation(boolean verticalSplit) {
        this.verticalSplit = verticalSplit;
        this.firstDivider.setOrientation(verticalSplit);
        this.lastDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    private final void doAddComponent(JComponent component) {
        if (component == null) {
            return;
        }
        if (this.isLookAndFeelUpdated) {
            ThreeComponentsSplitterKt.access$updateComponentTreeUI(component);
            this.isLookAndFeelUpdated = false;
        }
        this.add(component);
        component.invalidate();
    }

    public final int getMinSize() {
        return this.minSize;
    }

    public final void setMinSize(int minSize) {
        this.minSize = Math.max(0, minSize);
        this.doLayout();
        this.repaint();
    }

    public final int getFirstSize() {
        return this.firstVisible() ? this.firstSize : 0;
    }

    public final void setFirstSize(int size) {
        int oldSize = this.firstSize;
        this.firstSize = Math.max(this.getMinSize(true), size);
        if (this.firstVisible() && oldSize != this.firstSize) {
            this.doLayout();
            this.repaint();
        }
    }

    public final int getLastSize() {
        return this.lastVisible() ? this.lastSize : 0;
    }

    public final void setLastSize(int size) {
        int oldSize = this.lastSize;
        this.lastSize = Math.max(this.getMinSize(false), size);
        if (this.lastVisible() && oldSize != this.lastSize) {
            this.doLayout();
            this.repaint();
        }
    }

    public final int getMinSize(boolean first) {
        return this.getMinSize(first ? this.firstComponent : this.lastComponent);
    }

    public final int getMaxSize(boolean first) {
        int size = this.getOrientation() ? this.getHeight() : this.getWidth();
        return size - (first ? this.getLastSize() : this.getFirstSize()) - this.minSize;
    }

    private final int getMinSize(JComponent component) {
        if (this.isHonorMinimumSize && component != null && component.isVisible()) {
            return this.getOrientation() ? component.getMinimumSize().height : component.getMinimumSize().width;
        }
        return this.minSize;
    }

    public final void addDividerResizeListener(@NotNull ComponentListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (this.dividerDispatcher == null) {
            this.dividerDispatcher = EventDispatcher.create(ComponentListener.class);
        }
        EventDispatcher<ComponentListener> eventDispatcher = this.dividerDispatcher;
        Intrinsics.checkNotNull(eventDispatcher);
        eventDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            this.initGlassPane();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            this.releaseGlassPane();
        }
    }

    private final void initGlassPane() {
        Disposable glassPaneDisposable;
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find(this);
        Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"find(...)");
        IdeGlassPane glassPane = ideGlassPane;
        if (glassPane == this.glassPane) {
            return;
        }
        this.releaseGlassPane();
        this.glassPane = glassPane;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.glassPaneDisposable = glassPaneDisposable = disposable;
        Object[] objectArray = new Divider[]{this.firstDivider, this.lastDivider};
        MyMouseAdapter listener2 = new MyMouseAdapter(CollectionsKt.listOf((Object[])objectArray));
        glassPane.addMouseMotionPreprocessor(listener2, glassPaneDisposable);
        glassPane.addMousePreprocessor(listener2, glassPaneDisposable);
    }

    private final void releaseGlassPane() {
        if (this.glassPaneDisposable != null) {
            Disposable disposable = this.glassPaneDisposable;
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.dispose((Disposable)disposable);
            this.glassPaneDisposable = null;
            this.glassPane = null;
        }
    }

    @JvmOverloads
    public ThreeComponentsSplitter(boolean vertical) {
        this(vertical, false, 2, null);
    }

    @JvmOverloads
    public ThreeComponentsSplitter() {
        this(false, false, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0016J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/ui/ThreeComponentsSplitter$Divider;", "Ljavax/swing/JPanel;", "splitter", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "isFirst", "", "isOnePixel", "<init>", "(Lcom/intellij/openapi/ui/ThreeComponentsSplitter;ZZ)V", "isDragging", "point", "Ljava/awt/Point;", "getTargetEvent", "Ljava/awt/event/MouseEvent;", "e", "wasPressedOnMe", "getBackground", "Ljava/awt/Color;", "isInside", "p", "setOrientation", "", "isVerticalSplit", "center", "processMouseMotionEvent", "clamp", "", "pos", "size", "component", "Ljavax/swing/JComponent;", "componentSize", "processMouseEvent", "resizeCursor", "Ljava/awt/Cursor;", "getResizeCursor", "()Ljava/awt/Cursor;", "intellij.platform.ide"})
    private static final class Divider
    extends JPanel {
        @NotNull
        private final ThreeComponentsSplitter splitter;
        private final boolean isFirst;
        private final boolean isOnePixel;
        private boolean isDragging;
        @Nullable
        private Point point;
        private boolean wasPressedOnMe;

        public Divider(@NotNull ThreeComponentsSplitter splitter, boolean isFirst, boolean isOnePixel) {
            Intrinsics.checkNotNullParameter((Object)splitter, (String)"splitter");
            super(new GridBagLayout());
            this.splitter = splitter;
            this.isFirst = isFirst;
            this.isOnePixel = isOnePixel;
            this.setFocusable(false);
            this.enableEvents(48L);
            this.setOrientation(this.splitter.verticalSplit);
        }

        @NotNull
        public final MouseEvent getTargetEvent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MouseEvent mouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"convertMouseEvent(...)");
            return mouseEvent;
        }

        @Override
        @Nullable
        public Color getBackground() {
            return this.isOnePixel ? UIUtil.CONTRAST_BORDER_COLOR : super.getBackground();
        }

        private final boolean isInside(Point p) {
            int dndOff;
            if (!this.isVisible()) {
                return false;
            }
            Window window = ComponentUtil.getWindow((Component)this);
            if (window != null) {
                Object[] objectArray;
                List components;
                Point point = SwingUtilities.convertPoint(this, p, window);
                Component component = UIUtil.getDeepestComponentAt((Component)window, (int)point.x, (int)point.y);
                if (ComponentUtil.findParentByCondition((Component)component, arg_0 -> Divider.isInside$lambda$0(components = CollectionsKt.listOf((Object[])(objectArray = new Component[]{this.splitter.getFirstComponent(), this.splitter.firstDivider, this.splitter.getInnerComponent(), this.splitter.lastDivider, this.splitter.getLastComponent()})), arg_0)) == null) {
                    return false;
                }
            }
            int n = dndOff = this.isOnePixel ? JBUIScale.scale((int)Registry.Companion.intValue("ide.splitter.mouseZone")) / 2 : 0;
            if (this.splitter.verticalSplit) {
                if (p.x >= 0 && p.x < this.getWidth()) {
                    return this.getHeight() > 0 ? p.y >= -dndOff && p.y < this.getHeight() + dndOff : p.y >= -this.splitter.dividerZone / 2 && p.y <= this.splitter.dividerZone / 2;
                }
            } else if (p.y >= 0 && p.y < this.getHeight()) {
                return this.getWidth() > 0 ? p.x >= -dndOff && p.x < this.getWidth() + dndOff : p.x >= -this.splitter.dividerZone / 2 && p.x <= this.splitter.dividerZone / 2;
            }
            return false;
        }

        public final void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!this.splitter.showDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            Icon icon = isVerticalSplit ? (Icon)ThreeComponentsSplitterKt.access$getSplitGlueV$p() : AllIcons.General.ArrowSplitCenterH;
            Intrinsics.checkNotNull((Object)icon);
            Icon glueIcon = icon;
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, (Insets)JBInsets.emptyInsets(), 0, 0));
            JLabel splitDownlabel = new JLabel(isVerticalSplit ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.setToolTipText(isVerticalSplit ? UIBundle.message("splitter.down.tooltip.text", new Object[0]) : UIBundle.message("splitter.right.tooltip.text", new Object[0]));
            new ClickListener(this){
                final /* synthetic */ Divider this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onClick(MouseEvent e, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Divider.access$getSplitter$p(this.this$0).getInnerComponent() != null) {
                        int income;
                        if (ThreeComponentsSplitter.access$getVerticalSplit$p(Divider.access$getSplitter$p(this.this$0))) {
                            JComponent jComponent = Divider.access$getSplitter$p(this.this$0).getInnerComponent();
                            Intrinsics.checkNotNull((Object)jComponent);
                            v1 = jComponent.getHeight();
                        } else {
                            JComponent jComponent = Divider.access$getSplitter$p(this.this$0).getInnerComponent();
                            Intrinsics.checkNotNull((Object)jComponent);
                            v1 = income = jComponent.getWidth();
                        }
                        if (Divider.access$isFirst$p(this.this$0)) {
                            Divider.access$getSplitter$p(this.this$0).setFirstSize(Divider.access$getSplitter$p(this.this$0).getFirstSize() + income);
                        } else {
                            Divider.access$getSplitter$p(this.this$0).setLastSize(Divider.access$getSplitter$p(this.this$0).getLastSize() + income);
                        }
                    }
                    return true;
                }
            }.installOn((Component)splitDownlabel);
            this.add((Component)splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, (Insets)JBInsets.emptyInsets(), 0, 0));
            JLabel splitCenterlabel = new JLabel(isVerticalSplit ? AllIcons.General.ArrowSplitCenterV : AllIcons.General.ArrowSplitCenterH);
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.setToolTipText(UIBundle.message("splitter.center.tooltip.text", new Object[0]));
            new ClickListener(this){
                final /* synthetic */ Divider this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onClick(MouseEvent e, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Divider.access$center(this.this$0);
                    return true;
                }
            }.installOn((Component)splitCenterlabel);
            this.add((Component)splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, (Insets)JBInsets.emptyInsets(), 0, 0));
            JLabel splitUpLabel = new JLabel(isVerticalSplit ? AllIcons.General.ArrowUp : AllIcons.General.ArrowLeft);
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.setToolTipText(isVerticalSplit ? UIBundle.message("splitter.up.tooltip.text", new Object[0]) : UIBundle.message("splitter.left.tooltip.text", new Object[0]));
            new ClickListener(this){
                final /* synthetic */ Divider this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onClick(MouseEvent e, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Divider.access$getSplitter$p(this.this$0).getInnerComponent() != null) {
                        int income;
                        if (ThreeComponentsSplitter.access$getVerticalSplit$p(Divider.access$getSplitter$p(this.this$0))) {
                            JComponent jComponent = Divider.access$getSplitter$p(this.this$0).getInnerComponent();
                            Intrinsics.checkNotNull((Object)jComponent);
                            v1 = jComponent.getHeight();
                        } else {
                            JComponent jComponent = Divider.access$getSplitter$p(this.this$0).getInnerComponent();
                            Intrinsics.checkNotNull((Object)jComponent);
                            v1 = income = jComponent.getWidth();
                        }
                        if (Divider.access$isFirst$p(this.this$0)) {
                            Divider.access$getSplitter$p(this.this$0).setFirstSize(Divider.access$getSplitter$p(this.this$0).getFirstSize() + income);
                        } else {
                            Divider.access$getSplitter$p(this.this$0).setLastSize(Divider.access$getSplitter$p(this.this$0).getLastSize() + income);
                        }
                    }
                    return true;
                }
            }.installOn((Component)splitUpLabel);
            this.add((Component)splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, (Insets)JBInsets.emptyInsets(), 0, 0));
        }

        private final void center() {
            if (this.splitter.getInnerComponent() != null) {
                int n;
                int n2 = this.splitter.getFirstSize();
                if (this.splitter.verticalSplit) {
                    JComponent jComponent = this.splitter.getInnerComponent();
                    Intrinsics.checkNotNull((Object)jComponent);
                    n = jComponent.getHeight();
                } else {
                    JComponent jComponent = this.splitter.getInnerComponent();
                    Intrinsics.checkNotNull((Object)jComponent);
                    n = jComponent.getWidth();
                }
                int total = n2 + n;
                if (this.isFirst) {
                    this.splitter.setFirstSize(total / 2);
                } else {
                    this.splitter.setLastSize(total / 2);
                }
            }
        }

        @Override
        public void processMouseMotionEvent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.processMouseMotionEvent(e);
            if (!this.isShowing()) {
                return;
            }
            IdeGlassPane glassPane = this.splitter.glassPane;
            if (506 == e.getID() && this.wasPressedOnMe) {
                int size;
                this.isDragging = true;
                this.setCursor(this.getResizeCursor());
                IdeGlassPane ideGlassPane = glassPane;
                if (ideGlassPane != null) {
                    ideGlassPane.setCursor(this.getResizeCursor(), this);
                }
                this.point = SwingUtilities.convertPoint(this, e.getPoint(), this.splitter);
                int n = size = this.splitter.getOrientation() ? this.splitter.getHeight() : this.splitter.getWidth();
                if (this.splitter.getOrientation()) {
                    if (size > 0 || this.splitter.dividerZone > 0) {
                        if (this.isFirst) {
                            Point point = this.point;
                            Intrinsics.checkNotNull((Object)point);
                            this.splitter.setFirstSize(this.clamp(point.y, size, this.splitter.getFirstComponent(), this.splitter.getLastSize()));
                        } else {
                            Point point = this.point;
                            Intrinsics.checkNotNull((Object)point);
                            this.splitter.setLastSize(this.clamp(size - point.y - this.splitter.getDividerWidth(), size, this.splitter.getLastComponent(), this.splitter.getFirstSize()));
                        }
                    }
                } else if (size > 0 || this.splitter.dividerZone > 0) {
                    if (this.isFirst) {
                        Point point = this.point;
                        Intrinsics.checkNotNull((Object)point);
                        this.splitter.setFirstSize(this.clamp(point.x, size, this.splitter.getFirstComponent(), this.splitter.getLastSize()));
                    } else {
                        Point point = this.point;
                        Intrinsics.checkNotNull((Object)point);
                        this.splitter.setLastSize(this.clamp(size - point.x - this.splitter.getDividerWidth(), size, this.splitter.getLastComponent(), this.splitter.getFirstSize()));
                    }
                }
                this.splitter.doLayout();
            } else if (503 == e.getID() && glassPane != null) {
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                if (this.isInside(point)) {
                    glassPane.setCursor(this.getResizeCursor(), this);
                    e.consume();
                } else {
                    glassPane.setCursor(null, this);
                }
            }
            if (this.wasPressedOnMe) {
                e.consume();
            }
        }

        private final int clamp(int pos, int size, JComponent component, int componentSize) {
            int maxSize;
            int minSize = this.splitter.getMinSize(component);
            return minSize <= (maxSize = size - componentSize - this.splitter.getMinSize(this.splitter.getInnerComponent()) - this.splitter.getDividerWidth() * this.splitter.visibleDividersCount()) ? RangesKt.coerceIn((int)pos, (int)minSize, (int)maxSize) : pos;
        }

        @Override
        public void processMouseEvent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.processMouseEvent(e);
            if (!this.isShowing()) {
                return;
            }
            IdeGlassPane glassPane = this.splitter.glassPane;
            switch (e.getID()) {
                case 504: {
                    this.setCursor(this.getResizeCursor());
                    break;
                }
                case 505: {
                    if (this.isDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    if (this.isInside(point)) {
                        this.wasPressedOnMe = true;
                        IdeGlassPane ideGlassPane = glassPane;
                        if (ideGlassPane != null) {
                            ideGlassPane.setCursor(this.getResizeCursor(), this);
                        }
                        e.consume();
                        break;
                    }
                    this.wasPressedOnMe = false;
                    break;
                }
                case 502: {
                    if (this.wasPressedOnMe) {
                        e.consume();
                    }
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    if (this.isInside(point) && glassPane != null) {
                        glassPane.setCursor(this.getResizeCursor(), this);
                    }
                    if (this.isDragging && this.splitter.dividerDispatcher != null) {
                        EventDispatcher eventDispatcher = this.splitter.dividerDispatcher;
                        Intrinsics.checkNotNull((Object)eventDispatcher);
                        ((ComponentListener)eventDispatcher.getMulticaster()).componentResized(new ComponentEvent(this, 101));
                    }
                    this.wasPressedOnMe = false;
                    this.isDragging = false;
                    this.point = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.center();
                }
            }
        }

        private final Cursor getResizeCursor() {
            if (this.splitter.getOrientation()) {
                Cursor cursor = Cursor.getPredefinedCursor(this.isFirst ? 9 : 8);
                Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
                return cursor;
            }
            Cursor cursor = Cursor.getPredefinedCursor(this.isFirst ? 10 : 11);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
            return cursor;
        }

        private static final boolean isInside$lambda$0(List $components, Component it) {
            return it != null && $components.contains(it);
        }

        public static final /* synthetic */ ThreeComponentsSplitter access$getSplitter$p(Divider $this) {
            return $this.splitter;
        }

        public static final /* synthetic */ boolean access$isFirst$p(Divider $this) {
            return $this.isFirst;
        }

        public static final /* synthetic */ void access$center(Divider $this) {
            $this.center();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/ui/ThreeComponentsSplitter$MyFocusTraversalPolicy;", "Ljavax/swing/LayoutFocusTraversalPolicy;", "<init>", "(Lcom/intellij/openapi/ui/ThreeComponentsSplitter;)V", "getComponentAfter", "Ljava/awt/Component;", "aContainer", "Ljava/awt/Container;", "aComponent", "getComponentBefore", "nextVisible", "component", "prevVisible", "getFirstComponent", "getLastComponent", "reentrantLock", "", "getDefaultComponent", "findChildToFocus", "intellij.platform.ide"})
    private final class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean reentrantLock;

        @Override
        @NotNull
        public Component getComponentAfter(@NotNull Container aContainer, @NotNull Component aComponent) {
            Component component;
            Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
            Intrinsics.checkNotNullParameter((Object)aComponent, (String)"aComponent");
            Component comp = null;
            if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.getFirstComponent())) {
                Component component2 = next = this.nextVisible(ThreeComponentsSplitter.this.getFirstComponent());
                comp = component2 != null ? this.findChildToFocus(component2) : aComponent;
            } else if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.getInnerComponent())) {
                Component component3 = next = this.nextVisible(ThreeComponentsSplitter.this.getInnerComponent());
                comp = component3 != null ? this.findChildToFocus(component3) : aComponent;
            } else {
                Component component4 = next = this.nextVisible(ThreeComponentsSplitter.this.getLastComponent());
                Component component5 = comp = component4 != null ? this.findChildToFocus(component4) : aComponent;
            }
            if (comp == aComponent) {
                Component component6 = super.getComponentAfter(aContainer, aComponent);
                Intrinsics.checkNotNull((Object)component6);
                component = component6;
            } else {
                component = comp;
            }
            return component;
        }

        @Override
        @NotNull
        public Component getComponentBefore(@NotNull Container aContainer, @NotNull Component aComponent) {
            Component component;
            Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
            Intrinsics.checkNotNullParameter((Object)aComponent, (String)"aComponent");
            Component component2 = null;
            if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.getInnerComponent())) {
                Component component3 = prev = this.prevVisible(ThreeComponentsSplitter.this.getInnerComponent());
                component2 = component3 != null ? this.findChildToFocus(component3) : aComponent;
            } else if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.getLastComponent())) {
                Component component4 = prev = this.prevVisible(ThreeComponentsSplitter.this.getLastComponent());
                component2 = component4 != null ? this.findChildToFocus(component4) : aComponent;
            } else {
                Component component5 = prev = this.prevVisible(ThreeComponentsSplitter.this.getFirstComponent());
                Component component6 = component2 = component5 != null ? this.findChildToFocus(component5) : aComponent;
            }
            if (component2 == aComponent) {
                Component component7 = super.getComponentBefore(aContainer, aComponent);
                Intrinsics.checkNotNull((Object)component7);
                component = component7;
            } else {
                component = component2;
            }
            return component;
        }

        private final Component nextVisible(Component component) {
            if (component == ThreeComponentsSplitter.this.getFirstComponent()) {
                return ThreeComponentsSplitter.this.innerVisible() ? (Component)ThreeComponentsSplitter.this.getInnerComponent() : (ThreeComponentsSplitter.this.lastVisible() ? (Component)ThreeComponentsSplitter.this.getLastComponent() : null);
            }
            if (component == ThreeComponentsSplitter.this.getInnerComponent()) {
                return ThreeComponentsSplitter.this.lastVisible() ? (Component)ThreeComponentsSplitter.this.getLastComponent() : (ThreeComponentsSplitter.this.firstVisible() ? (Component)ThreeComponentsSplitter.this.getFirstComponent() : null);
            }
            return component == ThreeComponentsSplitter.this.getLastComponent() ? (Component)(ThreeComponentsSplitter.this.firstVisible() ? ThreeComponentsSplitter.this.getFirstComponent() : (ThreeComponentsSplitter.this.innerVisible() ? ThreeComponentsSplitter.this.getInnerComponent() : null)) : null;
        }

        private final Component prevVisible(Component component) {
            if (component == ThreeComponentsSplitter.this.getFirstComponent()) {
                return ThreeComponentsSplitter.this.lastVisible() ? (Component)ThreeComponentsSplitter.this.getLastComponent() : (ThreeComponentsSplitter.this.innerVisible() ? (Component)ThreeComponentsSplitter.this.getInnerComponent() : null);
            }
            if (component == ThreeComponentsSplitter.this.getInnerComponent()) {
                return ThreeComponentsSplitter.this.firstVisible() ? (Component)ThreeComponentsSplitter.this.getFirstComponent() : (ThreeComponentsSplitter.this.lastVisible() ? (Component)ThreeComponentsSplitter.this.getLastComponent() : null);
            }
            return component == ThreeComponentsSplitter.this.getLastComponent() ? (Component)(ThreeComponentsSplitter.this.innerVisible() ? ThreeComponentsSplitter.this.getInnerComponent() : (ThreeComponentsSplitter.this.firstVisible() ? ThreeComponentsSplitter.this.getFirstComponent() : null)) : null;
        }

        @Override
        @Nullable
        public Component getFirstComponent(@NotNull Container aContainer) {
            Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
            if (ThreeComponentsSplitter.this.firstVisible()) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.getFirstComponent());
            }
            Component component = this.nextVisible(ThreeComponentsSplitter.this.getFirstComponent());
            if (component == null) {
                return null;
            }
            return this.findChildToFocus(component);
        }

        @Override
        @Nullable
        public Component getLastComponent(@NotNull Container aContainer) {
            Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
            if (ThreeComponentsSplitter.this.lastVisible()) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.getLastComponent());
            }
            Component component = this.prevVisible(ThreeComponentsSplitter.this.getLastComponent());
            if (component == null) {
                return null;
            }
            return this.findChildToFocus(component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Component getDefaultComponent(@NotNull Container aContainer) {
            Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
            if (this.reentrantLock) {
                return null;
            }
            try {
                Component component;
                this.reentrantLock = true;
                if (ThreeComponentsSplitter.this.innerVisible()) {
                    Component component2 = this.findChildToFocus(ThreeComponentsSplitter.this.getInnerComponent());
                    return component2;
                }
                if (this.nextVisible(ThreeComponentsSplitter.this.getLastComponent()) == null) {
                    Component component3 = null;
                    return component3;
                }
                Component component4 = this.findChildToFocus(component);
                return component4;
            }
            finally {
                this.reentrantLock = false;
            }
        }

        @NotNull
        public final Component findChildToFocus(@Nullable Component component) {
            Window ancestor = SwingUtilities.getWindowAncestor(ThreeComponentsSplitter.this);
            Component component2 = FocusUtil.getMostRecentComponent((Component)component, (Window)ancestor);
            if (component2 != null) {
                Component it = component2;
                boolean bl = false;
                return it;
            }
            Component defaultComponentInPanel = FocusUtil.getDefaultComponentInPanel((Component)component);
            Component component3 = defaultComponentInPanel;
            if (component3 == null) {
                Component component4 = FocusUtil.findFocusableComponentIn((Component)component, null);
                component3 = component4;
                Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"findFocusableComponentIn(...)");
            }
            return component3;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/ui/ThreeComponentsSplitter$MyMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "Lcom/intellij/openapi/util/Weighted;", "dividers", "", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter$Divider;", "<init>", "(Ljava/util/List;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseMoved", "mouseDragged", "getWeight", "", "processMouseMotionEvent", "processMouseEvent", "intellij.platform.ide"})
    private static final class MyMouseAdapter
    extends MouseAdapter
    implements Weighted {
        @NotNull
        private final List<Divider> dividers;

        public MyMouseAdapter(@NotNull List<Divider> dividers) {
            Intrinsics.checkNotNullParameter(dividers, (String)"dividers");
            this.dividers = dividers;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.processMouseEvent(e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.processMouseEvent(e);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.processMouseMotionEvent(e);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.processMouseMotionEvent(e);
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        private final void processMouseMotionEvent(MouseEvent e) {
            for (Divider divider : this.dividers) {
                MouseEvent event = divider.getTargetEvent(e);
                divider.processMouseMotionEvent(event);
                if (!event.isConsumed()) continue;
                e.consume();
                break;
            }
        }

        private final void processMouseEvent(MouseEvent e) {
            for (Divider divider : this.dividers) {
                MouseEvent event = divider.getTargetEvent(e);
                divider.processMouseEvent(event);
                if (!event.isConsumed()) continue;
                e.consume();
                break;
            }
        }
    }
}

