/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PopupUtil {
    private static final Logger LOG = Logger.getInstance(PopupUtil.class);
    private static final String POPUP_TOGGLE_COMPONENT = "POPUP_TOGGLE_BUTTON";

    private PopupUtil() {
    }

    @Nullable
    public static Component getOwner(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof RootPaneContainer) {
            JRootPane root = ((RootPaneContainer)((Object)wnd)).getRootPane();
            JBPopup popup2 = (JBPopup)root.getClientProperty("JBPopup");
            if (popup2 == null) {
                return c;
            }
            Component owner2 = popup2.getOwner();
            if (owner2 == null) {
                return c;
            }
            return PopupUtil.getOwner(owner2);
        }
        return null;
    }

    public static JBPopup getPopupContainerFor(@Nullable Component c) {
        JBPopup popup2;
        if (c == null) {
            return null;
        }
        if (c instanceof JComponent && (popup2 = (JBPopup)((JComponent)c).getClientProperty("JBPopup")) != null) {
            return popup2;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        return PopupUtil.getPopupFor(wnd);
    }

    @Nullable
    public static JBPopup getPopupFor(@Nullable Window wnd) {
        if (wnd instanceof JWindow) {
            JRootPane root = ((JWindow)wnd).getRootPane();
            return (JBPopup)root.getClientProperty("JBPopup");
        }
        return null;
    }

    public static void setPopupType(@NotNull PopupFactory factory, int type) {
        if (factory == null) {
            PopupUtil.$$$reportNull$$$0(0);
        }
        try {
            Method method = PopupFactory.class.getDeclaredMethod("setPopupType", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)factory, type);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public static int getPopupType(@NotNull PopupFactory factory) {
        if (factory == null) {
            PopupUtil.$$$reportNull$$$0(1);
        }
        try {
            if (!ClientId.isCurrentlyUnderLocalId()) {
                Field field = PopupFactory.class.getDeclaredField("HEAVY_WEIGHT_POPUP");
                field.setAccessible(true);
                return (Integer)field.get(null);
            }
            Method method = PopupFactory.class.getDeclaredMethod("getPopupType", new Class[0]);
            method.setAccessible(true);
            Object result2 = method.invoke((Object)factory, new Object[0]);
            return result2 instanceof Integer ? (Integer)result2 : -1;
        }
        catch (Throwable e) {
            LOG.error(e);
            return -1;
        }
    }

    public static Component getActiveComponent() {
        Window[] windows;
        for (Window each : windows = Window.getWindows()) {
            if (!each.isActive()) continue;
            return each;
        }
        IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
        if (frame != null) {
            return frame.getComponent();
        }
        return JOptionPane.getRootFrame();
    }

    public static void showBalloonForActiveFrame(@NlsContexts.PopupContent @NotNull String message, MessageType type) {
        if (message == null) {
            PopupUtil.$$$reportNull$$$0(2);
        }
        Runnable runnable = () -> {
            IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
            if (frame == null) {
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project = projects.length == 0 ? ProjectManager.getInstance().getDefaultProject() : projects[0];
                JFrame jFrame = WindowManager.getInstance().getFrame(project);
                if (jFrame != null) {
                    PopupUtil.showBalloonForComponent(jFrame, message, type, true, (Disposable)project);
                } else {
                    LOG.info("Can not get component to show message: " + message);
                }
                return;
            }
            PopupUtil.showBalloonForComponent(frame.getComponent(), message, type, true, (Disposable)frame.getProject());
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void showBalloonForActiveComponent(@NlsContexts.PopupContent @NotNull String message, MessageType type) {
        if (message == null) {
            PopupUtil.$$$reportNull$$$0(3);
        }
        Runnable runnable = () -> {
            Window[] windows = Window.getWindows();
            Window targetWindow = null;
            for (Window each : windows) {
                if (!each.isActive()) continue;
                targetWindow = each;
                break;
            }
            if (targetWindow == null) {
                targetWindow = JOptionPane.getRootFrame();
            }
            PopupUtil.showBalloonForComponent(targetWindow, message, type, true, null);
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void showBalloonForComponent(@NotNull Component component, @NlsContexts.PopupContent @NotNull String message, MessageType type, boolean atTop, @Nullable Disposable disposable) {
        Balloon.Position position;
        int x;
        int y;
        JBPopupFactory popupFactory;
        if (component == null) {
            PopupUtil.$$$reportNull$$$0(4);
        }
        if (message == null) {
            PopupUtil.$$$reportNull$$$0(5);
        }
        if ((popupFactory = JBPopupFactory.getInstance()) == null) {
            return;
        }
        BalloonBuilder balloonBuilder = popupFactory.createHtmlTextBalloonBuilder(message, type, null);
        balloonBuilder.setDisposable((Disposable)(disposable == null ? ApplicationManager.getApplication() : disposable));
        Balloon balloon = balloonBuilder.createBalloon();
        Dimension size = component.getSize();
        if (size == null) {
            y = 0;
            x = 0;
            position = Balloon.Position.above;
        } else {
            x = Math.min(10, size.width / 2);
            y = size.height;
            position = Balloon.Position.below;
        }
        balloon.show(new RelativePoint(component, new Point(x, y)), position);
    }

    public static boolean isComboPopupKeyEvent(@NotNull ComponentEvent event, @NotNull JComboBox comboBox) {
        if (event == null) {
            PopupUtil.$$$reportNull$$$0(6);
        }
        if (comboBox == null) {
            PopupUtil.$$$reportNull$$$0(7);
        }
        Component component = event.getComponent();
        if (!comboBox.isPopupVisible() || component == null) {
            return false;
        }
        ComboPopup popup2 = (ComboPopup)ReflectionUtil.getField(comboBox.getUI().getClass(), (Object)comboBox.getUI(), ComboPopup.class, (String)"popup");
        return popup2 != null && SwingUtilities.isDescendingFrom(popup2.getList(), component);
    }

    public static boolean handleEscKeyEvent() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
        if (selectedPath.length > 0) {
            menuSelectionManager.clearSelectedPath();
        } else {
            if (ApplicationManager.getApplication() == null) {
                return false;
            }
            StackingPopupDispatcher popupDispatcher = StackingPopupDispatcher.getInstance();
            if (popupDispatcher != null && !popupDispatcher.isPopupFocused()) {
                return false;
            }
        }
        return true;
    }

    public static void showForActionButtonEvent(@NotNull JBPopup popup2, @NotNull AnActionEvent e) {
        InputEvent inputEvent;
        if (popup2 == null) {
            PopupUtil.$$$reportNull$$$0(8);
        }
        if (e == null) {
            PopupUtil.$$$reportNull$$$0(9);
        }
        if ((inputEvent = e.getInputEvent()) == null) {
            popup2.showInFocusCenter();
        } else {
            Component component = inputEvent.getComponent();
            if (component instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component);
            } else {
                popup2.showInCenterOf(component);
            }
        }
    }

    public static Border createComplexPopupTextFieldBorder() {
        return JBUI.Borders.compound((Border[])new Border[]{new JBEmptyBorder(JBUI.CurrentTheme.ComplexPopup.textFieldBorderInsets().getUnscaled()), JBUI.Borders.customLine((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)0, (int)0, (int)1, (int)0), new JBEmptyBorder(JBUI.CurrentTheme.ComplexPopup.textFieldInputInsets().getUnscaled())});
    }

    public static void applyNewUIBackground(@Nullable Component component) {
        if (component != null && ExperimentalUI.isNewUI()) {
            component.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        }
    }

    public static Border getComplexPopupHorizontalHeaderBorder() {
        Insets headerInsets = JBUI.CurrentTheme.ComplexPopup.headerInsets().getUnscaled();
        return new JBEmptyBorder(0, headerInsets.left, 0, headerInsets.right);
    }

    public static Border getComplexPopupVerticalHeaderBorder() {
        Insets headerInsets = JBUI.CurrentTheme.ComplexPopup.headerInsets().getUnscaled();
        return new JBEmptyBorder(headerInsets.top, 0, headerInsets.bottom, 0);
    }

    public static void configListRendererFixedHeight(SelectablePanel selectablePanel) {
        PopupUtil.configListRendererFlexibleHeight(selectablePanel);
        selectablePanel.setPreferredHeight(JBUI.CurrentTheme.List.rowHeight());
    }

    public static void configListRendererFlexibleHeight(SelectablePanel selectablePanel) {
        int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
        Insets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
        selectablePanel.setBorder(new EmptyBorder(innerInsets.top, innerInsets.left + leftRightInset, innerInsets.bottom, innerInsets.right + leftRightInset));
        selectablePanel.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
        selectablePanel.setSelectionInsets(new Insets(0, leftRightInset, 0, leftRightInset));
    }

    public static void applyPreviewTitleInsets(JComponent title) {
        if (ExperimentalUI.isNewUI()) {
            title.setBorder((Border)JBUI.Borders.empty((int)10, (int)20, (int)6, (int)0));
        } else {
            title.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)4, (int)8));
        }
    }

    @NotNull
    public static Insets getListInsets(boolean titleVisible, boolean adVisible) {
        if (!ExperimentalUI.isNewUI()) {
            Insets insets = UIUtil.getListViewportPadding((boolean)adVisible);
            if (insets == null) {
                PopupUtil.$$$reportNull$$$0(10);
            }
            return insets;
        }
        int topInset = titleVisible ? 0 : JBUI.CurrentTheme.Popup.bodyTopInsetNoHeader();
        int bottomInset = adVisible ? JBUI.CurrentTheme.Popup.bodyBottomInsetBeforeAd() : JBUI.CurrentTheme.Popup.bodyBottomInsetNoAd();
        return new JBInsets(topInset, 0, bottomInset, 0);
    }

    public static void setPopupToggleComponent(@NotNull JBPopup jbPopup, @Nullable Component toggleComponent) {
        if (jbPopup == null) {
            PopupUtil.$$$reportNull$$$0(11);
        }
        JComponent content = jbPopup.getContent();
        content.putClientProperty(POPUP_TOGGLE_COMPONENT, toggleComponent != null ? new WeakReference<Component>(toggleComponent) : null);
    }

    @Nullable
    public static Component getPopupToggleComponent(@NotNull JBPopup jbPopup) {
        if (jbPopup == null) {
            PopupUtil.$$$reportNull$$$0(12);
        }
        return (Component)SoftReference.dereference((Reference)((WeakReference)jbPopup.getContent().getClientProperty(POPUP_TOGGLE_COMPONENT)));
    }

    public static void addToggledStateListener(@NotNull JBPopup popup2, final @NotNull Presentation presentation) {
        if (popup2 == null) {
            PopupUtil.$$$reportNull$$$0(13);
        }
        if (presentation == null) {
            PopupUtil.$$$reportNull$$$0(14);
        }
        popup2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Toggleable.setSelected(presentation, true);
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Toggleable.setSelected(presentation, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/ui/popup/util/PopupUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/popup/util/PopupUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jbPopup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/popup/util/PopupUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getListInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPopupType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPopupType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showBalloonForActiveFrame";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showBalloonForActiveComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showBalloonForComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isComboPopupKeyEvent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showForActionButtonEvent";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setPopupToggleComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPopupToggleComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addToggledStateListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

