/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.components.WideSelectionListUI;
import com.intellij.ui.dsl.listCellRenderer.KotlinUIDslRendererComponent;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.im.InputMethodRequests;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBList<E>
extends JList<E>
implements ComponentWithEmptyText,
ComponentWithExpandableItems<Integer> {
    public static final String IGNORE_LIST_ROW_HEIGHT = "IgnoreListRowHeight";
    @ApiStatus.Internal
    public static final Key<Boolean> IMMUTABLE_MODEL_AND_RENDERER = Key.create((String)"ImmutableModelAndRenderer");
    private StatusText myEmptyText;
    private ExpandableItemsHandler<Integer> myExpandableItemsHandler;
    @Nullable
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;
    private int myDropTargetIndex;
    @NotNull
    private Function<? super Integer, Integer> offsetFromElementTopForDnD;

    public JBList() {
        this.myDropTargetIndex = -1;
        this.offsetFromElementTopForDnD = dropTargetIndex -> 0;
        this.init();
    }

    public JBList(@NotNull ListModel<E> dataModel) {
        if (dataModel == null) {
            JBList.$$$reportNull$$$0(0);
        }
        super(dataModel);
        this.myDropTargetIndex = -1;
        this.offsetFromElementTopForDnD = dropTargetIndex -> 0;
        this.init();
    }

    public JBList(E ... listData) {
        if (listData == null) {
            JBList.$$$reportNull$$$0(1);
        }
        super(JBList.createDefaultListModel(listData));
        this.myDropTargetIndex = -1;
        this.offsetFromElementTopForDnD = dropTargetIndex -> 0;
        this.init();
    }

    @NotNull
    public static <T> DefaultListModel<T> createDefaultListModel(T ... items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(2);
        }
        return JBList.createDefaultListModel(Arrays.asList(items));
    }

    @NotNull
    public static <T> DefaultListModel<T> createDefaultListModel(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(3);
        }
        DefaultListModel<T> model = new DefaultListModel<T>();
        for (T item : items) {
            model.add(model.getSize(), item);
        }
        DefaultListModel<T> defaultListModel = model;
        if (defaultListModel == null) {
            JBList.$$$reportNull$$$0(4);
        }
        return defaultListModel;
    }

    public JBList(@NotNull Collection<? extends E> items) {
        if (items == null) {
            JBList.$$$reportNull$$$0(5);
        }
        this((ListModel<? extends E>)JBList.createDefaultListModel(items));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            return;
        }
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            ListUI ui = this.getUI();
            if (ui instanceof WideSelectionListUI && this.getLayoutOrientation() == 0) {
                x = 0;
                width = this.getWidth();
            }
            super.repaint(tm, x, y, width, height);
        }
    }

    @Override
    public void setUI(ListUI ui) {
        Class<?> type;
        if (ui != null && Registry.is((String)"ide.wide.selection.list.ui", (boolean)true) && (type = ui.getClass()) == BasicListUI.class) {
            ui = new WideSelectionListUI();
        }
        super.setUI(ui);
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString());
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(() -> {
                    if (this.myBusyIcon != null) {
                        this.repaint();
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    public void setDropTargetIndex(int index) {
        if (index != this.myDropTargetIndex) {
            this.myDropTargetIndex = index;
            this.repaint();
        }
    }

    public void setOffsetFromElementTopForDnD(@NotNull Function<? super Integer, Integer> offsetFromElementTopForDnD) {
        if (offsetFromElementTopForDnD == null) {
            JBList.$$$reportNull$$$0(6);
        }
        this.offsetFromElementTopForDnD = offsetFromElementTopForDnD;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int dropLineY;
        Rectangle rc;
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
        if (this.myDropTargetIndex < 0) {
            return;
        }
        if (this.myDropTargetIndex == this.getModel().getSize()) {
            rc = this.getCellBounds(this.myDropTargetIndex - 1, this.myDropTargetIndex - 1);
            dropLineY = (int)rc.getMaxY() - 1;
        } else {
            rc = this.getCellBounds(this.myDropTargetIndex, this.myDropTargetIndex);
            dropLineY = rc.y + this.offsetFromElementTopForDnD.apply((Integer)this.myDropTargetIndex);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(PlatformColors.BLUE);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawLine(rc.x, dropLineY, rc.x + rc.width, dropLineY);
        g2d.drawLine(rc.x, dropLineY - 2, rc.x, dropLineY + 2);
        g2d.drawLine(rc.x + rc.width, dropLineY - 2, rc.x + rc.width, dropLineY + 2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension s = this.getEmptyText().getPreferredSize();
        JBInsets.addTo((Dimension)s, (Insets)this.getInsets());
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(s.width, size.width), Math.max(s.height, size.height));
    }

    protected final Dimension super_getPreferredSize() {
        return super.getPreferredSize();
    }

    private void init() {
        this.setSelectionBackground(UIUtil.getListSelectionBackground((boolean)true));
        this.setSelectionForeground(NamedColorUtil.getListSelectionForeground((boolean)true));
        this.installDefaultCopyAction();
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBList.this.isEmpty();
            }
        };
        this.putClientProperty(UIUtil.NOT_IN_HIERARCHY_COMPONENTS, this.myEmptyText.getWrappedFragmentsIterable());
        this.myExpandableItemsHandler = this.createExpandableItemsHandler();
        this.setCellRenderer(new DefaultListCellRenderer());
    }

    private void installDefaultCopyAction() {
        Action copy = this.getActionMap().get("copy");
        if (copy == null || copy instanceof UIResource) {
            AbstractAction newCopy = new AbstractAction(){

                @Override
                public boolean isEnabled() {
                    return JBList.this.getSelectedIndex() != -1;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBList.this.doCopyToClipboardAction();
                }
            };
            this.getActionMap().put("copy", newCopy);
        }
    }

    protected void doCopyToClipboardAction() {
        ArrayList<String> selected2 = new ArrayList<String>();
        for (int index : this.getSelectedIndices()) {
            Object value2 = this.getModel().getElementAt(index);
            String text = this.itemToText(index, value2);
            if (text == null) continue;
            selected2.add(text);
        }
        if (!selected2.isEmpty()) {
            String text = StringUtil.join(selected2, (String)"\n");
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
        }
    }

    @Nullable
    protected String itemToText(int index, E value2) {
        Component c;
        ListCellRenderer<E> renderer = this.getCellRenderer();
        Component component = c = renderer == null ? null : renderer.getListCellRendererComponent(this, value2, index, true, true);
        if (c != null) {
            c = ExpandedItemRendererComponentWrapper.unwrap(c);
        }
        if (c instanceof KotlinUIDslRendererComponent) {
            KotlinUIDslRendererComponent uiDslRendererComponent = (KotlinUIDslRendererComponent)((Object)c);
            return uiDslRendererComponent.getCopyText();
        }
        SimpleColoredComponent coloredComponent = null;
        if (c instanceof JComponent) {
            coloredComponent = (SimpleColoredComponent)UIUtil.findComponentOfType((JComponent)((JComponent)c), SimpleColoredComponent.class);
        }
        return coloredComponent != null ? coloredComponent.getCharSequence(true).toString() : (c instanceof JTextComponent ? ((JTextComponent)c).getText() : (c instanceof JLabel ? ((JLabel)c).getText() : (value2 != null ? value2.toString() : null)));
    }

    public boolean isEmpty() {
        return this.getItemsCount() == 0;
    }

    public int getItemsCount() {
        ListModel model = this.getModel();
        return model == null ? 0 : model.getSize();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            JBList.$$$reportNull$$$0(7);
        }
        return statusText;
    }

    public void setEmptyText(@NlsContexts.StatusText @NotNull String text) {
        if (text == null) {
            JBList.$$$reportNull$$$0(8);
        }
        this.myEmptyText.setText(text);
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            JBList.$$$reportNull$$$0(9);
        }
        return expandableItemsHandler;
    }

    @NotNull
    protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        if (expandableItemsHandler == null) {
            JBList.$$$reportNull$$$0(10);
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public void setCellRenderer(@NotNull ListCellRenderer<? super E> cellRenderer) {
        if (cellRenderer == null) {
            JBList.$$$reportNull$$$0(11);
        }
        if (this.myExpandableItemsHandler == null) {
            super.setCellRenderer(cellRenderer);
            return;
        }
        super.setCellRenderer(new ExpandedItemListCellRendererWrapper<E>(cellRenderer, this.myExpandableItemsHandler));
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        return JBList.adjustIncrement(visibleRect, orientation, direction, increment);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment = super.getScrollableBlockIncrement(visibleRect, orientation, direction);
        return JBList.adjustIncrement(visibleRect, orientation, direction, increment);
    }

    private static int adjustIncrement(Rectangle visibleRect, int orientation, int direction, int increment) {
        if (increment == 0 && orientation == 1 && direction < 0) {
            return visibleRect.y;
        }
        return increment;
    }

    public void installCellRenderer(@NotNull @NotNull Function<? super E, ? extends @NotNull JComponent> fun) {
        if (fun == null) {
            JBList.$$$reportNull$$$0(12);
        }
        this.setCellRenderer(new SelectionAwareListCellRenderer<E>(fun));
    }

    @Deprecated(forRemoval=true)
    public void installCellRenderer(@NotNull NotNullFunction<? super E, ? extends JComponent> fun) {
        if (fun == null) {
            JBList.$$$reportNull$$$0(13);
        }
        this.installCellRenderer((Function<? super E, ? extends JComponent>)fun);
    }

    public void disableEmptyText() {
        this.getEmptyText().setText("");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBList();
        }
        return this.accessibleContext;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        SpeedSearchSupply supply = SpeedSearchSupply.getSupply(this, true);
        if (supply == null) {
            return null;
        }
        return supply.getInputMethodRequests();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listData";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetFromElementTopForDnD";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultListModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandableItemsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultListModel";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setOffsetFromElementTopForDnD";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installCellRenderer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    protected class AccessibleJBList
    extends JList.AccessibleJList {
        protected AccessibleJBList() {
            super(JBList.this);
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            return this.getAccessibleChild(JBList.this.locationToIndex(p));
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return i < 0 || i >= JBList.this.getModel().getSize() ? null : new AccessibleJBListChild(this, JBList.this, i);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return (AccessibleRole)UIUtil.invokeAndWaitIfNeeded(() -> super.getAccessibleRole());
        }

        /*
         * Signature claims super is javax.swing.JList$AccessibleJList.AccessibleJListChild, not javax.swing.JList$AccessibleJList$AccessibleJListChild - discarding signature.
         */
        protected class AccessibleJBListChild
        extends JList.AccessibleJList.AccessibleJListChild {
            public AccessibleJBListChild(AccessibleJBList this$1, JBList<E> parent, int indexInParent) {
                super(this$1, parent, indexInParent);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return (AccessibleRole)UIUtil.invokeAndWaitIfNeeded(() -> super.getAccessibleRole());
            }
        }
    }

    public static class StripedListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, cellHasFocus);
            if (!isSelected && index % 2 == 0) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            return this;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContextDelegateWithContextMenu(super.getAccessibleContext()){

                    protected void doShowContextMenu() {
                        ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, null, null, true);
                    }

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }
                };
            }
            return this.accessibleContext;
        }
    }
}

