/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.ScrollBarPainter;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.components.ScrollSource;
import com.intellij.ui.scroll.LatchingScroll;
import com.intellij.ui.scroll.MouseWheelSmoothScroll;
import com.intellij.ui.scroll.TouchScroll;
import com.intellij.ui.scroll.TouchScrollUtil;
import com.intellij.ui.tabs.impl.IslandsPainterProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class JBScrollPane
extends JScrollPane {
    public static final Key<Boolean> IGNORE_SCROLLBAR_IN_INSETS = Key.create((String)"IGNORE_SCROLLBAR_IN_INSETS");
    public static final Key<Boolean> IGNORE_SCROLL_LATCHING = Key.create((String)"IGNORE_SCROLL_LATCHING");
    @ApiStatus.Experimental
    public static final Key<Boolean> FORCE_HORIZONTAL_SCROLL = Key.create((String)"FORCE_SHIFT_ON_SCROLL");
    private static final Logger LOG = Logger.getInstance(JBScrollPane.class);
    private static final String STATUS_COMPONENT = "STATUS_COMPONENT";
    private ScrollSource myScrollSource = ScrollSource.UNKNOWN;
    private double myWheelRotation;
    private int myViewportBorderWidth = -1;
    private volatile boolean myBackgroundRequested;
    private boolean myIsOverlappingScrollBar = false;
    private boolean paintBorderAllowed;
    protected JComponent statusComponent;
    private static final int SCROLL_MODIFIERS = -1106;

    public JBScrollPane(int viewportWidth) {
        this.init(false);
        this.myViewportBorderWidth = viewportWidth;
        this.updateViewportBorder();
    }

    public JBScrollPane() {
        this.init();
    }

    public JBScrollPane(Component view) {
        super(view);
        this.init();
    }

    public JBScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    public JBScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground() {
        JViewport child;
        Color color = super.getBackground();
        if (!this.myBackgroundRequested && EventQueue.isDispatchThread() && ((Boolean)ScrollSettings.isBackgroundFromView.invoke()).booleanValue() && (!this.isBackgroundSet() || color instanceof UIResource) && (child = this.getViewport()) != null) {
            try {
                this.myBackgroundRequested = true;
                Color color2 = child.getBackground();
                return color2;
            }
            finally {
                this.myBackgroundRequested = false;
            }
        }
        return color;
    }

    public boolean isOverlappingScrollBar() {
        return this.myIsOverlappingScrollBar;
    }

    public void setOverlappingScrollBar(boolean overlappingScrollBar) {
        boolean oldValue = this.myIsOverlappingScrollBar;
        this.myIsOverlappingScrollBar = overlappingScrollBar;
        if (oldValue != this.myIsOverlappingScrollBar) {
            this.revalidate();
            this.repaint();
        }
    }

    static Color getViewBackground(JScrollPane pane) {
        if (pane == null) {
            return null;
        }
        JViewport viewport = pane.getViewport();
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        if (view == null) {
            return null;
        }
        return view.getBackground();
    }

    private void init() {
        this.init(true);
    }

    private void init(boolean setupCorners) {
        this.setLayout(this.createLayout());
        if (setupCorners) {
            this.setupCorners();
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    protected Layout createLayout() {
        return new Layout();
    }

    protected void setupCorners() {
        this.setCorner("UPPER_RIGHT_CORNER", new Corner());
        this.setCorner("UPPER_LEFT_CORNER", new Corner());
        this.setCorner("LOWER_RIGHT_CORNER", new Corner());
        this.setCorner("LOWER_LEFT_CORNER", new Corner());
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        this.updateViewportBorder();
        if (ui instanceof BasicScrollPaneUI) {
            try {
                Field field = BasicScrollPaneUI.class.getDeclaredField("mouseScrollListener");
                field.setAccessible(true);
                Object value2 = field.get(ui);
                if (value2 instanceof MouseWheelListener) {
                    MouseWheelListener oldListener = (MouseWheelListener)value2;
                    JBMouseWheelListener newListener = new JBMouseWheelListener(oldListener);
                    field.set(ui, newListener);
                    this.removeMouseWheelListener(oldListener);
                    this.addMouseWheelListener(newListener);
                }
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
        }
    }

    public void setStatusComponent(JComponent statusComponent) {
        JComponent old = this.getStatusComponent();
        this.statusComponent = statusComponent;
        if (statusComponent != null) {
            this.add((Component)statusComponent, STATUS_COMPONENT);
        } else if (old != null) {
            this.remove(old);
        }
        this.firePropertyChange("statusComponent", old, statusComponent);
        this.revalidate();
        this.repaint();
    }

    public JComponent getStatusComponent() {
        return this.statusComponent;
    }

    @Override
    public void paint(Graphics g) {
        this.paintBorderAllowed = !this.isBorderOverComponents();
        super.paint(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.paintBorderAllowed) {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isBorderOverComponents()) {
            this.paintBorderAllowed = true;
            this.paintBorder(g);
        }
    }

    private boolean isBorderOverComponents() {
        Border border = this.getBorder();
        return border != null && border.getClass().getName().contains("DarculaScrollPaneBorder");
    }

    @NotNull
    private static MouseWheelEvent withShiftModifier(@NotNull MouseWheelEvent event) {
        if (event == null) {
            JBScrollPane.$$$reportNull$$$0(0);
        }
        MouseWheelEvent mouseWheelEvent = MouseEventAdapter.convert((MouseWheelEvent)event, (Component)((JComponent)event.getSource()), (int)event.getID(), (long)event.getWhen(), (int)(UIUtil.getAllModifiers((InputEvent)event) | 0x40), (int)event.getX(), (int)event.getY());
        if (mouseWheelEvent == null) {
            JBScrollPane.$$$reportNull$$$0(1);
        }
        return mouseWheelEvent;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return JBScrollPane.isOptimizedDrawingEnabledFor(this.getVerticalScrollBar()) && JBScrollPane.isOptimizedDrawingEnabledFor(this.getHorizontalScrollBar());
    }

    private static boolean isOptimizedDrawingEnabledFor(JScrollBar bar) {
        return bar == null || !bar.isVisible() || bar.isOpaque() && bar.isOptimizedDrawingEnabled();
    }

    private void updateViewportBorder() {
        if (this.getViewportBorder() instanceof ViewportBorder) {
            this.setViewportBorder(new ViewportBorder(this.myViewportBorderWidth >= 0 ? this.myViewportBorderWidth : 1));
        }
    }

    public static ViewportBorder createIndentBorder() {
        return new ViewportBorder(2);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new JBScrollBar(1);
    }

    @Override
    @NotNull
    public JScrollBar createHorizontalScrollBar() {
        return new JBScrollBar(0);
    }

    @Override
    protected JViewport createViewport() {
        return new JBViewport();
    }

    public static boolean canBePreprocessed(@NotNull MouseEvent e, @NotNull JScrollBar bar) {
        if (e == null) {
            JBScrollPane.$$$reportNull$$$0(2);
        }
        if (bar == null) {
            JBScrollPane.$$$reportNull$$$0(3);
        }
        if (e.getID() == 503 || e.getID() == 501) {
            ScrollBarUI ui = bar.getUI();
            if (ui instanceof BasicScrollBarUI) {
                BasicScrollBarUI bui = (BasicScrollBarUI)ui;
                try {
                    Rectangle rect = (Rectangle)ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.class, (String)"getThumbBounds", (Class[])ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)bui, new Object[0]);
                    Point point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), bar);
                    return !rect.contains(point);
                }
                catch (Exception e1) {
                    return true;
                }
            }
            if (ui instanceof DefaultScrollBarUI) {
                DefaultScrollBarUI dui = (DefaultScrollBarUI)ui;
                Point point = e.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, bar);
                return !dui.isThumbContains(point.x, point.y);
            }
        }
        return true;
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        boolean hasAbsoluteDelta = (Boolean)ScrollSettings.isPixelPerfectEnabled.invoke();
        this.myScrollSource = hasAbsoluteDelta ? ScrollSource.TOUCHPAD : ScrollSource.MOUSE_WHEEL;
        this.myWheelRotation = e.getPreciseWheelRotation();
        super.processMouseWheelEvent(e);
        this.myScrollSource = ScrollSource.UNKNOWN;
    }

    int getInitialDelay(boolean valueIsAdjusting) {
        ScrollSource source = valueIsAdjusting ? ScrollSource.SCROLLBAR : this.myScrollSource;
        return source.getInterpolationDelay(this.myWheelRotation);
    }

    public static boolean isScrollEvent(@NotNull MouseWheelEvent event) {
        boolean ignore;
        if (event == null) {
            JBScrollPane.$$$reportNull$$$0(4);
        }
        if (event.isConsumed()) {
            return false;
        }
        boolean bl = ignore = event.getWheelRotation() == 0;
        if (ignore && (((Boolean)ScrollSettings.isPixelPerfectEnabled.invoke()).booleanValue() || ((Boolean)ScrollSettings.isHighPrecisionEnabled.invoke()).booleanValue())) {
            double rotation = event.getPreciseWheelRotation();
            ignore = rotation == 0.0 || !Double.isFinite(rotation);
        }
        return !ignore && 0 == (0xFFFFFBAE & event.getModifiers());
    }

    @ApiStatus.Internal
    public static RegionPainter<Float> getThumbPainter(@NotNull Supplier<? extends Component> supplier, @NotNull CoroutineScope coroutineScope) {
        if (supplier == null) {
            JBScrollPane.$$$reportNull$$$0(5);
        }
        if (coroutineScope == null) {
            JBScrollPane.$$$reportNull$$$0(6);
        }
        IslandsPainterProvider provider = IslandsPainterProvider.getInstance();
        return new ScrollBarPainter.Thumb(supplier, SystemInfoRt.isMac || provider != null && provider.useMacScrollBar(), coroutineScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBScrollPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBScrollPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withShiftModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withShiftModifier";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBePreprocessed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isScrollEvent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getThumbPainter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Layout
    extends ScrollPaneLayout {
        private static final Insets EMPTY_INSETS = JBInsets.emptyInsets();
        protected Component statusComponent;

        @Override
        public void syncWithScrollPane(JScrollPane sp) {
            super.syncWithScrollPane(sp);
            if (sp instanceof JBScrollPane) {
                this.statusComponent = ((JBScrollPane)sp).getStatusComponent();
            }
        }

        @Override
        public void addLayoutComponent(String s, Component c) {
            if (s.equals(JBScrollPane.STATUS_COMPONENT)) {
                this.statusComponent = this.addSingletonComponent(this.statusComponent, c);
            } else {
                super.addLayoutComponent(s, c);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle lower;
            boolean hasStatusComponent;
            Dimension viewPreferredSize;
            Border border;
            boolean hsbOnTop;
            JScrollPane pane = (JScrollPane)parent;
            Rectangle viewportBounds = new Rectangle(pane.getWidth(), pane.getHeight());
            boolean isOverlappingScrollBar = Layout.isOverlappingScrollBar(pane);
            @NotNull Rectangle wholePaneBounds = viewportBounds.getBounds();
            JBInsets.removeFrom((Rectangle)viewportBounds, (Insets)pane.getInsets());
            Object property = pane.getClientProperty(Flip.class);
            Flip flip = property instanceof Flip ? (Flip)((Object)property) : Flip.NONE;
            boolean bl = hsbOnTop = flip == Flip.BOTH || flip == Flip.VERTICAL;
            boolean vsbOnLeft = pane.getComponentOrientation().isLeftToRight() ? flip == Flip.BOTH || flip == Flip.HORIZONTAL : flip == Flip.NONE || flip == Flip.VERTICAL;
            Rectangle rowHeadBounds = new Rectangle(viewportBounds.x, 0, 0, 0);
            if (this.rowHead != null && this.rowHead.isVisible()) {
                rowHeadBounds.width = Layout.min(viewportBounds.width, this.rowHead.getPreferredSize().width);
                viewportBounds.width -= rowHeadBounds.width;
                if (vsbOnLeft) {
                    rowHeadBounds.x += viewportBounds.width;
                } else {
                    viewportBounds.x += rowHeadBounds.width;
                }
            }
            Rectangle colHeadBounds = new Rectangle(0, viewportBounds.y, 0, 0);
            if (this.colHead != null && this.colHead.isVisible()) {
                colHeadBounds.height = Layout.min(viewportBounds.height, this.colHead.getPreferredSize().height);
                viewportBounds.height -= colHeadBounds.height;
                if (hsbOnTop) {
                    colHeadBounds.y += viewportBounds.height;
                } else {
                    viewportBounds.y += colHeadBounds.height;
                }
            }
            Insets insets = (border = pane.getViewportBorder()) == null ? null : border.getBorderInsets(parent);
            JBInsets.removeFrom((Rectangle)viewportBounds, (Insets)insets);
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            boolean isEmpty = viewportBounds.width < 0 || viewportBounds.height < 0;
            Component view = this.viewport == null ? null : this.viewport.getView();
            Dimension dimension = viewPreferredSize = view == null ? new Dimension() : view.getPreferredSize();
            if (view instanceof JComponent && !view.isPreferredSizeSet()) {
                JBInsets.removeFrom((Dimension)viewPreferredSize, (Insets)JBViewport.getViewInsets((JComponent)view));
            }
            Dimension viewportExtentSize = this.viewport == null ? new Dimension() : this.viewport.toViewCoordinates(viewportBounds.getSize());
            Point viewLocation = new Point();
            if (view != null) {
                viewLocation = view.getLocation(viewLocation);
            }
            boolean vsbRequiresSpace = false;
            boolean vsbNeeded = false;
            int vsbPolicy = pane.getVerticalScrollBarPolicy();
            if (!isEmpty && vsbPolicy != 21) {
                vsbNeeded = vsbPolicy == 22 || Layout.isVerticalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize);
            }
            Rectangle vsbBounds = new Rectangle(0, viewportBounds.y - insets.top, 0, 0);
            if (this.vsb != null) {
                if (Layout.isAlwaysOpaque(view)) {
                    this.vsb.setOpaque(true);
                }
                boolean bl2 = vsbRequiresSpace = this.vsb.isOpaque() && !isOverlappingScrollBar;
                if (vsbNeeded) {
                    this.adjustForVSB(viewportBounds, insets, vsbBounds, vsbRequiresSpace, vsbOnLeft, isOverlappingScrollBar, wholePaneBounds);
                    if (vsbRequiresSpace && this.viewport != null) {
                        viewportExtentSize = this.viewport.toViewCoordinates(viewportBounds.getSize());
                    }
                }
            }
            boolean hsbRequiresSpace = false;
            boolean hsbNeeded = false;
            int hsbPolicy = pane.getHorizontalScrollBarPolicy();
            if (!isEmpty && hsbPolicy != 31) {
                hsbNeeded = hsbPolicy == 32 || Layout.isHorizontalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize);
            }
            Rectangle hsbBounds = new Rectangle(viewportBounds.x - insets.left, 0, 0, 0);
            if (this.hsb != null) {
                if (Layout.isAlwaysOpaque(view)) {
                    this.hsb.setOpaque(true);
                }
                boolean bl3 = hsbRequiresSpace = this.hsb.isOpaque() && !isOverlappingScrollBar;
                if (hsbNeeded) {
                    this.adjustForHSB(viewportBounds, insets, hsbBounds, hsbRequiresSpace, hsbOnTop, isOverlappingScrollBar, wholePaneBounds);
                    if (this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                        if (!hsbRequiresSpace) {
                            viewPreferredSize.height += hsbBounds.height;
                        } else if (this.viewport != null) {
                            viewportExtentSize = this.viewport.toViewCoordinates(viewportBounds.getSize());
                        }
                        vsbNeeded = Layout.isScrollBarNeeded(viewLocation.y, viewPreferredSize.height, viewportExtentSize.height);
                        if (vsbNeeded) {
                            this.adjustForVSB(viewportBounds, insets, vsbBounds, vsbRequiresSpace, vsbOnLeft, isOverlappingScrollBar, wholePaneBounds);
                        }
                    }
                }
            }
            if (this.viewport != null) {
                this.viewport.setBounds(viewportBounds);
                if (!isEmpty && view instanceof Scrollable) {
                    boolean hsbNeededNew;
                    boolean vsbNeededNew;
                    viewportExtentSize = this.viewport.toViewCoordinates(viewportBounds.getSize());
                    boolean vsbNeededOld = vsbNeeded;
                    if (this.vsb != null && vsbPolicy == 20 && vsbNeeded != (vsbNeededNew = Layout.isVerticalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize))) {
                        vsbNeeded = vsbNeededNew;
                        if (vsbNeeded) {
                            this.adjustForVSB(viewportBounds, insets, vsbBounds, vsbRequiresSpace, vsbOnLeft, isOverlappingScrollBar, wholePaneBounds);
                        } else if (vsbRequiresSpace) {
                            viewportBounds.width += vsbBounds.width;
                        }
                        if (vsbRequiresSpace) {
                            viewportExtentSize = this.viewport.toViewCoordinates(viewportBounds.getSize());
                        }
                    }
                    boolean hsbNeededOld = hsbNeeded;
                    if (this.hsb != null && hsbPolicy == 30 && hsbNeeded != (hsbNeededNew = Layout.isHorizontalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize))) {
                        hsbNeeded = hsbNeededNew;
                        if (hsbNeeded) {
                            this.adjustForHSB(viewportBounds, insets, hsbBounds, hsbRequiresSpace, hsbOnTop, isOverlappingScrollBar, wholePaneBounds);
                        } else if (hsbRequiresSpace) {
                            viewportBounds.height += hsbBounds.height;
                        }
                        if (hsbRequiresSpace && this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                            viewportExtentSize = this.viewport.toViewCoordinates(viewportBounds.getSize());
                            vsbNeeded = Layout.isScrollBarNeeded(viewLocation.y, viewPreferredSize.height, viewportExtentSize.height);
                            if (vsbNeeded) {
                                this.adjustForVSB(viewportBounds, insets, vsbBounds, vsbRequiresSpace, vsbOnLeft, isOverlappingScrollBar, wholePaneBounds);
                            }
                        }
                    }
                    if (hsbNeededOld != hsbNeeded || vsbNeededOld != vsbNeeded) {
                        this.viewport.setBounds(viewportBounds);
                    }
                }
            }
            rowHeadBounds.y = viewportBounds.y - insets.top;
            rowHeadBounds.height = viewportBounds.height + insets.top + insets.bottom;
            boolean fillLowerCorner = false;
            if (this.rowHead != null) {
                if (hsbRequiresSpace) {
                    Component corner = hsbOnTop ? (vsbOnLeft ? this.upperRight : this.upperLeft) : (vsbOnLeft ? this.lowerRight : this.lowerLeft);
                    boolean bl4 = fillLowerCorner = corner == null && UIManager.getBoolean("ScrollPane.fillLowerCorner");
                    if (!fillLowerCorner && ScrollSettings.isHeaderOverCorner(this.viewport)) {
                        if (hsbOnTop) {
                            rowHeadBounds.y -= hsbBounds.height;
                        }
                        rowHeadBounds.height += hsbBounds.height;
                    }
                }
                this.rowHead.setBounds(rowHeadBounds);
                this.rowHead.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.RIGHT : Alignment.LEFT));
            }
            colHeadBounds.x = viewportBounds.x - insets.left;
            colHeadBounds.width = viewportBounds.width + insets.left + insets.right;
            boolean fillUpperCorner = false;
            boolean bl5 = hasStatusComponent = this.statusComponent != null && this.statusComponent.isShowing();
            if (this.colHead != null) {
                if (vsbRequiresSpace) {
                    Component corner = vsbOnLeft ? (hsbOnTop ? this.lowerLeft : this.upperLeft) : (hsbOnTop ? this.lowerRight : this.upperRight);
                    boolean bl6 = fillUpperCorner = corner == null && UIManager.getBoolean("ScrollPane.fillUpperCorner") && !hasStatusComponent;
                    if (!fillUpperCorner && ScrollSettings.isHeaderOverCorner(this.viewport)) {
                        if (vsbOnLeft) {
                            colHeadBounds.x -= vsbBounds.width;
                        }
                        colHeadBounds.width += vsbBounds.width;
                    }
                }
                this.colHead.setBounds(colHeadBounds);
                this.colHead.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.BOTTOM : Alignment.TOP));
            }
            int overlapWidth = 0;
            int overlapHeight = 0;
            if (vsbNeeded && !vsbRequiresSpace && hsbNeeded && !hsbRequiresSpace) {
                overlapWidth = vsbBounds.width;
            }
            vsbBounds.y = viewportBounds.y - insets.top;
            vsbBounds.height = viewportBounds.height + insets.top + insets.bottom;
            Rectangle actualVsbBounds = new Rectangle(vsbBounds);
            if (this.vsb != null) {
                this.vsb.setVisible(vsbNeeded);
                if (vsbNeeded) {
                    if (fillUpperCorner) {
                        if (!hsbOnTop) {
                            vsbBounds.y -= colHeadBounds.height;
                        }
                        vsbBounds.height += colHeadBounds.height;
                    }
                    int overlapY = !hsbOnTop ? 0 : overlapHeight;
                    actualVsbBounds.y += overlapY;
                    actualVsbBounds.height -= overlapHeight;
                    this.vsb.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.LEFT : Alignment.RIGHT));
                }
                if (!vsbRequiresSpace) {
                    if (!vsbOnLeft) {
                        vsbBounds.x += vsbBounds.width;
                    }
                    vsbBounds.width = 0;
                }
            }
            hsbBounds.x = viewportBounds.x - insets.left;
            hsbBounds.width = viewportBounds.width + insets.left + insets.right;
            if (this.hsb != null) {
                this.hsb.setVisible(hsbNeeded);
                if (hsbNeeded) {
                    if (fillLowerCorner) {
                        if (!vsbOnLeft) {
                            hsbBounds.x -= rowHeadBounds.width;
                        }
                        hsbBounds.width += rowHeadBounds.width;
                    }
                    int overlapX = !vsbOnLeft ? 0 : overlapWidth;
                    this.hsb.setBounds(hsbBounds.x + overlapX, hsbBounds.y, hsbBounds.width - overlapWidth, hsbBounds.height);
                    this.hsb.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.TOP : Alignment.BOTTOM));
                }
                if (!hsbRequiresSpace) {
                    if (!hsbOnTop) {
                        hsbBounds.y += hsbBounds.height;
                    }
                    hsbBounds.height = 0;
                }
            }
            if (hasStatusComponent) {
                Dimension scSize = this.statusComponent.getPreferredSize();
                switch (flip.ordinal()) {
                    case 0: {
                        this.statusComponent.setBounds(actualVsbBounds.x + actualVsbBounds.width - scSize.width, actualVsbBounds.y, scSize.width, scSize.height);
                        actualVsbBounds.y += scSize.height;
                        break;
                    }
                    case 2: {
                        this.statusComponent.setBounds(actualVsbBounds.x, actualVsbBounds.y, scSize.width, scSize.height);
                        actualVsbBounds.y += scSize.height;
                        break;
                    }
                    case 1: {
                        this.statusComponent.setBounds(actualVsbBounds.x + actualVsbBounds.width - scSize.width, actualVsbBounds.y + actualVsbBounds.height - scSize.height, scSize.width, scSize.height);
                        break;
                    }
                    case 3: {
                        this.statusComponent.setBounds(actualVsbBounds.x, actualVsbBounds.y + actualVsbBounds.height - scSize.height, scSize.width, scSize.height);
                    }
                }
                actualVsbBounds.height -= scSize.height;
            }
            if (this.vsb != null && vsbNeeded) {
                this.vsb.setBounds(actualVsbBounds);
            }
            Rectangle left = vsbOnLeft ? vsbBounds : rowHeadBounds;
            Rectangle right = vsbOnLeft ? rowHeadBounds : vsbBounds;
            Rectangle upper = hsbOnTop ? hsbBounds : colHeadBounds;
            Rectangle rectangle = lower = hsbOnTop ? colHeadBounds : hsbBounds;
            if (this.lowerLeft != null) {
                Rectangle lowerLeftBounds = new Rectangle(left.x, left.y + left.height, 0, 0);
                if (left.width > 0 && lower.height > 0) {
                    Layout.updateCornerBounds(lowerLeftBounds, lower.x, lower.y + lower.height);
                }
                this.lowerLeft.setBounds(lowerLeftBounds);
            }
            if (this.lowerRight != null) {
                Rectangle lowerRightBounds = new Rectangle(lower.x + lower.width, right.y + right.height, 0, 0);
                if (right.width > 0 && lower.height > 0) {
                    Layout.updateCornerBounds(lowerRightBounds, right.x + right.width, lower.y + lower.height);
                }
                this.lowerRight.setBounds(lowerRightBounds);
            }
            if (this.upperLeft != null) {
                Rectangle upperLeftBounds = new Rectangle(left.x, upper.y, 0, 0);
                if (left.width > 0 && upper.height > 0) {
                    Layout.updateCornerBounds(upperLeftBounds, upper.x, left.y);
                }
                this.upperLeft.setBounds(upperLeftBounds);
            }
            if (this.upperRight != null) {
                Rectangle upperRightBounds = new Rectangle(upper.x + upper.width, upper.y, 0, 0);
                if (right.width > 0 && upper.height > 0) {
                    Layout.updateCornerBounds(upperRightBounds, right.x + right.width, right.y);
                }
                this.upperRight.setBounds(upperRightBounds);
            }
            if (!vsbRequiresSpace && vsbNeeded || !hsbRequiresSpace && hsbNeeded) {
                Layout.fixComponentZOrder(this.vsb, 0);
                Layout.fixComponentZOrder(this.viewport, -1);
            } else if (hasStatusComponent) {
                Layout.fixComponentZOrder(this.statusComponent, 0);
                Layout.fixComponentZOrder(this.viewport, -1);
            }
        }

        private static boolean tracksViewportWidth(Component view) {
            return view instanceof Scrollable && ((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
        }

        private static boolean tracksViewportHeight(Component view) {
            return view instanceof Scrollable && ((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component view;
            Dimension result2 = new Dimension();
            JScrollPane pane = (JScrollPane)parent;
            JBInsets.addTo((Dimension)result2, (Insets)pane.getInsets());
            Border border = pane.getViewportBorder();
            if (border != null) {
                JBInsets.addTo((Dimension)result2, (Insets)border.getBorderInsets(parent));
            }
            int vsbPolicy = pane.getVerticalScrollBarPolicy();
            int hsbPolicy = pane.getHorizontalScrollBarPolicy();
            if (this.viewport != null && (view = this.viewport.getView()) != null) {
                Point viewLocation = view.getLocation();
                Dimension viewportExtentSize = Layout.calculatePreferredSize(this.viewport);
                Dimension viewPreferredSize = Layout.calculatePreferredSize(view);
                if (view instanceof JComponent && !view.isPreferredSizeSet()) {
                    JBInsets.removeFrom((Dimension)viewPreferredSize, (Insets)JBViewport.getViewInsets((JComponent)view));
                }
                result2.width += viewportExtentSize.width;
                result2.height += viewportExtentSize.height;
                if (vsbPolicy == 20 && viewportExtentSize.height < viewPreferredSize.height && Layout.isVerticalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize)) {
                    vsbPolicy = 22;
                }
                if (hsbPolicy == 30 && viewportExtentSize.width < viewPreferredSize.width && Layout.isHorizontalScrollBarNeeded(view, viewLocation, viewPreferredSize, viewportExtentSize)) {
                    hsbPolicy = 32;
                }
            }
            boolean isOverlappingScrollBar = Layout.isOverlappingScrollBar(pane);
            if (this.vsb != null && vsbPolicy == 22 && this.vsb.isEnabled() && !isOverlappingScrollBar) {
                result2.width += this.vsb.getPreferredSize().width;
            }
            if (this.hsb != null && hsbPolicy == 32 && this.hsb.isEnabled() && !isOverlappingScrollBar) {
                result2.height += this.hsb.getPreferredSize().height;
            }
            if (this.rowHead != null && this.rowHead.isVisible()) {
                result2.width += this.rowHead.getPreferredSize().width;
            }
            if (this.colHead != null && this.colHead.isVisible()) {
                result2.height += this.colHead.getPreferredSize().height;
            }
            return result2;
        }

        private static Dimension calculatePreferredSize(Component component) {
            Dimension maximumSize;
            Dimension preferredSize = component.getPreferredSize();
            if (preferredSize == null) {
                preferredSize = new Dimension();
            }
            if ((maximumSize = component.getMaximumSize()) != null) {
                if (maximumSize.width != Short.MAX_VALUE && maximumSize.width != Integer.MAX_VALUE) {
                    preferredSize.width = Math.min(maximumSize.width, preferredSize.width);
                }
                if (maximumSize.height != Short.MAX_VALUE && maximumSize.height != Integer.MAX_VALUE) {
                    preferredSize.height = Math.min(maximumSize.height, preferredSize.height);
                }
            }
            return preferredSize;
        }

        private static boolean isOverlappingScrollBar(JScrollPane scrollPane2) {
            return scrollPane2 instanceof JBScrollPane && ((JBScrollPane)scrollPane2).isOverlappingScrollBar();
        }

        private static boolean isAlwaysOpaque(Component view) {
            return !SystemInfo.isMac && ScrollSettings.isNotSupportedYet(view);
        }

        private static void updateCornerBounds(Rectangle bounds, int x, int y) {
            bounds.width = Math.abs(bounds.x - x);
            bounds.height = Math.abs(bounds.y - y);
            bounds.x = Math.min(bounds.x, x);
            bounds.y = Math.min(bounds.y, y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void fixComponentZOrder(Component component, int index) {
            if (component != null) {
                Container parent = component.getParent();
                Object object = parent.getTreeLock();
                synchronized (object) {
                    if (index < 0) {
                        index += parent.getComponentCount();
                    }
                    parent.setComponentZOrder(component, index);
                }
            }
        }

        private void adjustForVSB(Rectangle bounds, Insets insets, Rectangle vsbBounds, boolean vsbRequiresSpace, boolean vsbOnLeft, boolean vsbOverlapping, @NotNull Rectangle wholePaneBounds) {
            if (wholePaneBounds == null) {
                Layout.$$$reportNull$$$0(0);
            }
            int n = vsbBounds.width = this.vsb.isEnabled() ? Layout.min(bounds.width, this.vsb.getPreferredSize().width) : 0;
            if (vsbOnLeft) {
                vsbBounds.x = vsbOverlapping ? 0 : bounds.x - insets.left;
                if (vsbRequiresSpace) {
                    bounds.x += vsbBounds.width;
                }
            } else {
                vsbBounds.x = vsbOverlapping ? wholePaneBounds.x + wholePaneBounds.width - vsbBounds.width : bounds.x + bounds.width + insets.right - vsbBounds.width;
            }
            if (vsbRequiresSpace) {
                bounds.width -= vsbBounds.width;
            }
        }

        private void adjustForHSB(Rectangle bounds, Insets insets, Rectangle hsbBounds, boolean hsbRequiresSpace, boolean hsbOnTop, boolean hsbOverlapping, @NotNull Rectangle wholePaneBounds) {
            if (wholePaneBounds == null) {
                Layout.$$$reportNull$$$0(1);
            }
            int n = hsbBounds.height = this.hsb.isEnabled() ? Layout.min(bounds.height, this.hsb.getPreferredSize().height) : 0;
            if (hsbOnTop) {
                hsbBounds.y = hsbOverlapping ? 0 : bounds.y - insets.top;
                if (hsbRequiresSpace) {
                    bounds.y += hsbBounds.height;
                }
            } else {
                hsbBounds.y = hsbOverlapping ? wholePaneBounds.y + wholePaneBounds.height - hsbBounds.height : bounds.y + bounds.height + insets.bottom - hsbBounds.height;
            }
            if (hsbRequiresSpace) {
                bounds.height -= hsbBounds.height;
            }
        }

        private static int min(int one, int two) {
            return Math.max(0, Math.min(one, two));
        }

        private static boolean isScrollBarNeeded(int location, int preferredSize, int extentSize) {
            return preferredSize > extentSize || location != 0;
        }

        private static boolean isHorizontalScrollBarNeeded(Component view, Point location, Dimension preferredSize, Dimension extentSize) {
            return Layout.isScrollBarNeeded(location.x, preferredSize.width, extentSize.width) && !Layout.tracksViewportWidth(view);
        }

        private static boolean isVerticalScrollBarNeeded(Component view, Point location, Dimension preferredSize, Dimension extentSize) {
            return Layout.isScrollBarNeeded(location.y, preferredSize.height, extentSize.height) && !Layout.tracksViewportHeight(view);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "wholePaneBounds";
            objectArray2[1] = "com/intellij/ui/components/JBScrollPane$Layout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "adjustForVSB";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "adjustForHSB";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Corner
    extends JPanel {
        Corner() {
            ScrollBarPainter.setBackground(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private static final class JBMouseWheelListener
    implements MouseWheelListener {
        private final MouseWheelListener myDelegate;
        private MouseWheelSmoothScroll mySmoothScroll;
        private TouchScroll myTouchScroll;
        private LatchingScroll myLatchingScroll;

        private JBMouseWheelListener(MouseWheelListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            boolean isScrollEvent = JBScrollPane.isScrollEvent(event);
            boolean isScrollPaneEvent = event.getSource() instanceof JScrollPane;
            if (isScrollEvent && isScrollPaneEvent) {
                boolean isAdjustedDeltaZero;
                JScrollPane pane = (JScrollPane)event.getSource();
                if (Boolean.TRUE.equals(ClientProperty.get((Component)pane, FORCE_HORIZONTAL_SCROLL))) {
                    event = JBScrollPane.withShiftModifier(event);
                }
                JScrollBar bar = event.isShiftDown() ? pane.getHorizontalScrollBar() : pane.getVerticalScrollBar();
                boolean isWheelScrollEnabled = pane.isWheelScrollingEnabled();
                boolean isBarVisible = bar != null && bar.isVisible();
                boolean bl = isAdjustedDeltaZero = bar instanceof JBScrollBar && ((JBScrollBar)bar).getDeltaAdjusted(event) == 0.0;
                if (isWheelScrollEnabled && isBarVisible && !isAdjustedDeltaZero) {
                    if (TouchScrollUtil.isTouchScroll(event)) {
                        if (this.myTouchScroll == null) {
                            this.myTouchScroll = TouchScroll.create();
                        }
                        this.myTouchScroll.processMouseWheelEvent(event, this.myDelegate::mouseWheelMoved);
                    } else if (UISettings.getShadowInstance().getAnimatedScrolling()) {
                        if (this.mySmoothScroll == null) {
                            this.mySmoothScroll = MouseWheelSmoothScroll.create(() -> ScrollSettings.isEligibleFor(pane));
                        }
                        this.mySmoothScroll.processMouseWheelEvent(event, this.myDelegate::mouseWheelMoved);
                    } else {
                        if (LatchingScroll.isEnabled()) {
                            if (this.myLatchingScroll == null) {
                                this.myLatchingScroll = new LatchingScroll();
                            }
                            if (this.myLatchingScroll.shouldBeIgnored(event)) {
                                event.consume();
                            }
                        }
                        if (!(event.isConsumed() || bar instanceof JBScrollBar && ((JBScrollBar)bar).handleMouseWheelEvent(event))) {
                            this.myDelegate.mouseWheelMoved(event);
                        }
                    }
                }
                if (!event.isConsumed()) {
                    MouseEventAdapter.redispatch((MouseEvent)event, (Component)((Component)ComponentUtil.getParentOfType(JScrollPane.class, (Component)pane.getParent())));
                }
            }
        }
    }

    public static class ViewportBorder
    extends LineBorder {
        ViewportBorder(int thickness) {
            super(null, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColor(c);
            super.paintBorder(c, g, x, y, width, height);
        }

        private void updateColor(Component c) {
            if (!(c instanceof JScrollPane)) {
                return;
            }
            this.lineColor = JBScrollPane.getViewBackground((JScrollPane)c);
        }
    }

    public static enum Alignment {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        public static Alignment get(JComponent component) {
            if (component != null) {
                Object property = component.getClientProperty(Alignment.class);
                if (property instanceof Alignment) {
                    Alignment alignment = (Alignment)((Object)property);
                    return alignment;
                }
                Container parent = component.getParent();
                if (parent instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)parent;
                    if (component == pane.getColumnHeader()) {
                        return TOP;
                    }
                    if (component == pane.getHorizontalScrollBar()) {
                        return BOTTOM;
                    }
                    boolean ltr = pane.getComponentOrientation().isLeftToRight();
                    if (component == pane.getVerticalScrollBar()) {
                        return ltr ? RIGHT : LEFT;
                    }
                    if (component == pane.getRowHeader()) {
                        return ltr ? LEFT : RIGHT;
                    }
                }
                if (component instanceof JScrollBar) {
                    JScrollBar bar = (JScrollBar)component;
                    return switch (bar.getOrientation()) {
                        case 0 -> BOTTOM;
                        case 1 -> {
                            if (bar.getComponentOrientation().isLeftToRight()) {
                                yield RIGHT;
                            }
                            yield LEFT;
                        }
                        default -> null;
                    };
                }
            }
            return null;
        }
    }

    public static enum Flip {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }
}

