/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.GridLayoutComponentProperty;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsX;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsXKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.impl.Cell;
import com.intellij.ui.dsl.gridLayout.impl.ComponentCell;
import com.intellij.ui.dsl.gridLayout.impl.GridCell;
import com.intellij.ui.dsl.gridLayout.impl.GridImplKt;
import com.intellij.ui.dsl.gridLayout.impl.LayoutCellData;
import com.intellij.ui.dsl.gridLayout.impl.LayoutData;
import com.intellij.ui.dsl.gridLayout.impl.PreCalculationData;
import com.intellij.ui.dsl.gridLayout.impl.PreferredSizeData;
import com.intellij.ui.dsl.gridLayout.impl.RowBaselineData;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\"\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u001e\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006J\u0014\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020/0.H\u0002J\u001c\u0010-\u001a\u00020\u001c2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020/01H\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\u001c\u00103\u001a\u00020\u001c2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020/0.H\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0006H\u0002J\b\u00105\u001a\u00020\u001cH\u0002J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0010\u00108\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u00108\u001a\u0004\u0018\u00010 2\u0006\u00109\u001a\u00020\u0001JA\u0010:\u001a\u0004\u0018\u0001H;\"\u0004\b\u0000\u0010;2\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00020>\u0012\u0006\u0012\u0004\u0018\u0001H;0=2\u0014\u0010?\u001a\u0010\u0012\u0004\u0012\u00020@\u0012\u0006\u0012\u0004\u0018\u0001H;0=H\u0002\u00a2\u0006\u0002\u0010AJ \u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J \u0010H\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0002J\u001c\u0010M\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010N\u001a\u0004\u0018\u00010 H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/GridImpl;", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "<init>", "()V", "resizableColumns", "", "", "getResizableColumns", "()Ljava/util/Set;", "resizableRows", "getResizableRows", "columnsGaps", "", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;", "getColumnsGaps", "()Ljava/util/List;", "rowsGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "getRowsGaps", "visible", "", "getVisible", "()Z", "layoutData", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutData;", "cells", "Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "register", "", "component", "Ljavax/swing/JComponent;", "constraints", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "setConstraints", "registerSubGrid", "unregister", "getPreferredSizeData", "Lcom/intellij/ui/dsl/gridLayout/impl/PreferredSizeData;", "parentInsets", "Ljava/awt/Insets;", "layout", "width", "height", "x", "y", "collectPreCalculationData", "", "Lcom/intellij/ui/dsl/gridLayout/impl/PreCalculationData;", "preCalculationDataMap", "", "calculatePreferredLayoutData", "calculateLayoutDataStep1", "calculateLayoutDataStep2", "calculateLayoutDataStep3", "calculateLayoutDataStep4", "calculateOutsideGaps", "getConstraints", "grid", "recurseFind", "T", "onGrid", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/gridLayout/impl/GridCell;", "onCell", "Lcom/intellij/ui/dsl/gridLayout/impl/ComponentCell;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "calculateBounds", "Ljava/awt/Rectangle;", "layoutCellData", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "offsetX", "offsetY", "calculateBaseline", "verticalAlign", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "rowBaselineData", "Lcom/intellij/ui/dsl/gridLayout/impl/RowBaselineData;", "isEmpty", "skipConstraints", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGridImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridImpl.kt\ncom/intellij/ui/dsl/gridLayout/impl/GridImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,676:1\n1761#2,3:677\n1491#2:680\n1516#2,3:681\n1519#2,3:691\n382#3,7:684\n1#4:694\n1#4:705\n11879#5,9:695\n13805#5:704\n13806#5:706\n11888#5:707\n*S KotlinDebug\n*F\n+ 1 GridImpl.kt\ncom/intellij/ui/dsl/gridLayout/impl/GridImpl\n*L\n27#1:677,3\n131#1:680\n131#1:681,3\n131#1:691,3\n131#1:684,7\n290#1:705\n290#1:695,9\n290#1:704\n290#1:706\n290#1:707\n*E\n"})
public final class GridImpl
implements Grid {
    @NotNull
    private final Set<Integer> resizableColumns = new LinkedHashSet();
    @NotNull
    private final Set<Integer> resizableRows = new LinkedHashSet();
    @NotNull
    private final List<UnscaledGapsX> columnsGaps = new ArrayList();
    @NotNull
    private final List<UnscaledGapsY> rowsGaps = new ArrayList();
    @NotNull
    private final LayoutData layoutData = new LayoutData();
    @NotNull
    private final List<Cell> cells = new ArrayList();

    @Override
    @NotNull
    public Set<Integer> getResizableColumns() {
        return this.resizableColumns;
    }

    @Override
    @NotNull
    public Set<Integer> getResizableRows() {
        return this.resizableRows;
    }

    @Override
    @NotNull
    public List<UnscaledGapsX> getColumnsGaps() {
        return this.columnsGaps;
    }

    @Override
    @NotNull
    public List<UnscaledGapsY> getRowsGaps() {
        return this.rowsGaps;
    }

    public final boolean getVisible() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.cells;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Cell it = (Cell)element$iv;
                    boolean bl2 = false;
                    if (!it.getVisible()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void register(@NotNull JComponent component, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (!GridImpl.isEmpty$default(this, constraints, null, 2, null)) {
            throw new UiDslException("Some cells are occupied already: " + constraints, null, 2, null);
        }
        this.cells.add(new ComponentCell(constraints, component));
    }

    public final void setConstraints(@NotNull JComponent component, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Iterator iterator = ((Iterable)this.cells).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Cell cell = (Cell)iterator.next();
            if (!(cell instanceof ComponentCell) || ((ComponentCell)cell).getComponent() != component) continue;
            if (!this.isEmpty(constraints, cell.getConstraints())) {
                throw new UiDslException("Some cells are occupied already: " + constraints, null, 2, null);
            }
            this.cells.set(i, new ComponentCell(constraints, component));
            return;
        }
    }

    @NotNull
    public final Grid registerSubGrid(@NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (!GridImpl.isEmpty$default(this, constraints, null, 2, null)) {
            throw new UiDslException("Some cells are occupied already: " + constraints, null, 2, null);
        }
        GridImpl result2 = new GridImpl();
        this.cells.add(new GridCell(constraints, result2));
        return result2;
    }

    public final boolean unregister(@NotNull JComponent component) {
        Iterator<Cell> iterator;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Iterator<Cell> iterator2 = iterator = this.cells.iterator();
        while (iterator2.hasNext()) {
            Cell cell = iterator2.next();
            Cell cell2 = cell;
            if (cell2 instanceof ComponentCell) {
                if (!Intrinsics.areEqual((Object)((ComponentCell)cell).getComponent(), (Object)component)) continue;
                iterator.remove();
                return true;
            }
            if (cell2 instanceof GridCell) {
                if (!((GridCell)cell).getContent().unregister(component)) continue;
                return true;
            }
            throw new NoWhenBranchMatchedException();
        }
        return false;
    }

    @NotNull
    public final PreferredSizeData getPreferredSizeData(@NotNull Insets parentInsets) {
        Intrinsics.checkNotNullParameter((Object)parentInsets, (String)"parentInsets");
        this.calculatePreferredLayoutData();
        Gaps outsideGaps = this.layoutData.getOutsideGaps(parentInsets);
        return new PreferredSizeData(new Dimension(this.layoutData.getPreferredWidth() + outsideGaps.getWidth(), this.layoutData.getPreferredHeight() + outsideGaps.getHeight()), outsideGaps);
    }

    public final void layout(int width, int height, @NotNull Insets parentInsets) {
        Intrinsics.checkNotNullParameter((Object)parentInsets, (String)"parentInsets");
        this.calculatePreferredLayoutData();
        Gaps outsideGaps = this.layoutData.getOutsideGaps(parentInsets);
        this.calculateLayoutDataStep2(width - outsideGaps.getWidth());
        this.calculateLayoutDataStep3();
        this.calculateLayoutDataStep4(height - outsideGaps.getHeight());
        this.layout(outsideGaps.getLeft(), outsideGaps.getTop());
    }

    public final void layout(int x, int y) {
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            Rectangle bounds = this.calculateBounds(layoutCellData, x, y);
            Cell cell = layoutCellData.getCell();
            if (cell instanceof ComponentCell) {
                ((ComponentCell)cell).getComponent().setBounds(bounds);
                continue;
            }
            if (cell instanceof GridCell) {
                ((GridCell)cell).getContent().layout(bounds.x, bounds.y);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<JComponent, PreCalculationData> collectPreCalculationData() {
        void $this$groupByTo$iv$iv;
        Map result2 = new LinkedHashMap();
        this.collectPreCalculationData(result2);
        Iterable $this$groupBy$iv = result2.values();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            PreCalculationData it = (PreCalculationData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getConstraints().getWidthGroup();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map widthGroups = destination$iv$iv;
        for (Map.Entry entry : widthGroups.entrySet()) {
            Object element$iv$iv;
            String widthGroup = (String)entry.getKey();
            List preCalculationDataList = (List)entry.getValue();
            if (widthGroup == null) continue;
            element$iv$iv = ((Iterable)preCalculationDataList).iterator();
            if (!element$iv$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            PreCalculationData it = (PreCalculationData)element$iv$iv.next();
            boolean bl = false;
            int n = it.getCalculatedPreferredSize().width;
            while (element$iv$iv.hasNext()) {
                PreCalculationData it2 = (PreCalculationData)element$iv$iv.next();
                $i$a$-maxOf-GridImpl$collectPreCalculationData$maxWidth$1 = false;
                int n2 = it2.getCalculatedPreferredSize().width;
                if (n >= n2) continue;
                n = n2;
            }
            int maxWidth = n;
            for (PreCalculationData preCalculationData : preCalculationDataList) {
                preCalculationData.getCalculatedPreferredSize().width = maxWidth;
            }
        }
        return result2;
    }

    private final void collectPreCalculationData(Map<JComponent, PreCalculationData> preCalculationDataMap) {
        for (Cell cell : this.cells) {
            Cell cell2 = cell;
            if (cell2 instanceof ComponentCell) {
                JComponent component = ((ComponentCell)cell).getComponent();
                if (!component.isVisible()) continue;
                Dimension componentMinimumSize = component.getMinimumSize();
                Dimension componentPreferredSize = component.getPreferredSize();
                Intrinsics.checkNotNull((Object)componentMinimumSize);
                Intrinsics.checkNotNull((Object)componentPreferredSize);
                preCalculationDataMap.put(component, new PreCalculationData(componentMinimumSize, componentPreferredSize, cell.getConstraints()));
                continue;
            }
            if (cell2 instanceof GridCell) {
                ((GridCell)cell).getContent().collectPreCalculationData(preCalculationDataMap);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void calculatePreferredLayoutData() {
        Map<JComponent, PreCalculationData> preCalculationDataMap = this.collectPreCalculationData();
        this.calculateLayoutDataStep1(preCalculationDataMap);
        this.calculateLayoutDataStep2(this.layoutData.getPreferredWidth());
        this.calculateLayoutDataStep3();
        this.calculateLayoutDataStep4(this.layoutData.getPreferredHeight());
        this.calculateOutsideGaps(this.layoutData.getPreferredWidth(), this.layoutData.getPreferredHeight());
    }

    private final void calculateLayoutDataStep1(Map<JComponent, PreCalculationData> preCalculationDataMap) {
        this.layoutData.getColumnsSizeCalculator().reset();
        List visibleCellsData = new ArrayList();
        int columnsCount = 0;
        int rowsCount = 0;
        for (Cell cell : this.cells) {
            Dimension preferredSize = null;
            Cell cell2 = cell;
            if (cell2 instanceof ComponentCell) {
                PreCalculationData preCalculationData;
                JComponent component = ((ComponentCell)cell).getComponent();
                if (!component.isVisible()) continue;
                PreCalculationData preCalculationData2 = preCalculationData = preCalculationDataMap.get(component);
                Intrinsics.checkNotNull((Object)preCalculationData2);
                preferredSize = preCalculationData2.getCalculatedPreferredSize();
            } else if (cell2 instanceof GridCell) {
                GridImpl grid = ((GridCell)cell).getContent();
                if (!grid.getVisible()) continue;
                grid.calculateLayoutDataStep1(preCalculationDataMap);
                preferredSize = new Dimension(grid.layoutData.getPreferredWidth(), 0);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LayoutCellData layoutCellData = null;
            Constraints $this$calculateLayoutDataStep1_u24lambda_u240 = cell.getConstraints();
            boolean bl = false;
            UnscaledGapsX unscaledGapsX = (UnscaledGapsX)CollectionsKt.getOrNull(this.getColumnsGaps(), (int)$this$calculateLayoutDataStep1_u24lambda_u240.getX());
            UnscaledGapsX unscaledGapsX2 = (UnscaledGapsX)CollectionsKt.getOrNull(this.getColumnsGaps(), (int)($this$calculateLayoutDataStep1_u24lambda_u240.getX() + $this$calculateLayoutDataStep1_u24lambda_u240.getWidth() - 1));
            UnscaledGapsY unscaledGapsY = (UnscaledGapsY)CollectionsKt.getOrNull(this.getRowsGaps(), (int)$this$calculateLayoutDataStep1_u24lambda_u240.getY());
            UnscaledGapsY unscaledGapsY2 = (UnscaledGapsY)CollectionsKt.getOrNull(this.getRowsGaps(), (int)($this$calculateLayoutDataStep1_u24lambda_u240.getY() + $this$calculateLayoutDataStep1_u24lambda_u240.getHeight() - 1));
            layoutCellData = new LayoutCellData(cell, preferredSize, UnscaledGapsXKt.UnscaledGapsX(unscaledGapsX != null ? unscaledGapsX.getLeft() : 0, unscaledGapsX2 != null ? unscaledGapsX2.getRight() : 0), UnscaledGapsYKt.UnscaledGapsY(unscaledGapsY != null ? unscaledGapsY.getTop() : 0, unscaledGapsY2 != null ? unscaledGapsY2.getBottom() : 0));
            columnsCount = Math.max(columnsCount, $this$calculateLayoutDataStep1_u24lambda_u240.getX() + $this$calculateLayoutDataStep1_u24lambda_u240.getWidth());
            rowsCount = Math.max(rowsCount, $this$calculateLayoutDataStep1_u24lambda_u240.getY() + $this$calculateLayoutDataStep1_u24lambda_u240.getHeight());
            visibleCellsData.add(layoutCellData);
            this.layoutData.getColumnsSizeCalculator().addConstraint(cell.getConstraints().getX(), cell.getConstraints().getWidth(), layoutCellData.getCellPaddedWidth());
        }
        this.layoutData.setVisibleCellsData(visibleCellsData);
        this.layoutData.setPreferredWidth(this.layoutData.getColumnsSizeCalculator().calculatePreferredSize());
        this.layoutData.getDimension().setSize(columnsCount, rowsCount);
    }

    private final void calculateLayoutDataStep2(int width) {
        this.layoutData.setColumnsCoord(this.layoutData.getColumnsSizeCalculator().calculateCoords(width, this.getResizableColumns()));
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            Cell cell = layoutCellData.getCell();
            if (!(cell instanceof GridCell)) continue;
            ((GridCell)cell).getContent().calculateLayoutDataStep2(this.layoutData.getFullPaddedWidth(layoutCellData));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateLayoutDataStep3() {
        Constraints constraints;
        this.layoutData.getRowsSizeCalculator().reset();
        this.layoutData.getBaselineData().reset();
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            constraints = layoutCellData.getCell().getConstraints();
            layoutCellData.setBaseline(null);
            Cell cell = layoutCellData.getCell();
            if (cell instanceof ComponentCell) {
                if (!GridImplKt.access$isSupportedBaseline(constraints)) continue;
                int componentWidth = this.layoutData.getPaddedWidth(layoutCellData) + layoutCellData.getScaledVisualPaddings().getWidth();
                int baseline = 0;
                if (componentWidth >= 0) {
                    Object object = cell.getConstraints().getComponentHelper();
                    baseline = object != null && (object = object.getBaseline(componentWidth, layoutCellData.getPreferredSize().height)) != null ? ((Integer)object).intValue() : ((ComponentCell)cell).getComponent().getBaseline(componentWidth, layoutCellData.getPreferredSize().height);
                    layoutCellData.getPreferredSize().height = ((ComponentCell)cell).getComponent().getPreferredSize().height;
                } else {
                    baseline = -1;
                }
                if (baseline < 0) continue;
                layoutCellData.setBaseline(baseline);
                this.layoutData.getBaselineData().registerBaseline(layoutCellData, baseline);
                continue;
            }
            if (cell instanceof GridCell) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                GridImpl grid = ((GridCell)cell).getContent();
                grid.calculateLayoutDataStep3();
                layoutCellData.getPreferredSize().height = grid.layoutData.getPreferredHeight();
                if (grid.layoutData.getDimension().height != 1 || !GridImplKt.access$isSupportedBaseline(constraints)) continue;
                Pair pair = VerticalAlign.values();
                boolean $i$f$mapNotNull = false;
                void var9_14 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Pair it$iv$iv;
                    RowBaselineData baselineData;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    Pair result2 = null;
                    if (it != VerticalAlign.FILL && (baselineData = grid.layoutData.getBaselineData().get((VerticalAlign)it)) != null) {
                        result2 = new Pair((Object)it, (Object)baselineData);
                    }
                    if (result2 == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List gridBaselines = (List)destination$iv$iv;
                if (gridBaselines.size() != 1) continue;
                pair = (Pair)gridBaselines.get(0);
                VerticalAlign verticalAlign = (VerticalAlign)((Object)pair.component1());
                RowBaselineData gridBaselineData = (RowBaselineData)pair.component2();
                int baseline = this.calculateBaseline(layoutCellData.getPreferredSize().height, verticalAlign, gridBaselineData);
                layoutCellData.setBaseline(baseline);
                this.layoutData.getBaselineData().registerBaseline(layoutCellData, baseline);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            int n;
            constraints = layoutCellData.getCell().getConstraints();
            if (layoutCellData.getBaseline() == null) {
                n = layoutCellData.getGapHeight() - layoutCellData.getScaledVisualPaddings().getHeight() + layoutCellData.getPreferredSize().height;
            } else {
                RowBaselineData rowBaselineData;
                RowBaselineData rowBaselineData2 = rowBaselineData = this.layoutData.getBaselineData().get(layoutCellData);
                Intrinsics.checkNotNull((Object)rowBaselineData2);
                n = rowBaselineData2.getHeight();
            }
            int height = n;
            this.layoutData.getRowsSizeCalculator().addConstraint(constraints.getY(), constraints.getHeight(), height);
        }
        this.layoutData.setPreferredHeight(this.layoutData.getRowsSizeCalculator().calculatePreferredSize());
    }

    private final void calculateLayoutDataStep4(int height) {
        this.layoutData.setRowsCoord(this.layoutData.getRowsSizeCalculator().calculateCoords(height, this.getResizableRows()));
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            Cell cell = layoutCellData.getCell();
            if (!(cell instanceof GridCell)) continue;
            int subGridHeight = cell.getConstraints().getVerticalAlign() == VerticalAlign.FILL ? this.layoutData.getFullPaddedHeight(layoutCellData) : ((GridCell)cell).getContent().layoutData.getPreferredHeight();
            ((GridCell)cell).getContent().calculateLayoutDataStep4(subGridHeight);
        }
    }

    private final void calculateOutsideGaps(int width, int height) {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        for (LayoutCellData layoutCellData : this.layoutData.getVisibleCellsData()) {
            GridLayout layout;
            JComponent component;
            Cell cell = layoutCellData.getCell();
            ComponentCell componentCell = cell instanceof ComponentCell ? (ComponentCell)cell : null;
            JComponent jComponent = component = componentCell != null ? componentCell.getComponent() : null;
            LayoutManager layoutManager = jComponent != null ? jComponent.getLayout() : null;
            GridLayout gridLayout = layout = layoutManager instanceof GridLayout ? (GridLayout)layoutManager : null;
            if (layout != null && !Intrinsics.areEqual((Object)component.getClientProperty((Object)GridLayoutComponentProperty.SUB_GRID_AUTO_VISUAL_PADDINGS), (Object)false)) {
                PreferredSizeData preferredSizeData = layout.getPreferredSizeData$intellij_platform_ide(component);
                layoutCellData.setScaledVisualPaddings(preferredSizeData.getOutsideGaps());
            }
            Rectangle bounds = this.calculateBounds(layoutCellData, 0, 0);
            Cell cell2 = cell;
            if (cell2 instanceof ComponentCell) {
                left = Math.min(left, bounds.x);
                top = Math.min(top, bounds.y);
                right = Math.max(right, bounds.x + bounds.width - width);
                bottom = Math.max(bottom, bounds.y + bounds.height - height);
                continue;
            }
            if (cell2 instanceof GridCell) {
                ((GridCell)cell).getContent().calculateOutsideGaps(bounds.width, bounds.height);
                Gaps outsideGaps = ((GridCell)cell).getContent().layoutData.getOutsideGaps();
                left = Math.min(left, bounds.x - outsideGaps.getLeft());
                top = Math.min(top, bounds.y - outsideGaps.getTop());
                right = Math.max(right, bounds.x + bounds.width + outsideGaps.getRight() - width);
                bottom = Math.max(bottom, bounds.y + bounds.height + outsideGaps.getBottom() - height);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.layoutData.setOutsideGaps(new Gaps(-top, -left, bottom, right));
    }

    @Nullable
    public final Constraints getConstraints(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return (Constraints)this.recurseFind(GridImpl::getConstraints$lambda$0, arg_0 -> GridImpl.getConstraints$lambda$1(component, arg_0));
    }

    @Nullable
    public final Constraints getConstraints(@NotNull Grid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return (Constraints)this.recurseFind(arg_0 -> GridImpl.getConstraints$lambda$2(grid, arg_0), GridImpl::getConstraints$lambda$3);
    }

    private final <T> T recurseFind(Function1<? super GridCell, ? extends T> onGrid, Function1<? super ComponentCell, ? extends T> onCell) {
        for (Cell cell : this.cells) {
            Object result2 = null;
            Cell cell2 = cell;
            if (cell2 instanceof ComponentCell) {
                result2 = onCell.invoke((Object)cell);
            } else if (cell2 instanceof GridCell) {
                result2 = onGrid.invoke((Object)cell);
                if (result2 == null) {
                    result2 = ((GridCell)cell).getContent().recurseFind(onGrid, onCell);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (result2 == null) continue;
            return (T)result2;
        }
        return null;
    }

    private final Rectangle calculateBounds(LayoutCellData layoutCellData, int offsetX, int offsetY) {
        Cell cell = layoutCellData.getCell();
        Constraints constraints = cell.getConstraints();
        Gaps gaps = layoutCellData.getScaledGaps();
        Gaps visualPaddings = layoutCellData.getScaledVisualPaddings();
        int paddedWidth = this.layoutData.getPaddedWidth(layoutCellData);
        int fullPaddedWidth = this.layoutData.getFullPaddedWidth(layoutCellData);
        int n = this.layoutData.getColumnsCoord()[constraints.getX()] + gaps.getLeft() + JBUIScale.scale((int)layoutCellData.getUnscaledColumnGaps().getLeft()) - visualPaddings.getLeft();
        int x = n + (switch (WhenMappings.$EnumSwitchMapping$0[constraints.getHorizontalAlign().ordinal()]) {
            case 1 -> 0;
            case 2 -> (fullPaddedWidth - paddedWidth) / 2;
            case 3 -> fullPaddedWidth - paddedWidth;
            case 4 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        });
        int fullPaddedHeight = this.layoutData.getFullPaddedHeight(layoutCellData);
        int paddedHeight = constraints.getVerticalAlign() == VerticalAlign.FILL ? fullPaddedHeight : Math.min(fullPaddedHeight, layoutCellData.getPreferredSize().height - visualPaddings.getHeight());
        int y = 0;
        Integer baseline = layoutCellData.getBaseline();
        if (baseline == null) {
            int n2 = this.layoutData.getRowsCoord()[constraints.getY()] + JBUIScale.scale((int)layoutCellData.getUnscaledRowGaps().getTop()) + gaps.getTop() - visualPaddings.getTop();
            y = n2 + (switch (WhenMappings.$EnumSwitchMapping$1[constraints.getVerticalAlign().ordinal()]) {
                case 1 -> 0;
                case 2 -> (fullPaddedHeight - paddedHeight) / 2;
                case 3 -> fullPaddedHeight - paddedHeight;
                case 4 -> 0;
                default -> throw new NoWhenBranchMatchedException();
            });
        } else {
            RowBaselineData rowBaselineData = this.layoutData.getBaselineData().get(layoutCellData);
            Intrinsics.checkNotNull((Object)rowBaselineData);
            RowBaselineData rowBaselineData2 = rowBaselineData;
            int rowHeight = this.layoutData.getHeight(layoutCellData);
            y = this.layoutData.getRowsCoord()[constraints.getY()] + this.calculateBaseline(rowHeight, constraints.getVerticalAlign(), rowBaselineData2) - baseline;
        }
        return new Rectangle(offsetX + x, offsetY + y, paddedWidth + visualPaddings.getWidth(), paddedHeight + visualPaddings.getHeight());
    }

    private final int calculateBaseline(int height, VerticalAlign verticalAlign, RowBaselineData rowBaselineData) {
        int n = rowBaselineData.getMaxAboveBaseline();
        return n + (switch (WhenMappings.$EnumSwitchMapping$1[verticalAlign.ordinal()]) {
            case 1 -> 0;
            case 2 -> (height - rowBaselineData.getHeight()) / 2;
            case 3 -> height - rowBaselineData.getHeight();
            case 4 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private final boolean isEmpty(Constraints constraints, Constraints skipConstraints) {
        for (Cell cell : this.cells) {
            Constraints $this$isEmpty_u24lambda_u240 = cell.getConstraints();
            boolean bl = false;
            if ($this$isEmpty_u24lambda_u240 == skipConstraints || constraints.getX() + constraints.getWidth() <= $this$isEmpty_u24lambda_u240.getX() || $this$isEmpty_u24lambda_u240.getX() + $this$isEmpty_u24lambda_u240.getWidth() <= constraints.getX() || constraints.getY() + constraints.getHeight() <= $this$isEmpty_u24lambda_u240.getY() || $this$isEmpty_u24lambda_u240.getY() + $this$isEmpty_u24lambda_u240.getHeight() <= constraints.getY()) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ boolean isEmpty$default(GridImpl gridImpl, Constraints constraints, Constraints constraints2, int n, Object object) {
        if ((n & 2) != 0) {
            constraints2 = null;
        }
        return gridImpl.isEmpty(constraints, constraints2);
    }

    private static final Constraints getConstraints$lambda$0(GridCell it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    private static final Constraints getConstraints$lambda$1(JComponent $component, ComponentCell componentCell) {
        Intrinsics.checkNotNullParameter((Object)componentCell, (String)"componentCell");
        return componentCell.getComponent() == $component ? componentCell.getConstraints() : null;
    }

    private static final Constraints getConstraints$lambda$2(Grid $grid, GridCell gridCell) {
        Intrinsics.checkNotNullParameter((Object)gridCell, (String)"gridCell");
        return gridCell.getContent() == $grid ? gridCell.getConstraints() : null;
    }

    private static final Constraints getConstraints$lambda$3(ComponentCell it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalAlign.values().length];
            try {
                nArray[HorizontalAlign.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlign.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlign.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlign.FILL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalAlign.values().length];
            try {
                nArray[VerticalAlign.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlign.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlign.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlign.FILL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

