/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scroll;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsStateKt;
import com.intellij.ui.scroll.SmoothScrollUtil;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.JBAnimator;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MouseWheelSmoothScroll {
    private final InertialAnimator horizontal;
    private final InertialAnimator vertical;
    @NotNull
    private final Supplier<Boolean> myScrollEnabled;

    public static MouseWheelSmoothScroll create() {
        return MouseWheelSmoothScroll.create(() -> true);
    }

    public static MouseWheelSmoothScroll create(@NotNull Supplier<Boolean> isScrollEnabled) {
        if (isScrollEnabled == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(0);
        }
        return new MouseWheelSmoothScroll(isScrollEnabled);
    }

    private MouseWheelSmoothScroll(@NotNull Supplier<Boolean> isEnabledChecker) {
        if (isEnabledChecker == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(1);
        }
        this.horizontal = new InertialAnimator();
        this.vertical = new InertialAnimator();
        this.myScrollEnabled = Objects.requireNonNull(isEnabledChecker);
    }

    public void processMouseWheelEvent(@NotNull MouseWheelEvent e, @Nullable Consumer<? super MouseWheelEvent> alternative) {
        JScrollBar bar;
        if (e == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(2);
        }
        JScrollBar jScrollBar = bar = this.myScrollEnabled.get() == false ? null : SmoothScrollUtil.getEventScrollBar(e);
        if (bar == null) {
            if (alternative != null) {
                alternative.accept(e);
            }
            return;
        }
        InertialAnimator animator2 = SmoothScrollUtil.isHorizontalScroll(e) ? this.horizontal : this.vertical;
        int value2 = bar.getValue();
        int delta = (int)MouseWheelSmoothScroll.getDelta(bar, e, animator2.myTargetValue);
        if (delta == 0) {
            return;
        }
        animator2.start(value2, value2 + delta, bar::setValue, MouseWheelSmoothScroll.shouldStop(bar), ScrollAnimationSettings.SETTINGS);
        e.consume();
    }

    private static Predicate<Integer> shouldStop(JScrollBar bar) {
        return v -> v - bar.getValue() != 0 || !bar.isShowing();
    }

    private static double getDelta(@NotNull JScrollBar bar, @NotNull MouseWheelEvent event, double animationTargetValue) {
        JViewport viewport;
        Component component;
        double rotation;
        int direction;
        if (bar == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(3);
        }
        if (event == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(4);
        }
        int n = direction = (rotation = event.getPreciseWheelRotation()) < 0.0 ? -1 : 1;
        if (event.getScrollType() == 1) {
            return direction * bar.getBlockIncrement(direction);
        }
        if (event.getSource() instanceof JScrollPane && (component = (viewport = ((JScrollPane)event.getSource()).getViewport()).getView()) instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            int orientation = bar.getOrientation();
            boolean isVertical = orientation == 1;
            int scroll = Math.abs(event.getUnitsToScroll());
            Rectangle rect = viewport.getViewRect();
            int delta = 0;
            if (!Double.isNaN(animationTargetValue)) {
                if (isVertical) {
                    rect.y = (int)animationTargetValue;
                } else {
                    rect.x = (int)animationTargetValue;
                }
            }
            for (int i = 0; i < scroll; ++i) {
                int increment = Math.max(scrollable.getScrollableUnitIncrement(rect, orientation, direction), 0) * direction;
                if (isVertical) {
                    rect.y += increment;
                } else {
                    rect.x += increment;
                }
                delta += increment;
            }
            return delta;
        }
        int increment = bar.getUnitIncrement(direction);
        int delta = increment * event.getUnitsToScroll();
        return delta == 0 ? rotation : (double)delta;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isScrollEnabled";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isEnabledChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/scroll/MouseWheelSmoothScroll";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processMouseWheelEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDelta";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class InertialAnimator {
        private double myInitValue = Double.NaN;
        private double myCurrentValue = Double.NaN;
        private double myTargetValue = Double.NaN;
        private long myStartEventTime = -1L;
        private long myLastEventTime = -1L;
        private long myDuration = -1L;
        private AnimationSettings mySettings;
        private long animationId = -1L;
        private final Consumer<? super Integer> BLACK_HOLE = x -> {};
        @NotNull
        private Consumer<? super Integer> myConsumer = this.BLACK_HOLE;
        private final Predicate<? super Integer> FALSE_PREDICATE = value2 -> false;
        @NotNull
        private Predicate<? super Integer> myShouldStop = this.FALSE_PREDICATE;
        private final JBAnimator myTimer = new JBAnimator();

        InertialAnimator() {
            this.myTimer.setPeriod(2);
            this.myTimer.setCyclic(true);
            this.myTimer.setName("Inertial Animation Timer");
        }

        public final void start(int initValue, int targetValue, @NotNull Consumer<? super Integer> consumer, @Nullable Predicate<? super Integer> shouldStop, @NotNull AnimationSettings settings) {
            boolean isSameDirection;
            if (consumer == null) {
                InertialAnimator.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                InertialAnimator.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            double duration = this.mySettings.getDuration();
            if (duration == 0.0) {
                consumer.accept((Integer)targetValue);
                this.stop();
                return;
            }
            boolean bl = isSameDirection = (this.myTargetValue - this.myInitValue) * (double)(targetValue - initValue) > 0.0;
            if (isSameDirection && this.myTimer.isRunning(this.animationId)) {
                this.myTargetValue += (double)(targetValue - initValue);
                this.myDuration = (long)duration + Math.max(this.myLastEventTime - this.myStartEventTime, 0L);
                this.myInitValue = this.myCurrentValue;
                this.myStartEventTime = this.myLastEventTime;
            } else {
                this.myTargetValue = targetValue;
                this.myDuration = (long)duration;
                this.myInitValue = initValue;
                this.myStartEventTime = System.currentTimeMillis();
            }
            this.myConsumer = Objects.requireNonNull(consumer);
            this.myShouldStop = shouldStop == null ? this.FALSE_PREDICATE : shouldStop;
            this.myCurrentValue = initValue;
            if (!this.myTimer.isRunning(this.animationId)) {
                this.animationId = this.myTimer.animate(new Animation(this::run).setDuration(Integer.MAX_VALUE).setEasing(com.intellij.util.animation.Easing.LINEAR));
            }
        }

        private void run(double value2) {
            if (value2 == 1.0) {
                this.myConsumer.accept((Integer)((int)Math.round(this.myTargetValue)));
                this.stop();
                return;
            }
            if (this.myShouldStop.test((Integer)((int)Math.round(this.myCurrentValue)))) {
                this.stop();
                return;
            }
            this.myLastEventTime = System.currentTimeMillis();
            long currentEventTime = Math.min(this.myLastEventTime, this.myStartEventTime + this.myDuration);
            this.myCurrentValue = this.mySettings.getEasing().calc(currentEventTime - this.myStartEventTime, this.myInitValue, this.myTargetValue - this.myInitValue, this.myDuration);
            this.myConsumer.accept((Integer)((int)Math.round(this.myCurrentValue)));
            if (this.myLastEventTime >= this.myStartEventTime + this.myDuration) {
                this.stop();
            }
        }

        public final void stop() {
            this.myTimer.stop();
            this.myStartEventTime = -1L;
            this.myLastEventTime = -1L;
            this.myDuration = -1L;
            this.myTargetValue = Double.NaN;
            this.myCurrentValue = Double.NaN;
            this.myInitValue = Double.NaN;
            this.myConsumer = this.BLACK_HOLE;
            this.myShouldStop = this.FALSE_PREDICATE;
            this.mySettings = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/scroll/MouseWheelSmoothScroll$InertialAnimator";
            objectArray[2] = "start";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum ScrollAnimationSettings implements AnimationSettings
    {
        SETTINGS{
            private CubicBezierEasing ourEasing;
            private int curvePoints;

            @Override
            public double getDuration() {
                return LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() ? (double)UISettings.getShadowInstance().getAnimatedScrollingDuration() : (double)UISettingsStateKt.getDefaultAnimatedScrollingDuration();
            }

            @Override
            @NotNull
            public Easing getEasing() {
                int points = UISettings.getShadowInstance().getAnimatedScrollingCurvePoints();
                if (points != this.curvePoints || this.ourEasing == null) {
                    double x1 = (double)(points >> 24 & 0xFF) / 200.0;
                    double y1 = (double)(points >> 16 & 0xFF) / 200.0;
                    double x2 = (double)(points >> 8 & 0xFF) / 200.0;
                    double y2 = (double)(points & 0xFF) / 200.0;
                    if (this.ourEasing == null) {
                        this.ourEasing = new CubicBezierEasing(x1, y1, x2, y2, 2000);
                    } else {
                        this.ourEasing.update(x1, y1, x2, y2);
                    }
                    this.curvePoints = points;
                }
                CubicBezierEasing cubicBezierEasing = this.ourEasing;
                if (cubicBezierEasing == null) {
                    1.$$$reportNull$$$0(0);
                }
                return cubicBezierEasing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/scroll/MouseWheelSmoothScroll$ScrollAnimationSettings$1", "getEasing"));
            }
        };

    }

    static interface AnimationSettings {
        public double getDuration();

        @NotNull
        public Easing getEasing();
    }

    static class CubicBezierEasing
    implements Easing {
        private final com.intellij.util.animation.CubicBezierEasing delegate;

        CubicBezierEasing(double c1x, double c1y, double c2x, double c2y, int size) {
            this.delegate = new com.intellij.util.animation.CubicBezierEasing(c1x, c1y, c2x, c2y, size);
        }

        public void update(double c1x, double c1y, double c2x, double c2y) {
            this.delegate.update(c1x, c1y, c2x, c2y);
        }

        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public double calc(double t, double b, double c, double d) {
            double x = t / d;
            return c * this.delegate.calc(x) + b;
        }
    }

    static interface Easing {
        public double calc(double var1, double var3, double var5, double var7);
    }
}

