/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.multiRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLabelKt;
import com.intellij.ui.tabs.impl.multiRow.MultiRowPassInfo;
import com.intellij.ui.tabs.impl.multiRow.TabsRow;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0000\u0018\u0000 52\u00020\u0001:\u00042345B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0012J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u0011\u001a\u00020\u000fH\u0002JO\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2*\u0010!\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0#0\"\"\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0#H\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0002J \u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0002J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002\u00a8\u00066"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow;", "Lcom/intellij/ui/tabs/impl/multiRow/TabsRow;", "infos", "", "Lcom/intellij/ui/tabs/TabInfo;", "withTitle", "", "withEntryPointToolbar", "<init>", "(Ljava/util/List;ZZ)V", "layoutTabs", "", "data", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "x", "", "y", "maxLength", "layoutTabs$intellij_platform_ide", "calculateCompressibleLengths", "Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow$CompressionResult;", "prefLengths", "requiredLen", "maxLen", "decreaseInsets", "calculateDecreasedInsets", "Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow$TabInsets;", "tabInsets", "lenToDecrease", "decreaseMaxLengths", "lengths", "decreaseProportionally", "limit", "curLenToMinLen", "", "Lkotlin/Pair;", "(II[Lkotlin/Pair;)Ljava/util/List;", "createTabInsets", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "info", "createUiDecoration", "Lcom/intellij/ui/tabs/UiDecorator$UiDecoration;", "insets", "getMinTabInsets", "curInsets", "getMiddleTabInsets", "roundToInt", "value", "", "CachedDecoration", "CompressionResult", "TabInsets", "Companion", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nCompressibleTabsRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressibleTabsRow.kt\ncom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1563#2:284\n1634#2,3:285\n1740#2,3:288\n1056#2:292\n1563#2:293\n1634#2,3:294\n1563#2:297\n1634#2,3:298\n360#2,7:301\n1#3:291\n*S KotlinDebug\n*F\n+ 1 CompressibleTabsRow.kt\ncom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow\n*L\n23#1:284\n23#1:285,3\n53#1:288,3\n131#1:292\n132#1:293\n132#1:294,3\n133#1:297\n133#1:298,3\n144#1:301,7\n*E\n"})
public final class CompressibleTabsRow
extends TabsRow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float CORNER_TO_TEXT_INSET_RATIO = 0.33f;
    private static final float ICON_INSET_RATIO = 0.5f;
    private static final float ACTIONS_INSET_RATIO = 0.0f;
    private static final float CORNER_TO_ACTIONS_MID_INSET_RATIO = 0.75f;
    private static final float CORNER_TO_ACTIONS_INSET_RATIO = 0.5f;
    private static final int CORNER_TO_TEXT_INSET_MIN = 4;
    private static final int CORNER_TO_ACTIONS_INSET_MIN = 4;

    public CompressibleTabsRow(@NotNull List<TabInfo> infos, boolean withTitle, boolean withEntryPointToolbar) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        super(infos, withTitle, withEntryPointToolbar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layoutTabs$intellij_platform_ide(@NotNull MultiRowPassInfo data, int x, int y, int maxLength) {
        int gapsLengths;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JBTabsImpl tabs = data.tabs;
        UiDecorator uiDecorator = tabs.getUiDecorator$intellij_platform_ide();
        Intrinsics.checkNotNull((Object)uiDecorator);
        UiDecorator.UiDecoration decoration = uiDecorator.getDecoration();
        Iterable $this$map$iv = this.getInfos();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TabLabel label2;
            void it;
            TabInfo tabInfo = (TabInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)tabs.getTabLabel((TabInfo)it));
            label2.apply(decoration);
            collection.add(label2.getPreferredSize().width);
        }
        List prefLengths = (List)destination$iv$iv;
        int requiredLength = CollectionsKt.sumOfInt((Iterable)prefLengths);
        CompressionResult result2 = requiredLength > maxLength - (gapsLengths = tabs.getTabHGap() * (this.getInfos().size() - 1)) ? this.calculateCompressibleLengths(data, prefLengths, requiredLength, maxLength - gapsLengths) : new CompressionResult(prefLengths, false);
        int curX = x;
        Iterator iterator = ((Iterable)this.getInfos()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TabLabel label3;
            int index = n++;
            TabInfo info = (TabInfo)iterator.next();
            Intrinsics.checkNotNull((Object)tabs.getTabLabel(info));
            int len = ((Number)result2.getLengths().get(index)).intValue();
            label3.setForcePaintBorders(result2.getForcePaintBorders());
            tabs.layout(label3, curX, y, len, data.getRowHeight());
            curX += len + tabs.getTabHGap();
        }
    }

    private final CompressionResult calculateCompressibleLengths(MultiRowPassInfo data, List<Integer> prefLengths, int requiredLen, int maxLen) {
        List<Integer> decreasedLengths = this.decreaseInsets(data, prefLengths, requiredLen, maxLen);
        if (CollectionsKt.sumOfInt((Iterable)decreasedLengths) > maxLen) {
            boolean bl;
            List<Integer> resultLengths;
            block4: {
                resultLengths = this.decreaseMaxLengths(decreasedLengths, maxLen);
                Iterable $this$all$iv = CollectionsKt.zip((Iterable)resultLengths, (Iterable)decreasedLengths);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (((Number)it.getFirst()).intValue() < ((Number)it.getSecond()).intValue()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            boolean paintBorders = bl;
            return new CompressionResult(resultLengths, paintBorders);
        }
        return new CompressionResult(decreasedLengths, false);
    }

    private final List<Integer> decreaseInsets(MultiRowPassInfo data, List<Integer> prefLengths, int requiredLen, int maxLen) {
        JBTabsImpl tabs = data.tabs;
        int extraLen = requiredLen - maxLen;
        int tabExtraLen = extraLen / this.getInfos().size();
        int remainingExtraLen = extraLen % this.getInfos().size();
        LinkedList<CachedDecoration> cachedDecorations = new LinkedList<CachedDecoration>();
        List decreasedLengths = new ArrayList();
        int n = ((Collection)this.getInfos()).size();
        for (int ind = 0; ind < n; ++ind) {
            Object v0;
            TabLabel.ActionsPosition actionsPosition;
            TabLabel label2;
            int curExtraLen;
            TabInfo info;
            block5: {
                info = this.getInfos().get(ind);
                curExtraLen = 0;
                curExtraLen = tabExtraLen;
                if (remainingExtraLen > 0) {
                    int n2 = curExtraLen;
                    curExtraLen = n2 + 1;
                    --remainingExtraLen;
                }
                Intrinsics.checkNotNull((Object)tabs.getTabLabel(info));
                actionsPosition = label2.getActionsPosition();
                Iterable iterable = cachedDecorations;
                for (Object t : iterable) {
                    CachedDecoration it = (CachedDecoration)t;
                    boolean bl = false;
                    if (!(it.getExtraLen() == curExtraLen && it.getActionsPosition() == actionsPosition)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            CachedDecoration cached = v0;
            if (cached != null) {
                label2.apply(cached.getDecoration());
                v1 = decreasedLengths.add(((Number)prefLengths.get(ind)).intValue() - cached.getDecreasedLen());
            } else {
                TabInsets curInsets = this.createTabInsets(tabs, info);
                TabInsets decreasedInsets = this.calculateDecreasedInsets(curInsets, curExtraLen);
                UiDecorator.UiDecoration decoration = this.createUiDecoration(tabs, info, decreasedInsets);
                int decreasedLen = curInsets.sum() - decreasedInsets.sum();
                cachedDecorations.add(new CachedDecoration(decoration, curExtraLen, decreasedLen, actionsPosition));
                label2.apply(decoration);
                v1 = decreasedLengths.add(((Number)prefLengths.get(ind)).intValue() - decreasedLen);
            }
            label2.isCompressionEnabled = true;
        }
        return decreasedLengths;
    }

    private final TabInsets calculateDecreasedInsets(TabInsets tabInsets, int lenToDecrease) {
        TabInsets tabInsets2;
        TabInsets middleTabInsets = this.getMiddleTabInsets(tabInsets);
        TabInsets minTabInsets = this.getMinTabInsets(tabInsets);
        int middleDecreasableLen = tabInsets.sum() - middleTabInsets.sum();
        int decreasableLen = tabInsets.sum() - minTabInsets.sum();
        if (lenToDecrease <= middleDecreasableLen) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)tabInsets.getActionsInset(), (Object)middleTabInsets.getActionsInset()), TuplesKt.to((Object)tabInsets.getCornerToActions(), (Object)middleTabInsets.getCornerToActions())};
            List<Integer> insets = this.decreaseProportionally(lenToDecrease, middleDecreasableLen, pairArray);
            tabInsets2 = new TabInsets(tabInsets.getActionsPosition(), tabInsets.getCornerToText(), tabInsets.getIconInset(), ((Number)insets.get(0)).intValue(), ((Number)insets.get(1)).intValue());
        } else if (lenToDecrease <= decreasableLen) {
            Object object = new Pair[]{TuplesKt.to((Object)tabInsets.getCornerToText(), (Object)minTabInsets.getCornerToText()), TuplesKt.to((Object)middleTabInsets.getCornerToActions(), (Object)minTabInsets.getCornerToActions()), TuplesKt.to((Object)tabInsets.getIconInset(), (Object)minTabInsets.getIconInset()), TuplesKt.to((Object)middleTabInsets.getActionsInset(), (Object)minTabInsets.getActionsInset())};
            List<Integer> insets = this.decreaseProportionally(lenToDecrease - middleDecreasableLen, decreasableLen - middleDecreasableLen, (Pair<Integer, Integer>)object);
            object = tabInsets.getActionsPosition();
            int n = ((Number)insets.get(0)).intValue();
            int n2 = ((Number)insets.get(1)).intValue();
            int n3 = ((Number)insets.get(2)).intValue();
            int n4 = ((Number)insets.get(3)).intValue();
            tabInsets2 = new TabInsets((TabLabel.ActionsPosition)((Object)object), n, n3, n4, n2);
        } else {
            tabInsets2 = minTabInsets;
        }
        return tabInsets2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> decreaseMaxLengths(List<Integer> lengths, int maxLength) {
        void var12_30;
        int n;
        int n2;
        int n3;
        List sortedLengths;
        List indexes;
        ArrayList<Integer> arrayList;
        block11: {
            ArrayList<Integer> $this$mapTo$iv$iv232;
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = CollectionsKt.withIndex((Iterable)lengths);
            boolean $i$f$sortedBy = false;
            List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IndexedValue it = (IndexedValue)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getValue();
                    it = (IndexedValue)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
                }
            });
            Iterable $this$map$iv = sorted;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable<Integer> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                arrayList = destination$iv$iv;
                boolean bl = false;
                arrayList.add(indexedValue.getIndex());
            }
            indexes = destination$iv$iv;
            Iterable $this$map$iv2 = sorted;
            int $i$f$map2 = 0;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv232 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            int $i$f$mapTo2 = 0;
            for (Object e : $this$mapTo$iv$iv232) {
                void it;
                IndexedValue bl = (IndexedValue)e;
                arrayList = destination$iv$iv232;
                boolean bl2 = false;
                arrayList.add(((Number)it.getValue()).intValue());
            }
            sortedLengths = (List)destination$iv$iv232;
            $i$f$map2 = lengths.size();
            $this$mapTo$iv$iv232 = new ArrayList<Integer>($i$f$map2);
            int destination$iv$iv232 = 0;
            while (destination$iv$iv232 < $i$f$map2) {
                int item$iv$iv = $i$f$mapTo2 = destination$iv$iv232++;
                arrayList = $this$mapTo$iv$iv232;
                boolean bl = false;
                arrayList.add(0);
            }
            List sums = $this$mapTo$iv$iv232;
            sums.set(0, ((Number)sortedLengths.get(0)).intValue() * lengths.size());
            int $this$mapTo$iv$iv232 = lengths.size();
            for (int ind = 1; ind < $this$mapTo$iv$iv232; ++ind) {
                sums.set(ind, ((Number)sums.get(ind - 1)).intValue() + (((Number)sortedLengths.get(ind)).intValue() - ((Number)sortedLengths.get(ind - 1)).intValue()) * (lengths.size() - ind));
            }
            List $this$indexOfFirst$iv = sums;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object e : $this$indexOfFirst$iv) {
                int it = ((Number)e).intValue();
                n3 = 0;
                if (it >= maxLength) {
                    n2 = index$iv;
                    break block11;
                }
                ++index$iv;
            }
            n2 = -1;
        }
        int index = n2;
        int decreasableLen = maxLength - CollectionsKt.sumOfInt((Iterable)sortedLengths.subList(0, index));
        int avgLen = decreasableLen / (lengths.size() - index);
        int remainingLen = decreasableLen % (lengths.size() - index);
        int n4 = lengths.size();
        ArrayList arrayList2 = new ArrayList(n4);
        n3 = 0;
        while (n3 < n4) {
            int n5 = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0);
        }
        List result2 = arrayList2;
        boolean bl = false;
        int n6 = ((Collection)sortedLengths).size();
        while (var12_30 < n6) {
            int initialIndex = ((Number)indexes.get((int)var12_30)).intValue();
            if (var12_30 < index) {
                result2.set(initialIndex, sortedLengths.get((int)var12_30));
            } else {
                result2.set(initialIndex, avgLen);
                if (remainingLen > 0) {
                    n = ((Number)result2.get(initialIndex)).intValue();
                    result2.set(initialIndex, n + 1);
                    --remainingLen;
                }
            }
            ++var12_30;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> decreaseProportionally(int lenToDecrease, int limit, Pair<Integer, Integer> ... curLenToMinLen) {
        int n;
        float ratio = 1.0f - (float)lenToDecrease / (float)limit;
        List result2 = new ArrayList();
        int n2 = curLenToMinLen.length;
        for (int i = 0; i < n2; ++i) {
            Pair<Integer, Integer> pair = curLenToMinLen[i];
            int curLen = ((Number)pair.component1()).intValue();
            int minLen = ((Number)pair.component2()).intValue();
            result2.add(Math.max((int)((float)curLen * ratio), minLen));
        }
        Pair<Integer, Integer>[] pairArray = curLenToMinLen;
        int n3 = 0;
        int n4 = pairArray.length;
        for (n = 0; n < n4; ++n) {
            void it;
            Pair<Integer, Integer> pair;
            Pair<Integer, Integer> pair2 = pair = pairArray[n];
            int n5 = n3;
            boolean bl = false;
            int n6 = ((Number)it.getFirst()).intValue();
            n3 = n5 + n6;
        }
        int remainingLen = n3 - lenToDecrease - CollectionsKt.sumOfInt((Iterable)result2);
        while (remainingLen > 0) {
            n3 = ((Collection)result2).size();
            for (int ind = 0; ind < n3; ++ind) {
                if (remainingLen <= 0) continue;
                --remainingLen;
                n = ind;
                n4 = ((Number)result2.get(n)).intValue();
                result2.set(n, n4 + 1);
            }
        }
        return result2;
    }

    private final TabInsets createTabInsets(JBTabsImpl tabs, TabInfo info) {
        UiDecorator uiDecorator = tabs.getUiDecorator$intellij_platform_ide();
        Intrinsics.checkNotNull((Object)uiDecorator);
        TabLabel.MergedUiDecoration decoration = TabLabelKt.mergeUiDecorations(uiDecorator.getDecoration(), JBTabsImpl.defaultDecorator.getDecoration());
        TabLabel tabLabel = tabs.getTabLabel(info);
        Intrinsics.checkNotNull((Object)tabLabel);
        TabLabel.ActionsPosition actionsPosition = tabLabel.getActionsPosition();
        Insets insets = decoration.contentInsetsSupplier.apply(actionsPosition);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"apply(...)");
        Insets contentInsets = insets;
        int cornerToText = actionsPosition == TabLabel.ActionsPosition.RIGHT ? decoration.labelInsets.left + contentInsets.left : decoration.labelInsets.right + contentInsets.right;
        int cornerToActions = switch (WhenMappings.$EnumSwitchMapping$0[actionsPosition.ordinal()]) {
            case 1 -> decoration.labelInsets.right;
            case 2 -> decoration.labelInsets.left;
            case 3 -> decoration.labelInsets.left + contentInsets.left;
            default -> throw new NoWhenBranchMatchedException();
        };
        int actionsInset = switch (WhenMappings.$EnumSwitchMapping$0[actionsPosition.ordinal()]) {
            case 1 -> contentInsets.right;
            case 2 -> contentInsets.left;
            case 3 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
        int n = decoration.iconTextGap;
        return new TabInsets(actionsPosition, cornerToText, n, actionsInset, cornerToActions);
    }

    private final UiDecorator.UiDecoration createUiDecoration(JBTabsImpl tabs, TabInfo info, TabInsets insets) {
        TabLabel tabLabel = tabs.getTabLabel(info);
        Intrinsics.checkNotNull((Object)tabLabel);
        TabLabel.ActionsPosition actionsPosition = tabLabel.getActionsPosition();
        int cornerToActions = insets.getCornerToActions() + (actionsPosition == TabLabel.ActionsPosition.NONE && insets.getActionsInset() > 0 ? insets.getActionsInset() : 0);
        Insets contentInsets = new Insets(0, actionsPosition == TabLabel.ActionsPosition.LEFT ? insets.getActionsInset() : 0, 0, actionsPosition == TabLabel.ActionsPosition.RIGHT ? insets.getActionsInset() : 0);
        UiDecorator uiDecorator = tabs.getUiDecorator$intellij_platform_ide();
        Intrinsics.checkNotNull((Object)uiDecorator);
        TabLabel.MergedUiDecoration originalDec = TabLabelKt.mergeUiDecorations(uiDecorator.getDecoration(), JBTabsImpl.defaultDecorator.getDecoration());
        Insets labelInsets = new Insets(originalDec.labelInsets.top, actionsPosition == TabLabel.ActionsPosition.RIGHT ? insets.getCornerToText() : cornerToActions, originalDec.labelInsets.bottom, actionsPosition == TabLabel.ActionsPosition.RIGHT ? cornerToActions : insets.getCornerToText());
        return new UiDecorator.UiDecoration(null, labelInsets, arg_0 -> CompressibleTabsRow.createUiDecoration$lambda$0(contentInsets, arg_0), insets.getIconInset());
    }

    private final TabInsets getMinTabInsets(TabInsets curInsets) {
        TabLabel.ActionsPosition actionsPosition = curInsets.getActionsPosition();
        int n = Math.max(this.roundToInt((float)curInsets.getCornerToText() * 0.33f), JBUI.scale((int)4));
        int n2 = Math.max(this.roundToInt((float)curInsets.getCornerToActions() * 0.5f), JBUI.scale((int)4));
        int n3 = this.roundToInt((float)curInsets.getIconInset() * 0.5f);
        int n4 = this.roundToInt((float)curInsets.getActionsInset() * 0.0f);
        return new TabInsets(actionsPosition, n, n3, n4, n2);
    }

    private final TabInsets getMiddleTabInsets(TabInsets curInsets) {
        TabLabel.ActionsPosition actionsPosition = curInsets.getActionsPosition();
        int n = curInsets.getCornerToText();
        int n2 = Math.max(this.roundToInt((float)curInsets.getCornerToActions() * 0.75f), JBUI.scale((int)4));
        int n3 = curInsets.getIconInset();
        int n4 = this.roundToInt((float)curInsets.getActionsInset() * 0.0f);
        return new TabInsets(actionsPosition, n, n3, n4, n2);
    }

    private final int roundToInt(float value2) {
        return (int)Math.rint(value2);
    }

    private static final Insets createUiDecoration$lambda$0(Insets $contentInsets, TabLabel.ActionsPosition it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return $contentInsets;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow$CachedDecoration;", "", "decoration", "Lcom/intellij/ui/tabs/UiDecorator$UiDecoration;", "extraLen", "", "decreasedLen", "actionsPosition", "Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "<init>", "(Lcom/intellij/ui/tabs/UiDecorator$UiDecoration;IILcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;)V", "getDecoration", "()Lcom/intellij/ui/tabs/UiDecorator$UiDecoration;", "getExtraLen", "()I", "getDecreasedLen", "getActionsPosition", "()Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "intellij.platform.ide"})
    private static final class CachedDecoration {
        @NotNull
        private final UiDecorator.UiDecoration decoration;
        private final int extraLen;
        private final int decreasedLen;
        @NotNull
        private final TabLabel.ActionsPosition actionsPosition;

        public CachedDecoration(@NotNull UiDecorator.UiDecoration decoration, int extraLen, int decreasedLen, @NotNull TabLabel.ActionsPosition actionsPosition) {
            Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
            Intrinsics.checkNotNullParameter((Object)((Object)actionsPosition), (String)"actionsPosition");
            this.decoration = decoration;
            this.extraLen = extraLen;
            this.decreasedLen = decreasedLen;
            this.actionsPosition = actionsPosition;
        }

        @NotNull
        public final UiDecorator.UiDecoration getDecoration() {
            return this.decoration;
        }

        public final int getExtraLen() {
            return this.extraLen;
        }

        public final int getDecreasedLen() {
            return this.decreasedLen;
        }

        @NotNull
        public final TabLabel.ActionsPosition getActionsPosition() {
            return this.actionsPosition;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow$Companion;", "", "<init>", "()V", "CORNER_TO_TEXT_INSET_RATIO", "", "ICON_INSET_RATIO", "ACTIONS_INSET_RATIO", "CORNER_TO_ACTIONS_MID_INSET_RATIO", "CORNER_TO_ACTIONS_INSET_RATIO", "CORNER_TO_TEXT_INSET_MIN", "", "CORNER_TO_ACTIONS_INSET_MIN", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow$CompressionResult;", "", "lengths", "", "", "forcePaintBorders", "", "<init>", "(Ljava/util/List;Z)V", "getLengths", "()Ljava/util/List;", "getForcePaintBorders", "()Z", "intellij.platform.ide"})
    private static final class CompressionResult {
        @NotNull
        private final List<Integer> lengths;
        private final boolean forcePaintBorders;

        public CompressionResult(@NotNull List<Integer> lengths, boolean forcePaintBorders) {
            Intrinsics.checkNotNullParameter(lengths, (String)"lengths");
            this.lengths = lengths;
            this.forcePaintBorders = forcePaintBorders;
        }

        @NotNull
        public final List<Integer> getLengths() {
            return this.lengths;
        }

        public final boolean getForcePaintBorders() {
            return this.forcePaintBorders;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0005J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/CompressibleTabsRow$TabInsets;", "", "actionsPosition", "Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "cornerToText", "", "iconInset", "actionsInset", "cornerToActions", "<init>", "(Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;IIII)V", "getActionsPosition", "()Lcom/intellij/ui/tabs/impl/TabLabel$ActionsPosition;", "getCornerToText", "()I", "getIconInset", "getActionsInset", "getCornerToActions", "sum", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide"})
    private static final class TabInsets {
        @NotNull
        private final TabLabel.ActionsPosition actionsPosition;
        private final int cornerToText;
        private final int iconInset;
        private final int actionsInset;
        private final int cornerToActions;

        public TabInsets(@NotNull TabLabel.ActionsPosition actionsPosition, int cornerToText, int iconInset, int actionsInset, int cornerToActions) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionsPosition), (String)"actionsPosition");
            this.actionsPosition = actionsPosition;
            this.cornerToText = cornerToText;
            this.iconInset = iconInset;
            this.actionsInset = actionsInset;
            this.cornerToActions = cornerToActions;
        }

        @NotNull
        public final TabLabel.ActionsPosition getActionsPosition() {
            return this.actionsPosition;
        }

        public final int getCornerToText() {
            return this.cornerToText;
        }

        public final int getIconInset() {
            return this.iconInset;
        }

        public final int getActionsInset() {
            return this.actionsInset;
        }

        public final int getCornerToActions() {
            return this.cornerToActions;
        }

        public final int sum() {
            return this.cornerToText + this.iconInset + this.actionsInset + this.cornerToActions;
        }

        @NotNull
        public final TabLabel.ActionsPosition component1() {
            return this.actionsPosition;
        }

        public final int component2() {
            return this.cornerToText;
        }

        public final int component3() {
            return this.iconInset;
        }

        public final int component4() {
            return this.actionsInset;
        }

        public final int component5() {
            return this.cornerToActions;
        }

        @NotNull
        public final TabInsets copy(@NotNull TabLabel.ActionsPosition actionsPosition, int cornerToText, int iconInset, int actionsInset, int cornerToActions) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionsPosition), (String)"actionsPosition");
            return new TabInsets(actionsPosition, cornerToText, iconInset, actionsInset, cornerToActions);
        }

        public static /* synthetic */ TabInsets copy$default(TabInsets tabInsets, TabLabel.ActionsPosition actionsPosition, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                actionsPosition = tabInsets.actionsPosition;
            }
            if ((n5 & 2) != 0) {
                n = tabInsets.cornerToText;
            }
            if ((n5 & 4) != 0) {
                n2 = tabInsets.iconInset;
            }
            if ((n5 & 8) != 0) {
                n3 = tabInsets.actionsInset;
            }
            if ((n5 & 0x10) != 0) {
                n4 = tabInsets.cornerToActions;
            }
            return tabInsets.copy(actionsPosition, n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "TabInsets(actionsPosition=" + this.actionsPosition + ", cornerToText=" + this.cornerToText + ", iconInset=" + this.iconInset + ", actionsInset=" + this.actionsInset + ", cornerToActions=" + this.cornerToActions + ")";
        }

        public int hashCode() {
            int result2 = this.actionsPosition.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.cornerToText);
            result2 = result2 * 31 + Integer.hashCode(this.iconInset);
            result2 = result2 * 31 + Integer.hashCode(this.actionsInset);
            result2 = result2 * 31 + Integer.hashCode(this.cornerToActions);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TabInsets)) {
                return false;
            }
            TabInsets tabInsets = (TabInsets)other;
            if (this.actionsPosition != tabInsets.actionsPosition) {
                return false;
            }
            if (this.cornerToText != tabInsets.cornerToText) {
                return false;
            }
            if (this.iconInset != tabInsets.iconInset) {
                return false;
            }
            if (this.actionsInset != tabInsets.actionsInset) {
                return false;
            }
            return this.cornerToActions == tabInsets.cornerToActions;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TabLabel.ActionsPosition.values().length];
            try {
                nArray[TabLabel.ActionsPosition.RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabLabel.ActionsPosition.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabLabel.ActionsPosition.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

