/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.util.animation.Animations;
import com.intellij.util.animation.DoubleIntFunction;
import java.awt.Rectangle;
import java.util.function.DoubleFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/animation/DoubleRectangleFunction;", "Ljava/util/function/DoubleFunction;", "Ljava/awt/Rectangle;", "from", "to", "<init>", "(Ljava/awt/Rectangle;Ljava/awt/Rectangle;)V", "getFrom", "()Ljava/awt/Rectangle;", "getTo", "x", "Lcom/intellij/util/animation/DoubleIntFunction;", "y", "width", "height", "apply", "value", "", "intellij.platform.ide"})
public final class DoubleRectangleFunction
implements DoubleFunction<Rectangle> {
    @NotNull
    private final Rectangle from;
    @NotNull
    private final Rectangle to;
    @NotNull
    private final DoubleIntFunction x;
    @NotNull
    private final DoubleIntFunction y;
    @NotNull
    private final DoubleIntFunction width;
    @NotNull
    private final DoubleIntFunction height;

    public DoubleRectangleFunction(@NotNull Rectangle from, @NotNull Rectangle to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.from = from;
        this.to = to;
        this.x = Animations.access$range(this.from.x, this.to.x);
        this.y = Animations.access$range(this.from.y, this.to.y);
        this.width = Animations.access$range(this.from.width, this.to.width);
        this.height = Animations.access$range(this.from.height, this.to.height);
    }

    @NotNull
    public final Rectangle getFrom() {
        return this.from;
    }

    @NotNull
    public final Rectangle getTo() {
        return this.to;
    }

    @Override
    @NotNull
    public Rectangle apply(double value2) {
        return new Rectangle(this.x.apply(value2), this.y.apply(value2), this.width.apply(value2), this.height.apply(value2));
    }
}

