/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation.components;

import com.intellij.ui.JBColor;
import com.intellij.util.animation.Easing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0014J\r\u0010+\u001a\u00020\u0003*\u00020\u000eH\u0082\u0002J\r\u0010,\u001a\u00020\u0003*\u00020\u000eH\u0082\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/intellij/util/animation/components/BezierPainter;", "Ljavax/swing/JComponent;", "x1", "", "y1", "x2", "y2", "<init>", "(DDDD)V", "controlSize", "", "gridColor", "Lcom/intellij/ui/JBColor;", "<set-?>", "Ljava/awt/geom/Point2D;", "firstControlPoint", "getFirstControlPoint", "()Ljava/awt/geom/Point2D;", "setFirstControlPoint", "(Ljava/awt/geom/Point2D;)V", "firstControlPoint$delegate", "Lkotlin/properties/ReadWriteProperty;", "secondControlPoint", "getSecondControlPoint", "setSecondControlPoint", "secondControlPoint$delegate", "fireEvents", "", "prop", "Lkotlin/reflect/KProperty;", "oldValue", "", "newValue", "getEasing", "Lcom/intellij/util/animation/Easing;", "toScreenXY", "Ljava/awt/Point;", "point", "fromScreenXY", "Ljava/awt/geom/Point2D$Double;", "paintComponent", "g", "Ljava/awt/Graphics;", "component1", "component2", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nBezierPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BezierPainter.kt\ncom/intellij/util/animation/components/BezierPainter\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,138:1\n33#2,3:139\n33#2,3:142\n*S KotlinDebug\n*F\n+ 1 BezierPainter.kt\ncom/intellij/util/animation/components/BezierPainter\n*L\n19#1:139,3\n20#1:142,3\n*E\n"})
public class BezierPainter
extends JComponent {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final int controlSize;
    @NotNull
    private final JBColor gridColor = new JBColor(new Color(0xF0F0F0), new Color(0x313335));
    @NotNull
    private final ReadWriteProperty firstControlPoint$delegate;
    @NotNull
    private final ReadWriteProperty secondControlPoint$delegate;

    public BezierPainter(double x1, double y1, double x2, double y2) {
        this.controlSize = 10;
        Delegates delegates = Delegates.INSTANCE;
        Point2D.Double initialValue$iv = new Point2D.Double(x1, y1);
        boolean $i$f$observable = false;
        this.firstControlPoint$delegate = (ReadWriteProperty)new ObservableProperty<Point2D>((Object)initialValue$iv, this){
            final /* synthetic */ BezierPainter $receiver$inlined;
            {
                this.$receiver$inlined = bezierPainter;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void p2;
                void p1;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty p0 = property;
                boolean bl = false;
                BezierPainter.access$fireEvents(this.$receiver$inlined, p0, p1, p2);
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = new Point2D.Double(x2, y2);
        $i$f$observable = false;
        this.secondControlPoint$delegate = (ReadWriteProperty)new ObservableProperty<Point2D>((Object)initialValue$iv, this){
            final /* synthetic */ BezierPainter $receiver$inlined;
            {
                this.$receiver$inlined = bezierPainter;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void p2;
                void p1;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty p0 = property;
                boolean bl = false;
                BezierPainter.access$fireEvents(this.$receiver$inlined, p0, p1, p2);
            }
        };
        MouseAdapter value2 = new MouseAdapter(this){
            private int i;
            final /* synthetic */ BezierPainter this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                switch (this.i) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)point);
                        this.this$0.setFirstControlPoint(BezierPainter.access$fromScreenXY(this.this$0, point));
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)point);
                        this.this$0.setSecondControlPoint(BezierPainter.access$fromScreenXY(this.this$0, point));
                    }
                }
                this.this$0.repaint();
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                BezierPainter bezierPainter = this.this$0;
                Point $this$mouseMoved_u24lambda_u240 = point;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)$this$mouseMoved_u24lambda_u240);
                int n = this.intersects($this$mouseMoved_u24lambda_u240, bezierPainter.getFirstControlPoint()) ? 1 : (this.i = this.intersects($this$mouseMoved_u24lambda_u240, bezierPainter.getSecondControlPoint()) ? 2 : 0);
                if (this.i != 0) {
                    bezierPainter.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    bezierPainter.setCursor(Cursor.getDefaultCursor());
                }
            }

            private final boolean intersects(Point $this$intersects, Point2D point) {
                Point xy = BezierPainter.access$toScreenXY(this.this$0, point);
                return xy.x - BezierPainter.access$getControlSize$p(this.this$0) / 2 <= $this$intersects.x && $this$intersects.x <= xy.x + BezierPainter.access$getControlSize$p(this.this$0) / 2 && xy.y - BezierPainter.access$getControlSize$p(this.this$0) / 2 <= $this$intersects.y && $this$intersects.y <= xy.y + BezierPainter.access$getControlSize$p(this.this$0) / 2;
            }
        };
        this.addMouseMotionListener(value2);
        this.addMouseListener(value2);
        this.setMinimumSize(new Dimension(300, 300));
    }

    @NotNull
    public final Point2D getFirstControlPoint() {
        return (Point2D)this.firstControlPoint$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setFirstControlPoint(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.firstControlPoint$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)point2D);
    }

    @NotNull
    public final Point2D getSecondControlPoint() {
        return (Point2D)this.secondControlPoint$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setSecondControlPoint(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.secondControlPoint$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)point2D);
    }

    private final void fireEvents(KProperty<?> prop, Object oldValue, Object newValue) {
        if (!Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
            this.firePropertyChange(prop.getName(), oldValue, newValue);
            this.repaint();
        }
    }

    @NotNull
    public final Easing getEasing() {
        Easing easing = Easing.bezier(this.getFirstControlPoint().getX(), this.getFirstControlPoint().getY(), this.getSecondControlPoint().getX(), this.getSecondControlPoint().getY());
        Intrinsics.checkNotNullExpressionValue((Object)easing, (String)"bezier(...)");
        return easing;
    }

    private final Point toScreenXY(Point2D point) {
        Rectangle b = this.getVisibleRect();
        boolean bl = false;
        Insets insets = this.getInsets();
        int width = b.width - (insets.left + insets.right);
        int height = b.height - (insets.top + insets.bottom);
        return new Point((int)(point.getX() * (double)width + (double)insets.left + (double)b.x), height - (int)(point.getY() * (double)height) + insets.top + b.y);
    }

    private final Point2D.Double fromScreenXY(Point point) {
        Rectangle b = this.getVisibleRect();
        boolean bl = false;
        Insets insets = this.getInsets();
        int left = insets.left + b.x;
        int top = insets.top + b.y;
        int width = b.width - (insets.left + insets.right);
        int height = b.height - (insets.top + insets.bottom);
        double x = (double)Math.min(Math.max(-left, point.x - left), b.width - left) / (double)width;
        double y = (double)Math.min(Math.max(-top, point.y - top), b.height - top) / (double)height;
        return new Point2D.Double(x, 1.0 - y);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle bounds = this.getVisibleRect();
        Insets insets = this.getInsets();
        int x = bounds.x + insets.left;
        int y = bounds.y + insets.top;
        int width = bounds.width - (insets.left + insets.right);
        int height = bounds.height - (insets.top + insets.bottom);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, bounds.width, bounds.height);
        g2d.setColor((Color)this.gridColor);
        for (int i = 0; i < 5; ++i) {
            g2d.drawLine(x + width * i / 4, y, x + width * i / 4, y + height);
            g2d.drawLine(x, y + height * i / 4, x + width, y + height * i / 4);
        }
        Point point = this.toScreenXY(new Point2D.Double(0.0, 0.0));
        double x0 = this.component1(point);
        double y0 = this.component2(point);
        Point point2 = this.toScreenXY(this.getFirstControlPoint());
        double x1 = this.component1(point2);
        double y1 = this.component2(point2);
        Point point3 = this.toScreenXY(this.getSecondControlPoint());
        double x2 = this.component1(point3);
        double y2 = this.component2(point3);
        Point point4 = this.toScreenXY(new Point2D.Double(1.0, 1.0));
        double x3 = this.component1(point4);
        double y3 = this.component2(point4);
        CubicCurve2D.Double bez = new CubicCurve2D.Double(x0, y0, x1, y1, x2, y2, x3, y3);
        g2d.setColor(JBColor.foreground());
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(bez);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.isEnabled() ? new Color(151, 118, 169) : (JBColor.isBright() ? (Color)JBColor.LIGHT_GRAY : (Color)JBColor.GRAY));
        g2d.fillOval((int)x1 - this.controlSize / 2, (int)y1 - this.controlSize / 2, this.controlSize, this.controlSize);
        g2d.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
        g2d.setColor(this.isEnabled() ? new Color(208, 167, 8) : (JBColor.isBright() ? (Color)JBColor.LIGHT_GRAY : (Color)JBColor.GRAY));
        g2d.fillOval((int)x2 - this.controlSize / 2, (int)y2 - this.controlSize / 2, this.controlSize, this.controlSize);
        g2d.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
        g2d.dispose();
    }

    private final double component1(Point2D $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getX();
    }

    private final double component2(Point2D $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.getY();
    }

    public static final /* synthetic */ void access$fireEvents(BezierPainter $this, KProperty prop, Object oldValue, Object newValue) {
        $this.fireEvents(prop, oldValue, newValue);
    }

    public static final /* synthetic */ Point2D.Double access$fromScreenXY(BezierPainter $this, Point point) {
        return $this.fromScreenXY(point);
    }

    public static final /* synthetic */ Point access$toScreenXY(BezierPainter $this, Point2D point) {
        return $this.toScreenXY(point);
    }

    public static final /* synthetic */ int access$getControlSize$p(BezierPainter $this) {
        return $this.controlSize;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BezierPainter.class, "firstControlPoint", "getFirstControlPoint()Ljava/awt/geom/Point2D;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BezierPainter.class, "secondControlPoint", "getSecondControlPoint()Ljava/awt/geom/Point2D;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

