/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ProxyAuthentication;
import com.intellij.util.net.ProxyUtils;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/net/IdeProxyAuthenticator;", "Ljava/net/Authenticator;", "proxyAuth", "Lcom/intellij/util/net/ProxyAuthentication;", "<init>", "(Lcom/intellij/util/net/ProxyAuthentication;)V", "getPasswordAuthentication", "Ljava/net/PasswordAuthentication;", "toString", "", "Companion", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nIdeProxyAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeProxyAuthenticator.kt\ncom/intellij/util/net/IdeProxyAuthenticator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n60#2,5:71\n13#2:76\n*S KotlinDebug\n*F\n+ 1 IdeProxyAuthenticator.kt\ncom/intellij/util/net/IdeProxyAuthenticator\n*L\n39#1:71,5\n63#1:76\n*E\n"})
public final class IdeProxyAuthenticator
extends Authenticator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyAuthentication proxyAuth;
    @NotNull
    private static final Logger logger;

    public IdeProxyAuthenticator(@NotNull ProxyAuthentication proxyAuth) {
        Intrinsics.checkNotNullParameter((Object)proxyAuth, (String)"proxyAuth");
        this.proxyAuth = proxyAuth;
    }

    @Override
    @Nullable
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        Credentials credentials;
        boolean isProxy;
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this + " on " + Thread.currentThread(), e$iv);
        }
        boolean bl = isProxy = Authenticator.RequestorType.PROXY == this.getRequestorType() || Intrinsics.areEqual((Object)"SOCKS authentication", (Object)this.getRequestingPrompt());
        if (!isProxy) {
            return null;
        }
        String string = ProxyUtils.getHostNameReliably(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingURL());
        if (string == null) {
            string = "";
        }
        String host = string;
        int port = this.getRequestingPort();
        Credentials credentials2 = credentials = this.proxyAuth.getKnownAuthentication(host, port);
        if ((credentials2 != null ? credentials2.getUserName() : null) != null && credentials.getPassword() != null) {
            return IdeProxyAuthenticator.Companion.toPasswordAuthentication(credentials);
        }
        String string2 = this.getRequestingPrompt();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRequestingPrompt(...)");
        Credentials credentials3 = this.proxyAuth.getPromptedAuthentication(string2, host, port);
        return credentials3 != null ? IdeProxyAuthenticator.Companion.toPasswordAuthentication(credentials3) : null;
    }

    @NotNull
    public String toString() {
        String string = Integer.toString(System.identityHashCode(this), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "Auth@" + string + "{type=" + this.getRequestorType() + ", scheme=" + this.getRequestingScheme() + ", protocol=" + this.getRequestingProtocol() + ", prompt=" + this.getRequestingPrompt() + ", host=" + this.getRequestingHost() + ", port=" + this.getRequestingPort() + ", site=" + this.getRequestingSite() + ", url=" + this.getRequestingURL() + "}";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IdeProxyAuthenticator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IdeProxyAuthenticator.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/util/net/IdeProxyAuthenticator$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "toPasswordAuthentication", "Ljava/net/PasswordAuthentication;", "Lcom/intellij/credentialStore/Credentials;", "intellij.platform.ide"})
    private static final class Companion {
        private Companion() {
        }

        private final PasswordAuthentication toPasswordAuthentication(Credentials $this$toPasswordAuthentication) {
            Object object;
            String string;
            block5: {
                block4: {
                    if ($this$toPasswordAuthentication.getUserName() == null) {
                        return null;
                    }
                    string = $this$toPasswordAuthentication.getUserName();
                    Intrinsics.checkNotNull((Object)string);
                    object = $this$toPasswordAuthentication.getPassword();
                    if (object == null) break block4;
                    char[] cArray = OneTimeString.toCharArray$default((OneTimeString)object, (boolean)false, (int)1, null);
                    object = cArray;
                    if (cArray != null) break block5;
                }
                object = new char[0];
            }
            return new PasswordAuthentication(string, (char[])object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

