/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.scroll;

import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH&J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/ui/scroll/BoundedRangeModelThresholdListener;", "Ljavax/swing/event/ChangeListener;", "model", "Ljavax/swing/BoundedRangeModel;", "thresholdPercent", "", "<init>", "(Ljavax/swing/BoundedRangeModel;F)V", "stateChanged", "", "e", "Ljavax/swing/event/ChangeEvent;", "onThresholdReached", "isAtThreshold", "", "Companion", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nBoundedRangeModelThresholdListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundedRangeModelThresholdListener.kt\ncom/intellij/util/ui/scroll/BoundedRangeModelThresholdListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public abstract class BoundedRangeModelThresholdListener
implements ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BoundedRangeModel model;
    private final float thresholdPercent;

    public BoundedRangeModelThresholdListener(@NotNull BoundedRangeModel model, float thresholdPercent) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.thresholdPercent = thresholdPercent;
        if (!(this.thresholdPercent > 0.0f && this.thresholdPercent < 1.0f)) {
            boolean bl = false;
            String string = "Threshold should be a value greater than 0 and lesser than 1";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.model.getValueIsAdjusting()) {
            return;
        }
        if (this.isAtThreshold()) {
            this.onThresholdReached();
        }
    }

    public abstract void onThresholdReached();

    private final boolean isAtThreshold() {
        int visibleAmount = this.model.getExtent();
        int value2 = this.model.getValue();
        int maximum = this.model.getMaximum();
        if (maximum == 0) {
            return false;
        }
        float scrollFraction = (float)(visibleAmount + value2) / (float)maximum;
        return !(scrollFraction < this.thresholdPercent);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull JScrollBar scrollBar, float threshold, @NotNull Function0<Unit> listener2) {
        Companion.install(scrollBar, threshold, listener2);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull JScrollBar scrollBar, @NotNull Function0<Unit> listener2) {
        Companion.install(scrollBar, listener2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/util/ui/scroll/BoundedRangeModelThresholdListener$Companion;", "", "<init>", "()V", "install", "", "scrollBar", "Ljavax/swing/JScrollBar;", "threshold", "", "listener", "Lkotlin/Function0;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void install(@NotNull JScrollBar scrollBar, float threshold, @NotNull Function0<Unit> listener2) {
            Intrinsics.checkNotNullParameter((Object)scrollBar, (String)"scrollBar");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            BoundedRangeModel boundedRangeModel = scrollBar.getModel();
            scrollBar.getModel().addChangeListener(new BoundedRangeModelThresholdListener(threshold, listener2, boundedRangeModel){
                final /* synthetic */ Function0<Unit> $listener;
                {
                    this.$listener = $listener;
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1, $threshold);
                }

                public void onThresholdReached() {
                    this.$listener.invoke();
                }
            });
        }

        public static /* synthetic */ void install$default(Companion companion, JScrollBar jScrollBar, float f, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                f = 0.5f;
            }
            companion.install(jScrollBar, f, (Function0<Unit>)function0);
        }

        @JvmStatic
        @JvmOverloads
        public final void install(@NotNull JScrollBar scrollBar, @NotNull Function0<Unit> listener2) {
            Intrinsics.checkNotNullParameter((Object)scrollBar, (String)"scrollBar");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            com.intellij.util.ui.scroll.BoundedRangeModelThresholdListener$Companion.install$default(this, scrollBar, 0.0f, listener2, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

