/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001ag\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u000228\u0010\b\u001a4\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"lazyUiDisposable", "", "T", "parent", "Lcom/intellij/openapi/Disposable;", "ui", "Ljavax/swing/JComponent;", "child", "task", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/openapi/project/Project;", "project", "(Lcom/intellij/openapi/Disposable;Ljavax/swing/JComponent;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "intellij.platform.ide"})
public final class LazyUiDisposableKt {
    @ApiStatus.Internal
    public static final <T> void lazyUiDisposable(@Nullable Disposable parent, @NotNull JComponent ui, T child, @NotNull Function2<? super T, ? super Project, Unit> task) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        AtomicReference<JComponent> uiRef = new AtomicReference<JComponent>(ui);
        UiNotifyConnector.Once.Companion.installOn((Component)ui, new Activatable(uiRef, parent, task, child){
            final /* synthetic */ AtomicReference<JComponent> $uiRef;
            final /* synthetic */ Disposable $parent;
            final /* synthetic */ Function2<T, Project, Unit> $task;
            final /* synthetic */ T $child;
            {
                this.$uiRef = $uiRef;
                this.$parent = $parent;
                this.$task = $task;
                this.$child = $child;
            }

            public void showNotify() {
                JComponent jComponent = this.$uiRef.getAndSet(null);
                if (jComponent == null) {
                    return;
                }
                JComponent ui = jComponent;
                Project project = null;
                Disposable parent = this.$parent;
                if (ApplicationManager.getApplication() != null) {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)ui);
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    DataContext context = dataContext;
                    project = (Project)CommonDataKeys.PROJECT.getData(context);
                    if (parent == null) {
                        parent = (Disposable)PlatformDataKeys.UI_DISPOSABLE.getData(context);
                    }
                }
                if (parent == null) {
                    Disposable disposable;
                    if (project == null) {
                        $i$f$logger = false;
                        Logger logger = Logger.getInstance(Disposable.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("use application as a parent disposable");
                        disposable = (Disposable)ApplicationManager.getApplication();
                    } else {
                        $i$f$logger = false;
                        Logger logger = Logger.getInstance(Disposable.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("use project as a parent disposable");
                        disposable = (Disposable)project;
                    }
                    parent = disposable;
                }
                this.$task.invoke(this.$child, project);
                if (this.$child instanceof Disposable) {
                    Disposable disposable = parent;
                    Intrinsics.checkNotNull((Object)disposable);
                    Disposer.register((Disposable)disposable, (Disposable)((Disposable)this.$child));
                }
            }
        });
    }
}

