/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.openapi.util.io.CaseSensitivityAttribute;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelPosixFileInfo;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.ijent.community.impl.nio.EelPosixGroupPrincipal;
import com.intellij.platform.ijent.community.impl.nio.EelPosixUserPrincipal;
import com.intellij.platform.ijent.community.impl.nio.IjentNioBasicFileAttributes;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J\u0011\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\t\u0010\u001a\u001a\u00020\u0019H\u0096\u0001J\t\u0010\u001b\u001a\u00020\u0019H\u0096\u0001J\t\u0010\u001c\u001a\u00020\u0019H\u0096\u0001J\u0011\u0010\u001d\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J\u0011\u0010\u001e\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J\t\u0010\u001f\u001a\u00020 H\u0096\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPosixFileAttributes;", "Lcom/intellij/openapi/util/io/CaseSensitivityAttribute;", "Ljava/nio/file/attribute/PosixFileAttributes;", "Ljava/nio/file/attribute/BasicFileAttributes;", "fileInfo", "Lcom/intellij/platform/eel/fs/EelPosixFileInfo;", "<init>", "(Lcom/intellij/platform/eel/fs/EelPosixFileInfo;)V", "getFileInfo$intellij_platform_ijent_community_impl", "()Lcom/intellij/platform/eel/fs/EelPosixFileInfo;", "owner", "Ljava/nio/file/attribute/UserPrincipal;", "group", "Ljava/nio/file/attribute/GroupPrincipal;", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "getCaseSensitivity", "Lcom/intellij/openapi/util/io/FileAttributes$CaseSensitivity;", "creationTime", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "fileKey", "", "isDirectory", "", "isOther", "isRegularFile", "isSymbolicLink", "lastAccessTime", "lastModifiedTime", "size", "", "intellij.platform.ijent.community.impl"})
@SourceDebugExtension(value={"SMAP\nIjentNioBasicFileAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentNioBasicFileAttributes.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioPosixFileAttributes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n774#2:127\n865#2,2:128\n*S KotlinDebug\n*F\n+ 1 IjentNioBasicFileAttributes.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioPosixFileAttributes\n*L\n80#1:127\n80#1:128,2\n*E\n"})
public final class IjentNioPosixFileAttributes
implements CaseSensitivityAttribute,
PosixFileAttributes,
BasicFileAttributes {
    private final /* synthetic */ IjentNioBasicFileAttributes $$delegate_0;
    @NotNull
    private final EelPosixFileInfo fileInfo;

    public IjentNioPosixFileAttributes(@NotNull EelPosixFileInfo fileInfo) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        this.$$delegate_0 = new IjentNioBasicFileAttributes((EelFileInfo)fileInfo);
        this.fileInfo = fileInfo;
    }

    @NotNull
    public final EelPosixFileInfo getFileInfo$intellij_platform_ijent_community_impl() {
        return this.fileInfo;
    }

    @Override
    @NotNull
    public UserPrincipal owner() {
        return new EelPosixUserPrincipal(this.fileInfo.getPermissions().getOwner());
    }

    @Override
    @NotNull
    public GroupPrincipal group() {
        return new EelPosixGroupPrincipal(this.fileInfo.getPermissions().getGroup());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<PosixFilePermission> permissions() {
        Set set;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PosixFilePermission pfp = (PosixFilePermission)((Object)element$iv$iv);
            boolean bl = false;
            if (!(switch (WhenMappings.$EnumSwitchMapping$0[pfp.ordinal()]) {
                case 1 -> this.fileInfo.getPermissions().getOwnerCanRead();
                case 2 -> this.fileInfo.getPermissions().getOwnerCanWrite();
                case 3 -> this.fileInfo.getPermissions().getOwnerCanExecute();
                case 4 -> this.fileInfo.getPermissions().getGroupCanRead();
                case 5 -> this.fileInfo.getPermissions().getGroupCanWrite();
                case 6 -> this.fileInfo.getPermissions().getGroupCanExecute();
                case 7 -> this.fileInfo.getPermissions().getOtherCanRead();
                case 8 -> this.fileInfo.getPermissions().getOtherCanWrite();
                case 9 -> this.fileInfo.getPermissions().getOtherCanExecute();
                default -> throw new NoWhenBranchMatchedException();
            })) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List permissions = (List)destination$iv$iv;
        if (permissions.isEmpty()) {
            EnumSet<PosixFilePermission> enumSet = EnumSet.noneOf(PosixFilePermission.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
            set = enumSet;
        } else {
            EnumSet enumSet = EnumSet.copyOf((Collection)permissions);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(...)");
            set = enumSet;
        }
        return set;
    }

    @NotNull
    public FileAttributes.CaseSensitivity getCaseSensitivity() {
        EelPosixFileInfo.Type type = this.fileInfo.getType();
        if (!(type instanceof EelFileInfo.Type.Directory)) {
            throw new IllegalStateException("Cannot ask for case sensitivity of " + type);
        }
        return EelPathUtils.INSTANCE.getCaseSensitivity((EelFileInfo.Type.Directory)type);
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.$$delegate_0.lastModifiedTime();
    }

    @Override
    public FileTime lastAccessTime() {
        return this.$$delegate_0.lastAccessTime();
    }

    @Override
    public FileTime creationTime() {
        return this.$$delegate_0.creationTime();
    }

    @Override
    public boolean isRegularFile() {
        return this.$$delegate_0.isRegularFile();
    }

    @Override
    public boolean isDirectory() {
        return this.$$delegate_0.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.$$delegate_0.isSymbolicLink();
    }

    @Override
    public boolean isOther() {
        return this.$$delegate_0.isOther();
    }

    @Override
    public long size() {
        return this.$$delegate_0.size();
    }

    @Override
    public Object fileKey() {
        return this.$$delegate_0.fileKey();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<PosixFilePermission> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])PosixFilePermission.values());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PosixFilePermission.values().length];
            try {
                nArray[PosixFilePermission.OWNER_READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OWNER_WRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OWNER_EXECUTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.GROUP_READ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.GROUP_WRITE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.GROUP_EXECUTE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OTHERS_READ.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OTHERS_WRITE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OTHERS_EXECUTE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

