/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.ijent.community.impl.nio.EelPosixGroupPrincipal;
import com.intellij.platform.ijent.community.impl.nio.EelPosixUserPrincipal;
import com.intellij.platform.ijent.community.impl.nio.IjentNioBasicFileAttributeView;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPosixFileAttributeView;", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioBasicFileAttributeView;", "Ljava/nio/file/attribute/PosixFileAttributeView;", "api", "Lcom/intellij/platform/ijent/fs/IjentFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "nioPath", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "<init>", "(Lcom/intellij/platform/ijent/fs/IjentFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;)V", "name", "", "readAttributes", "Ljava/nio/file/attribute/PosixFileAttributes;", "setPermissions", "", "perms", "", "Ljava/nio/file/attribute/PosixFilePermission;", "setGroup", "group", "Ljava/nio/file/attribute/GroupPrincipal;", "getOwner", "Ljava/nio/file/attribute/UserPrincipal;", "setOwner", "owner", "intellij.platform.ijent.community.impl"})
public final class IjentNioPosixFileAttributeView
extends IjentNioBasicFileAttributeView
implements PosixFileAttributeView {
    public IjentNioPosixFileAttributeView(@NotNull IjentFileSystemApi api, @NotNull EelPath path, @NotNull IjentNioPath nioPath) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)nioPath, (String)"nioPath");
        super(api, path, nioPath);
    }

    @Override
    @Nullable
    public String name() {
        return "posix";
    }

    @Override
    @NotNull
    public PosixFileAttributes readAttributes() {
        PosixFileAttributes posixFileAttributes = Files.readAttributes((Path)this.getNioPath(), PosixFileAttributes.class, new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)posixFileAttributes, (String)"readAttributes(...)");
        return posixFileAttributes;
    }

    public void setPermissions(@Nullable Set<? extends PosixFilePermission> perms) {
        if (perms == null) {
            return;
        }
        this.getNioPath().getNioFs$intellij_platform_ijent_community_impl().provider().setAttribute(this.getNioPath(), "posix:permissions", perms, new LinkOption[0]);
    }

    @Override
    public void setGroup(@NotNull GroupPrincipal group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        if (!(group instanceof EelPosixGroupPrincipal)) {
            throw new UnsupportedOperationException("Unsupported group principal: " + group);
        }
        this.getNioPath().getNioFs$intellij_platform_ijent_community_impl().provider().setAttribute(this.getNioPath(), "posix:group", group, new LinkOption[0]);
    }

    @Override
    @Nullable
    public UserPrincipal getOwner() {
        return this.readAttributes().owner();
    }

    @Override
    public void setOwner(@NotNull UserPrincipal owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!(owner instanceof EelPosixUserPrincipal)) {
            throw new UnsupportedOperationException("Unsupported user principal: " + owner);
        }
        this.getNioPath().getNioFs$intellij_platform_ijent_community_impl().provider().setAttribute(this.getNioPath(), "posix:owner", owner, new LinkOption[0]);
    }
}

