/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.impl.CompositeQuery;
import com.intellij.model.search.impl.SearchParametersQuery;
import com.intellij.model.search.impl.SearchWordQueryBuilderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0014\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u00050\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/model/search/impl/SearchServiceImpl;", "Lcom/intellij/model/search/SearchService;", "<init>", "()V", "searchParameters", "Lcom/intellij/util/Query;", "T", "parameters", "Lcom/intellij/model/search/SearchParameters;", "searchWord", "Lcom/intellij/model/search/SearchWordQueryBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "word", "", "merge", "queries", "", "intellij.platform.indexing.impl"})
public final class SearchServiceImpl
implements SearchService {
    @NotNull
    public <T> Query<? extends T> searchParameters(@NotNull SearchParameters<T> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return new SearchParametersQuery<T>(parameters);
    }

    @NotNull
    public SearchWordQueryBuilder searchWord(@NotNull Project project, @NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return new SearchWordQueryBuilderImpl(project, word, null, false, null, null, null, null, null, 508, null);
    }

    @NotNull
    public <T> Query<? extends T> merge(@NotNull List<? extends Query<? extends T>> queries) {
        Query query;
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        switch (queries.size()) {
            case 0: {
                Query query2 = EmptyQuery.getEmptyQuery();
                query = query2;
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"getEmptyQuery(...)");
                break;
            }
            case 1: {
                query = queries.get(0);
                break;
            }
            default: {
                query = new CompositeQuery((Collection)queries);
            }
        }
        return query;
    }
}

