/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFilterLexer
extends DelegateLexer
implements IdTableBuilding.ScanWordProcessor {
    private static final Logger LOG = Logger.getInstance(BaseFilterLexer.class);
    private final OccurrenceConsumer myOccurrenceConsumer;
    private int myTodoScannedBound = 0;
    private int myOccurenceMask;
    private TodoScanningState myTodoScanningState;
    private CharSequence myCachedBufferSequence;
    private char[] myCachedArraySequence;

    protected BaseFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer);
        this.myOccurrenceConsumer = occurrenceConsumer;
    }

    protected final void advanceTodoItemCountsInToken() {
        if (!this.myOccurrenceConsumer.isNeedToDo()) {
            return;
        }
        int start = this.getTokenStart();
        int end = this.getTokenEnd();
        if ((start = Math.max(start, this.myTodoScannedBound)) >= end) {
            return;
        }
        CharSequence input = this.myCachedBufferSequence.subSequence(start, end);
        if (this.myTodoScanningState == null) {
            this.myTodoScanningState = BaseFilterLexer.createTodoScanningState(IndexPatternUtil.getIndexPatterns());
        }
        BaseFilterLexer.advanceTodoItemsCount(input, this.myOccurrenceConsumer, this.myTodoScanningState);
        this.myTodoScannedBound = end;
    }

    @ApiStatus.Internal
    @NotNull
    public static TodoScanningState createTodoScanningState(IndexPattern[] patterns) {
        Matcher[] matchers = new Matcher[patterns.length];
        TodoScanningState todoScanningState = new TodoScanningState(patterns, matchers);
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i].getOptimizedIndexingPattern();
            if (pattern == null) continue;
            matchers[i] = pattern.matcher("");
        }
        TodoScanningState todoScanningState2 = todoScanningState;
        if (todoScanningState2 == null) {
            BaseFilterLexer.$$$reportNull$$$0(0);
        }
        return todoScanningState2;
    }

    @ApiStatus.Internal
    public static void advanceTodoItemsCount(CharSequence input, OccurrenceConsumer consumer, TodoScanningState todoScanningState) {
        todoScanningState.myOccurrences.clear();
        for (int i = todoScanningState.myMatchers.length - 1; i >= 0; --i) {
            Matcher matcher = todoScanningState.myMatchers[i];
            if (matcher == null) continue;
            matcher.reset(input);
            try {
                while (matcher.find()) {
                    ProgressManager.checkCanceled();
                    int start = matcher.start();
                    if (start == matcher.end() || todoScanningState.myOccurrences.contains(start)) continue;
                    consumer.incTodoOccurrence(todoScanningState.myPatterns[i]);
                    todoScanningState.myOccurrences.add(start);
                }
                continue;
            }
            catch (StackOverflowError error) {
                LOG.error((Throwable)error);
            }
        }
    }

    @Override
    public final void run(CharSequence chars, char @Nullable [] charsArray, int start, int end) {
        this.myOccurrenceConsumer.addOccurrence(chars, charsArray, start, end, this.myOccurenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask) {
        this.myOccurrenceConsumer.addOccurrence(this.myCachedBufferSequence, this.myCachedArraySequence, this.getTokenStart(), this.getTokenEnd(), occurrenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask, int offset, int length) {
        this.myOccurrenceConsumer.addOccurrence(this.myCachedBufferSequence, this.myCachedArraySequence, this.getTokenStart() + offset, Math.min(this.getTokenStart() + offset + length, this.getTokenEnd()), occurrenceMask);
    }

    protected final void scanWordsInToken(int occurrenceMask, boolean mayHaveFileRefs, boolean mayHaveEscapes) {
        this.myOccurenceMask = occurrenceMask;
        int start = this.getTokenStart();
        int end = this.getTokenEnd();
        IdTableBuilding.scanWords(this, this.myCachedBufferSequence, this.myCachedArraySequence, start, end, mayHaveEscapes, this.getWordCodePointPredicate());
        if (mayHaveFileRefs) {
            this.processPossibleComplexFileName(this.myCachedBufferSequence, this.myCachedArraySequence, start, end);
        }
    }

    protected IntPredicate getWordCodePointPredicate() {
        return IdTableBuilding::isWordCodePoint;
    }

    private void processPossibleComplexFileName(CharSequence chars, char[] cachedArraySequence, int startOffset, int endOffset) {
        int offset = BaseFilterLexer.findCharsWithinRange(chars, startOffset, endOffset, "/\\");
        offset = Math.min(offset, endOffset);
        int start = startOffset;
        while (start < endOffset) {
            if (start != offset) {
                this.myOccurrenceConsumer.addOccurrence(chars, cachedArraySequence, start, offset, 8);
            }
            start = offset + 1;
            offset = Math.min(endOffset, BaseFilterLexer.findCharsWithinRange(chars, start, endOffset, "/\\"));
        }
    }

    private static int findCharsWithinRange(CharSequence chars, int startOffset, int endOffset, String charsToFind) {
        while (startOffset < endOffset) {
            if (charsToFind.indexOf(chars.charAt(startOffset)) != -1) {
                return startOffset;
            }
            ++startOffset;
        }
        return startOffset;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BaseFilterLexer.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myCachedBufferSequence = this.getBufferSequence();
        this.myCachedArraySequence = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)this.myCachedBufferSequence);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/BaseFilterLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTodoScanningState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/BaseFilterLexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static final class TodoScanningState {
        final IndexPattern[] myPatterns;
        final Matcher[] myMatchers;
        final IntList myOccurrences;

        public TodoScanningState(IndexPattern[] patterns, Matcher[] matchers) {
            this.myPatterns = patterns;
            this.myMatchers = matchers;
            this.myOccurrences = new IntArrayList(1);
        }
    }
}

