/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.impl.cache.impl.id.IdEntryToScopeMap;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.RepresentableAsByteArraySequence;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IdEntryToScopeMapImpl
extends AbstractMap<IdIndexEntry, Integer>
implements IdEntryToScopeMap,
RepresentableAsByteArraySequence {
    @NotNull
    private final Int2IntOpenHashMapWithFastMergeInt idHashToScopeMask;
    private transient ByteArraySequence serializedData;
    private static final ThreadLocalCachedIntArray intsArrayPool = new ThreadLocalCachedIntArray();

    public IdEntryToScopeMapImpl() {
        this(new Int2IntOpenHashMapWithFastMergeInt());
    }

    public IdEntryToScopeMapImpl(int initialCapacity) {
        this(new Int2IntOpenHashMapWithFastMergeInt(initialCapacity));
    }

    public IdEntryToScopeMapImpl(@NotNull Map<IdIndexEntry, Integer> toCopy) {
        if (toCopy == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(0);
        }
        this(IdEntryToScopeMapImpl.compactCopyOf(toCopy));
    }

    private IdEntryToScopeMapImpl(@NotNull Int2IntOpenHashMapWithFastMergeInt hashToScopeMask) {
        if (hashToScopeMask == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(1);
        }
        this.serializedData = null;
        this.idHashToScopeMask = hashToScopeMask;
    }

    @Override
    public int size() {
        return this.idHashToScopeMask.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof IdIndexEntry) {
            IdIndexEntry entry = (IdIndexEntry)key;
            return this.idHashToScopeMask.containsKey(entry.getWordHashCode());
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof IdIndexEntry) {
            IdIndexEntry entry = (IdIndexEntry)key;
            return this.idHashToScopeMask.get(entry.getWordHashCode());
        }
        return null;
    }

    @Override
    @NotNull
    public Set<IdIndexEntry> keySet() {
        return new AbstractSet<IdIndexEntry>(){

            @Override
            public boolean contains(Object o) {
                return IdEntryToScopeMapImpl.this.containsKey(o);
            }

            @Override
            @NotNull
            public Iterator<IdIndexEntry> iterator() {
                return new Iterator<IdIndexEntry>(){
                    final IntIterator iterator;
                    {
                        this.iterator = IdEntryToScopeMapImpl.this.idHashToScopeMask.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public IdIndexEntry next() {
                        return new IdIndexEntry(this.iterator.nextInt());
                    }
                };
            }

            @Override
            public int size() {
                return IdEntryToScopeMapImpl.this.idHashToScopeMask.size();
            }
        };
    }

    @Override
    @NotNull
    public Collection<Integer> values() {
        IntCollection intCollection = this.idHashToScopeMask.values();
        if (intCollection == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(2);
        }
        return intCollection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<IdIndexEntry, Integer>> entrySet() {
        return new AbstractSet<Map.Entry<IdIndexEntry, Integer>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<IdIndexEntry, Integer>> iterator() {
                return new Iterator<Map.Entry<IdIndexEntry, Integer>>(){
                    final ObjectIterator<Int2IntMap.Entry> iterator;
                    {
                        this.iterator = IdEntryToScopeMapImpl.this.idHashToScopeMask.int2IntEntrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<IdIndexEntry, Integer> next() {
                        Int2IntMap.Entry entry = (Int2IntMap.Entry)this.iterator.next();
                        return Map.entry(new IdIndexEntry(entry.getIntKey()), entry.getIntValue());
                    }
                };
            }

            @Override
            public int size() {
                return IdEntryToScopeMapImpl.this.idHashToScopeMask.size();
            }
        };
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super IdIndexEntry, ? super Integer> consumer) {
        if (consumer == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(3);
        }
        this.forEach((int hash, int value) -> {
            consumer.accept(new IdIndexEntry(hash), value);
            return true;
        });
    }

    @Override
    public void forEach(@NotNull IdEntryToScopeMap.BiIntConsumer consumer) {
        if (consumer == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(4);
        }
        ObjectIterator iterator = this.idHashToScopeMask.int2IntEntrySet().fastIterator();
        while (iterator.hasNext()) {
            int scopeMask;
            Int2IntMap.Entry entry = (Int2IntMap.Entry)iterator.next();
            int idHash = entry.getIntKey();
            if (consumer.consume(idHash, scopeMask = entry.getIntValue())) continue;
            return;
        }
    }

    public void updateMask(int hash, int occurrenceMask) {
        this.idHashToScopeMask.mergeInt(hash, occurrenceMask, (prev, cur) -> prev | cur);
        if (this.serializedData != null) {
            this.serializedData = null;
        }
    }

    ByteArraySequence ensureSerializedDataCached() {
        if (this.serializedData == null) {
            int estimatedBufferSize = IdEntryToScopeMapImpl.estimatedBufferSize(this.size());
            UnsyncByteArrayOutputStream stream = new UnsyncByteArrayOutputStream(estimatedBufferSize);
            try (DataOutputStream dos = new DataOutputStream((OutputStream)stream);){
                IdEntryToScopeMapImpl.writeTo(this, dos);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.serializedData = stream.toByteArraySequence();
        }
        return this.serializedData;
    }

    @NotNull
    public ByteArraySequence asByteArraySequence() {
        ByteArraySequence byteArraySequence = this.ensureSerializedDataCached();
        if (byteArraySequence == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(5);
        }
        return byteArraySequence;
    }

    public void writeTo(@NotNull DataOutput out) throws IOException {
        if (out == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(6);
        }
        this.ensureSerializedDataCached();
        out.write(this.serializedData.getInternalBuffer(), this.serializedData.getOffset(), this.serializedData.getLength());
    }

    private static void writeTo(@NotNull IdEntryToScopeMap idToScopeMap, @NotNull DataOutput out) throws IOException {
        if (idToScopeMap == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(7);
        }
        if (out == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(8);
        }
        int size = idToScopeMap.size();
        DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
        if (size == 0) {
            return;
        }
        Int2ObjectOpenHashMap scopeMaskToHashes = new Int2ObjectOpenHashMap(8);
        idToScopeMap.forEach((arg_0, arg_1) -> IdEntryToScopeMapImpl.lambda$writeTo$3((Int2ObjectMap)scopeMaskToHashes, arg_0, arg_1));
        IntIterator intIterator = scopeMaskToHashes.keySet().iterator();
        while (intIterator.hasNext()) {
            int scopeMask = (Integer)intIterator.next();
            out.writeByte(scopeMask & 0xFF);
            IntList idHashes = (IntList)scopeMaskToHashes.get(scopeMask);
            int hashesCount = idHashes.size();
            if (hashesCount == 0) {
                throw new IllegalStateException("hashesCount(scope: " + scopeMask + ")(=" + hashesCount + ") must be > 0");
            }
            IdEntryToScopeMapImpl.save(out, idHashes);
        }
    }

    private static void save(DataOutput out, IntList idHashes) throws IOException {
        idHashes.sort(null);
        DataInputOutputUtil.writeDiffCompressed((DataOutput)out, (IntList)idHashes);
    }

    private static int estimatedBufferSize(int size) {
        int averageScopeMasksCount = 5;
        int averageVarintSize = 2;
        int estimatedSize = (1 + averageScopeMasksCount + size) * averageVarintSize + averageScopeMasksCount;
        return Math.max(estimatedSize, 32);
    }

    private static Int2IntOpenHashMapWithFastMergeInt compactCopyOf(@NotNull Map<IdIndexEntry, Integer> toCopy) {
        if (toCopy == null) {
            IdEntryToScopeMapImpl.$$$reportNull$$$0(9);
        }
        Int2IntOpenHashMapWithFastMergeInt copy = new Int2IntOpenHashMapWithFastMergeInt(toCopy.size());
        for (Map.Entry<IdIndexEntry, Integer> entry : toCopy.entrySet()) {
            copy.put(entry.getKey().getWordHashCode(), entry.getValue());
        }
        return copy;
    }

    private static /* synthetic */ boolean lambda$writeTo$3(Int2ObjectMap scopeMaskToHashes, int idHash, int scopeMask) {
        IntList idHashes = (IntList)scopeMaskToHashes.computeIfAbsent(scopeMask, __ -> new IntArrayList());
        idHashes.add(idHash);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToScopeMask";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdEntryToScopeMapImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToScopeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdEntryToScopeMapImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asByteArraySequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compactCopyOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    public static class Int2IntOpenHashMapWithFastMergeInt
    extends Int2IntOpenHashMap {
        public Int2IntOpenHashMapWithFastMergeInt() {
        }

        public Int2IntOpenHashMapWithFastMergeInt(int expected) {
            super(expected);
        }

        public int mergeInt(int key, int value, @NotNull IntBinaryOperator remappingFunction) {
            if (remappingFunction == null) {
                Int2IntOpenHashMapWithFastMergeInt.$$$reportNull$$$0(0);
            }
            if (key == 0) {
                if (this.containsNullKey) {
                    int oldValue = this.value[this.n];
                    int newValue = remappingFunction.applyAsInt(oldValue, value);
                    if (newValue == oldValue) {
                        return oldValue;
                    }
                    this.value[this.n] = newValue;
                    return newValue;
                }
                this.put(key, value);
                return value;
            }
            int[] keys = this.key;
            int pos = HashCommon.mix((int)key) & this.mask;
            while (true) {
                int currKey;
                if ((currKey = keys[pos]) == 0) {
                    this.put(key, value);
                    return value;
                }
                if (key == currKey) {
                    int oldValue = this.value[pos];
                    int newValue = remappingFunction.applyAsInt(oldValue, value);
                    if (newValue == oldValue) {
                        return oldValue;
                    }
                    this.value[pos] = newValue;
                    return newValue;
                }
                pos = pos + 1 & this.mask;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remappingFunction", "com/intellij/psi/impl/cache/impl/id/IdEntryToScopeMapImpl$Int2IntOpenHashMapWithFastMergeInt", "mergeInt"));
        }
    }
}

