/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ValueLessInputMapExternalizer<Key>
implements DataExternalizer<Map<Key, Void>> {
    private final DataExternalizer<Collection<Key>> keysExternalizer;

    public ValueLessInputMapExternalizer(@NotNull DataExternalizer<Collection<Key>> keysExternalizer) {
        if (keysExternalizer == null) {
            ValueLessInputMapExternalizer.$$$reportNull$$$0(0);
        }
        this.keysExternalizer = keysExternalizer;
    }

    public void save(@NotNull DataOutput stream, Map<Key, Void> data) throws IOException {
        if (stream == null) {
            ValueLessInputMapExternalizer.$$$reportNull$$$0(1);
        }
        int size = data.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
        if (size == 0) {
            return;
        }
        this.keysExternalizer.save(stream, data.keySet());
    }

    public Map<Key, Void> read(@NotNull DataInput in) throws IOException {
        int entriesCount;
        if (in == null) {
            ValueLessInputMapExternalizer.$$$reportNull$$$0(2);
        }
        if ((entriesCount = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            return Collections.emptyMap();
        }
        Collection keys = (Collection)this.keysExternalizer.read(in);
        return new MapWithNullValues(new ObjectOpenHashSet(keys));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/ValueLessInputMapExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MapWithNullValues<Key>
    extends AbstractMap<Key, Void> {
        private final Set<Key> keys;

        private MapWithNullValues(@NotNull Set<Key> keys) {
            if (keys == null) {
                MapWithNullValues.$$$reportNull$$$0(0);
            }
            this.keys = keys;
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.keys.contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return value == null;
        }

        @Override
        public Void get(Object key) {
            return null;
        }

        @Override
        @Nullable
        public Void put(Key key, Void value) {
            if (value != null) {
                throw new IllegalArgumentException("Only null values are accepted, but got: " + String.valueOf(value));
            }
            this.keys.add(key);
            return null;
        }

        @Override
        public Void remove(Object key) {
            this.keys.remove(key);
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends Key, ? extends Void> m) {
            if (m == null) {
                MapWithNullValues.$$$reportNull$$$0(1);
            }
            this.keys.addAll(m.keySet());
        }

        @Override
        public void clear() {
            this.keys.clear();
        }

        @Override
        public void forEach(BiConsumer<? super Key, ? super Void> action) {
            Objects.requireNonNull(action);
            for (Key key : this.keys) {
                action.accept(key, null);
            }
        }

        @Override
        @NotNull
        public Set<Map.Entry<Key, Void>> entrySet() {
            return new AbstractSet<Map.Entry<Key, Void>>(){

                @Override
                public Iterator<Map.Entry<Key, Void>> iterator() {
                    final Iterator keysIterator = keys.iterator();
                    return new Iterator<Map.Entry<Key, Void>>(this){

                        @Override
                        public boolean hasNext() {
                            return keysIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<Key, Void> next() {
                            final Object key = keysIterator.next();
                            return new Map.Entry<Key, Void>(this){

                                @Override
                                public Key getKey() {
                                    return key;
                                }

                                @Override
                                public Void getValue() {
                                    return null;
                                }

                                @Override
                                public Void setValue(Void value) {
                                    return null;
                                }
                            };
                        }
                    };
                }

                @Override
                public int size() {
                    return keys.size();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/ValueLessInputMapExternalizer$MapWithNullValues";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putAll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

