/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexIdRuleValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "<init>", "()V", "getRuleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "validatePlugin", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
public final class IndexIdRuleValidator
extends CustomValidationRule {
    @NotNull
    public String getRuleId() {
        return "index_id";
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (CustomValidationRule.isThirdPartyValue((String)data)) {
            return ValidationResultType.ACCEPTED;
        }
        boolean runningFromSources = PluginManagerCore.isRunningFromSources();
        ID iD = ID.findByName((String)data);
        if (iD == null) {
            return ValidationResultType.REJECTED;
        }
        ID id = iD;
        PluginId pluginId = id.getPluginId();
        if (pluginId != null) {
            return this.validatePlugin(PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId));
        }
        if (!runningFromSources) {
            return ValidationResultType.ACCEPTED;
        }
        FileBasedIndexExtension extension = (FileBasedIndexExtension)FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(arg_0 -> IndexIdRuleValidator.doValidate$lambda$1(arg_0 -> IndexIdRuleValidator.doValidate$lambda$0(data, arg_0), arg_0));
        if (extension != null) {
            return this.validatePlugin(PluginInfoDetectorKt.getPluginInfo(extension.getClass()));
        }
        StubIndexExtension stubExtension = (StubIndexExtension)StubIndexExtension.EP_NAME.findFirstSafe(arg_0 -> IndexIdRuleValidator.doValidate$lambda$3(arg_0 -> IndexIdRuleValidator.doValidate$lambda$2(data, arg_0), arg_0));
        if (stubExtension != null) {
            return this.validatePlugin(PluginInfoDetectorKt.getPluginInfo(stubExtension.getClass()));
        }
        return ValidationResultType.REJECTED;
    }

    private final ValidationResultType validatePlugin(PluginInfo info) {
        if (info.getType() == PluginType.UNKNOWN) {
            return ValidationResultType.REJECTED;
        }
        return info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }

    private static final boolean doValidate$lambda$0(String $data, FileBasedIndexExtension ex) {
        return Intrinsics.areEqual((Object)ex.getName().getName(), (Object)$data);
    }

    private static final boolean doValidate$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean doValidate$lambda$2(String $data, StubIndexExtension ex) {
        return Intrinsics.areEqual((Object)ex.getKey().getName(), (Object)$data);
    }

    private static final boolean doValidate$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

