/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.hints;

import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseWeakBinaryFileInputFilter;
import com.intellij.util.indexing.hints.BinaryFileTypePolicy;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/hints/FileNameExtensionInputFilter;", "Lcom/intellij/util/indexing/hints/BaseWeakBinaryFileInputFilter;", "extension", "", "ignoreCase", "", "binary", "Lcom/intellij/util/indexing/hints/BinaryFileTypePolicy;", "<init>", "(Ljava/lang/String;ZLcom/intellij/util/indexing/hints/BinaryFileTypePolicy;)V", "dotExtension", "slowPathIfFileTypeHintUnsure", "file", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.platform.indexing.impl"})
@ApiStatus.Experimental
public final class FileNameExtensionInputFilter
extends BaseWeakBinaryFileInputFilter {
    private final boolean ignoreCase;
    @NotNull
    private final String dotExtension;

    public FileNameExtensionInputFilter(@NotNull String extension, boolean ignoreCase, @NotNull BinaryFileTypePolicy binary) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)((Object)binary), (String)"binary");
        super(binary, FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION);
        this.ignoreCase = ignoreCase;
        this.dotExtension = "." + extension;
    }

    public /* synthetic */ FileNameExtensionInputFilter(String string, boolean bl, BinaryFileTypePolicy binaryFileTypePolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            binaryFileTypePolicy = BinaryFileTypePolicy.BINARY_OR_NON_BINARY;
        }
        this(string, bl, binaryFileTypePolicy);
    }

    public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return StringsKt.endsWith((String)string, (String)this.dotExtension, (boolean)this.ignoreCase);
    }
}

