/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.UpdatedEntryProcessor;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SingleEntryIndexForwardIndexAccessor<V>
extends AbstractMapForwardIndexAccessor<Integer, V, Void> {
    private final NotNullLazyValue<UpdatableIndex<Integer, V, ?, ?>> myIndex;

    public SingleEntryIndexForwardIndexAccessor(SingleEntryFileBasedIndexExtension<V> extension) {
        super((DataExternalizer)VoidDataExternalizer.INSTANCE);
        ID name = extension.getName();
        FileBasedIndexEx fileBasedIndex = (FileBasedIndexEx)FileBasedIndex.getInstance();
        this.myIndex = NotNullLazyValue.volatileLazy(() -> fileBasedIndex.getIndex(name));
    }

    @NotNull
    public InputDataDiffBuilder<Integer, V> createDiffBuilderByMap(int inputId, @Nullable Map<Integer, V> map) throws IOException {
        return new SingleValueDiffBuilder(inputId, ContainerUtil.notNullize(map));
    }

    @NotNull
    public final InputDataDiffBuilder<Integer, V> getDiffBuilder(int inputId, @Nullable ByteArraySequence sequence) throws IOException {
        Map<Integer, V> data = this.fetchInputDataFromIndex(inputId);
        InputDataDiffBuilder<Integer, V> inputDataDiffBuilder = this.createDiffBuilderByMap(inputId, data);
        if (inputDataDiffBuilder == null) {
            SingleEntryIndexForwardIndexAccessor.$$$reportNull$$$0(0);
        }
        return inputDataDiffBuilder;
    }

    @Nullable
    protected Map<Integer, V> convertToMap(int inputId, @Nullable Void inputData) throws IOException {
        return this.fetchInputDataFromIndex(inputId);
    }

    private Map<Integer, V> fetchInputDataFromIndex(int inputId) throws IOException {
        try {
            return (Map)ProgressManager.getInstance().computeInNonCancelableSection(() -> ((UpdatableIndex)this.myIndex.getValue()).getIndexedFileData(inputId));
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public Void convertToDataType(@NotNull InputData<Integer, V> data) {
        if (data == null) {
            SingleEntryIndexForwardIndexAccessor.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public final ByteArraySequence serializeIndexedData(@NotNull InputData<Integer, V> data) {
        if (data == null) {
            SingleEntryIndexForwardIndexAccessor.$$$reportNull$$$0(2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToDataType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexedData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static final class SingleValueDiffBuilder<V>
    extends DirectInputDataDiffBuilder<Integer, V> {
        private final boolean myContainsValue;
        @Nullable
        private final V myCurrentValue;

        public SingleValueDiffBuilder(int inputId, @NotNull Map<Integer, V> currentData) {
            if (currentData == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(0);
            }
            this(inputId, !currentData.isEmpty(), ContainerUtil.getFirstItem(currentData.values()));
        }

        private SingleValueDiffBuilder(int inputId, boolean containsValue, @Nullable V currentValue) {
            super(inputId);
            this.myContainsValue = containsValue;
            this.myCurrentValue = currentValue;
        }

        @NotNull
        public Collection<Integer> getKeys() {
            Set<Integer> set = this.myContainsValue ? Collections.singleton(this.myInputId) : Collections.emptySet();
            if (set == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(1);
            }
            return set;
        }

        public boolean differentiate(@NotNull Map<Integer, V> newData, @NotNull UpdatedEntryProcessor<? super Integer, ? super V> changesProcessor) throws StorageException {
            if (newData == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(2);
            }
            if (changesProcessor == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(3);
            }
            boolean newValueExists = !newData.isEmpty();
            Object newValue = ContainerUtil.getFirstItem(newData.values());
            if (this.myContainsValue) {
                if (!newValueExists) {
                    changesProcessor.removed((Object)this.myInputId, this.myInputId);
                    return true;
                }
                if (Comparing.equal(this.myCurrentValue, (Object)newValue)) {
                    return false;
                }
                changesProcessor.updated((Object)this.myInputId, newValue, this.myInputId);
                return true;
            }
            if (newValueExists) {
                changesProcessor.added((Object)this.myInputId, newValue, this.myInputId);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor$SingleValueDiffBuilder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor$SingleValueDiffBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "differentiate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

