/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage.sharding;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface ShardableIndexExtension {
    public int shardsCount();

    default public int shardNo(int inputId) {
        return inputId % this.shardsCount();
    }

    public static int determineShardsCount(int enforcedShardsCount) {
        if (enforcedShardsCount > 0) {
            return enforcedShardsCount;
        }
        int cpus = Runtime.getRuntime().availableProcessors();
        if (cpus <= 16) {
            return 1;
        }
        if (cpus <= 32) {
            return 2;
        }
        return 3;
    }

    public int shardlessVersion();
}

