/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage.sharding;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShardedIndexStorage<K, V>
implements VfsAwareIndexStorage<K, V> {
    private final FileBasedIndexExtension<K, V> extension;
    private final VfsAwareIndexStorage<K, V>[] shards;
    private volatile boolean closed;

    ShardedIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull ThrowableNotNullFunction<Integer, VfsAwareIndexStorage<K, V>, IOException> storagesFactory) throws IOException {
        if (extension == null) {
            ShardedIndexStorage.$$$reportNull$$$0(0);
        }
        if (storagesFactory == null) {
            ShardedIndexStorage.$$$reportNull$$$0(1);
        }
        this.closed = false;
        if (!(extension instanceof ShardableIndexExtension)) {
            throw new IllegalArgumentException("Extension(" + String.valueOf(extension) + ") must be ShardableIndexExtension");
        }
        ShardableIndexExtension shardableExtension = (ShardableIndexExtension)extension;
        this.extension = extension;
        this.shards = new VfsAwareIndexStorage[shardableExtension.shardsCount()];
        try {
            for (int shardNo = 0; shardNo < this.shards.length; ++shardNo) {
                this.shards[shardNo] = (VfsAwareIndexStorage)storagesFactory.fun((Object)shardNo);
            }
        }
        catch (Throwable e) {
            try {
                IOUtil.closeAllSafely(this.shards);
            }
            catch (Throwable closeEx) {
                e.addSuppressed(closeEx);
            }
            throw e;
        }
    }

    public void addValue(K key, int inputId, V value) throws StorageException {
        IndexStorage<K, V> shard = this.shardFor(inputId);
        shard.addValue(key, inputId, value);
    }

    public void removeAllValues(@NotNull K key, int inputId) throws StorageException {
        if (key == null) {
            ShardedIndexStorage.$$$reportNull$$$0(2);
        }
        IndexStorage<K, V> shard = this.shardFor(inputId);
        shard.removeAllValues(key, inputId);
    }

    public void updateValue(K key, int inputId, V newValue) throws StorageException {
        IndexStorage<K, V> shard = this.shardFor(inputId);
        shard.updateValue(key, inputId, newValue);
    }

    private IndexStorage<K, V> shardFor(int inputId) {
        ShardableIndexExtension shardable = (ShardableIndexExtension)this.extension;
        int shardNo = shardable.shardNo(inputId);
        return this.shards[shardNo];
    }

    public <E extends Exception> boolean read(K key, @NotNull ValueContainerProcessor<V, E> processor) throws StorageException, E {
        if (processor == null) {
            ShardedIndexStorage.$$$reportNull$$$0(3);
        }
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            boolean shouldContinue = shard.read(key, processor);
            if (shouldContinue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            ShardedIndexStorage.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            ShardedIndexStorage.$$$reportNull$$$0(5);
        }
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            boolean shouldContinue = shard.processKeys(processor, scope, idFilter);
            if (shouldContinue) continue;
            return false;
        }
        return true;
    }

    public int keysCountApproximately() {
        int count = 0;
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            int shardKeyCount = shard.keysCountApproximately();
            if (shardKeyCount == -1) {
                return -1;
            }
            count += shardKeyCount;
        }
        return count;
    }

    public void clear() throws StorageException {
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            shard.clear();
        }
    }

    public void clearCaches() {
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            shard.clearCaches();
        }
    }

    public void flush() throws IOException {
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            shard.flush();
        }
    }

    public boolean isDirty() {
        for (VfsAwareIndexStorage<K, V> shard : this.shards) {
            if (!shard.isDirty()) continue;
            return true;
        }
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        IOUtil.closeAllSafely(this.shards);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isReadLockHeldByCurrentThread() {
        return ContainerUtil.or((Object[])this.shards, IndexStorage::isReadLockHeldByCurrentThread);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagesFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/storage/sharding/ShardedIndexStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

