/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.impl.AbstractDecomposableQuery;
import com.intellij.model.search.impl.Requests;
import com.intellij.model.search.impl.SearchWordQueryBuilderImpl;
import com.intellij.model.search.impl.TransformationKt;
import com.intellij.model.search.impl.WordRequest;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.impl.search.WordRequestInfoImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/model/search/impl/SearchWordQuery;", "R", "", "Lcom/intellij/model/search/impl/AbstractDecomposableQuery;", "myParameters", "Lcom/intellij/model/search/impl/SearchWordQueryBuilderImpl$Parameters;", "mapper", "Lcom/intellij/model/search/LeafOccurrenceMapper;", "<init>", "(Lcom/intellij/model/search/impl/SearchWordQueryBuilderImpl$Parameters;Lcom/intellij/model/search/LeafOccurrenceMapper;)V", "processResults", "", "consumer", "Lcom/intellij/util/Processor;", "decompose", "Lcom/intellij/model/search/impl/Requests;", "makesSenseToSearch", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "intellij.platform.indexing.impl"})
public final class SearchWordQuery<R>
extends AbstractDecomposableQuery<R> {
    @NotNull
    private final SearchWordQueryBuilderImpl.Parameters myParameters;
    @NotNull
    private final LeafOccurrenceMapper<? extends R> mapper;

    public SearchWordQuery(@NotNull SearchWordQueryBuilderImpl.Parameters myParameters, @NotNull LeafOccurrenceMapper<? extends R> mapper) {
        Intrinsics.checkNotNullParameter((Object)myParameters, (String)"myParameters");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.myParameters = myParameters;
        this.mapper = mapper;
    }

    protected boolean processResults(@NotNull Processor<? super R> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return HelperKt.runSearch(this.myParameters.getProject(), this, consumer);
    }

    @Override
    @NotNull
    public Requests<R> decompose() {
        SearchScope searchScope = this.myParameters.getSearchScope();
        if (!this.makesSenseToSearch(searchScope)) {
            return Requests.Companion.empty();
        }
        return new Requests(null, null, CollectionsKt.listOf(new WordRequest(new WordRequestInfoImpl(this.myParameters.getWord(), searchScope, this.myParameters.getCaseSensitive(), SearchContext.mask((Collection)this.myParameters.getSearchContexts()), this.myParameters.getContainerName()), this.myParameters.getInjection(), TransformationKt.xValueTransform((Function1)new Function1<LeafOccurrence, Collection<? extends R>>(this.mapper){

            public final Collection<R> invoke(LeafOccurrence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LeafOccurrenceMapper)this.receiver).mapOccurrence(p0);
            }
        }))), 3, null);
    }

    private final boolean makesSenseToSearch(SearchScope searchScope) {
        boolean bl;
        if (searchScope instanceof LocalSearchScope) {
            PsiElement[] psiElementArray = ((LocalSearchScope)searchScope).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            bl = !(((Object[])psiElementArray).length == 0);
        } else {
            bl = searchScope != GlobalSearchScope.EMPTY_SCOPE;
        }
        return bl;
    }
}

