/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.impl.storage.IndexLayoutPersistentSettings;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProviderBean;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0007J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00128FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/indexing/impl/storage/IndexStorageLayoutLocator;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLayout", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "Key", "Value", "indexExtension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "supportedLayoutProviders", "", "Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean;", "getSupportedLayoutProviders", "()Ljava/util/List;", "customLayoutId", "", "getCustomLayoutId$annotations", "getCustomLayoutId", "()Ljava/lang/String;", "customIndexLayoutProviderBean", "getCustomIndexLayoutProviderBean", "()Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean;", "prioritizedLayoutProviders", "forceTopProviderBean", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIndexStorageLayoutLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexStorageLayoutLocator.kt\ncom/intellij/util/indexing/impl/storage/IndexStorageLayoutLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n774#2:109\n865#2,2:110\n827#2:113\n855#2,2:114\n1563#2:116\n1634#2,3:117\n774#2:120\n865#2,2:121\n1056#2:123\n774#2:124\n865#2,2:125\n1#3:112\n13#4:127\n*S KotlinDebug\n*F\n+ 1 IndexStorageLayoutLocator.kt\ncom/intellij/util/indexing/impl/storage/IndexStorageLayoutLocator\n*L\n43#1:109\n43#1:110,2\n58#1:113\n58#1:114,2\n59#1:116\n59#1:117,3\n67#1:120\n67#1:121,2\n68#1:123\n104#1:124\n104#1:125,2\n23#1:127\n*E\n"})
public final class IndexStorageLayoutLocator {
    @NotNull
    public static final IndexStorageLayoutLocator INSTANCE = new IndexStorageLayoutLocator();
    @NotNull
    private static final Logger log;

    private IndexStorageLayoutLocator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final <Key, Value> VfsAwareIndexStorageLayout<Key, Value> getLayout(@NotNull FileBasedIndexExtension<Key, Value> indexExtension) throws IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FileBasedIndexLayoutProviderBean it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Object object;
        Object object2;
        String string;
        ID iD;
        String string2;
        Logger logger;
        FileBasedIndexLayoutProviderBean primaryProviderBeanForExtension;
        List applicableLayoutProviders;
        Iterable $this$filterTo$iv$iv;
        block8: {
            block7: {
                void it2;
                Intrinsics.checkNotNullParameter(indexExtension, (String)"indexExtension");
                List<FileBasedIndexLayoutProviderBean> prioritizedLayoutProviders = INSTANCE.prioritizedLayoutProviders(INSTANCE.getCustomIndexLayoutProviderBean());
                Iterable $this$filter$iv = prioritizedLayoutProviders;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo22 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FileBasedIndexLayoutProviderBean it3 = (FileBasedIndexLayoutProviderBean)element$iv$iv;
                    boolean bl = false;
                    if (!it3.getLayoutProvider().isApplicable(indexExtension)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                applicableLayoutProviders = (List)destination$iv$iv;
                primaryProviderBeanForExtension = (FileBasedIndexLayoutProviderBean)CollectionsKt.firstOrNull((List)applicableLayoutProviders);
                if (primaryProviderBeanForExtension == null) {
                    throw new UnsupportedOperationException(indexExtension + ": no suitable index storage provider was found in a " + CollectionsKt.joinToString$default((Iterable)prioritizedLayoutProviders, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                }
                logger = log;
                string2 = primaryProviderBeanForExtension.id;
                iD = indexExtension.getName();
                string = CollectionsKt.joinToString$default((Iterable)applicableLayoutProviders, null, null, null, (int)0, null, IndexStorageLayoutLocator::getLayout$lambda$1, (int)31, null);
                object2 = indexExtension instanceof ShardableIndexExtension ? (ShardableIndexExtension)indexExtension : null;
                if (object2 == null) break block7;
                ShardableIndexExtension $i$f$filterTo22 = object2;
                String string3 = string;
                ID iD2 = iD;
                String string4 = string2;
                object = logger;
                boolean bl = false;
                String string5 = ", shards = " + it2.shardsCount();
                logger = object;
                string2 = string4;
                iD = iD2;
                string = string3;
                String string6 = string5;
                object2 = string6;
                if (string6 != null) break block8;
            }
            object2 = "";
        }
        logger.info("Layout '" + string2 + "' will be used to for '" + iD + "' index (applicable providers: [" + string + "])" + (String)object2);
        $this$filterTo$iv$iv = applicableLayoutProviders;
        boolean $i$f$filterNot = false;
        void it2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (FileBasedIndexLayoutProviderBean)element$iv$iv;
            boolean bl = false;
            if (it == primaryProviderBeanForExtension) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FileBasedIndexLayoutProviderBean)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getLayoutProvider());
        }
        List otherApplicableProviders = (List)destination$iv$iv;
        VfsAwareIndexStorageLayout<Key, Value> vfsAwareIndexStorageLayout = primaryProviderBeanForExtension.getLayoutProvider().getLayout(indexExtension, otherApplicableProviders);
        Intrinsics.checkNotNullExpressionValue(vfsAwareIndexStorageLayout, (String)"getLayout(...)");
        return vfsAwareIndexStorageLayout;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileBasedIndexLayoutProviderBean> getSupportedLayoutProviders() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = FileBasedIndexLayoutProvider.STORAGE_LAYOUT_EP_NAME.getExtensionList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)element$iv$iv;
            boolean bl = false;
            if (!it.getLayoutProvider().isSupported()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)a;
                boolean bl = false;
                it = (FileBasedIndexLayoutProviderBean)b;
                Comparable comparable = Integer.valueOf(-it.priority);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(-it.priority));
            }
        });
    }

    @Nullable
    public static final String getCustomLayoutId() {
        FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = INSTANCE.getCustomIndexLayoutProviderBean();
        return fileBasedIndexLayoutProviderBean != null ? fileBasedIndexLayoutProviderBean.id : null;
    }

    @JvmStatic
    public static /* synthetic */ void getCustomLayoutId$annotations() {
    }

    private final FileBasedIndexLayoutProviderBean getCustomIndexLayoutProviderBean() {
        String forcedLayoutID = System.getProperty("idea.index.storage.forced.layout");
        if (forcedLayoutID != null) {
            Object v0;
            block3: {
                Iterable iterable = this.getSupportedLayoutProviders();
                for (Object t : iterable) {
                    FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.id, (Object)forcedLayoutID)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = v0;
            if (fileBasedIndexLayoutProviderBean == null) {
                throw new IllegalStateException("Can't find index storage layout for id = " + forcedLayoutID);
            }
            return fileBasedIndexLayoutProviderBean;
        }
        return IndexLayoutPersistentSettings.INSTANCE.getCustomLayout();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileBasedIndexLayoutProviderBean> prioritizedLayoutProviders(FileBasedIndexLayoutProviderBean forceTopProviderBean) {
        List list;
        void $this$filterTo$iv$iv;
        if (forceTopProviderBean == null) {
            return this.getSupportedLayoutProviders();
        }
        Iterable $this$filter$iv = this.getSupportedLayoutProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.id, (Object)forceTopProviderBean.id))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$prioritizedLayoutProviders_u24lambda_u241 = list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        boolean bl = false;
        $this$prioritizedLayoutProviders_u24lambda_u241.add(0, forceTopProviderBean);
        return list;
    }

    static /* synthetic */ List prioritizedLayoutProviders$default(IndexStorageLayoutLocator indexStorageLayoutLocator, FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean, int n, Object object) {
        if ((n & 1) != 0) {
            fileBasedIndexLayoutProviderBean = null;
        }
        return indexStorageLayoutLocator.prioritizedLayoutProviders(fileBasedIndexLayoutProviderBean);
    }

    private static final CharSequence getLayout$lambda$1(FileBasedIndexLayoutProviderBean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.id;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexStorageLayoutLocator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

