/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LazyStubList
extends StubList {
    private final AtomicReferenceArray<StubBase<?>> myStubs;
    private final ObjectStubSerializer<?, ?> myRootSerializer;
    private int mySize;
    private final AtomicInteger myInstantiated = new AtomicInteger(1);
    private volatile LazyStubData myData;

    LazyStubList(int size, StubBase<?> root, ObjectStubSerializer<?, ?> rootSerializer) {
        super(size);
        this.myStubs = new AtomicReferenceArray(size);
        this.myRootSerializer = rootSerializer;
        this.myStubs.set(0, root);
        root.setStubList((StubList)this);
    }

    public void addStub(@NotNull StubBase<?> stub, @Nullable StubBase<?> parent, @Nullable IElementType type) {
        if (stub == null) {
            LazyStubList.$$$reportNull$$$0(0);
        }
    }

    public void addLazyStub(IElementType type, int childIndex, int parentIndex) {
        this.addStub(childIndex, parentIndex, type.getIndex());
        ++this.mySize;
    }

    public boolean areChildrenNonAdjacent(int childId, int parentId) {
        return false;
    }

    public int size() {
        return this.mySize;
    }

    public StubBase<?> get(int index) {
        StubBase<?> stub = this.getCachedStub(index);
        if (stub != null) {
            return stub;
        }
        StubBase<?> newStub = this.instantiateStub(index);
        if (this.myStubs.compareAndSet(index, null, newStub)) {
            if (this.myInstantiated.incrementAndGet() == this.myStubs.length()) {
                this.myData = null;
            }
        } else {
            newStub = this.getCachedStub(index);
        }
        return newStub;
    }

    @Nullable
    @ApiStatus.Internal
    public StubBase<?> getCachedStub(int index) {
        return this.myStubs.get(index);
    }

    @NotNull
    private StubBase<?> instantiateStub(int index) {
        StubBase<?> stubBase;
        LazyStubData data = this.myData;
        if (data == null) {
            StubBase<?> stub = this.getCachedStub(index);
            if (stub != null) {
                StubBase<?> stubBase2 = stub;
                if (stubBase2 == null) {
                    LazyStubList.$$$reportNull$$$0(1);
                }
                return stubBase2;
            }
            throw new IllegalStateException("Not all (" + this.mySize + ") stubs are instantiated (" + String.valueOf(this.myInstantiated) + "), but data for them is missing");
        }
        try {
            StubBase<?> parent = this.get(data.getParentIndex(index));
            IElementType elementType = this.getStubElementType(index);
            ObjectStubSerializer serializer2 = StubElementRegistryService.getInstance().getStubSerializer(elementType);
            if (serializer2 == null) {
                throw new IllegalStateException("Stub serializer is null for the element type: " + String.valueOf(elementType));
            }
            StubBase<?> stub = data.deserializeStub(index, parent, serializer2, elementType);
            stub.id = index;
            stubBase = stub;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Error | Exception e) {
            PsiFileStub fileStub = this.myStubs.get(0).getContainingFileStub();
            PsiFile file = fileStub == null ? null : (PsiFile)fileStub.getPsi();
            PluginDescriptor plugin = PluginManager.getPluginByClass((Class)this.myRootSerializer.getClass());
            String message = StubSerializationUtil.brokenStubFormat(this.myRootSerializer, (PsiFile)file);
            throw new PluginException(message, e, plugin == null ? null : plugin.getPluginId());
        }
        if (stubBase == null) {
            LazyStubList.$$$reportNull$$$0(2);
        }
        return stubBase;
    }

    void setStubData(LazyStubData data) {
        if (this.myInstantiated.get() < this.mySize) {
            this.myData = data;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/LazyStubList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/LazyStubList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addStub";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

